package lrs.visitor;

import lrs.IAlgo;
import lrs.LRStruct;

/**
 * Return the n'th element in the list.
 *
 * @author Mathias Ricken
 */
public class GetNth implements IAlgo {
    /// singleton instance
    public static final GetNth Singleton = new GetNth();

    /// private singleton ctor
    private GetNth() {
    }

    /**
     * Operates on an empty LRStruct host, given an input object.
     *
     * @param host an empty LRStruct.
     * @param inp  index of element
     * @return nothing
     * @throws IllegalArgumentException
     */
    public Object emptyCase(LRStruct host, Object inp) {
        throw new IllegalArgumentException("LRStruct empty");
    }

    /**
     * Operates on a non-empty LRStruct host, given an input object.
     *
     * @param host a non-empty LRStruct.
     * @param inp  index of element
     * @return an n'th element
     */
    public Object nonEmptyCase(LRStruct host, Object inp) {
        int i = ((Integer) inp).intValue();
        if (i == 0) {
            return host.getFirst();
        }
        else {
            return host.getRest().execute(this, new Integer(i - 1));
        }
    }
}
