package controller;

import model.ILambda;
import sysModel.ICmdFactory;
import sysModel.SimDriver;
import sysModel.env.AEnvFactory;
import view.MBSView;

import java.awt.*;

/**
 * Controller class. Main program entry point.
 *
 * @author Mathias Ricken
 */
public class MBSController {
    /// simulation control
    private SimDriver _simDriver;

    /// view
    private MBSView _view;

    /**
     * Main program entry point.
     */
    public void run() {
        // initialize list of environment and fish names
        final String[] envClassNames = new String[]{
            "sysModel.env.BoundedEnv",
            "sysModel.env.UnboundedEnv",
            "sysModel.env.NoGridEnv"
        };
        final String[] fishClassNames = new String[]{
            "model.fish.GenericFish",
            "model.fish.SlowFish",
            "model.fish.DarterFish",
            "model.fish.CircleFish",
            "model.fish.SimpleFish",
            "model.fish.RockFish"
        };

        // initialize model
        _simDriver = new SimDriver();

        // initialize view and pass adapters to model
        _view = new MBSView(new IDisplayAdapter() {
            public void draw(Graphics2D g, Component comp, Point.Double p1, Point.Double p2) {
                _simDriver.draw(g, comp, p1, p2);
            }

            public Dimension getDisplaySize() {
                return _simDriver.getDisplaySize();
            }

            public void returnHome(final IScrollAdapter sa) {
            }

            public Point.Double getViewPosition(Point.Double pos) {
                return _simDriver.getViewPosition(pos);
            }

            public Point.Double getPanDelta(Point.Double delta) {
                return _simDriver.getPanDelta(delta);
            }
        }, new ISimAdapter() {
            public void step() {
                _simDriver.step();
            }

            public void start() {
                _simDriver.start();
            }

            public void stop() {
                _simDriver.stop();
            }

            public void setSpeed(int speed) {
                _simDriver.setSpeed(speed);
            }

            public void setStartLambda(ILambda startLambda) {
                _simDriver.setStartLambda(startLambda);
            }

            public void setIterationLambda(ILambda itLambda) {
                _simDriver.setIterationLambda(itLambda);
            }
        }, new IEnvAdapter() {
            public boolean loadEnvironment(String filename) {
                return _simDriver.loadEnvironment(filename);
            }

            public boolean saveEnvironment(String filename) {
                return _simDriver.saveEnvironment(filename);
            }

            public boolean createEnvironment(AEnvFactory factory) {
                return _simDriver.createEnvironment(factory);
            }

            public void setSeedLambda(ILambda seedLambda) {
                _simDriver.setSeedLambda(seedLambda);
            }

            public void edit(Point.Double p, int button) {
                _simDriver.edit(p, button);
            }

            public String getToolTipText(Point.Double p) {
                return _simDriver.getToolTipText(p);
            }

            public String[] getEnvironmentClassNames() {
                return envClassNames;
            }

            public String[] getFishClassNames() {
                return fishClassNames;
            }

            public ICmdFactory getCmdFactory() {
                return _simDriver.getCmdFactory();
            }
        });

        // set adapters connecting model to view
        _simDriver.setAdapters(new IEditAdapter() {
            public String getCurrentFish() {
                return _view.getCurrentFish();
            }

            public Color getCurrentColor() {
                return _view.getCurrentColor();
            }
        });

        _view.setSize(500, 400);
        _view.setVisible(true);
    }


    /**
     * Java Virtual Machine entry point.
     *
     * @param args command line arguments
     */
    public static void main(String[] args) {
        (new MBSController()).run();
    }
}
