package lrs;

/**
 * Represents the non-empty state of a LStruct.
 *
 * @author Dung X. Nguyen  Copyright 2001 - All rights reserved.
 * @stereotype composite
 * @since 10/09/01
 */

class NENode extends ANode {
    /**
     * The first data element of this LRStruct.
     */
    private Object _dat;
    /**
     * The rest of this LRStruct.
     */
    private LRStruct _tail;

    /**
     * Initializes this NENode to contain dat and a given tail list.
     *
     * @param dat  the data object to be stored in this NENode.
     * @param tail the LRStruct tail of this NENode.
     */
    NENode(Object dat, LRStruct tail) {
        _dat = dat;
        _tail = tail;
    }

    LRStruct getRest(LRStruct owner) {
        return _tail;
    }

    Object getFirst(LRStruct owner) {
        return _dat;
    }

    LRStruct setRest(LRStruct tail, LRStruct owner) {
        _tail = tail;
        return owner;
    }

    LRStruct setFirst(Object first, LRStruct owner) {
        _dat = first;
        return owner;
    }

    /**
     * Inserts a data object at the front of the LRStruct owner.
     *
     * @param dat   the object to be inserted at the front.
     * @param owner the LRS referencing this NENode.
     */
    LRStruct insertFront(Object dat, LRStruct owner) {
        return owner.setHead(new NENode(dat, new LRStruct(this)));
        /* Details:
        // LRStruct coOwner = new LRStruct (this);
        // NENode newNode = new NENode (dat, coOwner);
        // owner.setHead (newNode);
        // "old" style: owner._head = newNode - cannot be done here.
        */
    }

    Object removeFront(LRStruct owner) {
        owner.setHead(_tail.getHead()); // owner._head = _tail._head
        return _dat;
    }

    /**
     * Calls the visitor's non-empty case.
     */
    Object execute(IAlgo algo, Object input, LRStruct owner) {
        return algo.nonEmptyCase(owner, input);
    }
}

