package lrs.visitor;

import lrs.IAlgo;
import lrs.LRStruct;

/**
 * Clears this LRStruct.
 *
 * @author Mathias Ricken
 */
public class Clear implements IAlgo {
    /// singleton instance
    public static final Clear Singleton = new Clear();

    /// private singleton ctor
    private Clear() {
    }

    /**
     * Operates on an empty LRStruct host, given an input object.
     *
     * @param host an empty LRStruct.
     * @param inp  not used
     * @return the empty LRStruct
     */
    public Object emptyCase(LRStruct host, Object inp) {
        // done
        return host;
    }

    /**
     * Operates on a non-empty LRStruct host, given an input object.
     *
     * @param host a non-empty LRStruct.
     * @param inp  input object needed by this IAlgo.
     * @return an appropriate output object.
     */
    public Object nonEmptyCase(LRStruct host, Object inp) {
        // set rest to empty
        host.setRest(new LRStruct());
        // remove front
        host.removeFront();
        return host;
    }
}
