package model.fish;

import model.ILambda;
import model.RandNumGenerator;
import model.fish.display.ImageFishDisplay;
import sysModel.fish.AFish;

import java.awt.*;

/**
 * A fish that moves like a knight in chess.
 *
 *  _ _ _ _ _
 * |_|0|_|1|_|
 * |7|_|_|_|2|
 * |_|_|X|_|_|
 * |6|_|_|_|3|
 * |_|5|_|4|_|
 *
 * If the fish is located at the X, then the locations labelled 0 through 7 should be reachable.
 * The target location is selected at random.
 * When moving, the fish should always make two steps in one direction, then one step over, NOT one step
 * in one direction, then two steps over. While the destination is the same, the locations visited are different.
 * If the fish is blocked on the way to the target location, the fish should just stop in that place.
 * After the move has been executed, the fish is left facing in the direction of the last step (the "one over" step).
 *
 * @author Mathias Ricken
 */
public class KnightFish extends AFish {
    /**
     * Make a new knight fish.
     * @param fishColor color of the fish
     */
    public KnightFish(Color fishColor) {
        super(fishColor, new ImageFishDisplay("knight.gif",0));
    }

    /**
     * Execute the movement part of a simulation step.
     */
    protected void move() {
        int target = RandNumGenerator.instance().nextInt(8);
        int turns = target/2; // number of 90 degree turns
        turnRight(turns*Math.PI/2.0);
        final boolean oneOverToLeft = ((target%2)==0); // true if the "one over" step goes to the left, false if to the right

        // try to make the first step forward
        tryMoveFwd(new ILambda() {
            public Object apply(Object param) {
                // if blocked, do nothing
                return null;
            }
        }, new ILambda() {
            public Object apply(Object param) {
                // if open, move
                ((ILambda)param).apply(null);

                // try to make the second step forward
                return tryMoveFwd(new ILambda() {
                    public Object apply(Object param) {
                        // if blocked, do nothing
                        return null;
                    }
                }, new ILambda() {
                    public Object apply(Object param) {
                        // if open, move
                        ((ILambda)param).apply(null);

                        // if over to the left...
                        if (oneOverToLeft) {
                            // ...turn left
                            turnLeft();
                        }
                        else {
                            // ...else turn right
                            turnRight();
                        }

                        // try to make the step over
                        return tryMoveFwd(new ILambda() {
                            public Object apply(Object param) {
                                // if blocked, do nothing
                                return null;
                            }
                        }, new ILambda() {
                            public Object apply(Object param) {
                                // if open, move
                                ((ILambda)param).apply(null);

                                return null;
                            }
                        });
                    }
                });
            }
        });
    }
}
