package model.fish.tests;

import junit.framework.TestCase;
import model.ILambda;
import model.fish.GenericFish;
import sysModel.env.AGlobalEnv;
import sysModel.env.ILocalEnv;
import sysModel.env.ILocalEnvState;
import sysModel.fish.AFish;

import java.awt.*;

/**
 * Tests for GenericFish.
 *
 * @author Mathias Ricken
 */
public class Test_GenericFish extends TestCase {
    private static class TestNoWayLocalEnv implements ILocalEnv {
        public Object tryMoveFwd(AFish fish, ILambda blockedCmd, ILambda openCmd) {
            return blockedCmd.apply(null);
        }

        public Object tryBreedFwd(AFish fish, ILambda blockedCmd, ILambda openCmd) {
            return blockedCmd.apply(fish);
        }

        public void drawFish(AFish fish, Graphics2D g, Component comp) {
        }

        public void turnRight(AFish fish, double radians) {
        }

        public void removeFish(AFish fish) {
        }

        public Object execute(AGlobalEnv.ILocalEnvVisitor visitor, Object param) {
            return null;
        }

        public void setState(ILocalEnvState state) {
        }
    }

    /**
     * Test no way to move.
     */
    public void testNoWay() {
        TestNoWayLocalEnv localEnv = new TestNoWayLocalEnv();

        GenericFish gf = new GenericFish(Color.RED);
        gf.setLocalEnvironment(localEnv);

        for (int i = 0; i < 10; ++i) {
            try {
                gf.move();
                gf.turnRight();
            }
            catch (RuntimeException e) {
                fail("Should not have executed move");
            }
        }
    }

    private static class TestOneWayLocalEnv implements ILocalEnv {
        int count = 0;
        int open = 0;

        public void setOpen(int i) {
            count = 0;
            open = i;
        }

        public Object tryMoveFwd(AFish fish, ILambda blockedCmd, ILambda openCmd) {
            if (count != open) {
                ++count;
                return blockedCmd.apply(null);
            }
            else {
                ILambda l = new ILambda() {
                    int i;

                    {
                        i = count;
                    }

                    public Object apply(Object param) {
                        throw new RuntimeException("move " + i + " executed");
                    }
                };
                ++count;
                return openCmd.apply(l);
            }
        }

        public Object tryBreedFwd(AFish fish, ILambda blockedCmd, ILambda openCmd) {
            return blockedCmd.apply(fish);
        }

        public void drawFish(AFish fish, Graphics2D g, Component comp) {
        }

        public void turnRight(AFish fish, double radians) {
        }

        public void removeFish(AFish fish) {
        }

        public Object execute(AGlobalEnv.ILocalEnvVisitor visitor, Object param) {
            return null;
        }

        public void setState(ILocalEnvState state) {
        }
    }

    /**
     * Test one way to move.
     */
    public void testOneWay() {
        TestOneWayLocalEnv localEnv = new TestOneWayLocalEnv();

        GenericFish gf = new GenericFish(Color.RED);
        gf.setLocalEnvironment(localEnv);

        for (int i = 0; i < 3; ++i) {
            localEnv.setOpen(i);
            try {
                gf.move();
                fail("Should have executed move " + i);
            }
            catch (RuntimeException e) {
                if (!e.getMessage().equals("move " + i + " executed")) {
                    fail("Wrong move executed, should have been " + i + ": " + e);
                }
            }
        }
    }

    private static class TestTwoWayLocalEnv implements ILocalEnv {
        int count = 0;
        int blocked = 0;

        public void setBlocked(int i) {
            count = 0;
            blocked = i;
        }

        public Object tryMoveFwd(AFish fish, ILambda blockedCmd, ILambda openCmd) {
            if (count == blocked) {
                ++count;
                return blockedCmd.apply(null);
            }
            else {
                ILambda l = new ILambda() {
                    int i;

                    {
                        i = count;
                    }

                    public Object apply(Object param) {
                        throw new RuntimeException("move " + i + " executed");
                    }
                };
                ++count;
                return openCmd.apply(l);
            }
        }

        public Object tryBreedFwd(AFish fish, ILambda blockedCmd, ILambda openCmd) {
            return blockedCmd.apply(fish);
        }

        public void drawFish(AFish fish, Graphics2D g, Component comp) {
        }

        public void turnRight(AFish fish, double radians) {
        }

        public void removeFish(AFish fish) {
        }

        public Object execute(AGlobalEnv.ILocalEnvVisitor visitor, Object param) {
            return null;
        }

        public void setState(ILocalEnvState state) {
        }
    }

    /**
     * Test two ways to move.
     */
    public void testTwoWays() {
        TestTwoWayLocalEnv localEnv = new TestTwoWayLocalEnv();

        GenericFish gf = new GenericFish(Color.RED);
        gf.setLocalEnvironment(localEnv);

        for (int i = 0; i < 3; ++i) {
            localEnv.setBlocked(i);
            try {
                gf.move();
                fail("Should have executed move " + i);
            }
            catch (RuntimeException e) {
                if (!(e.getMessage().startsWith("move ") &&
                        e.getMessage().endsWith(" executed") &&
                        !e.getMessage().equals("move " + i + " executed"))) {
                    fail("Wrong move executed, should have been " + i + ": " + e);
                }
            }
        }
    }

    private static class TestAllWayLocalEnv implements ILocalEnv {
        public Object tryMoveFwd(AFish fish, ILambda blockedCmd, ILambda openCmd) {
            return openCmd.apply(new ILambda() {
                public Object apply(Object param) {
                    throw new RuntimeException("move executed");
                }
            });
        }

        public Object tryBreedFwd(AFish fish, ILambda blockedCmd, ILambda openCmd) {
            return blockedCmd.apply(fish);
        }

        public void drawFish(AFish fish, Graphics2D g, Component comp) {
        }

        public void turnRight(AFish fish, double radians) {
        }

        public void removeFish(AFish fish) {
        }

        public Object execute(AGlobalEnv.ILocalEnvVisitor visitor, Object param) {
            return null;
        }

        public void setState(ILocalEnvState state) {
        }
    }

    /**
     * Test all ways to move.
     */
    public void testAllWays() {
        TestAllWayLocalEnv localEnv = new TestAllWayLocalEnv();

        GenericFish gf = new GenericFish(Color.RED);
        gf.setLocalEnvironment(localEnv);

        for (int i = 0; i < 10; ++i) {
            try {
                gf.move();
                fail("Should have executed move " + i);
            }
            catch (RuntimeException e) {
            }
        }
    }

}
