package sysModel;

import model.ILambda;

/**
 * No operation.
 *
 * @author Mathias Ricken
 */
public class NoOpLambda implements ILambda {
    /**
     * Singleton instance.
     */
    private static NoOpLambda _instance = null;

    /**
     * Return singleton instance.
     *
     * @return singleton instance
     */
    public static NoOpLambda instance() {
        if (_instance == null) {
            _instance = new NoOpLambda();
        }
        return _instance;
    }

    /**
     * Private singleton constructor.
     */
    private NoOpLambda() {
    }

    /**
     * Do nothing.
     *
     * @param param ignored
     * @return null
     */
    public Object apply(Object param) {
        return null;
    }
}
