package sysModel.fish;

import java.awt.*;
import java.lang.reflect.Constructor;

/**
 * AFish factory to dynamically create new fish.
 *
 * @author Mathias Ricken
 */
public class DynamicFishFactory implements IFishFactory {
    /// current name of the fish class
    private String _curName;

    /// current color of the fish
    private Color _curColor;

    /**
     * Construct a new factory.
     *
     * @param name  initial name
     * @param color initial color
     */
    public DynamicFishFactory(String name, Color color) {
        _curName = name;
        _curColor = color;
    }

    /**
     * Mutator for the name.
     *
     * @param newName new name
     */
    public void setName(String newName) {
        _curName = newName;
    }


    /**
     * Mutator for the color.
     *
     * @param newColor new color
     */
    public void setName(Color newColor) {
        _curColor = newColor;
    }

    /**
     * Create a new fish.
     *
     * @return new fish
     */
    public AFish createFish() {
        try {
            Class envClass = Class.forName(_curName);
            Constructor envCtor = envClass.getConstructor(new Class[]{Color.class});
            return (AFish) envCtor.newInstance(new Object[]{_curColor});
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading fish class");
        }
    }
}
