package sysModel.parser;

/**
 * Default token visitor, all cases call the defaultCase method.
 *
 * @author Mathias Ricken
 */
public abstract class DefaultTokenVisitor implements ITokenVisitor {
    /**
     * Default case to be called of other methods are not overridden.
     *
     * @return visitor-specific return value
     */
    public abstract Object defaultCase();

    /**
     * Case to be called if end of file is reached.
     *
     * @return visitor-specific return value
     */
    public Object endCase() {
        return defaultCase();
    }

    /**
     * Case to be called if a word is read.
     *
     * @param word word
     * @return visitor-specific return value
     */
    public Object wordCase(String word) {
        return defaultCase();
    }

    /**
     * Case to be called if a number is read.
     *
     * @param num number
     * @return visitor-specific return value
     */
    public Object numCase(double num) {
        return defaultCase();
    }

    /**
     * Case to be called if an open parenthesis is read.
     *
     * @return visitor-specific return value
     */
    public Object openCase() {
        return defaultCase();
    }

    /**
     * Case to be called if a closed parenthesis is read.
     *
     * @return visitor-specific return value
     */
    public Object closeCase() {
        return defaultCase();
    }

    /**
     * Case to be called if a comma is read.
     *
     * @return visitor-specific return value
     */
    public Object commaCase() {
        return defaultCase();
    }
}
