/**
 * Number token
 *
 * @author  Mathias Ricken
 */
package sysModel.parser;

/**
 * Number token.
 *
 * @author Mathias Ricken
 */
public class NumberToken implements IToken {
    /**
     * Number.
     */
    private final double _num;

    /**
     * Make a new number token.
     *
     * @param n number
     */
    public NumberToken(double n) {
        _num = n;
    }

    /**
     * Execute visitor.
     *
     * @param v visitor
     * @return visitor-specific return value
     */
    public Object execute(ITokenVisitor v) {
        return v.numCase(_num);
    }
}

