package tests;

import junit.framework.Assert;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/**
 * Provides access to private members in classes.
 * 
 * @author Ross Burton
 * @author Mathias Ricken
 */
public class PrivateAccessor {
    /**
     * Return the value of the field specified.
     * @param o method containing the field
     * @param fieldName name of the field
     * @return value of the field
     */
    public static Object getField(Object o,
                                  String fieldName) {
        // Check we have valid arguments
        Assert.assertNotNull(o);
        Assert.assertNotNull(fieldName);
        // Go and find the private field...
        try {
            Field field = o.getClass().getDeclaredField(fieldName);
            boolean state = field.isAccessible();
            field.setAccessible(true);
            Object retval = field.get(o);
            field.setAccessible(state);
            return retval;
        }
        catch (IllegalAccessException ex) {
            Assert.fail("IllegalAccessException accessing " +
                        fieldName);
        }
        catch (NoSuchFieldException ex) {
            Assert.fail("NoSuchFieldException accessing " +
                        fieldName);
        }
        return null;
    }

    /**
     * Call the method specified.
     * @param o object containing the method
     * @param methodName name of the method
     * @param types type of the arguments
     * @param params parameters
     * @return return value
     */
    public static Object callMethod(Object o,
                                    String methodName,
                                    Class[] types,
                                    Object[] params) {
        // Check we have valid arguments
        Assert.assertNotNull(o);
        Assert.assertNotNull(methodName);
        // Go and find the private method...
        try {
            Method method = o.getClass().getDeclaredMethod(methodName, types);
            boolean state = method.isAccessible();
            method.setAccessible(true);
            Object retval = method.invoke(o, params);
            method.setAccessible(state);
            return retval;
        }
        catch (IllegalAccessException ex) {
            Assert.fail("IllegalAccessException accessing " +
                        methodName);
        }
        catch (NoSuchMethodException ex) {
            Assert.fail("NoSuchFieldException accessing " +
                        methodName);
        }
        catch (InvocationTargetException ex) {
            Assert.fail("InvocationTargetException accessing " +
                        methodName);
        }
        Assert.fail("Method '" + methodName +
                    "' not found");
        return null;
    }

    /**
     * Call the method specified.
     * @param o object containing the method
     * @param methodName name of the method
     * @param params parameters
     * @return return value
     */
    public static Object callMethod(Object o,
                                    String methodName,
                                    Object[] params) {
        // Check we have valid arguments
        Assert.assertNotNull(o);
        Assert.assertNotNull(methodName);
        // Go and find the private method...
        Class c = o.getClass();
        do {
            final Method methods[] =
                    c.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (methodName.equals(methods[i].getName())) {
                    try {
                        boolean state = methods[i].isAccessible();
                        methods[i].setAccessible(true);
                        Object retval = methods[i].invoke(o, params);
                        methods[i].setAccessible(state);
                        return retval;
                    }
                    catch (IllegalAccessException ex) {
                        Assert.fail("IllegalAccessException accessing " +
                                    methodName);
                    }
                    catch (InvocationTargetException ex) {
                        Assert.fail("InvocationTargetException accessing " +
                                    methodName + ": " + ex);
                    }
                }
            }
            c = c.getSuperclass();
        } while(c!=null);
        Assert.fail("Method '" + methodName +
                    "' not found");
        return null;
    }
}