package model.fish;

import model.ILambda;
import model.fish.display.CircleFishDisplay;
import sysModel.fish.AFish;

import java.awt.*;

/**
 * A fish that swims around in a circle.
 *
 * @author Mathias Ricken
 */
public class CircleFish extends AFish {
    /**
     * Create a new circle fish.
     *
     * @param fishColor color of the fish
     */
    public CircleFish(Color fishColor) {
        super(fishColor, new CircleFishDisplay());
    }

    /**
     * Execute the movement part of a simulation step.
     */
    public void move() {
        // attempt to move forward
        tryMoveFwd(new ILambda() {
            public Object apply(Object param) {
                // the field ahead is blocked, turn around
                turnRight(Math.PI);
                return null;
            }
        },
                   new ILambda() {
                       public Object apply(Object param) {
                           // the field ahead is open, move
                           ((ILambda) param).apply(null);
                           // turn 10 degrees to the right
                           turnRight(Math.PI / 18);
                           return null;
                       }
                   });

    }
}
