package model.fish;

import model.ILambda;
import model.fish.display.NarrowFishDisplay;
import sysModel.fish.AFish;

import java.awt.*;

/**
 * Class for a darter fish.
 *
 * @author Mathias G. Ricken
 */
public class DarterFish extends AFish {
    /**
     * Create a new darter fish.
     *
     * @param fishColor color of the fish
     */
    public DarterFish(Color fishColor) {
        super(fishColor, new NarrowFishDisplay());
    }

    /**
     * Execute the movement part of a simulation step.
     */
    public void move() {
        // attempt to move forward
        tryMoveFwd(new ILambda() {
            public Object apply(Object param) {
                // could not move forward at all
                // turn PI radians
                turnRight(Math.PI);
                return null;
            }
        },
                   new ILambda() {
                       public Object apply(Object param) {
                           // the field ahead is open, move
                           ((ILambda) param).apply(null);
                           // attempt to move forward again
                           tryMoveFwd(new ILambda() {
                               public Object apply(Object param) {
                                   // could not move forward any more
                                   // do nothing
                                   return null;
                               }
                           },
                                      new ILambda() {
                                          public Object apply(Object param) {
                                              // second field ahead is open, move
                                              ((ILambda) param).apply(null);
                                              return null;
                                          }
                                      });
                           return null;
                       }
                   });
    }
}
