package model.fish;

import model.RandNumGenerator;
import sysModel.fish.IFishDisplay;
import model.fish.display.RoundFishDisplay;

import java.awt.*;

import sysModel.fish.IFishDisplay;

/**
 * Class for a slow fish.
 *
 * @author Mathias G. Ricken
 */
public class SlowFish extends GenericFish {
    /**
     * Probability that this slow fish moves.
     */
    private double _probOfMoving = 1.0f / 5.0f;

    /**
     * Create a new slow fish.
     *
     * @param fishColor color of the fish
     */
    public SlowFish(Color fishColor) {
        super(fishColor);
    }

    /**
     * Execute the movement part of a simulation step.
     */
    public void move() {
        if (RandNumGenerator.instance().nextDouble() < _probOfMoving) {
            // slow fish attempts to move like super class
            super.move();
        }
    }

    /**
     * Draw the fish. The Graphics2D object has been translated, rotated and scaled so that the origin is in
     * the center of the fish. The fish should just be drawn from (-0.5, -0.5) to (0.5, 0.5).
     *
     * @param g    graphics object to drawFish on.
     * @param comp the component to drawFish on
     */
    public void paint(Graphics2D g, Component comp) {
        IFishDisplay fd = new RoundFishDisplay();
        fd.draw(g, comp, getColor());
    }
}
