package sysModel;

import model.ILambda;
import sysModel.env.ILocalEnv;
import sysModel.fish.AFish;

/**
 * Interface for a factory to create a notify lambda.
 *
 * @author Mathias Ricken
 */
public interface ICmdFactory {
    /**
     * Create a lambda that notifies all observers and sends them the lambda given as parameter.
     *
     * @param lambda lambda for the observers
     * @return notify lambda
     */
    public ILambda makeNotifyCmd(ILambda lambda);

    /**
     * Create a lambda that notifies all observers to check if they are at the specified location and, if so,
     * remove themselves from the observer.
     *
     * @param env local environment at which fish should be deleted
     * @return delete lambda
     */
    public ILambda makeDeleteCmd(ILocalEnv env);

    /**
     * Create a lambda that adds a new fish to the observable.
     *
     * @param fish fish to add
     * @return add lambda
     */
    public ILambda makeAddCmd(AFish fish);
}
