package sysModel;

import model.ILambda;

import java.util.Observable;
import java.util.Observer;

/**
 * Simulation engine that contains the observable and manages observers.
 * *
 *
 * @author Mathias Ricken
 */
public class SimEngine {
    /**
     * The observable.
     */
    private Observable _observable = new Observable() {
        public void notifyObservers(Object obj) {
            setChanged();
            super.notifyObservers(obj);
        }
    };

    /**
     * Add observer to simulation.
     *
     * @param observer observer to add
     */
    public void add(Observer observer) {
        _observable.addObserver(observer);
    }

    /**
     * Remove observer from simulation.
     *
     * @param observer observer to remove
     */
    public void delete(Observer observer) {
        _observable.deleteObserver(observer);
    }

    /**
     * Accept a lambda and pass it to all observers.
     *
     * @param lambda lambda to execute
     */
    public void notify(ILambda lambda) {
        _observable.notifyObservers(lambda);
    }

    /**
     * Clears all observers.
     */
    public void clear() {
        _observable.deleteObservers();
    }
}
