package sysModel.env;

import controller.IScrollAdapter;
import model.ILambda;
import sysModel.NoOpLambda;
import sysModel.fish.AFish;
import sysModel.fish.IFishFactory;
import sysModel.parser.Lexer;

import java.awt.*;

/**
 * Dummy environment used if no other environment has been created or loaded yet.
 *
 * @author Mathias Ricken
 */
public class NullEnv extends AGlobalEnv {
    /**
     * Singleton instance.
     */
    private static NullEnv _instance;

    /**
     * Return singleton instance.
     *
     * @return singleton instance
     */
    public synchronized static NullEnv instance() {
        if (_instance == null) {
            _instance = new NullEnv();
        }
        return _instance;
    }

    /**
     * Private singleton constructor.
     */
    private NullEnv() {
        super(null);
    };

    /**
     * Add the fish to the global environment.
     *
     * @param localEnv local environment
     * @param fish     fish to add
     */
    public void addFishToInternalData(ILocalEnv localEnv, AFish fish) {
    }

    /**
     * Remove the fish from the global environment.
     *
     * @param localEnv local environment
     */
    protected void removeFishFromInternalData(ILocalEnv localEnv) {
    }

    /**
     * Edit the fish.
     *
     * @param localEnv local environment
     * @param fishFactory
     * @param button
     * @return lambda to edit the fish
     */
    public ILambda editFish(ILocalEnv localEnv, IFishFactory fishFactory, int button) {
        return NoOpLambda.instance();
    }

    /**
     * Create a local environment for the position.
     *
     * @param p position
     * @return local environment
     */
    public ILocalEnv makeLocalEnv(Point.Double p) {
        return null;
    }

    /**
     * Factory method for parsing a stream of tokens and creating a global environment from it.
     *
     * @param l lexer
     * @return new global environment
     */
    public AGlobalEnv parseEnvironment(Lexer l) {
        return NullEnv.instance();
    }

    /**
     * Parse fish and add them to the environment.
     *
     * @param l parser to read from
     */
    protected void parseFish(final Lexer l) {
    }

    /**
     * Get the environment settings class.
     *
     * @return environment settings class
     */
    public AEnvFactory makeEnvFactory() {
        return new AEnvFactory() {
            public AGlobalEnv create() {
                return NullEnv.instance();
            };
            public String toString() {
                return NullEnv.class.getName();
            }
        };
    }

    /**
     * Print file header.
     *
     * @param pw PrintWriter to use
     */
    protected void printHeader(java.io.PrintWriter pw) {
    }

    /**
     * Get size of the display.
     *
     * @return size of the display in model coordinate units.
     */
    public Dimension getDisplaySize() {
        return new Dimension();
    }

    /**
     * The action to be executed if the display should return home.
     *
     * @param sa scroll adapter
     */
    public void returnHome(final IScrollAdapter sa) {
    }

    /**
     * Ask the model where to scroll, given where the user has scrolled.
     * If the environment just acts like a normal panal, it should return pos without modification.
     * If the environment recenters, it should return a position in the middle of the pan area.
     * All coordinates are in model coordinate units.
     *
     * @param pos position where the user scrolled to
     * @return position where the environment wants the view to be
     * @see controller.IDisplayAdapter#getPanDelta
     */
    public Point.Double getViewPosition(Point.Double pos) {
        // the panel always gets recentered after moving it, so return the center position
        return new Point.Double();
    }

    /**
     * Ask the model how much to pan, given where the user scrolled.
     * If the environment just acts like a normal panal, it should return (0,0).
     * If the environment recenters, it should return delta without modification.
     * All coordinates are in model coordinate units.
     *
     * @param delta how far the user scrolled
     * @return how far the panel should scroll
     * @see controller.IDisplayAdapter#getViewPosition
     */
    public Point.Double getPanDelta(Point.Double delta) {
        // we want the panel to keep track of the position, so return the delta as pan value
        return new Point.Double();
    }

    /**
     * Get a tool tip description for a specific place in the environment.
     *
     * @param p mouse coordinates
     * @return lambda for the simulation controller to execute. Must return the tooltip string.
     */
    public ILambda getToolTipText(final Point.Double p) {
        return new ILambda() {
            public Object apply(Object param) {
                return "";
            }
        };
    }
}
