package sysModel.fish.tests;

import junit.framework.TestCase;
import model.ILambda;
import model.fish.display.CircleFishDisplay;
import sysModel.env.AGlobalEnv;
import sysModel.env.ILocalEnv;
import sysModel.env.ILocalEnvState;
import sysModel.fish.AFish;

import java.awt.*;

/**
 * Test cases for AFish.
 *
 * @author Mathias Ricken
 */
public class Test_AFish extends TestCase {
    private ILambda _dummy;

    private class TestFish extends AFish {
        protected void move() {
            // dummy
        }

        public void paint(Graphics2D g, Component comp) {
            // dummy
        }

        public void die() {
            super.die();
        }

        public TestFish(Color c) {
            super(c, new CircleFishDisplay());
        }
    };
    
    private TestFish _fish;
    private ILocalEnv _localEnv;

    public void setUp() {
        _fish = new TestFish(Color.RED);
        _localEnv = new ILocalEnv() {
            void checkFish(AFish fish) {
                if (fish != _fish) {
                    throw new IllegalArgumentException("Wrong fish!");
                }
            }

            public Object tryMoveFwd(AFish fish, ILambda blockedCmd, ILambda openCmd) {
                checkFish(fish);
                throw new RuntimeException("tryMoveFwd called");
            }

            public Object tryBreedFwd(AFish fish, ILambda blockedCmd, ILambda openCmd) {
                checkFish(fish);
                throw new RuntimeException("tryBreedFwd called");
            }

            public void drawFish(AFish fish, Graphics2D g, Component comp) {
                checkFish(fish);
                throw new RuntimeException("drawFish called");
            }

            public void turnRight(AFish fish, double radians) {
                checkFish(fish);
                throw new RuntimeException("turnRight called, radians=" + radians);
            }

            public void removeFish(AFish fish) {
                checkFish(fish);
                throw new RuntimeException("removeFish called");
            }

            public Object execute(AGlobalEnv.ILocalEnvVisitor visitor, Object param) {
                throw new RuntimeException("execute called");
            }

            public void setState(ILocalEnvState state) {
            }
        };
        _dummy = new ILambda() {
            public Object apply(Object param) {
                return null;
            };
        };
        _fish.setLocalEnvironment(_localEnv);
    }

    /**
     * Test fish to local environment delegation for tryMoveFwd.
     */
    public void testTryMoveFwd() {
        try {
            _fish.tryMoveFwd(_dummy, _dummy);
            fail("Error in delegation.");
        }
        catch (RuntimeException e) {
            if (!e.getMessage().equals("tryMoveFwd called")) {
                fail("Wrong method called.");
            }
        }
    }

    /**
     * Test fish to local environment delegation for tryBreedFwd.
     */
    public void testTryBreedFwd() {
        try {
            _fish.tryBreedFwd(_dummy, _dummy);
            fail("Error in delegation.");
        }
        catch (RuntimeException e) {
            if (!e.getMessage().equals("tryBreedFwd called")) {
                fail("Wrong method called.");
            }
        }
    }

    /**
     * Test fish to local environment delegation for draw.
     */
    public void testDraw() {
        try {
            _fish.draw(null, null);
            fail("Error in delegation.");
        }
        catch (RuntimeException e) {
            if (!e.getMessage().equals("drawFish called")) {
                fail("Wrong method called.");
            }
        }
    }

    /**
     * Test fish to local environment delegation for turnRight.
     */
    public void testTurnRight() {
        try {
            _fish.turnRight(3);
            fail("Error in delegation.");
        }
        catch (RuntimeException e) {
            if (!e.getMessage().equals("turnRight called, radians=3.0")) {
                fail("Wrong method called. " + e);
            }
        }
    }

    /**
     * Test fish to local environment delegation for turnLeft.
     */
    public void testTurnLeft() {
        try {
            _fish.turnLeft(4.5);
            fail("Error in delegation.");
        }
        catch (RuntimeException e) {
            if (!e.getMessage().equals("turnRight called, radians=-4.5")) {
                fail("Wrong method called. " + e);
            }
        }
    }

    /**
     * Test fish to local environment delegation for die.
     */
    public void testDie() {
        _fish.setProbOfDying(2);
        try {
            _fish.die();
            fail("Error in delegation.");
        }
        catch (RuntimeException e) {
            if (!e.getMessage().equals("removeFish called")) {
                fail("Wrong method called.");
            }
        }
    }
}
