/**
 * Open parenthesis token singleton
 *
 * @author  Mathias Ricken
 */
package sysModel.parser;

/**
 * Open parenthesis token.
 *
 * @author Mathias Ricken
 */
public final class OpenToken implements IToken {
    /**
     * Singleton instance.
     */
    private static OpenToken _instance;

    /**
     * Return singleton instance.
     *
     * @return instance
     */
    public synchronized static OpenToken instance() {
        if (_instance == null) {
            _instance = new OpenToken();
        }
        return _instance;
    }

    /**
     * Private singleton constructor.
     */
    private OpenToken() {
    }

    /**
     * Execute visitor.
     *
     * @param v visitor
     * @return visitor-specific return value
     */
    public Object execute(ITokenVisitor v) {
        return v.openCase();
    }
}

