package sysModel.parser;

import sysModel.ICmdFactory;
import sysModel.env.AGlobalEnv;

import java.lang.reflect.Constructor;

/**
 * Parser class.
 *
 * @author Mathias Ricken
 */
public class Parser {
    /**
     * Invoke the parser and recreate a global environment from a file.
     * @param filename name of file
     * @param factory factory to use for creation
     * @return global environment
     */
    public static AGlobalEnv parse(String filename, final ICmdFactory factory) {
        try {
            final Lexer l = new Lexer(filename);

            return (AGlobalEnv) l.nextToken().execute(new DefaultTokenVisitor() {
                public Object defaultCase() {
                    throw new ParserException("Invalid token");
                }

                public Object wordCase(String className) {
                    // read class name
                    try {
                        Class envClass = Class.forName(className);
                        Constructor fishCtor = envClass.getConstructor(new Class[]{ICmdFactory.class});
                        final AGlobalEnv env = (AGlobalEnv) fishCtor.newInstance(new Object[]{factory});
                        return env.parse(l);
                    }
                    catch (Exception e) {
                        throw new ParserException(e.toString());
                    }
                }
            });
        }
        catch (java.io.IOException e) {
            throw new ParserException(e.toString());
        }
    }
}
