package brs.visitor;
import brs.*;
import fp.*;

/**
 * Traverse a binary tree in order:
 * For an empty tree:
 * do the appropriate processing.
 * For a non-empty tree:
 * Traverse the left subtree in order;
 * Process the root;
 * Traverse the right subtree in order;
 * 
 * Uses one lambda as variant.
 * Let f be an ILambda and b be some input object.
 * empty case: 
 *   InOrder1(empty, f, b) = b;
 * non-empty case: 
 *   InOder(tree, f, b) = f(InOrder1(tree.left, f, b), tree, InOrder1(tree.right, f, b));
 * @author DXN
 * @author SBW
 * @author Mathias Ricken - Copyright 2008 - All rights reserved.
 * @since 09/22/2004
 */
public class InOrder1<T,P> implements IVisitor<T,P,P> {
    private ILambda3<P,P,BiTree<T>,P> _f;

    public InOrder1(ILambda3<P,P,BiTree<T>,P> f) {
        _f = f;
    }

    public P emptyCase(BiTree<T> host, P... b) {
        return b[0]; 
    }

    public P nonEmptyCase(BiTree<T> host, P... b) {
        return _f.apply(host.getLeftSubTree().execute(this, b), 
                        host,
                        host.getRightSubTree().execute(this, b));
    }

    public static void main(String[] nu) {
        final ILambda<Integer,Integer> add = Add.Singleton;
        ILambda3<Integer,Integer,BiTree<Integer>,Integer> add3 = new ILambda3<Integer,Integer,BiTree<Integer>,Integer>() {
            public Integer apply(Integer arg1, BiTree<Integer> arg2, Integer arg3) {
                return add.apply(arg1, arg2.getRootDat(), arg3);
            }
        };
        // Add the numbers in the tree in in-order fashion:
        InOrder1<Integer,Integer> inOrderAdd = new InOrder1<Integer,Integer>(add3);

        final ILambda<String,Object> concat = new ILambda<String,Object>() {
            public String apply(Object... params) {
                if ("" != params[0].toString()) {
                    if ("" != params[1].toString()) {
                        return params[0].toString() + " " + params[1].toString();
                    }
                    else {
                        return params[0].toString();
                    }
                }
                else {
                    return params[1].toString();
                }
            }
        };
        ILambda3<String,String,BiTree<Integer>,String> concat3 = new ILambda3<String,String,BiTree<Integer>,String>() {
            public String apply(String arg1, BiTree<Integer> arg2, String arg3) {
                System.err.println(arg2.getRootDat());
                return concat.apply(concat.apply(arg1, arg2.getRootDat()), arg3);
            }
        };        
        // Concatenate the String representation of the elements in the tree 
        // in in-order fashion:
        InOrder1<Integer,String> inOrderConcat = new InOrder1<Integer,String>(concat3);

        ILambda3<BiTree<Integer>,BiTree<Integer>,BiTree<Integer>,BiTree<Integer>> makeTree = 
            new ILambda3<BiTree<Integer>,BiTree<Integer>,BiTree<Integer>,BiTree<Integer>>() {
            public BiTree<Integer> apply(BiTree<Integer> arg1,
                                         BiTree<Integer> arg2,
                                         BiTree<Integer> arg3) {
                BiTree<Integer> result = new BiTree<Integer>();
                result.insertRoot(arg2.getRootDat());
                result.setLeftSubTree(arg1);
                result.setRightSubTree(arg3);
                return result;
            }
        };
        // Cloning a BiTree:
        InOrder1<Integer,BiTree<Integer>> inOrderClone = new InOrder1<Integer,BiTree<Integer>>(makeTree);

        ILambda3<BiTree<Integer>,BiTree<Integer>,BiTree<Integer>,BiTree<Integer>> makeMirror =
            new ILambda3<BiTree<Integer>,BiTree<Integer>,BiTree<Integer>,BiTree<Integer>>() {
            public BiTree<Integer> apply(BiTree<Integer> arg1,
                                         BiTree<Integer> arg2,
                                         BiTree<Integer> arg3) {
                BiTree<Integer> result = new BiTree<Integer>();
                result.insertRoot(arg2.getRootDat());
                result.setLeftSubTree(arg3);
                result.setRightSubTree(arg1);
                return result;
            }
        };
        // Mirror image of a BiTree:
        InOrder1<Integer,BiTree<Integer>> inOrderMirror = new InOrder1<Integer,BiTree<Integer>>(makeMirror);
        BiTree<Integer> bt = new BiTree<Integer>();
        System.out.println(bt + "\nAdd \n" + bt.execute(inOrderAdd, 0));
        System.out.println("In order concat \n" + bt.execute(inOrderConcat, ""));        
//        System.out.println("Cloning \n" + bt.execute(inOrderClone, new BiTree())); 
//        System.out.println("Mirror Tree \n" + bt.execute(inOrderMirror, new BiTree()) + '\n'); 
        System.out.println("==============================");

        bt.insertRoot(5);
        System.out.println(bt + "\nAdd \n" + bt.execute(inOrderAdd, 0));
        System.out.println("In order concat \n" + bt.execute(inOrderConcat, ""));        
//        System.out.println("Cloning \n" + bt.execute(inOrderClone, new BiTree())); 
//        System.out.println("Mirror Tree \n" + bt.execute(inOrderMirror, new BiTree()) + '\n'); 
        System.out.println("==============================");

        bt.getLeftSubTree().insertRoot(-2);
        System.out.println(bt + "\nAdd \n" + bt.execute(inOrderAdd, 0));
        System.out.println("In order concat \n" + bt.execute(inOrderConcat, ""));        
//        System.out.println("Cloning \n" + bt.execute(inOrderClone, new BiTree())); 
//        System.out.println("Mirror Tree \n" + bt.execute(inOrderMirror, new BiTree()) + '\n'); 
        System.out.println("==============================");

        bt.getRightSubTree().insertRoot(10);
        System.out.println(bt + "\nAdd \n" + bt.execute(inOrderAdd, 0));
        System.out.println("In order concat \n" + bt.execute(inOrderConcat, ""));        
//        System.out.println("Cloning \n" + bt.execute(inOrderClone, new BiTree())); 
//        System.out.println("Mirror Tree \n" + bt.execute(inOrderMirror, new BiTree()) + '\n'); 
        System.out.println("==============================");

        bt.getRightSubTree().getLeftSubTree().insertRoot(-9);
        System.out.println(bt + "\nAdd \n" + bt.execute(inOrderAdd, 0));
        System.out.println("In order concat \n" + bt.execute(inOrderConcat, ""));        
//        System.out.println("Cloning \n" + bt.execute(inOrderClone, new BiTree())); 
//        System.out.println("Mirror Tree \n" + bt.execute(inOrderMirror, new BiTree()) + '\n'); 

        System.out.println("Done!");
    }
}
