/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.bytecode;

import java.io.IOException;
import java.util.Hashtable;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.EmptyVisitor;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;

public class ConstantChanger {
    Hashtable<String, String> map = new Hashtable();

    public void addTranslation(String in, String out) {
        this.map.put(in, out);
    }

    public void clearTranslations() {
        this.map.clear();
    }

    public static void main(String[] args) {
        String cname = "A$$L{0}$$C{1}$$R.class";
        try {
            JavaClass java_class = Repository.lookupClass(cname);
            if (java_class == null) {
                java_class = new ClassParser(cname).parse();
            }
            ConstantChanger c = new ConstantChanger();
            c.addTranslation("{0}", "String");
            c.addTranslation("{1}", "{0}");
            c.replaceConstants(java_class);
        }
        catch (IOException e) {
            System.out.println("Error loading class " + cname + " (" + e.getMessage() + ")");
        }
    }

    public String replace(String input) {
        String ret = "";
        int loc = 0;
        while (loc >= 0) {
            String val = "";
            int lidx = input.indexOf("{", loc);
            if (lidx >= 0) {
                int ridx = input.indexOf("}", lidx);
                val = input.substring(lidx, ridx + 1);
                ret = ret + input.substring(loc, lidx) + this.map.get(val);
                loc = ridx + 1;
                continue;
            }
            ret = ret + input.substring(loc);
            loc = -1;
        }
        String fval = ret.toString();
        return fval;
    }

    public void replaceConstants(JavaClass src) {
        ClassGen cg1 = new ClassGen(src);
        ConstantPoolGen cp1 = cg1.getConstantPool();
        this.replaceConstants(cp1);
    }

    public void replaceConstants(ConstantPoolGen cp1) {
        ConstantFixer myVisitor = new ConstantFixer(cp1);
        Constant[] cp = cp1.getConstantPool().getConstantPool();
        for (int i = 0; i < cp.length; ++i) {
            if (cp[i] == null) continue;
            cp[i].accept(myVisitor);
        }
    }

    class ConstantFixer
    extends EmptyVisitor {
        ConstantPoolGen p;

        public ConstantFixer(ConstantPoolGen p) {
            this.p = p;
        }

        public void visitConstantClass(ConstantClass obj) {
            String n = ConstantChanger.this.replace(obj.getBytes(this.p.getConstantPool()));
            this.p.setConstant(obj.getNameIndex(), new ConstantUtf8(n));
        }

        public void visitConstantNameAndType(ConstantNameAndType obj) {
            String n = ConstantChanger.this.replace(obj.getName(this.p.getConstantPool()));
            this.p.setConstant(obj.getNameIndex(), new ConstantUtf8(n));
        }

        public void visitConstantString(ConstantString obj) {
        }

        public void visitConstantUtf8(ConstantUtf8 obj) {
        }
    }
}

