/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.bytecode;

import edu.rice.cs.nextgen2.util.NGUtil;
import java.util.LinkedList;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericSignature {
    static byte[] bsig;
    static int loc;

    public static MethodSignature parseMethodSignature(String name, String sig, boolean isstatic) {
        if (name == null) {
            return MethodSignature.NO_SIG;
        }
        loc = 0;
        bsig = sig.getBytes();
        LinkedList<TypeVar> v = null;
        if (bsig[loc] == 60) {
            v = GenericSignature.parseTypeVars();
        }
        NGUtil.debugPrint(false, "so far: " + v + " loc:" + loc);
        LinkedList<Type> z = GenericSignature.parseVars('(', ')');
        Type s = GenericSignature.parseVar();
        MethodSignature m = new MethodSignature(name, v, z, s, isstatic);
        return m;
    }

    public static ClassSignature parseClassSignature(String name, String sig) {
        if (name == null) {
            return ClassSignature.NO_SIG;
        }
        loc = 0;
        bsig = sig.getBytes();
        LinkedList<TypeVar> v = new LinkedList();
        if (bsig[loc] == 60) {
            v = GenericSignature.parseTypeVars();
        }
        ClassType s = GenericSignature.parseClassType();
        ++loc;
        LinkedList<ClassType> ifaces = new LinkedList<ClassType>();
        while (loc < bsig.length) {
            ifaces.add(GenericSignature.parseClassType());
            ++loc;
        }
        ClassSignature ret = new ClassSignature(name, v, s, ifaces);
        return ret;
    }

    public static ClassType parseClassType() {
        return GenericSignature.parseClassType(true);
    }

    public static ClassType parseClassType(boolean needL) {
        boolean iface = false;
        if (bsig[loc] == 58) {
            iface = true;
            ++loc;
        }
        if (bsig[loc] == 76) {
            ++loc;
        } else if (needL) {
            GenericSignature.error();
        }
        int start = loc;
        while (bsig[loc] != 60 && bsig[loc] != 59) {
            ++loc;
        }
        String classname = new String(bsig, start, loc - start);
        LinkedList<Type> v = new LinkedList();
        if (bsig[loc] == 60) {
            v = GenericSignature.parseVars('<', '>');
        }
        NGUtil.debugPrint(false, ":parseClassType: curr:" + loc + " " + (char)bsig[loc]);
        ClassType outer = new ClassType(classname, v, iface);
        if (bsig[loc] == 46) {
            ++loc;
            ClassType inner = GenericSignature.parseClassType(false);
            inner.outer = outer;
            outer = inner;
        }
        NGUtil.debugPrint(false, "parseClassType: " + new String(bsig) + " next:" + (char)bsig[loc] + " idx: " + loc + " c:" + classname + v);
        return outer;
    }

    public static LinkedList<Type> parseVars(char ldelim, char rdelim) {
        if (bsig[loc] != ldelim) {
            GenericSignature.error();
        }
        ++loc;
        LinkedList<Type> l = new LinkedList<Type>();
        while (bsig[loc] != rdelim) {
            l.add(GenericSignature.parseVar());
            NGUtil.debugPrint(false, ":parseVars: curr:" + l + " " + (char)bsig[loc]);
            if (bsig[loc] != 59) continue;
            ++loc;
        }
        NGUtil.debugPrint(false, "parseVars: delim? " + (char)bsig[loc] + " =? " + rdelim);
        ++loc;
        return l;
    }

    public static Type parseVar() {
        byte c = bsig[loc];
        ++loc;
        switch (c) {
            case 66: {
                return Type.BYTE;
            }
            case 67: {
                return Type.CHAR;
            }
            case 68: {
                return Type.DOUBLE;
            }
            case 70: {
                return Type.FLOAT;
            }
            case 73: {
                return Type.INT;
            }
            case 74: {
                return Type.LONG;
            }
            case 58: 
            case 76: {
                --loc;
                return GenericSignature.parseClassType();
            }
            case 83: {
                return Type.SHORT;
            }
            case 84: {
                return GenericSignature.parseTypeVar();
            }
            case 86: {
                return Type.VOID;
            }
            case 90: {
                return Type.BOOLEAN;
            }
            case 91: {
                return new ArrayVar(GenericSignature.parseVar());
            }
            case 42: 
            case 43: 
            case 45: {
                --loc;
                return GenericSignature.parseWildVar();
            }
        }
        throw new RuntimeException("Unknown type sig:" + new String(bsig) + "sig[" + (loc - 1) + "]=" + (char)c);
    }

    public static LinkedList<TypeVar> parseTypeVars() {
        if (bsig[loc] != 60) {
            GenericSignature.error();
        }
        ++loc;
        LinkedList<TypeVar> l = new LinkedList<TypeVar>();
        while (bsig[loc] != 62) {
            l.add(GenericSignature.parseTypeVar());
        }
        NGUtil.debugPrint(false, "curr:" + loc + " " + (char)bsig[loc]);
        ++loc;
        return l;
    }

    public static TypeVar parseTypeVar() {
        int start = loc;
        while (bsig[loc] != 58 && bsig[loc] != 59) {
            ++loc;
        }
        Type bound = null;
        String tvar = new String(bsig, start, loc - start);
        if (bsig[loc] == 58) {
            bound = GenericSignature.parseVar();
            if (bsig[++loc] == 59) {
                ++loc;
            } else {
                GenericSignature.error();
            }
        } else {
            ++loc;
        }
        NGUtil.debugPrint(false, "parseTypeVar: " + new String(bsig) + " idx: " + loc);
        return new TypeVar(tvar, bound);
    }

    public static WildVar parseWildVar() {
        WildVar ret;
        int start = loc;
        if (bsig[loc] != 43 && bsig[loc] != 45 && bsig[loc] != 42) {
            GenericSignature.error();
        }
        if (bsig[loc] == 43) {
            ++loc;
            ret = new ExtendWildVar(GenericSignature.parseVar());
        } else if (bsig[loc] == 45) {
            ++loc;
            ret = new SuperWildVar(GenericSignature.parseVar());
        } else if (bsig[loc] == 42) {
            ++loc;
            ret = new AnyWildVar();
        } else {
            GenericSignature.error();
            return null;
        }
        NGUtil.debugPrint(false, "parseWildType:" + (char)bsig[loc]);
        return ret;
    }

    public static void error() {
        throw new RuntimeException("Error parsing: " + new String(bsig) + " " + (char)bsig[loc] + " at " + loc);
    }

    public static String[][] mapConversion(ClassSignature sig, MethodSignature msig) {
        int p;
        int csize = sig.typevars.size();
        int psize = sig.superclass.params.size();
        int msize = msig.typevars.size();
        String[][] ret = new String[csize + msize][2];
        for (p = 0; p < csize; ++p) {
            TypeVar v = sig.typevars.get(p);
            ret[p][0] = "{" + p + "}";
            ret[p][1] = "{" + sig.superclass.params.indexOf(v) + "}";
            NGUtil.debugPrint(false, "conversion:{" + p + "}" + " => " + ret[p][1]);
        }
        for (p = 0; p < msize; ++p) {
            ret[csize + p][0] = "{" + (csize + p) + "}";
            ret[csize + p][1] = "{" + (psize + p) + "}";
        }
        return ret;
    }

    protected static String toSignature(LinkedList<? extends Type> l) {
        String ret = "";
        ListIterator it = l.listIterator();
        while (it.hasNext()) {
            Type next = (Type)it.next();
            ret = ret + next.toSignature();
            ret = ret + (next instanceof AnyWildVar ? "" : ";");
        }
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassType
    extends Type {
        public LinkedList<Type> params;
        boolean iface;
        Type outer = Type.NOTYPE;

        public ClassType(String n, LinkedList<Type> p) {
            this(n, p, false);
        }

        public ClassType(String n, LinkedList<Type> p, boolean i) {
            super(n, "L");
            this.params = p;
            this.iface = i;
        }

        @Override
        public boolean isParametized() {
            return this.params.size() > 0;
        }

        @Override
        public boolean isGround() {
            return this.isGround(this.params);
        }

        @Override
        public String toString() {
            String ret = "";
            if (this.params == null || this.params.size() == 0) {
                ret = this.name;
            } else {
                String ps = "";
                ListIterator it = this.params.listIterator();
                while (it.hasNext()) {
                    if (!ps.equals("")) {
                        ps = ps + ",";
                    }
                    ps = ps + it.next();
                }
                ret = this.name + "<" + ps + ">";
            }
            if (this.outer != NOTYPE) {
                ret = this.outer + "." + ret;
            }
            return ret;
        }

        @Override
        public String toSignature() {
            System.out.println("ClassType.toSignature");
            String ret = "";
            if (this.outer != NOTYPE) {
                ret = ret + this.outer.toSignature() + ".";
            }
            if (this.iface) {
                ret = ret + ":";
            }
            ret = this.params == null || this.params.size() == 0 ? ret + "L" + this.name : ret + "L" + this.name + "<" + GenericSignature.toSignature(this.params) + ">";
            return ret;
        }
    }

    static class TypeVar
    extends Type {
        Type bounds;

        public TypeVar(String n, Type b) {
            super(n, "T");
            this.bounds = b;
        }

        public String toString() {
            if (this.bounds != null) {
                return this.name + ":" + this.bounds;
            }
            return this.name;
        }

        public String toSignature() {
            if (this.bounds != null) {
                return this.name + ":" + this.bounds.toSignature();
            }
            return this.sym + this.name;
        }

        public boolean isParametized() {
            return false;
        }

        public boolean isGround() {
            return false;
        }

        public boolean equals(Object o) {
            return o instanceof TypeVar && this.name.equals(((TypeVar)o).name);
        }
    }

    static class AnyWildVar
    extends WildVar {
        public AnyWildVar() {
            super(OBJECT, "*");
        }

        public String toString() {
            return this.name;
        }

        public String toSignature() {
            return this.sym;
        }
    }

    static class SuperWildVar
    extends WildVar {
        public SuperWildVar(Type b) {
            super(b, "-");
        }

        public String toString() {
            return this.name + " super " + this.bounds;
        }
    }

    static class ExtendWildVar
    extends WildVar {
        public ExtendWildVar(Type b) {
            super(b, "+");
        }

        public String toString() {
            return this.name + " extends " + this.bounds;
        }
    }

    static abstract class WildVar
    extends Type {
        Type bounds;

        public WildVar(Type b, String type) {
            super("?", type);
            this.bounds = b;
        }

        public String toSignature() {
            return this.sym + this.bounds.toSignature();
        }

        public boolean isParametized() {
            return false;
        }

        public boolean isGround() {
            return false;
        }

        public boolean equals(Object o) {
            return o instanceof WildVar && this.bounds.equals(((WildVar)o).bounds);
        }
    }

    static class ArrayVar
    extends Type {
        Type inner;

        public ArrayVar(Type i) {
            super("[]", "[");
            this.inner = i;
        }

        public boolean isParametized() {
            return this.inner.isParametized();
        }

        public boolean isGround() {
            return this.inner.isGround();
        }

        public String toString() {
            return this.inner + "[]";
        }

        public String toSignature() {
            System.out.println("GS.Array:" + this.inner + this.inner.getClass());
            return this.sym + this.inner.toSignature();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Type {
        public String name;
        String sym;
        public static final Type VOID = new Type("void", "V");
        public static final Type BYTE = new Type("byte", "B");
        public static final Type CHAR = new Type("char", "C");
        public static final Type DOUBLE = new Type("double", "D");
        public static final Type FLOAT = new Type("float", "F");
        public static final Type INT = new Type("int", "I");
        public static final Type LONG = new Type("long", "J");
        public static final Type SHORT = new Type("short", "S");
        public static final Type BOOLEAN = new Type("boolean", "Z");
        public static final Type OBJECT = new Type("java/lang/Object", "_");
        public static final Type NOTYPE = new Type("<notype>", "");

        protected Type(String n, String s) {
            this.name = n;
            this.sym = s;
        }

        public boolean isGround(LinkedList<Type> l) {
            ListIterator i = l.listIterator();
            while (i.hasNext()) {
                if (((Type)i.next()).isGround()) continue;
                return false;
            }
            return true;
        }

        public boolean isParametized() {
            return false;
        }

        public boolean isGround() {
            return true;
        }

        public String toString() {
            return this.name;
        }

        public String toSignature() {
            return this.sym;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassSignature {
        public String name;
        public LinkedList<TypeVar> typevars;
        public ClassType superclass;
        LinkedList<ClassType> ifaces;
        public static final ClassSignature NO_SIG = new ClassSignature("", new LinkedList<TypeVar>(), new ClassType("<empty", new LinkedList<Type>()), new LinkedList<ClassType>());

        public ClassSignature(String n, LinkedList<TypeVar> tvars, ClassType s, LinkedList<ClassType> i) {
            this.name = n;
            this.typevars = tvars;
            this.superclass = s;
            this.ifaces = i;
        }

        public ClassSignature(String n, String s) {
            this(n, new LinkedList<TypeVar>(), new ClassType(s, new LinkedList<Type>()), new LinkedList<ClassType>());
        }

        public String getTemplateName() {
            if (this == NO_SIG) {
                return null;
            }
            String ret = this.name;
            if (this.typevars.size() == 0) {
                return null;
            }
            ret = ret + "$$L";
            for (int i = 0; i < this.typevars.size(); ++i) {
                if (i > 0) {
                    ret = ret + "$$C";
                }
                ret = ret + "{" + i + "}";
            }
            ret = ret + "$$R";
            return ret;
        }

        public String toString() {
            String res = this.name + "<";
            ListIterator it = this.typevars.listIterator();
            if (it.hasNext()) {
                res = res + it.next();
            }
            while (it.hasNext()) {
                res = res + ";" + it.next();
            }
            res = res + ">" + this.superclass;
            if (this.ifaces.size() > 0) {
                res = res + " implementes ";
                ListIterator it2 = this.ifaces.listIterator();
                res = res + (ClassType)it2.next();
                while (it2.hasNext()) {
                    res = res + ", " + it2.next();
                }
            }
            return res;
        }

        public String toSignature() {
            String res = GenericSignature.toSignature(this.typevars);
            if (res.length() > 0) {
                res = "<" + res + ">";
            }
            String t = "";
            if (this.superclass instanceof ClassType) {
                t = ";";
            }
            return res + this.superclass.toSignature() + t + GenericSignature.toSignature(this.ifaces);
        }

        public String[][] mapConversionParent() {
            ClassType sup = this.superclass;
            String[][] ret = new String[sup.params.size()][2];
            for (int p = 0; p < sup.params.size(); ++p) {
                String newVal = null;
                Type v = sup.params.get(p);
                if (v instanceof ClassType) {
                    newVal = NGUtil.dotToDOT(v.toString());
                } else if (v instanceof TypeVar) {
                    LinkedList<TypeVar> tvars = this.typevars;
                    for (int q = 0; q < tvars.size(); ++q) {
                        if (!tvars.get((int)q).name.equals(v.name)) continue;
                        newVal = "{" + q + "}";
                        break;
                    }
                } else {
                    newVal = NGUtil.dotToDOT(v.toString());
                }
                ret[p][0] = "{" + p + "}";
                ret[p][1] = newVal;
                NGUtil.debugPrint(false, "conversion:{" + p + "}" + " => " + newVal);
            }
            return ret;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MethodSignature {
        String name;
        public LinkedList<TypeVar> typevars;
        LinkedList<Type> params;
        Type retType;
        boolean isStatic;
        public static final MethodSignature NO_SIG = new MethodSignature("<null>", new LinkedList<TypeVar>(), new LinkedList<Type>(), null, true);

        public MethodSignature(String n, LinkedList<TypeVar> t, LinkedList<Type> p, Type z, boolean s) {
            this.name = n;
            this.typevars = t;
            this.params = p;
            this.retType = z;
            this.isStatic = s;
        }

        public String getPME() {
            String res = null;
            ListIterator it = this.params.listIterator();
            if (it.hasNext()) {
                Type next = (Type)it.next();
                if (next.name.indexOf("$$E") > -1) {
                    res = next.name;
                }
            }
            return res;
        }

        public String getInterfaceName(ClassSignature csig) {
            String tv = "";
            if (this.typevars != null) {
                ListIterator it = this.typevars.listIterator();
                if (it.hasNext()) {
                    tv = tv + ((TypeVar)it.next()).bounds;
                }
                while (it.hasNext()) {
                    tv = tv + "$$C" + ((TypeVar)it.next()).bounds;
                }
            }
            String s = "S";
            if (!this.isStatic) {
                s = "D";
            }
            String ret = csig.name + "$$l" + NGUtil.dotToDOT(tv) + "$$r" + s + "$$E";
            return ret;
        }

        public String getTemplateName(ClassSignature csig) {
            String tv = "";
            if (this.typevars != null) {
                ListIterator it = this.typevars.listIterator();
                if (it.hasNext()) {
                    tv = tv + ((TypeVar)it.next()).bounds;
                }
                while (it.hasNext()) {
                    tv = tv + "$$C" + ((TypeVar)it.next()).bounds;
                }
            }
            int offset = 0;
            if (!this.isStatic) {
                offset = csig.typevars.size();
            }
            String p = "";
            for (int i = 0; i < this.typevars.size(); ++i) {
                if (i > 0) {
                    p = p + "$$C";
                }
                p = p + "{" + (offset + i) + "}";
            }
            String c = csig.name;
            if (!this.isStatic && (c = csig.getTemplateName()) == null) {
                c = csig.name + "$$L$$R";
            }
            String s = "S";
            if (!this.isStatic) {
                s = "D";
            }
            String ret = c + "$$l" + NGUtil.dotToDOT(tv) + "$$r" + s + "$$E" + "$$L" + p + "$$R";
            return ret;
        }

        public String toString() {
            return this.toString(false);
        }

        public String toString(boolean clean) {
            ListIterator it;
            String res = this.retType + " ";
            if (this.typevars != null) {
                res = res + "<";
                it = this.typevars.listIterator();
                if (it.hasNext()) {
                    res = res + it.next();
                }
                while (it.hasNext()) {
                    res = res + ";" + it.next();
                }
                res = res + ">";
            }
            res = res + this.name + "(";
            it = this.params.listIterator();
            if (clean && it.hasNext()) {
                Type next = (Type)it.next();
                if (next.name.indexOf("$$E") == -1) {
                    res = res + next;
                }
            }
            if (it.hasNext()) {
                res = res + it.next();
            }
            while (it.hasNext()) {
                res = res + "," + it.next();
            }
            res = res + ")";
            return res;
        }

        public String toSignature() {
            String res = "";
            if (this.typevars != null) {
                res = res + "<";
                res = res + GenericSignature.toSignature(this.typevars);
                res = res + ">";
            }
            res = res + "(";
            res = res + GenericSignature.toSignature(this.params);
            res = res + ")" + this.retType.toSignature();
            if (this.retType instanceof ClassType) {
                res = res + ";";
            }
            return res;
        }
    }
}

