/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.classloader;

import java.util.HashMap;

class ClassLoadChecker {
    private final SecurityManager _security = System.getSecurityManager();
    private HashMap<String, Boolean> _checkedPackages = new HashMap();

    ClassLoadChecker() {
    }

    public boolean mustUseSystemLoader(String name) {
        if (name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("sun.")) {
            return true;
        }
        if (this._security == null) {
            return false;
        }
        int lastDot = name.lastIndexOf(46);
        String packageName = lastDot == -1 ? "" : name.substring(0, lastDot);
        Boolean cacheCheck = this._checkedPackages.get(packageName);
        if (cacheCheck != null) {
            return cacheCheck;
        }
        try {
            this._security.checkPackageDefinition(packageName);
            this._checkedPackages.put(packageName, Boolean.FALSE);
            return false;
        }
        catch (SecurityException se) {
            this._checkedPackages.put(packageName, Boolean.TRUE);
            return true;
        }
    }
}

