/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.classloader;

import edu.rice.cs.nextgen2.classloader.InstantiationName;
import edu.rice.cs.nextgen2.classloader.Trio;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class InstantiationNameTest
extends TestCase {
    private static Vector<Trio<String, String, String[]>> _instantiationTemplateTrios;

    public InstantiationNameTest(String s) {
        super(s);
        _instantiationTemplateTrios.add(Trio.make("oneparam$$LA$$R", "oneparam$$L{0}$$R", new String[]{"A"}));
        _instantiationTemplateTrios.add(Trio.make("twoparams$$LA$$CB$$R", "twoparams$$L{1}$$C{0}$$R", new String[]{"A", "B"}));
        _instantiationTemplateTrios.add(Trio.make("nested1$$LList$$LA$$R$$CB$$R", "nested1$$L{1}$$C{0}$$R", new String[]{"List$$LA$$R", "B"}));
        _instantiationTemplateTrios.add(Trio.make("nested2$$LList$$LList$$LA$$R$$R$$CB$$R", "nested2$$L{1}$$C{0}$$R", new String[]{"List$$LList$$LA$$R$$R", "B"}));
        _instantiationTemplateTrios.add(Trio.make("nested3$$Lpack$$DList$$Ljava$$Dlang$$DObject$$R$$R", "nested3$$L{0}$$R", new String[]{"pack.List$$Ljava$$Dlang$$DObject$$R"}));
        _instantiationTemplateTrios.add(Trio.make("outer$inner$$LA$$R", "outer$inner$$L{0}$$R", new String[]{"A"}));
        _instantiationTemplateTrios.add(Trio.make("outer$inner$$LA$$CB$$R", "outer$inner$$L{1}$$C{0}$$R", new String[]{"A", "B"}));
        _instantiationTemplateTrios.add(Trio.make("outer$inner$$LA$$CB$$CC$$R", "outer$inner$$L{2}$$C{1}$$C{0}$$R", new String[]{"A", "B", "C"}));
        _instantiationTemplateTrios.add(Trio.make("first$$Ljava$$Dlang$$DInteger$$R", "first$$L{0}$$R", new String[]{"java.lang.Integer"}));
        _instantiationTemplateTrios.add(Trio.make("first$$Ljava$$Dlang$$DInteger$$R$", "first$$L{0}$$R$", new String[]{"java.lang.Integer"}));
        _instantiationTemplateTrios.add(Trio.make("Foo$$L$$AI$$R", "Foo$$L{0}$$R", new String[]{"[I"}));
        _instantiationTemplateTrios.add(Trio.make("Foo$$L$$ALjava$$Dlang$$DInteger$$S$$R", "Foo$$L{0}$$R", new String[]{"[Ljava.lang.Integer;"}));
        _instantiationTemplateTrios.add(Trio.make("Hashtable$$Ljava$$Dlang$$DString$$Cjava$$Dutil$$DList$$Ljava$$Dlang$$DString$$R$$R", "Hashtable$$L{1}$$C{0}$$R", new String[]{"java.lang.String", "java.util.List$$Ljava$$Dlang$$DString$$R"}));
        _instantiationTemplateTrios.add(Trio.make("Hashtable$$L$$ALjava$$Dlang$$DString$$S$$Cjava$$Dutil$$DList$$L$$ALjava$$Dlang$$DString$$S$$R$$R", "Hashtable$$L{1}$$C{0}$$R", new String[]{"[Ljava.lang.String;", "java.util.List$$L$$ALjava$$Dlang$$DString$$S$$R"}));
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static Test suite() {
        return new TestSuite(InstantiationNameTest.class);
    }

    public void testCreateInstantiationName() {
        String[] packageNames = new String[]{"", "foo.", "foo.bar."};
        for (int i = 0; i < packageNames.length; ++i) {
            String curPackage = packageNames[i];
            for (int j = 0; j < _instantiationTemplateTrios.size(); ++j) {
                String curClass = (String)_instantiationTemplateTrios.get(j).first();
                String combined = curPackage + curClass;
                InstantiationName name = new InstantiationName(combined);
                String[] correctArgs = _instantiationTemplateTrios.get(j).third();
                String[] createdArgs = name.getTypeParameters();
                InstantiationNameTest.assertEquals((String)("Incorrect number of arguments of instantiation name " + combined), (int)correctArgs.length, (int)createdArgs.length);
                for (int argNum = 0; argNum < correctArgs.length; ++argNum) {
                    InstantiationNameTest.assertEquals((String)("Argument #" + argNum + " of " + combined), (String)correctArgs[argNum], (String)createdArgs[argNum]);
                }
            }
        }
    }

    public void testInstantiationToTemplate() {
        String[] packageNames = new String[]{"", "foo.", "foo.bar."};
        for (int i = 0; i < packageNames.length; ++i) {
            String curPackage = packageNames[i];
            for (int j = 0; j < _instantiationTemplateTrios.size(); ++j) {
                String inst = (String)_instantiationTemplateTrios.get(j).first();
                String correctTemplate = curPackage + (String)_instantiationTemplateTrios.get(j).second();
                String combined = curPackage + inst;
                InstantiationName instName = new InstantiationName(combined);
                String templateName = instName.getTemplateName();
                InstantiationNameTest.assertEquals((String)("Template name of " + combined), (String)correctTemplate, (String)templateName);
            }
        }
    }
}

