/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.classloader;

import edu.rice.cs.nextgen2.classloader.ConstantToReplace;
import edu.rice.cs.nextgen2.classloader.InstantiationName;
import edu.rice.cs.nextgen2.classloader.NextGenLoader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.ListIterator;

class TemplateClass {
    public static final byte ClassTag = 7;
    public static final byte FieldrefTag = 9;
    public static final byte MethodrefTag = 10;
    public static final byte InterfaceMethodrefTag = 11;
    public static final byte StringTag = 8;
    public static final byte IntegerTag = 3;
    public static final byte FloatTag = 4;
    public static final byte LongTag = 5;
    public static final byte DoubleTag = 6;
    public static final byte NameAndTypeTag = 12;
    public static final byte Utf8Tag = 1;
    private byte[] _templateData;
    private ConstantToReplace[] _constantsToReplace;

    public TemplateClass(byte[] data) throws IOException {
        this._templateData = data;
        int pos = 8;
        int constantPoolCount = this._getUnsignedShort(pos) - 1;
        pos += 2;
        int[] constantLocation = new int[constantPoolCount];
        int[] constantLength = new int[constantPoolCount];
        LinkedList<Integer> classNamesList = new LinkedList<Integer>();
        for (int i = 0; i < constantPoolCount; ++i) {
            constantLocation[i] = pos;
            Integer xnameIdx = new Integer(this._getUnsignedShort(pos + 1) - 1);
            byte tag = this._templateData[pos];
            switch (tag) {
                case 7: {
                    constantLength[i] = 3;
                    Integer nameIdx = new Integer(this._getUnsignedShort(pos + 1) - 1);
                    if (classNamesList.contains(nameIdx)) break;
                    classNamesList.addLast(nameIdx);
                    break;
                }
                case 8: {
                    constantLength[i] = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: {
                    constantLength[i] = 5;
                    break;
                }
                case 12: {
                    constantLength[i] = 5;
                    Integer tempIdx = new Integer(this._getUnsignedShort(pos + 3) - 1);
                    if (classNamesList.contains(tempIdx)) break;
                    classNamesList.addLast(tempIdx);
                    break;
                }
                case 5: 
                case 6: {
                    constantLength[i] = 9;
                    break;
                }
                case 1: {
                    constantLength[i] = 3 + this._getUnsignedShort(pos + 1);
                    if (classNamesList.contains(new Integer(i))) break;
                    classNamesList.addLast(new Integer(i));
                }
            }
            pos += constantLength[i];
            if (tag != 5 && tag != 6) continue;
            constantLocation[++i] = constantLocation[i - 1] + constantLength[i - 1];
            constantLength[i] = 0;
        }
        LinkedList<ConstantToReplace> toReplace = new LinkedList<ConstantToReplace>();
        ListIterator itor = classNamesList.listIterator();
        while (itor.hasNext()) {
            int name_index = (Integer)itor.next();
            DataInputStream stream = new DataInputStream(new ByteArrayInputStream(this._templateData, constantLocation[name_index], constantLength[name_index]));
            stream.skipBytes(1);
            String name_str = stream.readUTF();
            if (name_str.indexOf(125) == -1) continue;
            toReplace.addLast(new ConstantToReplace(constantLocation[name_index], constantLength[name_index], name_str));
        }
        this._constantsToReplace = toReplace.toArray(new ConstantToReplace[0]);
        Arrays.sort(this._constantsToReplace);
    }

    private int _getUnsignedShort(int firstByteIndex) {
        byte a = this._templateData[firstByteIndex];
        byte b = this._templateData[firstByteIndex + 1];
        return (a & 0xFF) << 8 | b & 0xFF;
    }

    public byte[] getInstantiation(String[] parameters) throws IOException, ClassNotFoundException {
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = NextGenLoader.dotToSlash(parameters[i]);
        }
        int sizeDelta = 0;
        byte[][] newUTFs = new byte[this._constantsToReplace.length][];
        for (int i = 0; i < this._constantsToReplace.length; ++i) {
            ConstantToReplace constant = this._constantsToReplace[i];
            String newText = this.substituteParameters(constant.value, parameters);
            ByteArrayOutputStream outstream = new ByteArrayOutputStream();
            DataOutputStream dataOut = new DataOutputStream(outstream);
            dataOut.writeUTF(newText);
            newUTFs[i] = outstream.toByteArray();
            sizeDelta += newUTFs[i].length - constant.length + 1;
        }
        int newSize = this._templateData.length + sizeDelta;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream(newSize);
        DataOutputStream dataOut = new DataOutputStream(byteOut);
        int posInOld = 0;
        for (int i = 0; i < this._constantsToReplace.length; ++i) {
            ConstantToReplace constant = this._constantsToReplace[i];
            int sizeToCopy = constant.location - posInOld;
            dataOut.write(this._templateData, posInOld, sizeToCopy);
            posInOld += sizeToCopy + constant.length;
            dataOut.writeByte(1);
            dataOut.write(newUTFs[i], 0, newUTFs[i].length);
        }
        int sizeLeft = this._templateData.length - posInOld;
        dataOut.write(this._templateData, posInOld, sizeLeft);
        return byteOut.toByteArray();
    }

    private boolean isParametricClass(String name) throws ClassNotFoundException {
        Class c;
        return NextGenLoader.isParametric(name) && !(c = NextGenLoader.ONLY.loadClass(name, true)).isInterface();
    }

    private String baseClass(String name) {
        int dollarsIdx = name.indexOf("$$L");
        if (dollarsIdx == -1) {
            throw new RuntimeException("Asked for base class of non-parametric name " + name + "!");
        }
        return name.substring(0, dollarsIdx);
    }

    private String substituteParameters(String orig, String[] params) throws ClassNotFoundException {
        String[] fixed;
        if (orig.charAt(0) == '{') {
            int openBracketIdx = orig.indexOf(123);
            int closeBracketIdx = orig.indexOf(125);
            char lastChar = orig.charAt(orig.length() - 1);
            int paramNum = Integer.parseInt(orig.substring(openBracketIdx + 1, closeBracketIdx));
            String param = params[paramNum];
            switch (lastChar) {
                case '}': {
                    return param;
                }
                case '$': {
                    if (this.isParametricClass(param)) {
                        return param + "$";
                    }
                    return param;
                }
                case 'B': {
                    if (NextGenLoader.isParametric(param)) {
                        return this.baseClass(param);
                    }
                    return param;
                }
            }
            throw new RuntimeException("Invalid NextGen constant pool entry: " + orig);
        }
        if (orig.charAt(0) == '[') {
            fixed = params;
        } else {
            fixed = new String[params.length];
            for (int i = 0; i < fixed.length; ++i) {
                fixed[i] = InstantiationName.replaceSubstring(params[i], "/", "$$D");
                fixed[i] = InstantiationName.replaceSubstring(fixed[i], "[", "$$A");
                fixed[i] = InstantiationName.replaceSubstring(fixed[i], ";", "$$S");
                if (orig.charAt(0) != '$' || orig.charAt(1) != 'M') continue;
                fixed[i] = NextGenLoader.dotToSlash(fixed[i]);
            }
        }
        StringBuffer buf = new StringBuffer();
        int beginIndex = 0;
        int i = orig.indexOf(123);
        while (i >= 0) {
            char afterOpen = orig.charAt(i + 1);
            if (Character.isDigit(afterOpen)) {
                int closeBracket = orig.indexOf(125, i + 1);
                buf.append(orig.substring(beginIndex, i));
                int paramNum = Integer.parseInt(orig.substring(i + 1, closeBracket));
                buf.append(fixed[paramNum]);
                beginIndex = closeBracket + 1;
            }
            i = orig.indexOf(123, i + 1);
        }
        buf.append(orig.substring(beginIndex));
        return buf.toString();
    }
}

