/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.compiler.code;

import edu.rice.cs.nextgen2.compiler.code.Symbol;
import edu.rice.cs.nextgen2.compiler.code.Type;
import edu.rice.cs.nextgen2.compiler.code.Types;
import edu.rice.cs.nextgen2.compiler.util.List;
import edu.rice.cs.nextgen2.compiler.util.Name;
import edu.rice.cs.nextgen2.compiler.util.Pair;

public abstract class Attribute {
    public Type type;
    public static final Attribute[] emptyArray = new Attribute[0];

    public Attribute(Type type) {
        this.type = type;
    }

    public abstract void accept(Visitor var1);

    public static interface Visitor {
        public void visitConstant(Constant var1);

        public void visitClass(Class var1);

        public void visitCompound(Compound var1);

        public void visitArray(Array var1);

        public void visitEnum(Enum var1);

        public void visitError(Error var1);
    }

    public static class Error
    extends Attribute {
        public Error(Type type) {
            super(type);
        }

        public void accept(Visitor v) {
            v.visitError(this);
        }

        public String toString() {
            return "<error>";
        }
    }

    public static class Enum
    extends Attribute {
        public Symbol.VarSymbol value;

        public Enum(Type type, Symbol.VarSymbol value) {
            super(type);
            assert (value != null);
            this.value = value;
        }

        public void accept(Visitor v) {
            v.visitEnum(this);
        }

        public String toString() {
            return this.value == null ? "null" : this.value.name.toString();
        }
    }

    public static class Array
    extends Attribute {
        public final Attribute[] values;

        public Array(Type type, Attribute[] values) {
            super(type);
            this.values = values;
        }

        public void accept(Visitor v) {
            v.visitArray(this);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("{");
            boolean first = true;
            for (Attribute value : this.values) {
                if (!first) {
                    buf.append(",");
                }
                first = false;
                buf.append(value);
            }
            buf.append("}");
            return buf.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Compound
    extends Attribute {
        public static final List<Compound> emptyList = new List();
        public final List<Pair<Symbol.MethodSymbol, Attribute>> values;

        public Compound(Type type, List<Pair<Symbol.MethodSymbol, Attribute>> values) {
            super(type);
            this.values = values;
        }

        @Override
        public void accept(Visitor v) {
            v.visitCompound(this);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("@");
            buf.append(this.type.tsym.fullName());
            buf.append("{");
            boolean first = true;
            List<Pair<Symbol.MethodSymbol, Attribute>> v = this.values;
            while (v.nonEmpty()) {
                Pair value = (Pair)v.head;
                if (!first) {
                    buf.append(",");
                }
                first = false;
                buf.append(((Symbol.MethodSymbol)value.fst).name);
                buf.append("=");
                buf.append(value.snd);
                v = v.tail;
            }
            buf.append("}");
            return buf.toString();
        }

        public Attribute member(Name member) {
            for (Pair<Symbol.MethodSymbol, Attribute> pair : this.values) {
                if (((Symbol.MethodSymbol)pair.fst).name != member) continue;
                return (Attribute)pair.snd;
            }
            return null;
        }
    }

    public static class Class
    extends Attribute {
        public final Type type;

        public void accept(Visitor v) {
            v.visitClass(this);
        }

        public Class(Types types, Type type) {
            super(Class.makeClassType(types, type));
            this.type = type;
        }

        static Type makeClassType(Types types, Type type) {
            Type arg = type.isPrimitive() ? types.boxedClass((Type)type).type : types.erasure(type);
            return new Type.ClassType(types.syms.classType.outer(), Type.emptyList.prepend(arg), types.syms.classType.tsym);
        }

        public String toString() {
            return this.type + ".class";
        }
    }

    public static class Constant
    extends Attribute {
        public final Object value;

        public void accept(Visitor v) {
            v.visitConstant(this);
        }

        public Constant(Type type, Object value) {
            super(type);
            this.value = value;
        }

        public String toString() {
            return this.value.toString();
        }
    }
}

