/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.compiler.comp;

import edu.rice.cs.nextgen2.compiler.code.Symbol;
import edu.rice.cs.nextgen2.compiler.code.Symtab;
import edu.rice.cs.nextgen2.compiler.code.Type;
import edu.rice.cs.nextgen2.compiler.comp.Check;
import edu.rice.cs.nextgen2.compiler.tree.Tree;
import edu.rice.cs.nextgen2.compiler.tree.TreeInfo;
import edu.rice.cs.nextgen2.compiler.tree.TreeMaker;
import edu.rice.cs.nextgen2.compiler.tree.TreeScanner;
import edu.rice.cs.nextgen2.compiler.util.Bits;
import edu.rice.cs.nextgen2.compiler.util.Context;
import edu.rice.cs.nextgen2.compiler.util.List;
import edu.rice.cs.nextgen2.compiler.util.ListBuffer;
import edu.rice.cs.nextgen2.compiler.util.Log;
import edu.rice.cs.nextgen2.compiler.util.Name;
import edu.rice.cs.nextgen2.compiler.util.Options;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Flow
extends TreeScanner {
    protected static final Context.Key<Flow> flowKey = new Context.Key();
    private final Name.Table names;
    private final Log log;
    private final Symtab syms;
    private final Check chk;
    private TreeMaker make;
    private final boolean lintSwitchFallThrough;
    private final boolean lintFinally;
    private boolean alive;
    Bits inits;
    Bits uninits;
    Bits uninitsTry;
    Bits initsWhenTrue;
    Bits initsWhenFalse;
    Bits uninitsWhenTrue;
    Bits uninitsWhenFalse;
    Symbol.VarSymbol[] vars;
    Tree.ClassDef classDef;
    int firstadr;
    int nextadr;
    List<Type> thrown;
    List<Type> caught;
    boolean loopPassTwo = false;
    ListBuffer<PendingExit> pendingExits;

    public static Flow instance(Context context) {
        Flow instance = context.get(flowKey);
        if (instance == null) {
            instance = new Flow(context);
        }
        return instance;
    }

    protected Flow(Context context) {
        context.put(flowKey, this);
        this.names = Name.Table.instance(context);
        this.log = Log.instance(context);
        this.syms = Symtab.instance(context);
        this.chk = Check.instance(context);
        Options options = Options.instance(context);
        this.lintSwitchFallThrough = options.lint("fallthrough");
        this.lintFinally = options.lint("finally");
    }

    void errorUncaught() {
        PendingExit exit = this.pendingExits.next();
        while (exit != null) {
            boolean synthetic = this.classDef != null && this.classDef.pos == exit.tree.pos;
            this.log.error(exit.tree.pos, synthetic ? "unreported.exception.default.constructor" : "unreported.exception.need.to.catch.or.throw", exit.thrown);
            exit = this.pendingExits.next();
        }
    }

    void markThrown(Tree tree, Type exc) {
        if (!this.chk.isUnchecked(tree.pos, exc)) {
            if (!this.chk.isHandled(exc, this.caught)) {
                this.pendingExits.append(new PendingExit(tree, exc));
            }
            this.thrown = this.chk.incl(exc, this.thrown);
        }
    }

    boolean trackable(Symbol.VarSymbol sym) {
        return sym.owner.kind == 16 || (sym.flags() & 0x200040010L) == 16L && this.classDef.sym.isEnclosedBy((Symbol.ClassSymbol)sym.owner);
    }

    void newVar(Symbol.VarSymbol sym) {
        if (this.nextadr == this.vars.length) {
            Symbol.VarSymbol[] newvars = new Symbol.VarSymbol[this.nextadr * 2];
            System.arraycopy(this.vars, 0, newvars, 0, this.nextadr);
            this.vars = newvars;
        }
        sym.adr = this.nextadr;
        this.vars[this.nextadr] = sym;
        this.inits.excl(this.nextadr);
        this.uninits.incl(this.nextadr);
        ++this.nextadr;
    }

    void letInit(int pos, Symbol.VarSymbol sym) {
        if (sym.adr >= this.firstadr && this.trackable(sym)) {
            if ((sym.flags() & 0x10L) != 0L) {
                if ((sym.flags() & 0x200000000L) != 0L) {
                    this.log.error(pos, "final.parameter.may.not.be.assigned", sym);
                } else if (!this.uninits.isMember(sym.adr)) {
                    this.log.error(pos, this.loopPassTwo ? "var.might.be.assigned.in.loop" : "var.might.already.be.assigned", sym);
                } else if (!this.inits.isMember(sym.adr)) {
                    this.uninits.excl(sym.adr);
                    this.uninitsTry.excl(sym.adr);
                } else {
                    this.uninits.excl(sym.adr);
                }
            }
            this.inits.incl(sym.adr);
        } else if ((sym.flags() & 0x10L) != 0L) {
            this.log.error(pos, "var.might.already.be.assigned", sym);
        }
    }

    void letInit(Tree tree) {
        tree = TreeInfo.skipParens(tree);
        if (tree.tag == 35 || tree.tag == 34) {
            Symbol sym = TreeInfo.symbol(tree);
            this.letInit(tree.pos, (Symbol.VarSymbol)sym);
        }
    }

    void checkInit(int pos, Symbol.VarSymbol sym) {
        if ((sym.adr >= this.firstadr || sym.owner.kind != 2) && this.trackable(sym) && !this.inits.isMember(sym.adr)) {
            this.log.error(pos, "var.might.not.have.been.initialized", sym);
            this.inits.incl(sym.adr);
        }
    }

    void recordExit(Tree tree) {
        this.pendingExits.append(new PendingExit(tree, this.inits, this.uninits));
        this.markDead();
    }

    boolean resolveBreaks(Tree tree, ListBuffer<PendingExit> oldPendingExits) {
        boolean result = false;
        List<PendingExit> exits = this.pendingExits.toList();
        this.pendingExits = oldPendingExits;
        while (exits.nonEmpty()) {
            PendingExit exit = (PendingExit)exits.head;
            if (exit.tree.tag == 21 && ((Tree.Break)exit.tree).target == tree) {
                this.inits.andSet(exit.inits);
                this.uninits.andSet(exit.uninits);
                result = true;
            } else {
                this.pendingExits.append(exit);
            }
            exits = exits.tail;
        }
        return result;
    }

    boolean resolveContinues(Tree tree) {
        boolean result = false;
        List<PendingExit> exits = this.pendingExits.toList();
        this.pendingExits = new ListBuffer();
        while (exits.nonEmpty()) {
            PendingExit exit = (PendingExit)exits.head;
            if (exit.tree.tag == 22 && ((Tree.Continue)exit.tree).target == tree) {
                this.inits.andSet(exit.inits);
                this.uninits.andSet(exit.uninits);
                result = true;
            } else {
                this.pendingExits.append(exit);
            }
            exits = exits.tail;
        }
        return result;
    }

    void markDead() {
        this.inits.inclRange(this.firstadr, this.nextadr);
        this.uninits.inclRange(this.firstadr, this.nextadr);
        this.alive = false;
    }

    void split() {
        this.initsWhenFalse = this.inits.dup();
        this.uninitsWhenFalse = this.uninits.dup();
        this.initsWhenTrue = this.inits;
        this.uninitsWhenTrue = this.uninits;
        this.uninits = null;
        this.inits = null;
    }

    void merge() {
        this.inits = this.initsWhenFalse.andSet(this.initsWhenTrue);
        this.uninits = this.uninitsWhenFalse.andSet(this.uninitsWhenTrue);
    }

    void scanDef(Tree tree) {
        this.scanStat(tree);
        if (tree != null && tree.tag == 7 && !this.alive) {
            this.log.error(tree.pos, "initializer.must.be.able.to.complete.normally", new Object[0]);
        }
    }

    void scanStat(Tree tree) {
        if (!this.alive && tree != null) {
            this.log.error(tree.pos, "unreachable.stmt", new Object[0]);
            if (tree.tag != 6) {
                this.alive = true;
            }
        }
        this.scan(tree);
    }

    void scanStats(List<Tree> trees) {
        if (trees != null) {
            List<Tree> l = trees;
            while (l.nonEmpty()) {
                this.scanStat((Tree)l.head);
                l = l.tail;
            }
        }
    }

    void scanExpr(Tree tree) {
        if (tree != null) {
            this.scan(tree);
            if (this.inits == null) {
                this.merge();
            }
        }
    }

    void scanExprs(List<Tree> trees) {
        if (trees != null) {
            List<Tree> l = trees;
            while (l.nonEmpty()) {
                this.scanExpr((Tree)l.head);
                l = l.tail;
            }
        }
    }

    void scanCond(Tree tree) {
        if (tree.type.isFalse()) {
            if (this.inits == null) {
                this.merge();
            }
            this.initsWhenTrue = this.inits.dup();
            this.initsWhenTrue.inclRange(this.firstadr, this.nextadr);
            this.uninitsWhenTrue = this.uninits.dup();
            this.uninitsWhenTrue.inclRange(this.firstadr, this.nextadr);
            this.initsWhenFalse = this.inits;
            this.uninitsWhenFalse = this.uninits;
        } else if (tree.type.isTrue()) {
            if (this.inits == null) {
                this.merge();
            }
            this.initsWhenFalse = this.inits.dup();
            this.initsWhenFalse.inclRange(this.firstadr, this.nextadr);
            this.uninitsWhenFalse = this.uninits.dup();
            this.uninitsWhenFalse.inclRange(this.firstadr, this.nextadr);
            this.initsWhenTrue = this.inits;
            this.uninitsWhenTrue = this.uninits;
        } else {
            this.scan(tree);
            if (this.inits != null) {
                this.split();
            }
        }
        this.uninits = null;
        this.inits = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitClassDef(Tree.ClassDef tree) {
        if (tree.sym == null) {
            return;
        }
        Tree.ClassDef classDefPrev = this.classDef;
        List<Type> thrownPrev = this.thrown;
        List<Type> caughtPrev = this.caught;
        boolean alivePrev = this.alive;
        int firstadrPrev = this.firstadr;
        int nextadrPrev = this.nextadr;
        ListBuffer<PendingExit> pendingExitsPrev = this.pendingExits;
        this.pendingExits = new ListBuffer();
        if (tree.name != this.names.empty) {
            this.caught = Type.emptyList;
            this.firstadr = this.nextadr;
        }
        this.classDef = tree;
        this.thrown = Type.emptyList;
        try {
            Symbol.VarSymbol sym;
            Tree.VarDef def;
            List<Tree> l = tree.defs;
            while (l.nonEmpty()) {
                if (((Tree)l.head).tag == 5) {
                    def = (Tree.VarDef)l.head;
                    if ((def.mods.flags & 8L) != 0L && this.trackable(sym = def.sym)) {
                        this.newVar(sym);
                    }
                }
                l = l.tail;
            }
            l = tree.defs;
            while (l.nonEmpty()) {
                if (((Tree)l.head).tag != 4 && (TreeInfo.flags((Tree)l.head) & 8L) != 0L) {
                    this.scanDef((Tree)l.head);
                    this.errorUncaught();
                }
                l = l.tail;
            }
            if (tree.name != this.names.empty) {
                boolean firstConstructor = true;
                List<Tree> l2 = tree.defs;
                while (l2.nonEmpty()) {
                    if (TreeInfo.isInitialConstructor((Tree)l2.head)) {
                        List<Type> mthrown = ((Tree.MethodDef)l2.head).sym.type.thrown();
                        if (firstConstructor) {
                            this.caught = mthrown;
                            firstConstructor = false;
                        } else {
                            this.caught = this.chk.intersect(mthrown, this.caught);
                        }
                    }
                    l2 = l2.tail;
                }
            }
            l = tree.defs;
            while (l.nonEmpty()) {
                if (((Tree)l.head).tag == 5) {
                    def = (Tree.VarDef)l.head;
                    if ((def.mods.flags & 8L) == 0L && this.trackable(sym = def.sym)) {
                        this.newVar(sym);
                    }
                }
                l = l.tail;
            }
            l = tree.defs;
            while (l.nonEmpty()) {
                if (((Tree)l.head).tag != 4 && (TreeInfo.flags((Tree)l.head) & 8L) == 0L) {
                    this.scanDef((Tree)l.head);
                    this.errorUncaught();
                }
                l = l.tail;
            }
            l = tree.defs;
            while (l.nonEmpty()) {
                if (((Tree)l.head).tag == 4) {
                    this.scan((Tree)l.head);
                    this.errorUncaught();
                }
                l = l.tail;
            }
            if (tree.name == this.names.empty) {
                l = tree.defs;
                while (l.nonEmpty()) {
                    if (TreeInfo.isInitialConstructor((Tree)l.head)) {
                        Tree.MethodDef mdef = (Tree.MethodDef)l.head;
                        mdef.thrown = this.make.Types(this.thrown);
                        mdef.sym.type.setThrown(this.thrown);
                    }
                    l = l.tail;
                }
                this.thrown = this.chk.union(this.thrown, thrownPrev);
            } else {
                this.thrown = thrownPrev;
            }
        }
        finally {
            this.pendingExits = pendingExitsPrev;
            this.alive = alivePrev;
            this.nextadr = nextadrPrev;
            this.firstadr = firstadrPrev;
            this.caught = caughtPrev;
            this.classDef = classDefPrev;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitMethodDef(Tree.MethodDef tree) {
        if (tree.body == null) {
            return;
        }
        List<Type> caughtPrev = this.caught;
        List<Type> mthrown = tree.sym.type.thrown();
        Bits initsPrev = this.inits.dup();
        Bits uninitsPrev = this.uninits.dup();
        int nextadrPrev = this.nextadr;
        int firstadrPrev = this.firstadr;
        assert (this.pendingExits.isEmpty());
        try {
            boolean isInitialConstructor = TreeInfo.isInitialConstructor(tree);
            if (!isInitialConstructor) {
                this.firstadr = this.nextadr;
            }
            List<Tree.VarDef> l = tree.params;
            while (l.nonEmpty()) {
                Tree.VarDef def = (Tree.VarDef)l.head;
                this.scan(def);
                this.inits.incl(def.sym.adr);
                this.uninits.excl(def.sym.adr);
                l = l.tail;
            }
            if (isInitialConstructor) {
                this.caught = this.chk.union(this.caught, mthrown);
            } else if ((tree.sym.flags() & 0x100008L) != 0x100000L) {
                this.caught = mthrown;
            }
            this.alive = true;
            this.scanStat(tree.body);
            int endPos = TreeInfo.endPos(tree.body);
            if (this.alive && tree.sym.type.restype().tag != 9) {
                this.log.error(endPos, "missing.ret.stmt", new Object[0]);
            }
            if (isInitialConstructor) {
                for (int i = this.firstadr; i < this.nextadr; ++i) {
                    if (this.vars[i].owner != this.classDef.sym) continue;
                    this.checkInit(endPos, this.vars[i]);
                }
            }
            List<PendingExit> exits = this.pendingExits.toList();
            this.pendingExits = new ListBuffer();
            while (exits.nonEmpty()) {
                PendingExit exit = (PendingExit)exits.head;
                exits = exits.tail;
                if (exit.thrown == null) {
                    assert (exit.tree.tag == 23);
                    if (!isInitialConstructor) continue;
                    this.inits = exit.inits;
                    for (int i = this.firstadr; i < this.nextadr; ++i) {
                        this.checkInit(exit.tree.pos, this.vars[i]);
                    }
                    continue;
                }
                this.pendingExits.append(exit);
            }
        }
        finally {
            this.inits = initsPrev;
            this.uninits = uninitsPrev;
            this.nextadr = nextadrPrev;
            this.firstadr = firstadrPrev;
            this.caught = caughtPrev;
        }
    }

    @Override
    public void visitVarDef(Tree.VarDef tree) {
        boolean track = this.trackable(tree.sym);
        if (track && tree.sym.owner.kind == 16) {
            this.newVar(tree.sym);
        }
        if (tree.init != null) {
            this.scanExpr(tree.init);
            if (track) {
                this.letInit(tree.pos, tree.sym);
            }
        }
    }

    @Override
    public void visitBlock(Tree.Block tree) {
        int nextadrPrev = this.nextadr;
        this.scanStats(tree.stats);
        this.nextadr = nextadrPrev;
    }

    @Override
    public void visitDoLoop(Tree.DoLoop tree) {
        ListBuffer<PendingExit> prevPendingExits = this.pendingExits;
        boolean prevLoopPassTwo = this.loopPassTwo;
        while (true) {
            this.pendingExits = new ListBuffer();
            Bits uninitsEntry = this.uninits.dup();
            this.scanStat(tree.body);
            this.alive |= this.resolveContinues(tree);
            this.scanCond(tree.cond);
            if (this.log.nerrors != 0 || this.loopPassTwo || uninitsEntry.diffSet(this.uninitsWhenTrue).nextBit(this.firstadr) == -1) break;
            this.inits = this.initsWhenTrue;
            this.uninits = uninitsEntry.andSet(this.uninitsWhenTrue);
            this.loopPassTwo = true;
            this.alive = true;
        }
        this.loopPassTwo = prevLoopPassTwo;
        this.inits = this.initsWhenFalse;
        this.uninits = this.uninitsWhenFalse;
        this.alive = this.alive && !tree.cond.type.isTrue();
        this.alive |= this.resolveBreaks(tree, prevPendingExits);
    }

    @Override
    public void visitWhileLoop(Tree.WhileLoop tree) {
        Bits uninitsCond;
        Bits initsCond;
        ListBuffer<PendingExit> prevPendingExits = this.pendingExits;
        boolean prevLoopPassTwo = this.loopPassTwo;
        while (true) {
            this.pendingExits = new ListBuffer();
            Bits uninitsEntry = this.uninits.dup();
            this.scanCond(tree.cond);
            initsCond = this.initsWhenFalse;
            uninitsCond = this.uninitsWhenFalse;
            this.inits = this.initsWhenTrue;
            this.uninits = this.uninitsWhenTrue;
            this.alive = !tree.cond.type.isFalse();
            this.scanStat(tree.body);
            this.alive |= this.resolveContinues(tree);
            if (this.log.nerrors != 0 || this.loopPassTwo || uninitsEntry.diffSet(this.uninits).nextBit(this.firstadr) == -1) break;
            this.uninits = uninitsEntry.andSet(this.uninits);
            this.loopPassTwo = true;
            this.alive = true;
        }
        this.loopPassTwo = prevLoopPassTwo;
        this.inits = initsCond;
        this.uninits = uninitsCond;
        this.alive = this.resolveBreaks(tree, prevPendingExits) || !tree.cond.type.isTrue();
    }

    @Override
    public void visitForLoop(Tree.ForLoop tree) {
        Bits uninitsCond;
        Bits initsCond;
        ListBuffer<PendingExit> prevPendingExits = this.pendingExits;
        boolean prevLoopPassTwo = this.loopPassTwo;
        int nextadrPrev = this.nextadr;
        this.scanStats(tree.init);
        while (true) {
            this.pendingExits = new ListBuffer();
            Bits uninitsEntry = this.uninits.dup();
            if (tree.cond != null) {
                this.scanCond(tree.cond);
                initsCond = this.initsWhenFalse;
                uninitsCond = this.uninitsWhenFalse;
                this.inits = this.initsWhenTrue;
                this.uninits = this.uninitsWhenTrue;
                this.alive = !tree.cond.type.isFalse();
            } else {
                initsCond = this.inits.dup();
                initsCond.inclRange(this.firstadr, this.nextadr);
                uninitsCond = this.uninits.dup();
                uninitsCond.inclRange(this.firstadr, this.nextadr);
                this.alive = true;
            }
            this.scanStat(tree.body);
            this.alive |= this.resolveContinues(tree);
            this.scan(tree.step);
            if (this.log.nerrors != 0 || this.loopPassTwo || uninitsEntry.dup().diffSet(this.uninits).nextBit(this.firstadr) == -1) break;
            this.uninits = uninitsEntry.andSet(this.uninits);
            this.loopPassTwo = true;
            this.alive = true;
        }
        this.loopPassTwo = prevLoopPassTwo;
        this.inits = initsCond;
        this.uninits = uninitsCond;
        this.alive = this.resolveBreaks(tree, prevPendingExits) || tree.cond != null && !tree.cond.type.isTrue();
        this.nextadr = nextadrPrev;
    }

    @Override
    public void visitForeachLoop(Tree.ForeachLoop tree) {
        this.visitVarDef(tree.var);
        ListBuffer<PendingExit> prevPendingExits = this.pendingExits;
        boolean prevLoopPassTwo = this.loopPassTwo;
        int nextadrPrev = this.nextadr;
        this.scan(tree.expr);
        Bits initsStart = this.inits.dup();
        Bits uninitsStart = this.uninits.dup();
        this.letInit(tree.pos, tree.var.sym);
        while (true) {
            this.pendingExits = new ListBuffer();
            Bits uninitsEntry = this.uninits.dup();
            this.scanStat(tree.body);
            this.alive |= this.resolveContinues(tree);
            if (this.log.nerrors != 0 || this.loopPassTwo || uninitsEntry.diffSet(this.uninits).nextBit(this.firstadr) == -1) break;
            this.uninits = uninitsEntry.andSet(this.uninits);
            this.loopPassTwo = true;
            this.alive = true;
        }
        this.loopPassTwo = prevLoopPassTwo;
        this.inits = initsStart;
        this.uninits = uninitsStart.andSet(this.uninits);
        this.resolveBreaks(tree, prevPendingExits);
        this.alive = true;
        this.nextadr = nextadrPrev;
    }

    @Override
    public void visitLabelled(Tree.Labelled tree) {
        ListBuffer<PendingExit> prevPendingExits = this.pendingExits;
        this.pendingExits = new ListBuffer();
        this.scanStat(tree.body);
        this.alive |= this.resolveBreaks(tree, prevPendingExits);
    }

    @Override
    public void visitSwitch(Tree.Switch tree) {
        ListBuffer<PendingExit> prevPendingExits = this.pendingExits;
        this.pendingExits = new ListBuffer();
        int nextadrPrev = this.nextadr;
        this.scanExpr(tree.selector);
        Bits initsSwitch = this.inits;
        Bits uninitsSwitch = this.uninits.dup();
        boolean hasDefault = false;
        List<Tree.Case> l = tree.cases;
        while (l.nonEmpty()) {
            this.alive = true;
            this.inits = initsSwitch.dup();
            this.uninits = this.uninits.andSet(uninitsSwitch);
            Tree.Case c = (Tree.Case)l.head;
            if (c.pat == null) {
                hasDefault = true;
            } else {
                this.scanExpr(c.pat);
            }
            this.scanStats(c.stats);
            Flow.addVars(c.stats, initsSwitch, uninitsSwitch);
            if (!this.loopPassTwo && this.lintSwitchFallThrough && this.alive && c.stats.nonEmpty() && l.tail.nonEmpty()) {
                this.log.warning(((Tree.Case)l.tail.head).pos, "possible.fall-through.into.case", new Object[0]);
            }
            l = l.tail;
        }
        if (!hasDefault) {
            this.inits.andSet(initsSwitch);
            this.alive = true;
        }
        this.alive |= this.resolveBreaks(tree, prevPendingExits);
        this.nextadr = nextadrPrev;
    }

    private static void addVars(List<Tree> stats, Bits inits, Bits uninits) {
        while (stats.nonEmpty()) {
            Tree stat = (Tree)stats.head;
            if (stat.tag == 5) {
                int adr = ((Tree.VarDef)stat).sym.adr;
                inits.excl(adr);
                uninits.incl(adr);
            }
            stats = stats.tail;
        }
    }

    @Override
    public void visitTry(Tree.Try tree) {
        List<Type> caughtPrev = this.caught;
        List<Type> thrownPrev = this.thrown;
        this.thrown = Type.emptyList;
        List<Tree.Catch> l = tree.catchers;
        while (l.nonEmpty()) {
            this.caught = this.chk.incl(((Tree.Catch)l.head).param.type, this.caught);
            l = l.tail;
        }
        Bits uninitsTryPrev = this.uninitsTry;
        ListBuffer<PendingExit> prevPendingExits = this.pendingExits;
        this.pendingExits = new ListBuffer();
        Bits initsTry = this.inits.dup();
        this.uninitsTry = this.uninits.dup();
        this.scanStat(tree.body);
        List<Type> thrownInTry = this.thrown;
        this.thrown = thrownPrev;
        this.caught = caughtPrev;
        boolean aliveEnd = this.alive;
        this.uninitsTry.andSet(this.uninits);
        Bits initsEnd = this.inits;
        Bits uninitsEnd = this.uninits;
        int nextadrCatch = this.nextadr;
        List<Type> caughtInTry = Type.emptyList;
        List<Tree.Catch> l2 = tree.catchers;
        while (l2.nonEmpty()) {
            this.alive = true;
            Tree.VarDef param = ((Tree.Catch)l2.head).param;
            Type exc = param.type;
            if (this.chk.subset(exc, caughtInTry)) {
                this.log.error(((Tree.Catch)l2.head).pos, "except.already.caught", exc);
            } else if (!this.chk.isUnchecked(((Tree.Catch)l2.head).pos, exc) && exc.tsym != this.syms.throwableType.tsym && exc.tsym != this.syms.exceptionType.tsym && !this.chk.intersects(exc, thrownInTry)) {
                this.log.error(((Tree.Catch)l2.head).pos, "except.never.thrown.in.try", exc);
            }
            caughtInTry = this.chk.incl(exc, caughtInTry);
            this.inits = initsTry.dup();
            this.uninits = this.uninitsTry.dup();
            this.scan(param);
            this.inits.incl(param.sym.adr);
            this.uninits.excl(param.sym.adr);
            this.scanStat(((Tree.Catch)l2.head).body);
            initsEnd.andSet(this.inits);
            uninitsEnd.andSet(this.uninits);
            this.nextadr = nextadrCatch;
            aliveEnd |= this.alive;
            l2 = l2.tail;
        }
        if (tree.finalizer != null) {
            List<Type> savedThrown = this.thrown;
            this.thrown = Type.emptyList;
            this.inits = initsTry.dup();
            this.uninits = this.uninitsTry.dup();
            ListBuffer<PendingExit> exits = this.pendingExits;
            this.pendingExits = prevPendingExits;
            this.alive = true;
            this.scanStat(tree.finalizer);
            if (!this.alive) {
                this.thrown = this.chk.union(this.thrown, thrownPrev);
                if (this.lintFinally && !this.loopPassTwo) {
                    this.log.warning(TreeInfo.endPos(tree.finalizer), "finally.cannot.complete", new Object[0]);
                }
            } else {
                this.thrown = this.chk.union(this.thrown, this.chk.diff(thrownInTry, caughtInTry));
                this.thrown = this.chk.union(this.thrown, savedThrown);
                this.uninits.andSet(uninitsEnd);
                while (exits.nonEmpty()) {
                    PendingExit exit = exits.next();
                    if (exit.inits != null) {
                        exit.inits.orSet(this.inits);
                        exit.uninits.andSet(this.uninits);
                    }
                    this.pendingExits.append(exit);
                }
                this.inits.orSet(initsEnd);
                this.alive = aliveEnd;
            }
        } else {
            this.thrown = this.chk.union(this.thrown, this.chk.diff(thrownInTry, caughtInTry));
            this.inits = initsEnd;
            this.uninits = uninitsEnd;
            this.alive = aliveEnd;
            ListBuffer<PendingExit> exits = this.pendingExits;
            this.pendingExits = prevPendingExits;
            while (exits.nonEmpty()) {
                this.pendingExits.append(exits.next());
            }
        }
        this.uninitsTry.andSet(uninitsTryPrev).andSet(this.uninits);
    }

    @Override
    public void visitConditional(Tree.Conditional tree) {
        this.scanCond(tree.cond);
        Bits initsBeforeElse = this.initsWhenFalse;
        Bits uninitsBeforeElse = this.uninitsWhenFalse;
        this.inits = this.initsWhenTrue;
        this.uninits = this.uninitsWhenTrue;
        if (tree.truepart.type.tag == 8 && tree.falsepart.type.tag == 8) {
            this.scanCond(tree.truepart);
            Bits initsAfterThenWhenTrue = this.initsWhenTrue.dup();
            Bits initsAfterThenWhenFalse = this.initsWhenFalse.dup();
            Bits uninitsAfterThenWhenTrue = this.uninitsWhenTrue.dup();
            Bits uninitsAfterThenWhenFalse = this.uninitsWhenFalse.dup();
            this.inits = initsBeforeElse;
            this.uninits = uninitsBeforeElse;
            this.scanCond(tree.falsepart);
            this.initsWhenTrue.andSet(initsAfterThenWhenTrue);
            this.initsWhenFalse.andSet(initsAfterThenWhenFalse);
            this.uninitsWhenTrue.andSet(uninitsAfterThenWhenTrue);
            this.uninitsWhenFalse.andSet(uninitsAfterThenWhenFalse);
        } else {
            this.scanExpr(tree.truepart);
            Bits initsAfterThen = this.inits.dup();
            Bits uninitsAfterThen = this.uninits.dup();
            this.inits = initsBeforeElse;
            this.uninits = uninitsBeforeElse;
            this.scanExpr(tree.falsepart);
            this.inits.andSet(initsAfterThen);
            this.uninits.andSet(uninitsAfterThen);
        }
    }

    @Override
    public void visitIf(Tree.If tree) {
        this.scanCond(tree.cond);
        Bits initsBeforeElse = this.initsWhenFalse;
        Bits uninitsBeforeElse = this.uninitsWhenFalse;
        this.inits = this.initsWhenTrue;
        this.uninits = this.uninitsWhenTrue;
        this.scanStat(tree.thenpart);
        if (tree.elsepart != null) {
            boolean aliveAfterThen = this.alive;
            this.alive = true;
            Bits initsAfterThen = this.inits.dup();
            Bits uninitsAfterThen = this.uninits.dup();
            this.inits = initsBeforeElse;
            this.uninits = uninitsBeforeElse;
            this.scanStat(tree.elsepart);
            this.inits.andSet(initsAfterThen);
            this.uninits.andSet(uninitsAfterThen);
            this.alive |= aliveAfterThen;
        } else {
            this.inits.andSet(initsBeforeElse);
            this.uninits.andSet(uninitsBeforeElse);
            this.alive = true;
        }
    }

    @Override
    public void visitBreak(Tree.Break tree) {
        this.recordExit(tree);
    }

    @Override
    public void visitContinue(Tree.Continue tree) {
        this.recordExit(tree);
    }

    @Override
    public void visitReturn(Tree.Return tree) {
        this.scanExpr(tree.expr);
        this.recordExit(tree);
    }

    @Override
    public void visitThrow(Tree.Throw tree) {
        this.scanExpr(tree.expr);
        this.markThrown(tree, tree.expr.type);
        this.markDead();
    }

    @Override
    public void visitApply(Tree.Apply tree) {
        this.scanExpr(tree.meth);
        this.scanExprs(tree.args);
        List<Type> l = tree.meth.type.thrown();
        while (l.nonEmpty()) {
            this.markThrown(tree, (Type)l.head);
            l = l.tail;
        }
    }

    @Override
    public void visitNewClass(Tree.NewClass tree) {
        this.scanExpr(tree.encl);
        this.scanExprs(tree.args);
        List<Type> l = tree.constructor.type.thrown();
        while (l.nonEmpty()) {
            this.markThrown(tree, (Type)l.head);
            l = l.tail;
        }
        this.scan(tree.def);
    }

    @Override
    public void visitNewArray(Tree.NewArray tree) {
        this.scanExprs(tree.dims);
        this.scanExprs(tree.elems);
    }

    @Override
    public void visitAssert(Tree.Assert tree) {
        Bits initsExit = this.inits.dup();
        Bits uninitsExit = this.uninits.dup();
        this.scanCond(tree.cond);
        uninitsExit.andSet(this.uninitsWhenTrue);
        if (tree.detail != null) {
            this.inits = this.initsWhenFalse;
            this.uninits = this.uninitsWhenFalse;
            this.scanExpr(tree.detail);
        }
        this.inits = initsExit;
        this.uninits = uninitsExit;
    }

    @Override
    public void visitAssign(Tree.Assign tree) {
        Tree lhs = TreeInfo.skipParens(tree.lhs);
        if (!(lhs instanceof Tree.Ident)) {
            this.scanExpr(lhs);
        }
        this.scanExpr(tree.rhs);
        this.letInit(lhs);
    }

    @Override
    public void visitAssignop(Tree.Assignop tree) {
        this.scanExpr(tree.lhs);
        this.scanExpr(tree.rhs);
        this.letInit(tree.lhs);
    }

    @Override
    public void visitUnary(Tree.Unary tree) {
        switch (tree.tag) {
            case 48: {
                this.scanCond(tree.arg);
                Bits t = this.initsWhenFalse;
                this.initsWhenFalse = this.initsWhenTrue;
                this.initsWhenTrue = t;
                t = this.uninitsWhenFalse;
                this.uninitsWhenFalse = this.uninitsWhenTrue;
                this.uninitsWhenTrue = t;
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                this.scanExpr(tree.arg);
                this.letInit(tree.arg);
                break;
            }
            default: {
                this.scanExpr(tree.arg);
            }
        }
    }

    @Override
    public void visitBinary(Tree.Binary tree) {
        switch (tree.tag) {
            case 56: {
                this.scanCond(tree.lhs);
                Bits initsWhenFalseLeft = this.initsWhenFalse;
                Bits uninitsWhenFalseLeft = this.uninitsWhenFalse;
                this.inits = this.initsWhenTrue;
                this.uninits = this.uninitsWhenTrue;
                this.scanCond(tree.rhs);
                this.initsWhenFalse.andSet(initsWhenFalseLeft);
                this.uninitsWhenFalse.andSet(uninitsWhenFalseLeft);
                break;
            }
            case 55: {
                this.scanCond(tree.lhs);
                Bits initsWhenTrueLeft = this.initsWhenTrue;
                Bits uninitsWhenTrueLeft = this.uninitsWhenTrue;
                this.inits = this.initsWhenFalse;
                this.uninits = this.uninitsWhenFalse;
                this.scanCond(tree.rhs);
                this.initsWhenTrue.andSet(initsWhenTrueLeft);
                this.uninitsWhenTrue.andSet(uninitsWhenTrueLeft);
                break;
            }
            default: {
                this.scanExpr(tree.lhs);
                this.scanExpr(tree.rhs);
            }
        }
    }

    @Override
    public void visitIdent(Tree.Ident tree) {
        if (tree.sym.kind == 4) {
            this.checkInit(tree.pos, (Symbol.VarSymbol)tree.sym);
        }
    }

    @Override
    public void visitTopLevel(Tree.TopLevel tree) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void analyzeTree(Tree tree, TreeMaker make) {
        block8: {
            try {
                this.make = make;
                this.inits = new Bits();
                this.uninits = new Bits();
                this.uninitsTry = new Bits();
                this.uninitsWhenFalse = null;
                this.uninitsWhenTrue = null;
                this.initsWhenFalse = null;
                this.initsWhenTrue = null;
                if (this.vars == null) {
                    this.vars = new Symbol.VarSymbol[32];
                } else {
                    for (int i = 0; i < this.vars.length; ++i) {
                        this.vars[i] = null;
                    }
                }
                this.firstadr = 0;
                this.nextadr = 0;
                this.pendingExits = new ListBuffer();
                this.alive = true;
                this.caught = null;
                this.thrown = null;
                this.classDef = null;
                this.scan(tree);
                Object var5_4 = null;
                this.uninitsTry = null;
                this.uninits = null;
                this.inits = null;
                this.uninitsWhenFalse = null;
                this.uninitsWhenTrue = null;
                this.initsWhenFalse = null;
                this.initsWhenTrue = null;
                if (this.vars == null) break block8;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.uninitsTry = null;
                this.uninits = null;
                this.inits = null;
                this.uninitsWhenFalse = null;
                this.uninitsWhenTrue = null;
                this.initsWhenFalse = null;
                this.initsWhenTrue = null;
                if (this.vars != null) {
                    for (int i = 0; i < this.vars.length; ++i) {
                        this.vars[i] = null;
                    }
                }
                this.firstadr = 0;
                this.nextadr = 0;
                this.pendingExits = null;
                this.make = null;
                this.caught = null;
                this.thrown = null;
                this.classDef = null;
                throw throwable;
            }
            for (int i = 0; i < this.vars.length; ++i) {
                this.vars[i] = null;
            }
        }
        this.firstadr = 0;
        this.nextadr = 0;
        this.pendingExits = null;
        this.make = null;
        this.caught = null;
        this.thrown = null;
        this.classDef = null;
    }

    static class PendingExit {
        Tree tree;
        Bits inits;
        Bits uninits;
        Type thrown;

        PendingExit(Tree tree, Bits inits, Bits uninits) {
            this.tree = tree;
            this.inits = inits.dup();
            this.uninits = uninits.dup();
        }

        PendingExit(Tree tree, Type thrown) {
            this.tree = tree;
            this.thrown = thrown;
        }
    }
}

