/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.compiler.comp;

import edu.rice.cs.nextgen2.compiler.code.Scope;
import edu.rice.cs.nextgen2.compiler.code.Source;
import edu.rice.cs.nextgen2.compiler.code.Symbol;
import edu.rice.cs.nextgen2.compiler.code.Symtab;
import edu.rice.cs.nextgen2.compiler.code.Type;
import edu.rice.cs.nextgen2.compiler.code.Types;
import edu.rice.cs.nextgen2.compiler.comp.AttrContext;
import edu.rice.cs.nextgen2.compiler.comp.Check;
import edu.rice.cs.nextgen2.compiler.comp.Env;
import edu.rice.cs.nextgen2.compiler.comp.Infer;
import edu.rice.cs.nextgen2.compiler.jvm.ClassReader;
import edu.rice.cs.nextgen2.compiler.tree.Tree;
import edu.rice.cs.nextgen2.compiler.tree.TreeInfo;
import edu.rice.cs.nextgen2.compiler.util.Context;
import edu.rice.cs.nextgen2.compiler.util.Diagnostic;
import edu.rice.cs.nextgen2.compiler.util.FatalError;
import edu.rice.cs.nextgen2.compiler.util.List;
import edu.rice.cs.nextgen2.compiler.util.Log;
import edu.rice.cs.nextgen2.compiler.util.Name;
import edu.rice.cs.nextgen2.compiler.util.Warner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resolve {
    protected static final Context.Key<Resolve> resolveKey = new Context.Key();
    Name.Table names;
    Log log;
    Symtab syms;
    Check chk;
    Infer infer;
    ClassReader reader;
    TreeInfo treeinfo;
    Source source;
    Types types;
    final ResolveError varNotFound;
    final ResolveError wrongMethod;
    final ResolveError wrongMethods;
    final ResolveError methodNotFound;
    final ResolveError typeNotFound;
    Warner noteWarner = new Warner();

    public static Resolve instance(Context context) {
        Resolve instance = context.get(resolveKey);
        if (instance == null) {
            instance = new Resolve(context);
        }
        return instance;
    }

    protected Resolve(Context context) {
        context.put(resolveKey, this);
        this.syms = Symtab.instance(context);
        this.varNotFound = new ResolveError(68, this.syms.errSymbol, "variable not found");
        this.wrongMethod = new ResolveError(70, this.syms.errSymbol, "method not found");
        this.wrongMethods = new ResolveError(69, this.syms.errSymbol, "wrong methods");
        this.methodNotFound = new ResolveError(71, this.syms.errSymbol, "method not found");
        this.typeNotFound = new ResolveError(72, this.syms.errSymbol, "type not found");
        this.names = Name.Table.instance(context);
        this.log = Log.instance(context);
        this.chk = Check.instance(context);
        this.infer = Infer.instance(context);
        this.reader = ClassReader.instance(context);
        this.treeinfo = TreeInfo.instance(context);
        this.source = Source.instance(context);
        this.types = Types.instance(context);
    }

    static boolean isStatic(Env<AttrContext> env) {
        return ((AttrContext)env.info).staticLevel > ((AttrContext)env.outer.info).staticLevel;
    }

    static boolean isInitializer(Env<AttrContext> env) {
        Symbol owner = ((AttrContext)env.info).scope.owner;
        return owner.isConstructor() || owner.owner.kind == 2 && (owner.kind == 4 || owner.kind == 16 && (owner.flags() & 0x100000L) != 0L) && (owner.flags() & 8L) == 0L;
    }

    public boolean isAccessible(Env<AttrContext> env, Symbol.TypeSymbol c) {
        switch ((short)(c.flags() & 7L)) {
            case 2: {
                return env.enclClass.sym.outermostClass() == c.owner.outermostClass();
            }
            case 0: {
                return env.toplevel.packge == c.owner || env.toplevel.packge == c.packge() || env.enclMethod != null && (env.enclMethod.mods.flags & 0x20000000L) != 0L;
            }
            default: {
                return true;
            }
            case 4: 
        }
        return env.toplevel.packge == c.owner || env.toplevel.packge == c.packge() || this.isInnerSubClass(env.enclClass.sym, c.owner);
    }

    private boolean isInnerSubClass(Symbol.ClassSymbol c, Symbol base) {
        while (c != null && !c.isSubClass(base, this.types)) {
            c = c.owner.enclClass();
        }
        return c != null;
    }

    boolean isAccessible(Env<AttrContext> env, Type t) {
        return t.tag == 11 ? this.isAccessible(env, this.types.elemtype(t)) : this.isAccessible(env, t.tsym);
    }

    boolean isAccessible(Env<AttrContext> env, Type site, Symbol sym) {
        if (sym.name == this.names.init && sym.owner != site.tsym) {
            return false;
        }
        switch ((short)(sym.flags() & 7L)) {
            case 2: {
                return (env.enclClass.sym == sym.owner || env.enclClass.sym.outermostClass() == sym.owner.outermostClass()) && sym.isInheritedIn(site.tsym, this.types);
            }
            case 0: {
                return (env.toplevel.packge == sym.owner.owner || env.toplevel.packge == sym.packge()) && sym.isInheritedIn(site.tsym, this.types);
            }
            case 4: {
                return (env.toplevel.packge == sym.owner.owner || env.toplevel.packge == sym.packge() || this.isProtectedAccessible(sym, env.enclClass.sym, site) || ((AttrContext)env.info).selectSuper && (sym.flags() & 8L) == 0L && sym.kind != 2) && (sym.kind != 16 || sym.isConstructor() || ((Symbol.MethodSymbol)sym).implementation(site.tsym, this.types, true) == sym);
            }
        }
        return this.isAccessible(env, site);
    }

    private boolean isProtectedAccessible(Symbol sym, Symbol.ClassSymbol c, Type site) {
        while (c != null && (!c.isSubClass(sym.owner, this.types) || (c.flags() & 0x200L) != 0L || (sym.flags() & 8L) == 0L && sym.kind != 2 && !site.tsym.isSubClass(c, this.types))) {
            c = c.owner.enclClass();
        }
        return c != null;
    }

    Type rawInstantiate(Env<AttrContext> env, Type site, Symbol m, List<Type> argtypes, List<Type> typeargtypes, boolean allowBoxing, boolean useVarargs, Warner warn) throws Infer.NoInstanceException {
        Type.ForAll pmt;
        if (useVarargs && (m.flags() & 0x400000000L) == 0L) {
            return null;
        }
        Type mt = this.types.memberType(site, m);
        List<Type> tvars = ((AttrContext)env.info).tvars;
        if (typeargtypes == null) {
            typeargtypes = Type.emptyList;
        }
        if (mt.tag != 16 && typeargtypes.nonEmpty()) {
            return null;
        }
        if (mt.tag == 16 && typeargtypes.nonEmpty()) {
            pmt = (Type.ForAll)mt;
            if (typeargtypes.length() != pmt.tvars.length()) {
                return null;
            }
            List<Type> formals = pmt.tvars;
            List<Type> actuals = typeargtypes;
            while (formals.nonEmpty() && actuals.nonEmpty()) {
                List<Type> bounds = this.types.subst(this.types.getBounds((Type.TypeVar)formals.head), pmt.tvars, typeargtypes);
                while (bounds.nonEmpty()) {
                    if (!this.types.isSubTypeUnchecked((Type)actuals.head, (Type)bounds.head, warn)) {
                        return null;
                    }
                    bounds = bounds.tail;
                }
                formals = formals.tail;
                actuals = actuals.tail;
            }
            mt = this.types.subst(pmt.qtype, pmt.tvars, typeargtypes);
        } else if (mt.tag == 16) {
            pmt = (Type.ForAll)mt;
            List<Type> tvars1 = this.types.newInstances(pmt.tvars);
            tvars = tvars.appendList(tvars1);
            mt = this.types.subst(pmt.qtype, pmt.tvars, tvars1);
        }
        boolean instNeeded = tvars.tail != null;
        List<Type> l = argtypes;
        while (l.tail != null && !instNeeded) {
            if (((Type)l.head).tag == 16) {
                instNeeded = true;
            }
            l = l.tail;
        }
        List<Type> resa = this.infer.instantiateMethodTyparams(tvars, (Type.MethodType)mt, argtypes, allowBoxing, useVarargs, warn);
        ((AttrContext)env.info).inst = resa;
        if (instNeeded) {
            return this.infer.instantiateMethod(tvars, (Type.MethodType)mt, argtypes, allowBoxing, useVarargs, warn);
        }
        List<Type> formals = mt.argtypes();
        if (formals.head != null && ((Type)formals.head).toString().indexOf("$$E") > 0) {
            formals = formals.tail;
        }
        return this.argumentsAcceptable(argtypes, formals, allowBoxing, useVarargs, warn) ? mt : null;
    }

    Type instantiate(Env<AttrContext> env, Type site, Symbol m, List<Type> argtypes, List<Type> typeargtypes, boolean allowBoxing, boolean useVarargs, Warner warn) {
        try {
            return this.rawInstantiate(env, site, m, argtypes, typeargtypes, allowBoxing, useVarargs, warn);
        }
        catch (Infer.NoInstanceException ex) {
            return null;
        }
    }

    boolean argumentsAcceptable(List<Type> argtypes, List<Type> formals, boolean allowBoxing, boolean useVarargs, Warner warn) {
        Type varargsFormal;
        Type type = varargsFormal = useVarargs ? formals.last() : null;
        while (argtypes.nonEmpty() && formals.head != varargsFormal) {
            boolean works;
            boolean bl = works = allowBoxing ? this.types.isConvertible((Type)argtypes.head, (Type)formals.head, warn) : this.types.isSubTypeUnchecked((Type)argtypes.head, (Type)formals.head, warn);
            if (!works) {
                return false;
            }
            argtypes = argtypes.tail;
            formals = formals.tail;
        }
        if (formals.head != varargsFormal) {
            return false;
        }
        if (!useVarargs) {
            return argtypes.isEmpty();
        }
        Type elt = this.types.elemtype(varargsFormal);
        while (argtypes.nonEmpty()) {
            if (!this.types.isConvertible((Type)argtypes.head, elt, warn)) {
                return false;
            }
            argtypes = argtypes.tail;
        }
        return true;
    }

    Symbol findField(Env<AttrContext> env, Type site, Name name, Symbol.TypeSymbol c) {
        Symbol sym;
        Symbol bestSoFar = this.varNotFound;
        Scope.Entry e = c.members().lookup(name);
        while (e.scope != null) {
            if (e.sym.kind == 4 && (e.sym.flags_field & 0x1000L) == 0L) {
                return this.isAccessible(env, site, e.sym) ? e.sym : new AccessError(e.sym);
            }
            e = e.next();
        }
        Type st = this.types.supertype(c.type);
        if (st != null && st.tag == 10) {
            sym = this.findField(env, site, name, st.tsym);
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
        }
        List<Type> l = this.types.interfaces(c.type);
        while (bestSoFar.kind != 65 && l.nonEmpty()) {
            sym = this.findField(env, site, name, ((Type)l.head).tsym);
            if (bestSoFar.kind < 65 && sym.kind < 65 && sym.owner != bestSoFar.owner) {
                bestSoFar = new AmbiguityError(bestSoFar, sym);
            } else if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
            l = l.tail;
        }
        return bestSoFar;
    }

    public Symbol.VarSymbol resolveInternalField(int pos, Env<AttrContext> env, Type site, Name name) {
        Symbol sym = this.findField(env, site, name, site.tsym);
        if (sym.kind == 4) {
            return (Symbol.VarSymbol)sym;
        }
        throw new FatalError(new Diagnostic("fatal.err.cant.locate.field", name));
    }

    Symbol findVar(Env<AttrContext> env, Name name) {
        Symbol sym;
        Scope.Entry e;
        Symbol bestSoFar = this.varNotFound;
        Env<AttrContext> env1 = env;
        boolean staticOnly = false;
        while (env1.outer != null) {
            if (Resolve.isStatic(env1)) {
                staticOnly = true;
            }
            e = ((AttrContext)env1.info).scope.lookup(name);
            while (e.scope != null && (e.sym.kind != 4 || (e.sym.flags_field & 0x1000L) != 0L)) {
                e = e.next();
            }
            Symbol symbol = sym = e.scope != null ? e.sym : this.findField(env1, env1.enclClass.sym.type, name, env1.enclClass.sym);
            if (sym.exists()) {
                if (staticOnly && sym.kind == 4 && sym.owner.kind == 2 && (sym.flags() & 8L) == 0L) {
                    return new StaticError(sym);
                }
                return sym;
            }
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
            if ((env1.enclClass.sym.flags() & 8L) != 0L) {
                staticOnly = true;
            }
            env1 = env1.outer;
        }
        sym = this.findField(env, this.syms.predefClass.type, name, this.syms.predefClass);
        if (sym.exists()) {
            return sym;
        }
        if (((Symbol)bestSoFar).exists()) {
            return bestSoFar;
        }
        e = env.toplevel.namedImportScope.lookup(name);
        while (e.scope != null) {
            sym = e.sym;
            if (sym.kind == 4) {
                return this.isAccessible(env, sym.owner.type, sym) ? sym : new AccessError(sym);
            }
            e = e.next();
        }
        e = env.toplevel.starImportScope.lookup(name);
        while (e.scope != null) {
            sym = e.sym;
            if (sym.kind == 4) {
                if (bestSoFar.kind < 65 && sym.owner != bestSoFar.owner) {
                    bestSoFar = new AmbiguityError(bestSoFar, sym);
                } else if (sym.kind < bestSoFar.kind) {
                    bestSoFar = this.isAccessible(env, sym.owner.type, sym) ? sym : new AccessError(sym);
                }
            }
            e = e.next();
        }
        return bestSoFar;
    }

    Symbol selectBest(Env<AttrContext> env, Type site, List<Type> argtypes, List<Type> typeargtypes, Symbol sym, Symbol bestSoFar, boolean allowBoxing, boolean useVarargs) {
        if (sym.kind == 31) {
            return bestSoFar;
        }
        if (!sym.isInheritedIn(site.tsym, this.types)) {
            return bestSoFar;
        }
        assert (sym.kind < 65);
        try {
            if (this.rawInstantiate(env, site, sym, argtypes, typeargtypes, allowBoxing, useVarargs, Warner.noWarnings) == null) {
                switch (bestSoFar.kind) {
                    case 71: {
                        return this.wrongMethod.setWrongSym(sym);
                    }
                    case 70: {
                        return this.wrongMethods;
                    }
                }
                return bestSoFar;
            }
        }
        catch (Infer.NoInstanceException ex) {
            switch (bestSoFar.kind) {
                case 71: {
                    return this.wrongMethod.setWrongSym(sym, ex.getDiagnostic());
                }
                case 70: {
                    return this.wrongMethods;
                }
            }
            return bestSoFar;
        }
        if (!this.isAccessible(env, site, sym)) {
            return bestSoFar.kind == 71 ? new AccessError(sym) : bestSoFar;
        }
        return bestSoFar.kind > 65 ? sym : this.mostSpecific(sym, bestSoFar, env, site, allowBoxing, useVarargs);
    }

    Symbol mostSpecific(Symbol m1, Symbol m2, Env<AttrContext> env, Type site, boolean allowBoxing, boolean useVarargs) {
        switch (m2.kind) {
            case 16: {
                boolean m2SignatureMoreSpecific;
                if (m1 == m2) {
                    return m1;
                }
                Type mt1 = this.types.memberType(site, m1);
                this.noteWarner.unchecked = false;
                boolean m1SignatureMoreSpecific = (this.instantiate(env, site, m2, this.types.lowerBoundArgtypes(mt1), null, allowBoxing, false, this.noteWarner) != null || useVarargs && this.instantiate(env, site, m2, this.types.lowerBoundArgtypes(mt1), null, allowBoxing, true, this.noteWarner) != null) && !this.noteWarner.unchecked;
                Type mt2 = this.types.memberType(site, m2);
                this.noteWarner.unchecked = false;
                boolean bl = m2SignatureMoreSpecific = (this.instantiate(env, site, m1, this.types.lowerBoundArgtypes(mt2), null, allowBoxing, false, this.noteWarner) != null || useVarargs && this.instantiate(env, site, m1, this.types.lowerBoundArgtypes(mt2), null, allowBoxing, true, this.noteWarner) != null) && !this.noteWarner.unchecked;
                if (m1SignatureMoreSpecific && m2SignatureMoreSpecific) {
                    Symbol result;
                    boolean m2Abstract;
                    if (!this.types.overrideEquivalent(mt1, mt2)) {
                        return new AmbiguityError(m1, m2);
                    }
                    if ((m1.flags() & 0x80000000L) != (m2.flags() & 0x80000000L)) {
                        return (m1.flags() & 0x80000000L) != 0L ? m2 : m1;
                    }
                    Symbol.TypeSymbol m1Owner = (Symbol.TypeSymbol)m1.owner;
                    Symbol.TypeSymbol m2Owner = (Symbol.TypeSymbol)m2.owner;
                    if (this.types.asSuper(m1Owner.type, m2Owner) != null && ((m1.owner.flags_field & 0x200L) == 0L || (m2.owner.flags_field & 0x200L) != 0L) && m1.overrides(m2, m1Owner, this.types, false)) {
                        return m1;
                    }
                    if (this.types.asSuper(m2Owner.type, m1Owner) != null && ((m2.owner.flags_field & 0x200L) == 0L || (m1.owner.flags_field & 0x200L) != 0L) && m2.overrides(m1, m2Owner, this.types, false)) {
                        return m2;
                    }
                    boolean m1Abstract = (m1.flags() & 0x400L) != 0L;
                    boolean bl2 = m2Abstract = (m2.flags() & 0x400L) != 0L;
                    if (m1Abstract && !m2Abstract) {
                        return m2;
                    }
                    if (m2Abstract && !m1Abstract) {
                        return m1;
                    }
                    if (!m1Abstract && !m2Abstract) {
                        return new AmbiguityError(m1, m2);
                    }
                    if (!this.types.isSameType(m1.erasure(this.types), m2.erasure(this.types))) {
                        return new AmbiguityError(m1, m2);
                    }
                    Type result2 = mt2.restype();
                    if (mt2.tag == 16) {
                        result2 = this.types.subst(result2, ((Type.ForAll)mt2).tvars, ((Type.ForAll)mt1).tvars);
                    }
                    if (this.types.isSubType(mt1.restype(), result2)) {
                        result = m1;
                    } else if (this.types.isSubType(result2, mt1.restype())) {
                        result = m2;
                    } else {
                        return new AmbiguityError(m1, m2);
                    }
                    result = result.clone(result.owner);
                    result.type = (Type)result.type.clone();
                    result.type.setThrown(this.chk.intersect(mt1.thrown(), mt2.thrown()));
                    return result;
                }
                if (m1SignatureMoreSpecific) {
                    return m1;
                }
                if (m2SignatureMoreSpecific) {
                    return m2;
                }
                return new AmbiguityError(m1, m2);
            }
            case 65: {
                AmbiguityError e = (AmbiguityError)m2;
                Symbol err1 = this.mostSpecific(m1, e.sym1, env, site, allowBoxing, useVarargs);
                Symbol err2 = this.mostSpecific(m1, e.sym2, env, site, allowBoxing, useVarargs);
                if (err1 == err2) {
                    return err1;
                }
                if (err1 == e.sym1 && err2 == e.sym2) {
                    return m2;
                }
                if (err1 instanceof AmbiguityError && err2 instanceof AmbiguityError && ((AmbiguityError)err1).sym1 == ((AmbiguityError)err2).sym1) {
                    return new AmbiguityError(m1, m2);
                }
                return new AmbiguityError(err1, err2);
            }
        }
        throw new AssertionError();
    }

    private boolean methodsInherited(Symbol subclass, Symbol superclass) {
        return subclass.isSubClass(superclass, this.types) && ((subclass.flags() & 0x200L) == 0L || superclass.type != this.syms.objectType);
    }

    Symbol findMethod(Env<AttrContext> env, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes, boolean allowBoxing, boolean useVarargs) {
        Type intype = site.tsym == this.syms.arrayClass ? site.tsym.type : site;
        return this.findMethod(env, site, name, argtypes, typeargtypes, intype, true, this.methodNotFound, allowBoxing, useVarargs);
    }

    private Symbol findMethod(Env<AttrContext> env, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes, Type intype, boolean abstractok, Symbol bestSoFar, boolean allowBoxing, boolean useVarargs) {
        Type ct = intype;
        while (ct.tag == 10) {
            Symbol.ClassSymbol c = (Symbol.ClassSymbol)ct.tsym;
            if ((c.flags() & 0x600L) == 0L) {
                abstractok = false;
            }
            Scope.Entry e = c.members().lookup(name);
            while (e.scope != null) {
                if (e.sym.kind == 16 && (e.sym.flags_field & 0x1000L) == 0L) {
                    bestSoFar = this.selectBest(env, site, argtypes, typeargtypes, e.sym, bestSoFar, allowBoxing, useVarargs);
                }
                e = e.next();
            }
            if (abstractok) {
                List<Type> l = this.types.interfaces(c.type);
                while (l.nonEmpty()) {
                    bestSoFar = this.findMethod(env, site, name, argtypes, typeargtypes, (Type)l.head, abstractok, bestSoFar, allowBoxing, useVarargs);
                    l = l.tail;
                }
            }
            ct = this.types.supertype(ct);
        }
        return bestSoFar;
    }

    Symbol findFun(Env<AttrContext> env, Name name, List<Type> argtypes, List<Type> typeargtypes, boolean allowBoxing, boolean useVarargs) {
        Symbol sym;
        Symbol bestSoFar = this.methodNotFound;
        Env<AttrContext> env1 = env;
        boolean staticOnly = false;
        while (env1.outer != null) {
            if (Resolve.isStatic(env1)) {
                staticOnly = true;
            }
            if ((sym = this.findMethod(env1, env1.enclClass.sym.type, name, argtypes, typeargtypes, allowBoxing, useVarargs)).exists()) {
                if (staticOnly && sym.kind == 16 && sym.owner.kind == 2 && (sym.flags() & 8L) == 0L) {
                    return new StaticError(sym);
                }
                return sym;
            }
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
            if ((env1.enclClass.sym.flags() & 8L) != 0L) {
                staticOnly = true;
            }
            env1 = env1.outer;
        }
        sym = this.findMethod(env, this.syms.predefClass.type, name, argtypes, typeargtypes, allowBoxing, useVarargs);
        if (sym.exists()) {
            return sym;
        }
        Scope.Entry e = env.toplevel.namedImportScope.lookup(name);
        while (e.scope != null) {
            sym = e.sym;
            if (sym.kind == 16) {
                if (!this.isAccessible(env, sym.owner.type, sym)) {
                    sym = new AccessError(sym);
                }
                bestSoFar = this.selectBest(env, sym.owner.type, argtypes, typeargtypes, sym, bestSoFar, allowBoxing, useVarargs);
            }
            e = e.next();
        }
        if (bestSoFar.exists()) {
            return bestSoFar;
        }
        e = env.toplevel.starImportScope.lookup(name);
        while (e.scope != null) {
            sym = e.sym;
            if (sym.kind == 16) {
                if (!this.isAccessible(env, sym.owner.type, sym)) {
                    sym = new AccessError(sym);
                }
                bestSoFar = this.selectBest(env, sym.owner.type, argtypes, typeargtypes, sym, bestSoFar, allowBoxing, useVarargs);
            }
            e = e.next();
        }
        return bestSoFar;
    }

    Symbol loadClass(Env<AttrContext> env, Name name) {
        try {
            Symbol.ClassSymbol c = this.reader.loadClass(name);
            return this.isAccessible(env, c) ? c : new AccessError(c);
        }
        catch (ClassReader.BadClassFile err) {
            throw err;
        }
        catch (Symbol.CompletionFailure ex) {
            return this.typeNotFound;
        }
    }

    Symbol findMemberType(Env<AttrContext> env, Type site, Name name, Symbol.TypeSymbol c) {
        Symbol sym;
        Symbol bestSoFar = this.typeNotFound;
        Scope.Entry e = c.members().lookup(name);
        while (e.scope != null) {
            if (e.sym.kind == 2) {
                return this.isAccessible(env, site, e.sym) ? e.sym : new AccessError(e.sym);
            }
            e = e.next();
        }
        Type st = this.types.supertype(c.type);
        if (st != null && st.tag == 10) {
            sym = this.findMemberType(env, site, name, st.tsym);
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
        }
        List<Type> l = this.types.interfaces(c.type);
        while (bestSoFar.kind != 65 && l.nonEmpty()) {
            sym = this.findMemberType(env, site, name, ((Type)l.head).tsym);
            if (bestSoFar.kind < 65 && sym.kind < 65 && sym.owner != bestSoFar.owner) {
                bestSoFar = new AmbiguityError(bestSoFar, sym);
            } else if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
            l = l.tail;
        }
        return bestSoFar;
    }

    Symbol findGlobalType(Env<AttrContext> env, Scope scope, Name name) {
        Symbol bestSoFar = this.typeNotFound;
        Scope.Entry e = scope.lookup(name);
        while (e.scope != null) {
            Symbol sym = this.loadClass(env, e.sym.flatName());
            if (bestSoFar.kind == 2 && sym.kind == 2 && bestSoFar != sym) {
                return new AmbiguityError(bestSoFar, sym);
            }
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
            e = e.next();
        }
        return bestSoFar;
    }

    Symbol findType(Env<AttrContext> env, Name name) {
        Symbol sym;
        Symbol bestSoFar = this.typeNotFound;
        boolean staticOnly = false;
        Env<AttrContext> env1 = env;
        while (env1.outer != null) {
            Tree.ClassDef encl;
            if (Resolve.isStatic(env1)) {
                staticOnly = true;
            }
            Scope.Entry e = ((AttrContext)env1.info).scope.lookup(name);
            while (e.scope != null) {
                if (e.sym.kind == 2) {
                    if (staticOnly && e.sym.type.tag == 14 && e.sym.owner.kind == 2) {
                        return new StaticError(e.sym);
                    }
                    return e.sym;
                }
                e = e.next();
            }
            if (env1.baseClause) {
                encl = (Tree.ClassDef)env1.tree;
            } else {
                sym = this.findMemberType(env1, env1.enclClass.sym.type, name, env1.enclClass.sym);
                if (staticOnly && sym.kind == 2 && sym.type.tag == 10 && sym.type.outer().tag == 10 && env1.enclClass.sym.type.isParameterized() && sym.type.outer().isParameterized()) {
                    return new StaticError(sym);
                }
                if (sym.exists()) {
                    return sym;
                }
                if (sym.kind < bestSoFar.kind) {
                    bestSoFar = sym;
                }
                encl = env1.enclClass;
            }
            if ((encl.sym.flags() & 8L) != 0L) {
                staticOnly = true;
            }
            env1 = env1.outer;
        }
        if (env.tree.tag != 2) {
            sym = this.findGlobalType(env, env.toplevel.namedImportScope, name);
            if (sym.exists()) {
                return sym;
            }
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
            if ((sym = this.findGlobalType(env, env.toplevel.packge.members(), name)).exists()) {
                return sym;
            }
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
            if ((sym = this.findGlobalType(env, env.toplevel.starImportScope, name)).exists()) {
                return sym;
            }
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
        }
        return bestSoFar;
    }

    Symbol findIdent(Env<AttrContext> env, Name name, int kind) {
        Symbol sym;
        Symbol bestSoFar = this.typeNotFound;
        if ((kind & 4) != 0) {
            sym = this.findVar(env, name);
            if (sym.exists()) {
                return sym;
            }
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
        }
        if ((kind & 2) != 0) {
            sym = this.findType(env, name);
            if (sym.exists()) {
                return sym;
            }
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
        }
        if ((kind & 1) != 0) {
            return this.reader.enterPackage(name);
        }
        return bestSoFar;
    }

    Symbol findIdentInPackage(Env<AttrContext> env, Symbol.TypeSymbol pck, Name name, int kind) {
        Name fullname = Symbol.TypeSymbol.formFullName(name, pck);
        Symbol bestSoFar = this.typeNotFound;
        Symbol.PackageSymbol pack = null;
        if ((kind & 1) != 0 && (pack = this.reader.enterPackage(fullname)).exists()) {
            return pack;
        }
        if ((kind & 2) != 0) {
            Symbol sym = this.loadClass(env, fullname);
            if (sym.exists()) {
                if (name == sym.name) {
                    return sym;
                }
            } else if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
        }
        return pack != null ? pack : bestSoFar;
    }

    Symbol findIdentInType(Env<AttrContext> env, Type site, Name name, int kind) {
        Symbol sym;
        Symbol bestSoFar = this.typeNotFound;
        if ((kind & 4) != 0) {
            sym = this.findField(env, site, name, site.tsym);
            if (sym.exists()) {
                return sym;
            }
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
        }
        if ((kind & 2) != 0) {
            sym = this.findMemberType(env, site, name, site.tsym);
            if (sym.exists()) {
                return sym;
            }
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
        }
        return bestSoFar;
    }

    Symbol access(Symbol sym, int pos, Type site, Name name, boolean qualified, List<Type> argtypes, List<Type> typeargtypes) {
        if (sym.kind >= 65) {
            if (!(site.isErroneous() || Type.isErroneous(argtypes) || typeargtypes != null && Type.isErroneous(typeargtypes))) {
                ((ResolveError)sym).report(this.log, pos, site, name, argtypes, typeargtypes);
            }
            do {
                sym = ((ResolveError)sym).sym;
            } while (sym.kind >= 65);
            if (sym == this.syms.errSymbol) {
                sym = new Type.ErrorType((Name)name, (Symbol.TypeSymbol)(qualified ? site.tsym : this.syms.noSymbol)).tsym;
            }
        }
        return sym;
    }

    Symbol access(Symbol sym, int pos, Type site, Name name, boolean qualified) {
        if (sym.kind >= 65) {
            return this.access(sym, pos, site, name, qualified, Type.emptyList, null);
        }
        return sym;
    }

    void checkNonAbstract(int pos, Symbol sym) {
        if ((sym.flags() & 0x400L) != 0L) {
            this.log.error(pos, "abstract.cant.be.accessed.directly", Resolve.kindName(sym.kind), sym, sym.location());
        }
    }

    public void printscopes(Scope s) {
        while (s != null) {
            if (s.owner != null) {
                System.err.print(s.owner + ": ");
            }
            Scope.Entry e = s.elems;
            while (e != null) {
                if ((e.sym.flags() & 0x400L) != 0L) {
                    System.err.print("abstract ");
                }
                System.err.print(e.sym + " ");
                e = e.sibling;
            }
            System.err.println();
            s = s.next;
        }
    }

    void printscopes(Env<AttrContext> env) {
        while (env.outer != null) {
            System.err.println("------------------------------");
            this.printscopes(((AttrContext)env.info).scope);
            env = env.outer;
        }
    }

    public void printscopes(Type t) {
        while (t.tag == 10) {
            this.printscopes(t.tsym.members());
            t = this.types.supertype(t);
        }
    }

    Symbol resolveIdent(int pos, Env<AttrContext> env, Name name, int kind) {
        return this.access(this.findIdent(env, name, kind), pos, env.enclClass.sym.type, name, false);
    }

    Symbol resolveMethod(int pos, Env<AttrContext> env, Name name, List<Type> argtypes, List<Type> typeargtypes) {
        ((AttrContext)env.info).varArgs = false;
        Symbol sym = this.findFun(env, name, argtypes, typeargtypes, false, false);
        if (sym.kind >= 69 && this.source.allowVarargs()) {
            sym = this.findFun(env, name, argtypes, typeargtypes, true, false);
            if (sym.kind >= 69) {
                ((AttrContext)env.info).varArgs = true;
                sym = this.findFun(env, name, argtypes, typeargtypes, true, true);
            }
        }
        if (sym.kind >= 65) {
            sym = this.access(sym, pos, env.enclClass.sym.type, name, false, argtypes, typeargtypes);
        }
        return sym;
    }

    Symbol resolveQualifiedMethod(int pos, Env<AttrContext> env, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
        ((AttrContext)env.info).varArgs = false;
        Symbol sym = this.findMethod(env, site, name, argtypes, typeargtypes, false, false);
        if (sym.kind >= 69 && this.source.allowVarargs()) {
            sym = this.findMethod(env, site, name, argtypes, typeargtypes, true, false);
            if (sym.kind >= 69) {
                ((AttrContext)env.info).varArgs = true;
                sym = this.findMethod(env, site, name, argtypes, typeargtypes, true, true);
            }
        }
        if (sym.kind >= 65) {
            sym = this.access(sym, pos, site, name, true, argtypes, typeargtypes);
        }
        return sym;
    }

    public Symbol.MethodSymbol resolveInternalMethod(int pos, Env<AttrContext> env, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
        Symbol sym = this.resolveQualifiedMethod(pos, env, site, name, argtypes, typeargtypes);
        if (sym.kind == 16) {
            return (Symbol.MethodSymbol)sym;
        }
        throw new FatalError(new Diagnostic("fatal.err.cant.locate.meth", name));
    }

    Symbol resolveConstructor(int pos, Env<AttrContext> env, Type site, List<Type> argtypes, List<Type> typeargtypes) {
        ((AttrContext)env.info).varArgs = false;
        Symbol sym = this.resolveConstructor(pos, env, site, argtypes, typeargtypes, false, false);
        if (sym.kind >= 69 && this.source.allowVarargs()) {
            sym = this.resolveConstructor(pos, env, site, argtypes, typeargtypes, true, false);
            if (sym.kind >= 69) {
                ((AttrContext)env.info).varArgs = true;
                sym = this.resolveConstructor(pos, env, site, argtypes, typeargtypes, true, true);
            }
        }
        if (sym.kind >= 65) {
            sym = this.access(sym, pos, site, this.names.init, true, argtypes, typeargtypes);
        }
        return sym;
    }

    Symbol resolveConstructor(int pos, Env<AttrContext> env, Type site, List<Type> argtypes, List<Type> typeargtypes, boolean allowBoxing, boolean useVarargs) {
        Symbol sym = this.findMethod(env, site, this.names.init, argtypes, typeargtypes, allowBoxing, useVarargs);
        if ((sym.flags() & 0x20000L) != 0L && (((AttrContext)env.info).scope.owner.flags() & 0x20000L) == 0L && ((AttrContext)env.info).scope.owner.outermostClass() != sym.outermostClass()) {
            this.chk.warnDeprecated(pos, sym);
        }
        return sym;
    }

    public Symbol.MethodSymbol resolveInternalConstructor(int pos, Env<AttrContext> env, Type site, List<Type> argtypes, List<Type> typeargtypes) {
        Symbol sym = this.resolveConstructor(pos, env, site, argtypes, typeargtypes);
        if (sym.kind == 16) {
            return (Symbol.MethodSymbol)sym;
        }
        throw new FatalError(new Diagnostic("fatal.err.cant.locate.ctor", site));
    }

    Symbol resolveOperator(int pos, int optag, Env<AttrContext> env, List<Type> argtypes) {
        Name name = this.treeinfo.operatorName(optag);
        Symbol sym = this.findMethod(env, this.syms.predefClass.type, name, argtypes, null, false, false);
        if (sym.kind >= 69 && this.source.allowBoxing()) {
            sym = this.findMethod(env, this.syms.predefClass.type, name, argtypes, null, true, false);
        }
        return this.access(sym, pos, env.enclClass.sym.type, name, false, argtypes, null);
    }

    Symbol resolveUnaryOperator(int pos, int optag, Env<AttrContext> env, Type arg) {
        List<Type> argtypes = Type.emptyList.prepend(arg);
        return this.resolveOperator(pos, optag, env, argtypes);
    }

    Symbol resolveBinaryOperator(int pos, int optag, Env<AttrContext> env, Type left, Type right) {
        List<Type> argtypes = Type.emptyList.prepend(right).prepend(left);
        return this.resolveOperator(pos, optag, env, argtypes);
    }

    Symbol resolveSelf(int pos, Env<AttrContext> env, Symbol.TypeSymbol c, Name name) {
        Env<AttrContext> env1 = env;
        boolean staticOnly = false;
        while (env1.outer != null) {
            Symbol sym;
            if (Resolve.isStatic(env1)) {
                staticOnly = true;
            }
            if (env1.enclClass.sym == c && (sym = ((AttrContext)env1.info).scope.lookup((Name)name).sym) != null) {
                if (staticOnly) {
                    sym = new StaticError(sym);
                }
                return this.access(sym, pos, env.enclClass.sym.type, name, true);
            }
            if ((env1.enclClass.sym.flags() & 8L) != 0L) {
                staticOnly = true;
            }
            env1 = env1.outer;
        }
        this.log.error(pos, "not.encl.class", c);
        return this.syms.errSymbol;
    }

    Symbol resolveSelfContaining(int pos, Env<AttrContext> env, Symbol member) {
        Name name = this.names._this;
        Env<AttrContext> env1 = env;
        boolean staticOnly = false;
        while (env1.outer != null) {
            Symbol sym;
            if (Resolve.isStatic(env1)) {
                staticOnly = true;
            }
            if (env1.enclClass.sym.isSubClass(member.owner, this.types) && (sym = ((AttrContext)env1.info).scope.lookup((Name)name).sym) != null) {
                if (staticOnly) {
                    sym = new StaticError(sym);
                }
                return this.access(sym, pos, env.enclClass.sym.type, name, true);
            }
            if ((env1.enclClass.sym.flags() & 8L) != 0L) {
                staticOnly = true;
            }
            env1 = env1.outer;
        }
        this.log.error(pos, "encl.class.required", member);
        return this.syms.errSymbol;
    }

    Type resolveImplicitThis(int pos, Env<AttrContext> env, Type t) {
        Type thisType = ((t.tsym.owner.kind & 0x14) != 0 ? this.resolveSelf((int)pos, env, (Symbol.TypeSymbol)t.outer().tsym, (Name)this.names._this) : this.resolveSelfContaining((int)pos, env, (Symbol)t.tsym)).type;
        if (((AttrContext)env.info).isSelfCall && thisType.tsym == env.enclClass.sym) {
            this.log.error(pos, "cant.ref.before.ctor.called", "this");
        }
        return thisType;
    }

    static Diagnostic kindName(int kind) {
        switch (kind) {
            case 1: {
                return new Diagnostic("kindname.package", new Object[0]);
            }
            case 2: {
                return new Diagnostic("kindname.class", new Object[0]);
            }
            case 4: {
                return new Diagnostic("kindname.variable", new Object[0]);
            }
            case 12: {
                return new Diagnostic("kindname.value", new Object[0]);
            }
            case 16: {
                return new Diagnostic("kindname.method", new Object[0]);
            }
        }
        return new Diagnostic("kindname", Integer.toString(kind));
    }

    static Diagnostic kindNames(int kind) {
        StringBuffer key = new StringBuffer();
        key.append("kindname");
        if ((kind & 0xC) != 0) {
            key.append((kind & 0xC) == 4 ? ".variable" : ".value");
        }
        if ((kind & 0x10) != 0) {
            key.append(".method");
        }
        if ((kind & 2) != 0) {
            key.append(".class");
        }
        if ((kind & 1) != 0) {
            key.append(".package");
        }
        return new Diagnostic(key.toString(), kind);
    }

    static Diagnostic typeKindName(Type t) {
        if (t.tag == 14 || t.tag == 10 && (t.tsym.flags() & 0x1000000L) != 0L) {
            return new Diagnostic("kindname.type.variable", new Object[0]);
        }
        if (t.tag == 13) {
            return new Diagnostic("kindname.package", new Object[0]);
        }
        if ((t.tsym.flags_field & 0x2000L) != 0L) {
            return new Diagnostic("kindname.annotation", new Object[0]);
        }
        if ((t.tsym.flags_field & 0x200L) != 0L) {
            return new Diagnostic("kindname.interface", new Object[0]);
        }
        return new Diagnostic("kindname.class", new Object[0]);
    }

    static Diagnostic absentKindName(int kind) {
        switch (kind) {
            case 68: {
                return new Diagnostic("kindname.variable", new Object[0]);
            }
            case 69: 
            case 70: 
            case 71: {
                return new Diagnostic("kindname.method", new Object[0]);
            }
            case 72: {
                return new Diagnostic("kindname.class", new Object[0]);
            }
        }
        return new Diagnostic("kindname", kind);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AmbiguityError
    extends ResolveError {
        Symbol sym1;
        Symbol sym2;

        AmbiguityError(Symbol sym1, Symbol sym2) {
            super(65, sym1, "ambiguity error");
            this.sym1 = sym1;
            this.sym2 = sym2;
        }

        @Override
        void report(Log log, int pos, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
            AmbiguityError pair = this;
            while (true) {
                if (pair.sym1.kind == 65) {
                    pair = (AmbiguityError)pair.sym1;
                    continue;
                }
                if (pair.sym2.kind != 65) break;
                pair = (AmbiguityError)pair.sym2;
            }
            Name sname = pair.sym1.name;
            if (sname == sname.table.init) {
                sname = pair.sym1.owner.name;
            }
            log.error(pos, "ref.ambiguous", sname, Resolve.kindName(pair.sym1.kind), pair.sym1, pair.sym1.location(site, Resolve.this.types), Resolve.kindName(pair.sym2.kind), pair.sym2, pair.sym2.location(site, Resolve.this.types));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class StaticError
    extends ResolveError {
        StaticError(Symbol sym) {
            super(67, sym, "static error");
        }

        @Override
        void report(Log log, int pos, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
            String symstr = (this.sym.kind == 2 && this.sym.type.tag == 10 ? Resolve.this.types.erasure(this.sym.type) : this.sym).toString();
            log.error(pos, "non-static.cant.be.ref", Resolve.kindName(this.sym.kind), symstr);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AccessError
    extends ResolveError {
        AccessError(Symbol sym) {
            super(66, sym, "access error");
        }

        @Override
        void report(Log log, int pos, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
            if (this.sym.owner.type.tag != 19) {
                if (this.sym.name == this.sym.name.table.init && this.sym.owner != site.tsym) {
                    new ResolveError(71, this.sym.owner, "absent method " + this.sym).report(log, pos, site, name, argtypes, typeargtypes);
                }
                if ((this.sym.flags() & 1L) != 0L) {
                    log.error(pos, "not.def.public.class.intf.cant.access", this.sym, this.sym.location());
                } else if ((this.sym.flags() & 6L) != 0L) {
                    log.error(pos, "report.access", this.sym, TreeInfo.flagNames(this.sym.flags() & 6L), this.sym.location());
                } else {
                    log.error(pos, "not.def.public.cant.access", this.sym, this.sym.location());
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResolveError
    extends Symbol {
        final String debugName;
        final Symbol sym;
        Symbol wrongSym;
        Diagnostic explanation;

        ResolveError(int kind, Symbol sym, String debugName) {
            super(kind, 0L, null, null, null);
            this.debugName = debugName;
            this.sym = sym;
        }

        @Override
        public String toString() {
            return this.debugName + " wrongSym=" + this.wrongSym + " explanation=" + this.explanation;
        }

        ResolveError setWrongSym(Symbol sym, Diagnostic explanation) {
            this.wrongSym = sym;
            this.explanation = explanation;
            return this;
        }

        ResolveError setWrongSym(Symbol sym) {
            this.wrongSym = sym;
            this.explanation = null;
            return this;
        }

        @Override
        public boolean exists() {
            switch (this.kind) {
                case 66: 
                case 68: 
                case 71: 
                case 72: {
                    return false;
                }
            }
            return true;
        }

        void report(Log log, int pos, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
            if (name != name.table.error) {
                Diagnostic kindname = Resolve.absentKindName(this.kind);
                String idname = name.toString();
                String args = "";
                String typeargs = "";
                if (this.kind >= 69 && this.kind <= 71) {
                    if (this.isOperator(name)) {
                        log.error(pos, "operator.cant.be.applied", name, Type.toString(argtypes));
                        return;
                    }
                    if (name == name.table.init) {
                        kindname = new Diagnostic("kindname.constructor", new Object[0]);
                        idname = site.tsym.name.toString();
                    }
                    args = "(" + Type.toString(argtypes) + ")";
                    if (typeargtypes != null && typeargtypes.nonEmpty()) {
                        typeargs = "<" + Type.toString(typeargtypes) + ">";
                    }
                }
                if (this.kind == 70) {
                    log.error(pos, "cant.apply.symbol" + (this.explanation != null ? ".1" : ""), this.wrongSym.asMemberOf(site, Resolve.this.types), this.wrongSym.location(site, Resolve.this.types), typeargs, Type.toString(argtypes), this.explanation);
                } else if (site.tsym.name.len != 0) {
                    if (site.tsym.kind == 1 && !site.tsym.exists()) {
                        log.error(pos, "doesnt.exist", site.tsym);
                    } else {
                        log.error(pos, "cant.resolve.location", kindname, idname, args, typeargs, Resolve.typeKindName(site), site);
                    }
                } else {
                    log.error(pos, "cant.resolve", kindname, idname, args, typeargs);
                }
            }
        }

        boolean isOperator(Name name) {
            int i;
            for (i = 0; i < name.len && "+-~!*/%&|^<>=".indexOf(name.byteAt(i)) >= 0; ++i) {
            }
            return i > 0 && i == name.len;
        }
    }
}

