/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.compiler.flatten;

import edu.rice.cs.nextgen2.compiler.code.Scope;
import edu.rice.cs.nextgen2.compiler.code.Symbol;
import edu.rice.cs.nextgen2.compiler.code.Type;
import edu.rice.cs.nextgen2.compiler.flatten.ParamCollector;
import edu.rice.cs.nextgen2.compiler.flatten.TreeSnippeter;
import edu.rice.cs.nextgen2.compiler.flatten.Util;
import edu.rice.cs.nextgen2.compiler.flatten.VisitorEnv;
import edu.rice.cs.nextgen2.compiler.tree.Tree;
import edu.rice.cs.nextgen2.compiler.util.Context;
import edu.rice.cs.nextgen2.compiler.util.List;
import edu.rice.cs.nextgen2.compiler.util.Name;
import edu.rice.cs.nextgen2.util.NGUtil;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodVisitorEnv
extends VisitorEnv {
    Name localEnvName;
    Symbol.MethodSymbol msym;
    Symbol.MethodSymbol parentOverride;
    List<Type> parentUndefTyparams;
    List<Name> methTyparamNames;
    Tree.VarDef polyEnv = null;

    public MethodVisitorEnv(Context c, Symbol.ClassSymbol co, Symbol.MethodSymbol msym, List<Name> n, VisitorEnv outerEnv, Tree.VarDef polyEnv) {
        super(c, outerEnv, co, null, n);
        this.msym = msym;
        Type.ForAll mtype = (Type.ForAll)msym.type;
        this.methTyparamNames = Util.typeNames(mtype.tvars);
        Type.MethodType qtype = (Type.MethodType)mtype.qtype;
        List<Type> args = qtype.argtypes;
        this.templateSymbol = this.flatten.genPMInterface(msym, mtype.tvars);
        NGUtil.debugPrint(false, "   :: msym.type:" + msym.type + " " + msym.type.getClass());
        NGUtil.debugPrint(false, "   :: msym.type.tsym:" + msym.type.tsym + msym.type.tsym.getClass() + " eq?" + msym.equals(msym.type.tsym) + " eq Method?" + msym.type.tsym.equals(this.syms.methodClass));
        this.localEnvName = this.names.fromString("polyEnvLocal");
        this.polyEnv = polyEnv;
        this.parentOverride = null;
        this.parentUndefTyparams = co.type.typarams();
        Hashtable typeMap = new Hashtable();
        List<Type> staticChildTyparams = co.type.typarams();
        Type ct = this.types.supertype(co.type);
        while (ct.tag == 10) {
            Symbol.ClassSymbol csym = (Symbol.ClassSymbol)ct.tsym;
            List<Type> instSuperTyparams = ct.typarams();
            List<Type> staticSuperTyparams = ct.tsym.type.typarams();
            List<Type> l = staticChildTyparams;
            while (l.nonEmpty()) {
                int index = instSuperTyparams.index((Type)l.head);
                Type val = (Type)typeMap.get(l.head);
                if (val != null) {
                    if (index < 0) {
                        this.parentUndefTyparams = Util.remove(this.parentUndefTyparams, val);
                    } else {
                        typeMap.put(Util.elementAt(staticSuperTyparams, index), typeMap.get(l.head));
                    }
                }
                l = l.tail;
            }
            Scope.Entry e = csym.members().lookup(msym.name);
            while (e.scope != null) {
                if (e.sym.kind == 16) {
                    Symbol.MethodSymbol pmethSym = (Symbol.MethodSymbol)e.sym;
                    NGUtil.debugPrint(false, "MVE.<init> same type: mtype:" + mtype + " " + mtype.getClass() + " pmethSym.type:" + pmethSym.type + " " + pmethSym.type.getClass());
                    NGUtil.debugPrint(false, "MVE.<init> same type: p:" + pmethSym + " s:" + msym + this.types.hasSameArgs(this.types.erasure(mtype), this.types.erasure(pmethSym.type)));
                    if (this.types.hasSameArgs(this.types.erasure(mtype), this.types.erasure(pmethSym.type)) && !this.parentUndefTyparams.isEmpty()) {
                        this.parentOverride = pmethSym;
                        break;
                    }
                }
                e = e.next();
            }
            if (this.parentOverride != null) break;
            staticChildTyparams = staticSuperTyparams;
            ct = this.types.supertype(ct);
        }
    }

    protected boolean requiresReflection(List<Type> argtypes) {
        if (this.parentOverride == null) {
            return false;
        }
        List<Type> l = argtypes;
        while (l.nonEmpty()) {
            if (((Type)l.head).tag == 14) {
                return this.parentUndefTyparams.contains(l.head);
            }
            l = l.tail;
        }
        return false;
    }

    @Override
    public Tree constructApplySnippet(Tree.Apply tree) {
        Symbol.MethodSymbol abstractSnippetSymbol = this.constructApplySnippetSymbol(tree);
        this.make.at(tree.pos);
        Tree.Ident i = (Tree.Ident)this.make.Ident(this.polyEnv);
        Tree.Select s = (Tree.Select)this.make.Select((Tree)i, abstractSnippetSymbol);
        Tree ret = this.make.App(s, Tree.emptyList);
        return ret;
    }

    @Override
    public Tree constructSnippet(Tree tree, List<Tree> args, List<Type> argtypes, Tree returnIdent, Type returnType) {
        List<Type> tp;
        int num_meth = 0;
        int num_class = 0;
        List<Type> l = tp = ParamCollector.ONLY.typarams(TreeSnippeter.instance().find(tree).getTypeArg());
        while (l.nonEmpty()) {
            Type t = (Type)l.head;
            if (t.tag == 14) {
                if (this.methTyparamNames.contains(t.tsym.name)) {
                    ++num_meth;
                } else {
                    ++num_class;
                }
            }
            l = l.tail;
        }
        boolean reflect = false;
        if (num_class > 0 && num_meth == 0) {
            NGUtil.debugPrint(false, "MVE.constructSnippet: pushed up:" + tree + " args:" + argtypes + " methvars:" + this.typaramNames + "classvars:" + this.outerEnv.typaramNames);
            return this.outerEnv.constructSnippet(tree, args, argtypes, returnIdent, returnType);
        }
        if (num_class > 0 && num_meth > 0 && this.requiresReflection(argtypes)) {
            Tree.Ident thisIdent = new Tree.Ident(this.names.fromString("this"), this.owner);
            thisIdent.type = this.owner.type;
            thisIdent.pos = tree.pos;
        }
        Symbol.MethodSymbol snippetSym = this.constructSnippetSymbol(tree, args, argtypes, returnIdent, returnType, reflect);
        this.make.at(tree.pos);
        Tree.Ident i = (Tree.Ident)this.make.Ident(this.polyEnv);
        Tree.Select s = (Tree.Select)this.make.Select((Tree)i, snippetSym);
        return this.make.App(s, args);
    }
}

