/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.compiler.flatten;

import edu.rice.cs.nextgen2.compiler.code.Symbol;
import edu.rice.cs.nextgen2.compiler.code.Type;
import edu.rice.cs.nextgen2.compiler.code.Types;
import edu.rice.cs.nextgen2.compiler.comp.AttrContext;
import edu.rice.cs.nextgen2.compiler.comp.Env;
import edu.rice.cs.nextgen2.compiler.comp.Resolve;
import edu.rice.cs.nextgen2.compiler.flatten.TreeChecker;
import edu.rice.cs.nextgen2.compiler.flatten.TreeSnippeter;
import edu.rice.cs.nextgen2.compiler.flatten.VisitorEnv;
import edu.rice.cs.nextgen2.compiler.tree.Tree;
import edu.rice.cs.nextgen2.compiler.tree.TreeMaker;
import edu.rice.cs.nextgen2.compiler.util.List;
import edu.rice.cs.nextgen2.compiler.util.ListBuffer;
import edu.rice.cs.nextgen2.compiler.util.Name;
import edu.rice.cs.nextgen2.util.NGUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnippetClosure {
    public static final List<SnippetClosure> emptyList = new List();
    public List<Name> typaramNames;
    public Tree expr;
    public Symbol.MethodSymbol abstractSnippet;
    public Type returnType;
    public TreeMaker make;
    protected Name.Table names;
    public VisitorEnv env;
    final Types types;
    public boolean requiresReflection;
    Resolve rs;
    TreeChecker treeChecker;

    public SnippetClosure(Tree e, Symbol.MethodSymbol a, Type ret, List<Name> tnames, VisitorEnv venv, TreeMaker m, boolean reflect) {
        this.expr = e;
        this.abstractSnippet = a;
        this.returnType = ret;
        this.typaramNames = tnames;
        this.env = venv;
        this.make = m;
        this.requiresReflection = reflect;
        this.names = venv.names;
        this.types = venv.types;
        this.rs = venv.rs;
        this.treeChecker = venv.flat.treeChecker;
        NGUtil.debugPrint(false, ">>>created snippet:" + e + " <" + tnames + ">");
    }

    public String toString() {
        return "<" + this.abstractSnippet + ":= " + this.expr + ">";
    }

    public SnippetClosure copy() {
        return new SnippetClosure(this.expr, this.abstractSnippet, this.returnType, this.typaramNames, this.env, this.make, this.requiresReflection);
    }

    public Name name() {
        return this.abstractSnippet.name;
    }

    public Tree.MethodDef genSnippet(Symbol.ClassSymbol snippetOwner, int methodFlags) {
        Tree flatExpr;
        ListBuffer<Tree.Ident> args_ = new ListBuffer<Tree.Ident>();
        ListBuffer<Tree.VarDef> varDefs_ = new ListBuffer<Tree.VarDef>();
        Name snippetName = this.abstractSnippet.name;
        Type snippetType = this.abstractSnippet.type;
        Symbol.MethodSymbol snippetSymbol = new Symbol.MethodSymbol(methodFlags, snippetName, snippetType, snippetOwner);
        TreeSnippeter.Snippeter expr_ = TreeSnippeter.instance().find(this.expr);
        List<Tree> l = expr_.getArgs();
        while (l.nonEmpty()) {
            Tree.Ident ident = (Tree.Ident)l.head;
            Name identName = ident.name;
            Type identType = ident.type;
            Symbol.VarSymbol newVarSym = new Symbol.VarSymbol(16L, identName, identType, snippetSymbol);
            this.make.at(ident.pos);
            Tree.Ident newIdent = (Tree.Ident)this.make.Ident(newVarSym);
            Tree.Ident typeIdent = new Tree.Ident(identType.tsym.name, newVarSym);
            typeIdent.type = identType;
            args_.append(newIdent);
            Tree.VarDef newDef = new Tree.VarDef(this.make.Modifiers(0L), identName, typeIdent, null, newVarSym);
            newDef.type = identType;
            varDefs_.append(newDef);
            l = l.tail;
        }
        List<Tree> args = args_.toList();
        List<Tree.VarDef> varDefs = varDefs_.toList();
        expr_.setArgs(args);
        if ((methodFlags & 0x400) != 0) {
            flatExpr = null;
        } else {
            this.make.at(this.expr.pos);
            if (this.requiresReflection) {
                Name n_getClass = this.env.names.fromString("getClass");
                Tree.Ident p_ident = (Tree.Ident)args.head;
                Type.MethodType type_getClass = new Type.MethodType(Type.emptyList, this.env.syms.classType, Type.emptyList, TreeSnippeter.syms.methodClass);
                Symbol.MethodSymbol sym_getClass = new Symbol.MethodSymbol(1L, n_getClass, type_getClass, this.env.owner);
                Tree.Select s_getClass = new Tree.Select(p_ident, n_getClass, sym_getClass);
                s_getClass.type = type_getClass;
                Tree.Apply a_getClass = new Tree.Apply(null, s_getClass, Tree.emptyList);
                a_getClass.type = type_getClass.restype;
                Name n_toString = this.env.names.fromString("toString");
                Type.MethodType type_toString = new Type.MethodType(Type.emptyList, this.env.syms.stringType, Type.emptyList, TreeSnippeter.syms.methodClass);
                Symbol.MethodSymbol sym_toString = new Symbol.MethodSymbol(1L, n_toString, type_toString, this.env.owner);
                Tree.Select s_toString = new Tree.Select(a_getClass, n_toString, sym_toString);
                s_toString.type = type_toString;
                Tree.Apply a_toString = new Tree.Apply(null, s_toString, Tree.emptyList);
                String tempName = snippetOwner.name.toString();
                String envSuffix = tempName.substring(tempName.indexOf("$$E"));
                Tree.Literal l_suffix = new Tree.Literal(10, envSuffix);
                l_suffix.type = TreeSnippeter.syms.stringType.constType(envSuffix);
                NGUtil.debugPrint(false, "SC.reflect:owner:" + snippetOwner + " " + snippetOwner.name + " " + snippetOwner.name.toString().indexOf("$$E"));
                Tree.Ident i_Class = (Tree.Ident)this.make.Ident(this.env.syms.classType.tsym);
                Name n_forName = this.env.names.fromString("forName");
                Type.MethodType type_forName = new Type.MethodType(Type.emptyList, this.env.syms.classType, List.make(this.env.syms.stringType), this.env.syms.methodClass);
                Symbol.MethodSymbol sym_forName = new Symbol.MethodSymbol(1L, n_forName, type_forName, this.env.syms.classType.tsym);
                Tree.Select s_forName = new Tree.Select(i_Class, n_forName, sym_forName);
                Tree.Apply a_forName = new Tree.Apply(null, s_forName, Tree.emptyList);
                Env<AttrContext> attrEnv = null;
                Symbol.MethodSymbol forNameSym = this.rs.resolveInternalMethod(this.make.pos, attrEnv, this.types.erasure(TreeSnippeter.syms.classType), this.names.forName, Type.emptyList.prepend(TreeSnippeter.syms.stringType), null);
                Tree.Apply a_forName2 = (Tree.Apply)this.make.App(this.make.QualIdent(forNameSym), List.make(this.make.Ident(TreeSnippeter.syms.objectType.tsym)));
                Symbol.MethodSymbol sym_getField2 = this.rs.resolveInternalMethod(this.make.pos, attrEnv, this.types.erasure(TreeSnippeter.syms.classType), this.names.fromString("getField"), Type.emptyList.prepend(TreeSnippeter.syms.stringType), null);
                Name n_getField = this.env.names.fromString("getField");
                Type.ClassType type_Field = new Type.ClassType(null, Type.emptyList, null);
                Type.MethodType type_getField = new Type.MethodType(Type.emptyList, type_Field, List.make(this.env.syms.stringType), this.env.syms.methodClass);
                Symbol.MethodSymbol sym_getField = new Symbol.MethodSymbol(1L, n_getField, type_getField, this.env.syms.classType.tsym);
                Tree.Select s_getField = new Tree.Select(s_forName, n_getField, sym_getField);
                assert (false);
                flatExpr = null;
            } else {
                flatExpr = this.env.flatten.toSnippets.translate(this.expr, this.typaramNames);
            }
            NGUtil.debugPrint(false, "SC.genSnippet:" + this.expr + " => " + flatExpr);
            flatExpr.accept(this.treeChecker);
        }
        Tree.Return ret = this.make.Return(flatExpr);
        Tree.Block snippetBody = (Tree.Block)new Tree.Block(0L, List.make(ret)).setType(this.returnType);
        if (flatExpr == null) {
            snippetBody = null;
        }
        snippetOwner.members().enter(snippetSymbol);
        NGUtil.debugPrint(false, "AddingClassSnippet:" + snippetSymbol + " [] " + snippetOwner.members());
        Tree.MethodDef snippet = new Tree.MethodDef(this.make.Modifiers(methodFlags), snippetName, this.make.Type(this.returnType), Tree.TypeParameter.emptyList, varDefs, Tree.emptyList, snippetBody, null, snippetSymbol);
        snippet.pos = this.expr.pos;
        snippet.type = snippetType;
        NGUtil.debugPrint(false, "SnippetClosure.genSnippet:" + snippetSymbol + " new snippet:" + snippet);
        return snippet;
    }
}

