/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.compiler.flatten;

import edu.rice.cs.nextgen2.compiler.code.Symbol;
import edu.rice.cs.nextgen2.compiler.tree.Tree;
import edu.rice.cs.nextgen2.compiler.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreePrinter
extends Tree.Visitor {
    public static TreePrinter printer = new TreePrinter();

    private TreePrinter() {
    }

    public void output(String s) {
        System.out.print(s);
    }

    public void nl() {
        System.out.println();
    }

    public void print(List<Tree> trees) {
        if (trees == null) {
            return;
        }
        List<Tree> l = trees;
        while (l.nonEmpty()) {
            if (l != trees) {
                this.output(", ");
            }
            ((Tree)l.head).accept(this);
            l = l.tail;
        }
    }

    public String symbol(Symbol s) {
        switch (s.kind) {
            case 2: {
                return "" + s.type + "<" + s.type.typarams() + ">";
            }
            case 4: {
                return "" + s.type;
            }
        }
        return "[unknown " + s + " " + s.getClass() + "]";
    }

    @Override
    public void visitTopLevel(Tree.TopLevel that) {
        this.visitTree(that);
    }

    @Override
    public void visitImport(Tree.Import that) {
        this.visitTree(that);
    }

    @Override
    public void visitClassDef(Tree.ClassDef that) {
        this.output("class " + that.name + " (");
        this.print(that.defs);
        this.output(")");
        this.nl();
    }

    @Override
    public void visitMethodDef(Tree.MethodDef that) {
        this.output("method(");
        that.body.accept(this);
        this.output(")");
        this.nl();
    }

    @Override
    public void visitVarDef(Tree.VarDef that) {
        this.visitTree(that);
    }

    @Override
    public void visitSkip(Tree.Skip that) {
        this.visitTree(that);
    }

    @Override
    public void visitBlock(Tree.Block that) {
        this.print(that.stats);
    }

    @Override
    public void visitDoLoop(Tree.DoLoop that) {
        this.visitTree(that);
    }

    @Override
    public void visitWhileLoop(Tree.WhileLoop that) {
        this.visitTree(that);
    }

    @Override
    public void visitForLoop(Tree.ForLoop that) {
        this.visitTree(that);
    }

    @Override
    public void visitForeachLoop(Tree.ForeachLoop that) {
        this.visitTree(that);
    }

    @Override
    public void visitLabelled(Tree.Labelled that) {
        this.visitTree(that);
    }

    @Override
    public void visitSwitch(Tree.Switch that) {
        this.visitTree(that);
    }

    @Override
    public void visitCase(Tree.Case that) {
        this.visitTree(that);
    }

    @Override
    public void visitSynchronized(Tree.Synchronized that) {
        this.visitTree(that);
    }

    @Override
    public void visitTry(Tree.Try that) {
        this.visitTree(that);
    }

    @Override
    public void visitCatch(Tree.Catch that) {
        this.visitTree(that);
    }

    @Override
    public void visitConditional(Tree.Conditional that) {
        this.visitTree(that);
    }

    @Override
    public void visitIf(Tree.If that) {
        this.visitTree(that);
    }

    @Override
    public void visitExec(Tree.Exec that) {
        that.expr.accept(this);
    }

    @Override
    public void visitBreak(Tree.Break that) {
        this.visitTree(that);
    }

    @Override
    public void visitContinue(Tree.Continue that) {
        this.visitTree(that);
    }

    @Override
    public void visitReturn(Tree.Return that) {
        this.visitTree(that);
    }

    @Override
    public void visitThrow(Tree.Throw that) {
        this.visitTree(that);
    }

    @Override
    public void visitAssert(Tree.Assert that) {
        this.visitTree(that);
    }

    @Override
    public void visitApply(Tree.Apply that) {
        this.output("Apply(");
        that.meth.accept(this);
        this.output("<");
        this.print(that.typeargs);
        this.output(">");
        this.print(that.args);
        this.output("varargs:" + that.varargsElement);
        this.output(")");
        this.nl();
    }

    @Override
    public void visitNewClass(Tree.NewClass that) {
        this.visitTree(that);
    }

    @Override
    public void visitNewArray(Tree.NewArray that) {
        this.visitTree(that);
    }

    @Override
    public void visitParens(Tree.Parens that) {
        this.visitTree(that);
    }

    @Override
    public void visitAssign(Tree.Assign that) {
        this.visitTree(that);
    }

    @Override
    public void visitAssignop(Tree.Assignop that) {
        this.visitTree(that);
    }

    @Override
    public void visitUnary(Tree.Unary that) {
        this.visitTree(that);
    }

    @Override
    public void visitBinary(Tree.Binary that) {
        this.visitTree(that);
    }

    @Override
    public void visitTypeCast(Tree.TypeCast that) {
        this.visitTree(that);
    }

    @Override
    public void visitTypeTest(Tree.TypeTest that) {
        this.visitTree(that);
    }

    @Override
    public void visitIndexed(Tree.Indexed that) {
        this.visitTree(that);
    }

    @Override
    public void visitSelect(Tree.Select that) {
        this.output("Select(");
        that.selected.accept(this);
        this.output(that.name + " isa " + this.symbol(that.sym) + ")");
        this.nl();
    }

    @Override
    public void visitIdent(Tree.Ident that) {
        this.output("Ident(" + that.name + " isa " + this.symbol(that.sym) + ")");
        this.nl();
    }

    @Override
    public void visitLiteral(Tree.Literal that) {
        this.visitTree(that);
    }

    @Override
    public void visitTypeIdent(Tree.TypeIdent that) {
        this.visitTree(that);
    }

    @Override
    public void visitTypeArray(Tree.TypeArray that) {
        this.visitTree(that);
    }

    @Override
    public void visitTypeApply(Tree.TypeApply that) {
        this.visitTree(that);
    }

    @Override
    public void visitTypeParameter(Tree.TypeParameter that) {
        this.visitTree(that);
    }

    @Override
    public void visitTypeArgument(Tree.TypeArgument that) {
        this.visitTree(that);
    }

    @Override
    public void visitErroneous(Tree.Erroneous that) {
        this.visitTree(that);
    }

    @Override
    public void visitTree(Tree that) {
        this.output("unsupported:" + that + " " + that.getClass());
        this.nl();
    }
}

