/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.compiler.tree;

import edu.rice.cs.nextgen2.compiler.tree.Tree;
import edu.rice.cs.nextgen2.compiler.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeTranslator
extends Tree.Visitor {
    protected Tree result;

    public Tree translate(Tree tree) {
        if (tree == null) {
            return null;
        }
        tree.accept(this);
        Tree result = this.result;
        this.result = null;
        return result;
    }

    public List<Tree> translate(List<Tree> trees) {
        if (trees == null) {
            return null;
        }
        List<Tree> l = trees;
        while (l.nonEmpty()) {
            l.head = this.translate((Tree)l.head);
            l = l.tail;
        }
        return trees;
    }

    public List<Tree.VarDef> translateVarDefs(List<Tree.VarDef> trees) {
        List<Tree.VarDef> l = trees;
        while (l.nonEmpty()) {
            l.head = (Tree.VarDef)this.translate((Tree)l.head);
            l = l.tail;
        }
        return trees;
    }

    public List<Tree.TypeParameter> translateTypeParams(List<Tree.TypeParameter> trees) {
        List<Tree.TypeParameter> l = trees;
        while (l.nonEmpty()) {
            l.head = (Tree.TypeParameter)this.translate((Tree)l.head);
            l = l.tail;
        }
        return trees;
    }

    public List<Tree.Case> translateCases(List<Tree.Case> trees) {
        List<Tree.Case> l = trees;
        while (l.nonEmpty()) {
            l.head = (Tree.Case)this.translate((Tree)l.head);
            l = l.tail;
        }
        return trees;
    }

    public List<Tree.Catch> translateCatchers(List<Tree.Catch> trees) {
        List<Tree.Catch> l = trees;
        while (l.nonEmpty()) {
            l.head = (Tree.Catch)this.translate((Tree)l.head);
            l = l.tail;
        }
        return trees;
    }

    public List<Tree.Annotation> translateAnnotations(List<Tree.Annotation> trees) {
        List<Tree.Annotation> l = trees;
        while (l.nonEmpty()) {
            l.head = (Tree.Annotation)this.translate((Tree)l.head);
            l = l.tail;
        }
        return trees;
    }

    @Override
    public void visitTopLevel(Tree.TopLevel tree) {
        tree.pid = this.translate(tree.pid);
        tree.defs = this.translate(tree.defs);
        this.result = tree;
    }

    @Override
    public void visitImport(Tree.Import tree) {
        tree.qualid = this.translate(tree.qualid);
        this.result = tree;
    }

    @Override
    public void visitClassDef(Tree.ClassDef tree) {
        tree.mods = (Tree.Modifiers)this.translate(tree.mods);
        tree.typarams = this.translateTypeParams(tree.typarams);
        tree.extending = this.translate(tree.extending);
        tree.implementing = this.translate(tree.implementing);
        tree.defs = this.translate(tree.defs);
        this.result = tree;
    }

    @Override
    public void visitMethodDef(Tree.MethodDef tree) {
        tree.mods = (Tree.Modifiers)this.translate(tree.mods);
        tree.restype = this.translate(tree.restype);
        tree.typarams = this.translateTypeParams(tree.typarams);
        tree.params = this.translateVarDefs(tree.params);
        tree.thrown = this.translate(tree.thrown);
        tree.body = (Tree.Block)this.translate(tree.body);
        this.result = tree;
    }

    @Override
    public void visitVarDef(Tree.VarDef tree) {
        tree.mods = (Tree.Modifiers)this.translate(tree.mods);
        tree.vartype = this.translate(tree.vartype);
        tree.init = this.translate(tree.init);
        this.result = tree;
    }

    @Override
    public void visitSkip(Tree.Skip tree) {
        this.result = tree;
    }

    @Override
    public void visitBlock(Tree.Block tree) {
        tree.stats = this.translate(tree.stats);
        this.result = tree;
    }

    @Override
    public void visitDoLoop(Tree.DoLoop tree) {
        tree.body = this.translate(tree.body);
        tree.cond = this.translate(tree.cond);
        this.result = tree;
    }

    @Override
    public void visitWhileLoop(Tree.WhileLoop tree) {
        tree.cond = this.translate(tree.cond);
        tree.body = this.translate(tree.body);
        this.result = tree;
    }

    @Override
    public void visitForLoop(Tree.ForLoop tree) {
        tree.init = this.translate(tree.init);
        tree.cond = this.translate(tree.cond);
        tree.step = this.translate(tree.step);
        tree.body = this.translate(tree.body);
        this.result = tree;
    }

    @Override
    public void visitForeachLoop(Tree.ForeachLoop tree) {
        tree.var = (Tree.VarDef)this.translate(tree.var);
        tree.expr = this.translate(tree.expr);
        tree.body = this.translate(tree.body);
        this.result = tree;
    }

    @Override
    public void visitLabelled(Tree.Labelled tree) {
        tree.body = this.translate(tree.body);
        this.result = tree;
    }

    @Override
    public void visitSwitch(Tree.Switch tree) {
        tree.selector = this.translate(tree.selector);
        tree.cases = this.translateCases(tree.cases);
        this.result = tree;
    }

    @Override
    public void visitCase(Tree.Case tree) {
        tree.pat = this.translate(tree.pat);
        tree.stats = this.translate(tree.stats);
        this.result = tree;
    }

    @Override
    public void visitSynchronized(Tree.Synchronized tree) {
        tree.lock = this.translate(tree.lock);
        tree.body = this.translate(tree.body);
        this.result = tree;
    }

    @Override
    public void visitTry(Tree.Try tree) {
        tree.body = this.translate(tree.body);
        tree.catchers = this.translateCatchers(tree.catchers);
        tree.finalizer = this.translate(tree.finalizer);
        this.result = tree;
    }

    @Override
    public void visitCatch(Tree.Catch tree) {
        tree.param = (Tree.VarDef)this.translate(tree.param);
        tree.body = this.translate(tree.body);
        this.result = tree;
    }

    @Override
    public void visitConditional(Tree.Conditional tree) {
        tree.cond = this.translate(tree.cond);
        tree.truepart = this.translate(tree.truepart);
        tree.falsepart = this.translate(tree.falsepart);
        this.result = tree;
    }

    @Override
    public void visitIf(Tree.If tree) {
        tree.cond = this.translate(tree.cond);
        tree.thenpart = this.translate(tree.thenpart);
        tree.elsepart = this.translate(tree.elsepart);
        this.result = tree;
    }

    @Override
    public void visitExec(Tree.Exec tree) {
        tree.expr = this.translate(tree.expr);
        this.result = tree;
    }

    @Override
    public void visitBreak(Tree.Break tree) {
        this.result = tree;
    }

    @Override
    public void visitContinue(Tree.Continue tree) {
        this.result = tree;
    }

    @Override
    public void visitReturn(Tree.Return tree) {
        tree.expr = this.translate(tree.expr);
        this.result = tree;
    }

    @Override
    public void visitThrow(Tree.Throw tree) {
        tree.expr = this.translate(tree.expr);
        this.result = tree;
    }

    @Override
    public void visitAssert(Tree.Assert tree) {
        tree.cond = this.translate(tree.cond);
        tree.detail = this.translate(tree.detail);
        this.result = tree;
    }

    @Override
    public void visitApply(Tree.Apply tree) {
        tree.meth = this.translate(tree.meth);
        tree.args = this.translate(tree.args);
        this.result = tree;
    }

    @Override
    public void visitNewClass(Tree.NewClass tree) {
        tree.encl = this.translate(tree.encl);
        tree.clazz = this.translate(tree.clazz);
        tree.args = this.translate(tree.args);
        tree.def = (Tree.ClassDef)this.translate(tree.def);
        this.result = tree;
    }

    @Override
    public void visitNewArray(Tree.NewArray tree) {
        tree.elemtype = this.translate(tree.elemtype);
        tree.dims = this.translate(tree.dims);
        tree.elems = this.translate(tree.elems);
        this.result = tree;
    }

    @Override
    public void visitParens(Tree.Parens tree) {
        tree.expr = this.translate(tree.expr);
        this.result = tree;
    }

    @Override
    public void visitAssign(Tree.Assign tree) {
        tree.lhs = this.translate(tree.lhs);
        tree.rhs = this.translate(tree.rhs);
        this.result = tree;
    }

    @Override
    public void visitAssignop(Tree.Assignop tree) {
        tree.lhs = this.translate(tree.lhs);
        tree.rhs = this.translate(tree.rhs);
        this.result = tree;
    }

    @Override
    public void visitUnary(Tree.Unary tree) {
        tree.arg = this.translate(tree.arg);
        this.result = tree;
    }

    @Override
    public void visitBinary(Tree.Binary tree) {
        tree.lhs = this.translate(tree.lhs);
        tree.rhs = this.translate(tree.rhs);
        this.result = tree;
    }

    @Override
    public void visitTypeCast(Tree.TypeCast tree) {
        tree.clazz = this.translate(tree.clazz);
        tree.expr = this.translate(tree.expr);
        this.result = tree;
    }

    @Override
    public void visitTypeTest(Tree.TypeTest tree) {
        tree.expr = this.translate(tree.expr);
        tree.clazz = this.translate(tree.clazz);
        this.result = tree;
    }

    @Override
    public void visitIndexed(Tree.Indexed tree) {
        tree.indexed = this.translate(tree.indexed);
        tree.index = this.translate(tree.index);
        this.result = tree;
    }

    @Override
    public void visitSelect(Tree.Select tree) {
        tree.selected = this.translate(tree.selected);
        this.result = tree;
    }

    @Override
    public void visitIdent(Tree.Ident tree) {
        this.result = tree;
    }

    @Override
    public void visitLiteral(Tree.Literal tree) {
        this.result = tree;
    }

    @Override
    public void visitTypeIdent(Tree.TypeIdent tree) {
        this.result = tree;
    }

    @Override
    public void visitTypeArray(Tree.TypeArray tree) {
        tree.elemtype = this.translate(tree.elemtype);
        this.result = tree;
    }

    @Override
    public void visitTypeApply(Tree.TypeApply tree) {
        tree.clazz = this.translate(tree.clazz);
        tree.arguments = this.translate(tree.arguments);
        this.result = tree;
    }

    @Override
    public void visitTypeParameter(Tree.TypeParameter tree) {
        tree.bounds = this.translate(tree.bounds);
        this.result = tree;
    }

    @Override
    public void visitTypeArgument(Tree.TypeArgument tree) {
        tree.inner = this.translate(tree.inner);
        this.result = tree;
    }

    @Override
    public void visitErroneous(Tree.Erroneous tree) {
        this.result = tree;
    }

    @Override
    public void visitLetExpr(Tree.LetExpr tree) {
        tree.defs = this.translateVarDefs(tree.defs);
        tree.expr = this.translate(tree.expr);
        this.result = tree;
    }

    @Override
    public void visitModifiers(Tree.Modifiers tree) {
        tree.annotations = this.translateAnnotations(tree.annotations);
        this.result = tree;
    }

    @Override
    public void visitAnnotation(Tree.Annotation tree) {
        tree.annotationType = this.translate(tree.annotationType);
        tree.args = this.translate(tree.args);
        this.result = tree;
    }

    @Override
    public void visitTree(Tree tree) {
        throw new AssertionError(tree);
    }
}

