/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.compiler.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class List<A>
implements Collection<A> {
    public A head;
    public List<A> tail;
    private static Iterator EMPTYITERATOR = new Iterator(){

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    };

    public List(A head, List<A> tail) {
        this.tail = tail;
        this.head = head;
    }

    public List() {
        this(null, null);
    }

    public static <A> List<A> make() {
        return new List<A>();
    }

    public static <A> List<A> make(A x1) {
        return new List<A>(x1, new List<A>());
    }

    public static <A> List<A> make(A x1, A x2) {
        return new List<A>(x1, new List<A>(x2, new List<A>()));
    }

    public static <A> List<A> make(A x1, A x2, A x3) {
        return new List<A>(x1, new List<A>(x2, new List<A>(x3, new List<A>())));
    }

    public static <A> List<A> make(A[] vec) {
        List<A> xs = new List<A>();
        for (int i = vec.length - 1; i >= 0; --i) {
            xs = new List<A>(vec[i], xs);
        }
        return xs;
    }

    public static <A> List<A> make(int len, A init) {
        List<A> l = new List<A>();
        for (int i = 0; i < len; ++i) {
            l = new List<A>(init, l);
        }
        return l;
    }

    @Override
    public boolean isEmpty() {
        return this.tail == null;
    }

    public boolean nonEmpty() {
        return this.tail != null;
    }

    public int length() {
        List<A> l = this;
        int len = 0;
        while (l.tail != null) {
            l = l.tail;
            ++len;
        }
        return len;
    }

    @Override
    public int size() {
        return this.length();
    }

    public int index(A el) {
        int i = 0;
        List<A> l = this;
        while (l.nonEmpty()) {
            if (l.head.equals(el)) {
                return i;
            }
            l = l.tail;
            ++i;
        }
        return -1;
    }

    public List<A> prepend(A x) {
        return new List<A>(x, this);
    }

    public List<A> prependList(List<A> xs) {
        if (this.isEmpty()) {
            return xs;
        }
        if (xs.isEmpty()) {
            return this;
        }
        List<A> result = this;
        xs = xs.reverse();
        while (xs.nonEmpty()) {
            List<A> h = xs;
            xs = xs.tail;
            h.tail = result;
            result = h;
        }
        return result;
    }

    public List<A> reverse() {
        List<A> rev = new List<A>();
        List<A> l = this;
        while (l.nonEmpty()) {
            rev = new List<A>(l.head, rev);
            l = l.tail;
        }
        return rev;
    }

    public List<A> append(A x) {
        return List.make(x).prependList(this);
    }

    public List<A> appendList(List<A> x) {
        return x.prependList(this);
    }

    @Override
    public <T> T[] toArray(T[] vec) {
        List<A> l = this;
        T[] dest = vec;
        for (int i = 0; l.nonEmpty() && i < vec.length; ++i) {
            dest[i] = l.head;
            l = l.tail;
        }
        return vec;
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    public String toString(String sep) {
        if (this.isEmpty()) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append(this.head);
        List<A> l = this.tail;
        while (l.nonEmpty()) {
            buf.append(sep);
            buf.append(l.head);
            l = l.tail;
        }
        return buf.toString();
    }

    public String toString() {
        return this.toString(",");
    }

    @Override
    public int hashCode() {
        List<A> l = this;
        int h = 0;
        while (l.tail != null) {
            h = h * 41 + (this.head != null ? this.head.hashCode() : 0);
            l = l.tail;
        }
        return h;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof List && List.equals(this, (List)other);
    }

    public static boolean equals(List xs, List ys) {
        while (xs.tail != null && ys.tail != null) {
            if (xs.head == null ? ys.head != null : !xs.head.equals(ys.head)) {
                return false;
            }
            xs = xs.tail;
            ys = ys.tail;
        }
        return xs.tail == null && ys.tail == null;
    }

    @Override
    public boolean contains(Object x) {
        List<A> l = this;
        while (l.tail != null) {
            if (x == null ? l.head == null : l.head.equals(x)) {
                return true;
            }
            l = l.tail;
        }
        return false;
    }

    public boolean contains(List<A> that) {
        List<A> l = that;
        while (l.tail != null) {
            if (!this.contains(l.head)) {
                return false;
            }
            l = l.tail;
        }
        return true;
    }

    public A last() {
        A last = null;
        List<A> t = this;
        while (t.tail != null) {
            last = t.head;
            t = t.tail;
        }
        return last;
    }

    @Override
    public Iterator<A> iterator() {
        if (this.tail == null) {
            return EMPTYITERATOR;
        }
        return new Iterator<A>(){
            List<A> elems;
            {
                this.elems = List.this;
            }

            @Override
            public boolean hasNext() {
                return this.elems.tail != null;
            }

            @Override
            public A next() {
                Object result = this.elems.head;
                this.elems = this.elems.tail;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean add(A a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends A> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

