/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.compiler.util;

import edu.rice.cs.nextgen2.compiler.util.Context;
import edu.rice.cs.nextgen2.compiler.util.Log;
import edu.rice.cs.nextgen2.compiler.util.Options;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Paths {
    protected static final Context.Key<Paths> pathsKey = new Context.Key();
    private final Log log;
    private final Options options;
    private boolean warn;
    private Path bootClassPath;
    private Path userClassPath;
    private Path sourcePath;
    private boolean inited = false;
    private Path sourceSearchPath;
    private Path classSearchPath;

    public static Paths instance(Context context) {
        Paths instance = context.get(pathsKey);
        if (instance == null) {
            instance = new Paths(context);
        }
        return instance;
    }

    protected Paths(Context context) {
        context.put(pathsKey, this);
        this.log = Log.instance(context);
        this.options = Options.instance(context);
    }

    protected void lazy() {
        if (!this.inited) {
            this.warn = this.options.lint("path");
            this.bootClassPath = this.computeBootClassPath();
            this.userClassPath = this.computeUserClassPath();
            this.sourcePath = this.computeSourcePath();
            this.inited = true;
            if (this.options.get("-verbose") != null) {
                this.printVerbose("sourcepath", this.sourceSearchPath().toString());
                this.printVerbose("classpath", this.classSearchPath().toString());
            }
        }
    }

    public Collection<String> bootClassPath() {
        this.lazy();
        return Collections.unmodifiableCollection(this.bootClassPath);
    }

    public Collection<String> userClassPath() {
        this.lazy();
        return Collections.unmodifiableCollection(this.userClassPath);
    }

    public Collection<String> sourcePath() {
        this.lazy();
        return this.sourcePath == null ? null : Collections.unmodifiableCollection(this.sourcePath);
    }

    private Path computeBootClassPath() {
        Path path = new Path();
        path.addFiles((String)this.options.get("-Xbootclasspath/p:"));
        String optionValue = (String)this.options.get("-endorseddirs");
        if (optionValue != null) {
            path.addDirectories(optionValue);
        } else {
            path.addDirectories(System.getProperty("java.endorsed.dirs"), false);
        }
        optionValue = (String)this.options.get("-bootclasspath");
        if (optionValue != null) {
            path.addFiles(optionValue);
        } else {
            path.addFiles(System.getProperty("sun.boot.class.path"), false);
        }
        path.addFiles((String)this.options.get("-Xbootclasspath/a:"));
        optionValue = (String)this.options.get("-extdirs");
        if (optionValue != null) {
            path.addDirectories(optionValue);
        } else {
            path.addDirectories(System.getProperty("java.ext.dirs"), false);
        }
        return path;
    }

    private Path computeUserClassPath() {
        String cp = (String)this.options.get("-classpath");
        if (cp == null) {
            cp = System.getProperty("env.class.path");
        }
        if (cp == null && System.getProperty("application.home") == null) {
            cp = System.getProperty("java.class.path");
        }
        if (cp == null) {
            cp = ".";
        }
        return new Path().expandJarClassPaths(true).emptyPathDefault(".").addFiles(cp);
    }

    private Path computeSourcePath() {
        String sourcePathArg = (String)this.options.get("-sourcepath");
        if (sourcePathArg == null) {
            return null;
        }
        return new Path().addFiles(sourcePathArg);
    }

    public Collection<String> sourceSearchPath() {
        if (this.sourceSearchPath == null) {
            this.lazy();
            this.sourceSearchPath = this.sourcePath != null ? this.sourcePath : this.userClassPath;
        }
        return Collections.unmodifiableCollection(this.sourceSearchPath);
    }

    public Collection<String> classSearchPath() {
        if (this.classSearchPath == null) {
            this.lazy();
            this.classSearchPath = new Path();
            this.classSearchPath.addAll(this.bootClassPath);
            this.classSearchPath.addAll(this.userClassPath);
        }
        return Collections.unmodifiableCollection(this.classSearchPath);
    }

    private static boolean isZip(String name) {
        return new File(name).isFile();
    }

    private void printVerbose(String key, String arg) {
        Log.printLines(this.log.noticeWriter, Log.getLocalizedString("verbose." + key, arg));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Path
    extends LinkedHashSet<String> {
        private static final long serialVersionUID = 0L;
        private boolean expandJarClassPaths = false;
        private String emptyPathDefault = null;

        public Path expandJarClassPaths(boolean x) {
            this.expandJarClassPaths = x;
            return this;
        }

        public Path emptyPathDefault(String x) {
            this.emptyPathDefault = x;
            return this;
        }

        public Path addDirectories(String dirs, boolean warn) {
            if (dirs != null) {
                for (String dir : new PathIterator(dirs)) {
                    this.addDirectory(dir, warn);
                }
            }
            return this;
        }

        public Path addDirectories(String dirs) {
            return this.addDirectories(dirs, Paths.this.warn);
        }

        private void addDirectory(String dir, boolean warn) {
            if (!new File(dir).isDirectory()) {
                if (warn) {
                    Paths.this.log.warning(0, "dir.path.element.not.found", dir);
                }
                return;
            }
            for (String direntry : new File(dir).list()) {
                String canonicalized = direntry.toLowerCase();
                if (!canonicalized.endsWith(".jar") && !canonicalized.endsWith(".zip")) continue;
                this.addFile(dir + File.separator + direntry, warn);
            }
        }

        public Path addFiles(String files, boolean warn) {
            if (files != null) {
                for (String file : new PathIterator(files, this.emptyPathDefault)) {
                    this.addFile(file, warn);
                }
            }
            return this;
        }

        public Path addFiles(String files) {
            return this.addFiles(files, Paths.this.warn);
        }

        private void addFile(String file, boolean warn) {
            if (!this.contains(file)) {
                if (!new File(file).exists()) {
                    if (warn) {
                        Paths.this.log.warning(0, "path.element.not.found", file);
                    }
                } else {
                    super.add(file);
                    if (this.expandJarClassPaths && Paths.isZip(file)) {
                        this.addJarClassPath(file, warn);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addJarClassPath(String jarFileName, boolean warn) {
            try {
                String jarParent = new File(jarFileName).getParent();
                JarFile jar = new JarFile(jarFileName);
                try {
                    Manifest man = jar.getManifest();
                    if (man == null) {
                        return;
                    }
                    Attributes attr = man.getMainAttributes();
                    if (attr == null) {
                        return;
                    }
                    String path = attr.getValue(Attributes.Name.CLASS_PATH);
                    if (path == null) {
                        return;
                    }
                    StringTokenizer st = new StringTokenizer(path);
                    while (st.hasMoreTokens()) {
                        String elt = st.nextToken();
                        if (jarParent != null) {
                            elt = new File(jarParent, elt).toString();
                        }
                        this.addFile(elt, warn);
                    }
                }
                finally {
                    jar.close();
                }
            }
            catch (IOException e) {
                Paths.this.log.error(0, "error.reading.file", jarFileName, e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PathIterator
    implements Collection<String> {
        private int pos = 0;
        private final String path;
        private final String emptyPathDefault;

        public PathIterator(String path, String emptyPathDefault) {
            this.path = path;
            this.emptyPathDefault = emptyPathDefault;
        }

        public PathIterator(String path) {
            this(path, null);
        }

        @Override
        public Iterator<String> iterator() {
            return new Iterator<String>(){

                @Override
                public boolean hasNext() {
                    return PathIterator.this.pos <= PathIterator.this.path.length();
                }

                @Override
                public String next() {
                    int beg = PathIterator.this.pos;
                    int end = PathIterator.this.path.indexOf(File.pathSeparator, beg);
                    if (end == -1) {
                        end = PathIterator.this.path.length();
                    }
                    PathIterator.this.pos = end + 1;
                    if (beg == end && PathIterator.this.emptyPathDefault != null) {
                        return PathIterator.this.emptyPathDefault;
                    }
                    return PathIterator.this.path.substring(beg, end);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(String o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends String> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            throw new UnsupportedOperationException();
        }
    }
}

