/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.bytecode;

import edu.rice.cs.nextgen2.bytecode.ByteCodeClassLoader;
import edu.rice.cs.nextgen2.bytecode.ConstantChanger;
import edu.rice.cs.nextgen2.bytecode.GenericSignature;
import edu.rice.cs.nextgen2.util.ListHash;
import edu.rice.cs.nextgen2.util.NGUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.EmptyVisitor;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Signature;
import org.apache.bcel.classfile.Synthetic;
import org.apache.bcel.classfile.Unknown;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.CPInstruction;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;
import org.apache.bcel.util.ClassLoaderRepository;
import org.apache.bcel.util.ClassPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnippetProcessor {
    String build_dir;
    public ClassGen OBJECT_CLAZZ;
    ClassLoaderRepository rep;
    public Hashtable<String, ClassGen> classMap = new Hashtable();
    public Hashtable<ClassGen, LinkedList<MethodGen>> meths = new Hashtable();
    ListHash<ClassGen, MethodGen> hashMethods = new ListHash();
    Hashtable<String, MethodGen> hashSigToMethod = new Hashtable();
    ListHash<String, ClassGen> hashSubImpl = new ListHash();
    ListHash<ClassGen, ClassGen> polyMethIfaces = new ListHash();
    Hashtable<ClassGen, ClassGen> visited = new Hashtable();

    public SnippetProcessor(String bd, Collection<String> cp) {
        this.build_dir = bd;
        if (!bd.endsWith("/")) {
            this.build_dir = this.build_dir + "/";
        }
        ByteCodeClassLoader classloader = new ByteCodeClassLoader(Thread.currentThread().getContextClassLoader(), this.build_dir, cp);
        this.rep = new ClassLoaderRepository(classloader);
        this.OBJECT_CLAZZ = this.loadClass("java.lang.Object");
    }

    public static void main(String[] args) {
        SnippetProcessor c = new SnippetProcessor("out/", null);
        String[] files = new String[]{"A.java", "B.java"};
        c.process(files);
    }

    public void process(String[] sourcefiles) {
        NGUtil.debugPrint(false, "---- Classes ----");
        this.processClasses(sourcefiles);
        LinkedList<ClassGen> classes = new LinkedList<ClassGen>(this.classMap.values());
        NGUtil.debugPrint(false, "-------- Meths --------");
        this.patchMeths(classes);
    }

    public ZipFile openZip(String path) {
        try {
            ZipFile zip = new ZipFile(path);
            return zip;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void list(String pathname) {
        if (SnippetProcessor.isZip(pathname)) {
            ZipFile zip = this.openZip(pathname);
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                ZipEntry next = e.nextElement();
                System.out.println("zip entry:" + next + " " + next.getName());
            }
        }
    }

    static boolean isZip(String name) {
        return new File(name).isFile();
    }

    public void processClasses(String[] sourcefiles) {
        for (int i = 0; i < sourcefiles.length; ++i) {
            String filename = sourcefiles[i];
            if (filename.indexOf("$$L") > -1 || filename.indexOf("$$E") > -1) continue;
            ClassGen clazz = this.loadClass(filename);
            String tplName = this.getTemplateClass(clazz);
            NGUtil.debugPrint(false, "-- processing: " + clazz.getClassName() + " => " + tplName);
            ClassGen tpl = this.loadClass(tplName);
            if (tpl == null) continue;
            LinkedList<MethodGen> l = this.collectSnippets(clazz, true);
            ListIterator li = l.listIterator();
            Method[] meths = new Method[l.size()];
            int j = 0;
            while (li.hasNext()) {
                meths[j] = ((MethodGen)li.next()).getMethod();
                ++j;
            }
            tpl.setMethods(meths);
            this.writeClass(tpl);
        }
    }

    protected void writeClass(ClassGen cg) {
        JavaClass clazz = cg.getJavaClass();
        try {
            String newfile = cg.getClassName();
            if (newfile.endsWith(".java")) {
                newfile = newfile.substring(0, newfile.length() - 5);
            }
            newfile = newfile.replace('.', '/');
            newfile = this.build_dir + newfile.concat(".class");
            NGUtil.debugPrint(false, "SP.writeClass:" + newfile);
            clazz.dump(newfile);
        }
        catch (IOException e) {
            System.out.println(e.getStackTrace());
        }
    }

    public boolean checkNextgen(ClassGen cg) {
        Attribute[] attrs = cg.getAttributes();
        for (int i = 0; i < attrs.length; ++i) {
            if (attrs[i].getTag() != -1 || !((Unknown)attrs[i]).getName().equals("Nextgen")) continue;
            return true;
        }
        return false;
    }

    public GenericSignature.ClassSignature getSignature(ClassGen cg) {
        Attribute[] attrs = cg.getAttributes();
        for (int j = 0; j < attrs.length; ++j) {
            if (attrs[j].getTag() != 10) continue;
            String s = ((Signature)attrs[j]).getSignature();
            return GenericSignature.parseClassSignature(cg.getClassName(), s);
        }
        return new GenericSignature.ClassSignature(cg.getClassName(), cg.getSuperclassName());
    }

    public GenericSignature.MethodSignature getSignature(MethodGen mg) {
        Attribute[] attrs = mg.getAttributes();
        for (int j = 0; j < attrs.length; ++j) {
            if (attrs[j].getTag() != 10) continue;
            String s = ((Signature)attrs[j]).getSignature();
            return GenericSignature.parseMethodSignature(mg.getName(), s, mg.isStatic());
        }
        return GenericSignature.MethodSignature.NO_SIG;
    }

    public String getTemplateClass(ClassGen cg) {
        return this.getSignature(cg).getTemplateName();
    }

    public ClassGen loadClass(String source) {
        if (source == null) {
            return null;
        }
        String filename = source.replace('/', '.');
        if (source.endsWith(".java")) {
            filename = source.substring(0, source.length() - 5);
        }
        if (this.classMap.containsKey(source)) {
            return this.classMap.get(filename);
        }
        ClassPath classpath = new ClassPath(ClassPath.SYSTEM_CLASS_PATH.toString());
        try {
            JavaClass java_class = this.rep.loadClass(filename);
            ClassGen cg = new ClassGen(java_class);
            this.classMap.put(filename, cg);
            return cg;
        }
        catch (ClassNotFoundException e) {
            System.out.println("Error loading class " + filename + " (" + e.getMessage() + ")");
            System.out.println("begin stack");
            e.printStackTrace();
            System.out.println("end stack");
            Class<?> x = null;
            try {
                x = Thread.currentThread().getContextClassLoader().loadClass(filename);
            }
            catch (ClassNotFoundException e1) {
                // empty catch block
            }
            System.out.println("1: " + x);
            Object y = null;
            throw new RuntimeException(e);
        }
    }

    public LinkedList<MethodGen> collectSnippets(ClassGen cg, boolean rec) {
        NGUtil.debugPrint(false, "collectSnippets:" + cg.getClassName() + " rec:" + rec);
        if (this.meths.containsKey(cg)) {
            return this.meths.get(cg);
        }
        String tpl = this.getTemplateClass(cg);
        ClassGen tplg = this.loadClass(tpl);
        if (tplg == null) {
            throw new RuntimeException("not a ngc file");
        }
        ConstantPoolGen cpg = tplg.getConstantPool();
        LinkedList<MethodGen> snippets = this.collectMethodGens(tpl, tplg, cpg);
        GenericSignature.ClassSignature sig = this.getSignature(cg);
        NGUtil.debugPrint(false, "sig:" + sig + " super:" + cg.getSuperclassName() + " base:" + NGUtil.toBaseClass(cg.getSuperclassName()));
        if (rec && sig != GenericSignature.ClassSignature.NO_SIG) {
            ClassGen cgs = this.loadClass(NGUtil.toBaseClass(cg.getSuperclassName()));
            String tpl2 = this.getTemplateClass(cgs);
            ClassGen tplg2 = null;
            if (tpl2 != null) {
                tplg2 = this.loadClass(tpl2);
            }
            if (tplg2 != null) {
                ConstantPoolGen cpgs0 = tplg2.getConstantPool();
                ConstantPoolGen cpgs = new ConstantPoolGen(cpgs0.getFinalConstantPool());
                ConstantChanger c = new ConstantChanger();
                String[][] map = this.mapConversionParent(sig);
                for (int i = 0; i < map.length; ++i) {
                    c.addTranslation(map[i][0], map[i][1]);
                }
                c.replaceConstants(cpgs);
                LinkedList<MethodGen> superSnippets = this.collectSnippets(cgs, false);
                ListIterator l = superSnippets.listIterator();
                while (l.hasNext()) {
                    MethodGen next = (MethodGen)l.next();
                    if (next.getName().equals("<init>") || next.getName().equals("<clinit>") || next.getName().indexOf(36) == -1) continue;
                    next.setConstantPool(cpgs);
                    MethodGen newMeth = next.copy(tplg.getClassName(), cpg);
                    next.setConstantPool(cpgs0);
                    newMeth.removeLocalVariables();
                    NGUtil.debugPrint(false, " >> propagating snippet:" + newMeth.getName() + " " + newMeth.getSignature());
                    AttributeVisitor attrVisitor = new AttributeVisitor(cpgs, cpg);
                    attrVisitor.fixAttributes(newMeth);
                    snippets.add(newMeth);
                }
            }
        }
        this.meths.put(cg, snippets);
        return snippets;
    }

    public void patchMeths(LinkedList<ClassGen> classes) {
        ListIterator it = classes.listIterator();
        NGUtil.debugPrint(false, ">SP.patchMeths:" + classes);
        while (it.hasNext()) {
            ClassGen clazz = (ClassGen)it.next();
            if (clazz.getClassName().indexOf("$$") != -1) continue;
            this.processMeth(clazz, true);
        }
        NGUtil.debugPrint(false, "------------processing now------------");
        LinkedList<ClassGen> toprocess = new LinkedList<ClassGen>(this.hashMethods.keySet());
        it = toprocess.listIterator();
        while (it.hasNext()) {
            NGUtil.debugPrint(false, ((ClassGen)it.next()).getClassName());
        }
        it = toprocess.listIterator();
        Hashtable<String, String> processed = new Hashtable<String, String>();
        while (it.hasNext()) {
            ClassGen clazz = (ClassGen)it.next();
            GenericSignature.ClassSignature csig = this.getSignature(clazz);
            NGUtil.debugPrint(false, "> processing: " + csig);
            LinkedList<MethodGen> meths = this.hashMethods.get(clazz);
            NGUtil.debugPrint(false, "meths:" + meths);
            ListIterator itm = meths.listIterator();
            while (itm.hasNext()) {
                MethodGen meth = (MethodGen)itm.next();
                String key = csig.name + "." + meth;
                if (processed.get(key) != null) continue;
                processed.put(key, key);
                GenericSignature.MethodSignature sig = this.getSignature(meth);
                NGUtil.debugPrint(false, "CHECK:" + sig.typevars + " " + sig.getInterfaceName(csig));
                if (sig.typevars == null) continue;
                NGUtil.debugPrint(false, ">> processing: " + key);
                ClassGen clazz_tp = this.loadClass(sig.getTemplateName(csig));
                LinkedList<MethodGen> snippets = this.collectMethodSnippets(csig, sig);
                NGUtil.debugPrint(false, " PME1:" + sig.getPME() + " >> " + sig.getInterfaceName(csig));
                ClassGen clazz_if = this.loadClass(sig.getPME());
                LinkedList<ClassGen> interfaces = this.polyMethIfaces.get(clazz_if);
                NGUtil.debugPrint(false, ">interfaces:" + clazz_if.getClassName() + " " + interfaces);
                if (interfaces != null) {
                    ListIterator ifs = interfaces.listIterator();
                    while (ifs.hasNext()) {
                        String if0 = ((ClassGen)ifs.next()).getClassName();
                        NGUtil.debugPrint(false, "     " + if0);
                        clazz_if.removeInterface(if0);
                        if (if0.equals(clazz_if.getClassName().toString())) continue;
                        clazz_if.addInterface(if0);
                    }
                }
                NGUtil.debugPrint(false, "<interfaces:" + clazz_if.getClassName());
                String[] xaq = clazz_if.getInterfaceNames();
                for (int i = 0; i < xaq.length; ++i) {
                    NGUtil.debugPrint(false, "     " + xaq[i]);
                }
                MethodGen getname = this.generateGetName(clazz_tp);
                if (clazz_tp.containsMethod("className", getname.getSignature()) == null) {
                    NGUtil.debugPrint(false, "JIMP: adding classname for:" + clazz_tp.getClassName());
                    snippets.add(getname);
                }
                Method[] methodSnips = new Method[snippets.size()];
                ListIterator li = snippets.listIterator();
                int j = 0;
                while (li.hasNext()) {
                    MethodGen m = (MethodGen)li.next();
                    methodSnips[j] = m.getMethod();
                    ++j;
                    if (m.getName().equals("<init>") || m.getName().equals("<clinit>")) continue;
                    MethodGen ifaceMethod = new MethodGen(m.getAccessFlags(), m.getReturnType(), m.getArgumentTypes(), m.getArgumentNames(), m.getName(), clazz_if.getClassName(), new InstructionList(), clazz_if.getConstantPool());
                    ifaceMethod.isAbstract(true);
                    ifaceMethod.isFinal(false);
                    ifaceMethod.removeLocalVariables();
                    if (clazz_if.containsMethod(ifaceMethod.getName(), ifaceMethod.getSignature()) == null) {
                        clazz_if.addMethod(ifaceMethod.getMethod());
                    }
                    NGUtil.debugPrint(false, "Iface:" + ifaceMethod);
                }
                clazz_tp.setMethods(methodSnips);
                this.writeClass(clazz_tp);
                this.writeClass(clazz_if);
            }
        }
    }

    protected LinkedList<MethodGen> collectMethodSnippets(GenericSignature.ClassSignature csig, GenericSignature.MethodSignature msig) {
        NGUtil.debugPrint(false, "collectMethodSnippets:" + csig + "." + msig);
        ClassGen clazz_tp = this.loadClass(msig.getTemplateName(csig));
        String sig = msig.toString(true);
        ConstantPoolGen dcp = clazz_tp.getConstantPool();
        LinkedList<MethodGen> snippets = this.collectMethodGens(clazz_tp.getClassName(), clazz_tp, dcp);
        MethodGen meth = this.hashSigToMethod.get(csig.name + "." + sig);
        NGUtil.debugPrint(false, "checking for subimpl of:" + csig.name + "." + sig);
        LinkedList<ClassGen> subImpl = this.hashSubImpl.get(csig.name + "." + sig);
        if (subImpl != null) {
            ListIterator it2 = subImpl.listIterator();
            while (it2.hasNext()) {
                ClassGen sub = (ClassGen)it2.next();
                GenericSignature.ClassSignature csub = this.getSignature(sub);
                NGUtil.debugPrint(false, ">>> subimpl base:" + csig.name + " override:" + csub.name + "." + sig);
                NGUtil.debugPrint(false, "     if:" + msig.getInterfaceName(csub) + " tpl:" + msig.getTemplateName(csub));
                MethodGen meth2 = this.hashSigToMethod.get(sub.getClassName() + "." + sig);
                GenericSignature.MethodSignature subsig = this.getSignature(meth2);
                NGUtil.debugPrint(false, " PME:" + msig.getPME() + " >> " + subsig.getPME());
                NGUtil.debugPrint(false, " super:" + msig.params + "\n" + " sub  :" + subsig.params);
                ClassGen clazz2_tp = this.loadClass(msig.getTemplateName(csub));
                ConstantPoolGen scp0 = clazz2_tp.getConstantPool();
                ConstantPoolGen scp = new ConstantPoolGen(scp0.getFinalConstantPool());
                ConstantChanger c = new ConstantChanger();
                String[][] map = this.mapConversion(csub, msig);
                for (int i = 0; i < map.length; ++i) {
                    c.addTranslation(map[i][0], map[i][1]);
                }
                c.replaceConstants(scp);
                ReflectionChecker reflector = new ReflectionChecker(scp);
                ClassGen clazz_if = this.loadClass(msig.getPME());
                ClassGen clazz2_if = this.loadClass(subsig.getPME());
                NGUtil.debugPrint(false, "SP.hash ifaces:" + clazz_if.getClassName() + " <=> " + clazz2_if.getClassName());
                this.polyMethIfaces.add(clazz_if, clazz2_if);
                NGUtil.debugPrint(false, "Bridges: " + csub.name + " " + meth + " <> " + meth2);
                if (!clazz_if.getClassName().equals(clazz2_if.getClassName())) {
                    NGUtil.debugPrint(false, "clazz_if:" + clazz_if.getClassName());
                    NGUtil.debugPrint(false, "clazz2_if:" + clazz2_if.getClassName());
                    NGUtil.debugPrint(false, "clazz_tp:" + clazz_tp.getClassName());
                    NGUtil.debugPrint(false, "clazz2_tp:" + clazz2_tp.getClassName());
                    String tpl = this.getTemplateClass(sub);
                    ClassGen tplg = this.loadClass(tpl);
                    NGUtil.debugPrint(false, "Loading subclass:" + sub.getClassName() + " => " + tpl);
                    NGUtil.debugPrint(false, "sub:" + csub + " => " + tpl + " " + (tplg != null));
                    if (tplg == null) {
                        tplg = sub;
                    }
                    if (tplg.containsMethod(meth.getName(), meth.getSignature()) == null) {
                        MethodGen bridgeMethod = this.generateBridge(meth, tplg, meth2, clazz2_tp.getClassName());
                        NGUtil.debugPrint(false, "+GeneratedBridge " + bridgeMethod);
                        NGUtil.debugPrint(false, "+GeneratedBridge for " + csub + meth + " to " + bridgeMethod);
                        tplg.addMethod(bridgeMethod.getMethod());
                    }
                    this.writeClass(tplg);
                }
                LinkedList<MethodGen> subSnippets = this.collectMethodSnippets(csub, msig);
                ListIterator sit = subSnippets.listIterator();
                NGUtil.debugPrint(false, " .. sit.length:" + subSnippets.size());
                while (sit.hasNext()) {
                    MethodGen next = (MethodGen)sit.next();
                    if (next.getName().equals("<init>") || next.getName().equals("className") || next.getName().equals("<clinit>")) continue;
                    NGUtil.debugPrint(false, " .. submeth:" + next.getName());
                    this.removeSnippetIfNameExists(snippets, next);
                    boolean reflect = reflector.check(next);
                    if (reflect) continue;
                    next.setConstantPool(scp);
                    MethodGen newMeth = next.copy(clazz2_tp.getClassName(), dcp);
                    next.setConstantPool(scp0);
                    newMeth.removeLocalVariables();
                    AttributeVisitor attrVisitor = new AttributeVisitor(scp, dcp);
                    attrVisitor.fixAttributes(newMeth);
                    snippets.add(newMeth);
                }
            }
        }
        return snippets;
    }

    public MethodGen generateGetName(ClassGen clazz) {
        ConstantPoolGen cp = clazz.getConstantPool();
        InstructionFactory factory = new InstructionFactory(clazz, cp);
        InstructionList il = new InstructionList();
        MethodGen method = new MethodGen(1, Type.STRING, Type.NO_ARGS, new String[0], "className", clazz.getClassName(), il, cp);
        InstructionHandle ih_0 = il.append(new PUSH(cp, clazz.getClassName()));
        InstructionHandle ih_2 = il.append(InstructionFactory.createReturn(Type.OBJECT));
        method.setMaxStack();
        method.setMaxLocals();
        return method;
    }

    public MethodGen generateBridge(MethodGen src, ClassGen clazz, MethodGen dest, String tpl) {
        InstructionHandle ih_149;
        ConstantPoolGen cp = clazz.getConstantPool();
        InstructionFactory factory = new InstructionFactory(clazz, cp);
        InstructionList il = new InstructionList();
        MethodGen bridgeMethod = new MethodGen(src.getAccessFlags(), src.getReturnType(), src.getArgumentTypes(), src.getArgumentNames(), src.getName(), clazz.getClassName(), il, cp);
        String methodName = src.getName();
        int num_params = src.getArgumentNames().length;
        Type[] argTypes = dest.getArgumentTypes();
        InstructionHandle ih_0 = il.append(InstructionFactory.createLoad(Type.OBJECT, 1));
        il.append(factory.createInvoke(src.getArgumentTypes()[0].toString(), "className", Type.STRING, Type.NO_ARGS, (short)185));
        il.append(InstructionFactory.createStore(Type.OBJECT, num_params + 1));
        il.append(InstructionFactory.createLoad(Type.OBJECT, num_params + 1));
        il.append(InstructionFactory.createLoad(Type.OBJECT, num_params + 1));
        il.append(new PUSH(cp, "$$l"));
        il.append(factory.createInvoke("java.lang.String", "indexOf", Type.INT, new Type[]{Type.STRING}, (short)182));
        il.append(InstructionFactory.createLoad(Type.OBJECT, num_params + 1));
        il.append(factory.createInvoke("java.lang.String", "length", Type.INT, Type.NO_ARGS, (short)182));
        il.append(factory.createInvoke("java.lang.String", "substring", Type.STRING, new Type[]{Type.INT, Type.INT}, (short)182));
        il.append(InstructionFactory.createStore(Type.OBJECT, num_params + 2));
        InstructionHandle ih_9 = il.append(factory.createNew("java.lang.StringBuffer"));
        il.append(InstructionConstants.DUP);
        il.append(factory.createInvoke("java.lang.StringBuffer", "<init>", Type.VOID, Type.NO_ARGS, (short)183));
        NGUtil.debugPrint(false, "SUB:" + tpl + " => " + tpl.substring(0, tpl.indexOf("$$l")));
        il.append(new PUSH(cp, tpl.substring(0, tpl.indexOf("$$l"))));
        il.append(factory.createInvoke("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.STRING}, (short)182));
        il.append(InstructionFactory.createLoad(Type.OBJECT, num_params + 2));
        il.append(factory.createInvoke("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.STRING}, (short)182));
        il.append(factory.createInvoke("java.lang.StringBuffer", "toString", Type.STRING, Type.NO_ARGS, (short)182));
        il.append(InstructionFactory.createStore(Type.OBJECT, num_params + 2));
        InstructionHandle ih_50 = il.append(factory.createFieldAccess("edu.rice.cs.nextgen2.classloader.NextGenLoader", "reflectionTable", new ObjectType("java.util.HashMap"), (short)178));
        il.append(InstructionFactory.createLoad(Type.OBJECT, num_params + 2));
        il.append(factory.createInvoke("java.util.HashMap", "get", Type.OBJECT, new Type[]{Type.OBJECT}, (short)182));
        il.append(InstructionFactory.createStore(Type.OBJECT, num_params + 3));
        InstructionHandle ih_60 = il.append(InstructionFactory.createLoad(Type.OBJECT, num_params + 3));
        BranchInstruction ifnull_62 = InstructionFactory.createBranchInstruction((short)198, null);
        il.append(ifnull_62);
        InstructionHandle ih_65 = il.append(InstructionFactory.createLoad(Type.OBJECT, 0));
        il.append(InstructionFactory.createLoad(Type.OBJECT, num_params + 3));
        il.append(factory.createCheckCast((ReferenceType)argTypes[0]));
        for (int i = 1; i < argTypes.length; ++i) {
            il.append(InstructionFactory.createLoad(argTypes[i], i + 1));
        }
        InstructionHandle ih_60x = il.append(factory.createInvoke(dest.getClassName(), dest.getName(), dest.getReturnType(), argTypes, (short)182));
        il.append(InstructionFactory.createReturn(dest.getReturnType()));
        InstructionHandle ih_42 = il.append(InstructionFactory.createLoad(Type.OBJECT, num_params + 2));
        il.append(factory.createInvoke("java.lang.Class", "forName", new ObjectType("java.lang.Class"), new Type[]{Type.STRING}, (short)184));
        il.append(new PUSH(cp, "ONLY"));
        il.append(factory.createInvoke("java.lang.Class", "getDeclaredField", new ObjectType("java.lang.reflect.Field"), new Type[]{Type.STRING}, (short)182));
        il.append(InstructionConstants.ACONST_NULL);
        il.append(factory.createInvoke("java.lang.reflect.Field", "get", Type.OBJECT, new Type[]{Type.OBJECT}, (short)182));
        il.append(InstructionFactory.createStore(Type.OBJECT, num_params + 3));
        InstructionHandle ih_97 = il.append(factory.createFieldAccess("edu.rice.cs.nextgen2.classloader.NextGenLoader", "reflectionTable", new ObjectType("java.util.HashMap"), (short)178));
        il.append(InstructionFactory.createLoad(Type.OBJECT, num_params + 2));
        il.append(InstructionFactory.createLoad(Type.OBJECT, num_params + 3));
        il.append(factory.createInvoke("java.util.HashMap", "put", Type.OBJECT, new Type[]{Type.OBJECT, Type.OBJECT}, (short)182));
        il.append(InstructionConstants.POP);
        InstructionHandle ih_49 = il.append(InstructionFactory.createLoad(Type.OBJECT, 0));
        il.append(InstructionFactory.createLoad(Type.OBJECT, num_params + 3));
        il.append(factory.createCheckCast((ReferenceType)argTypes[0]));
        for (int i = 1; i < argTypes.length; ++i) {
            il.append(InstructionFactory.createLoad(argTypes[i], i + 1));
        }
        InstructionHandle ih_105 = il.append(factory.createInvoke(dest.getClassName(), dest.getName(), dest.getReturnType(), argTypes, (short)182));
        il.append(InstructionFactory.createReturn(dest.getReturnType()));
        String[] exceptions = new String[]{"java.lang.ClassNotFoundException", "java.lang.NoSuchFieldException", "java.lang.IllegalAccessException"};
        BranchInstruction[] gotos = new BranchInstruction[exceptions.length];
        for (int i = 0; i < exceptions.length; ++i) {
            InstructionHandle ih_109 = il.append(InstructionFactory.createStore(Type.OBJECT, num_params + 1));
            il.append(InstructionFactory.createLoad(Type.OBJECT, num_params + 1));
            il.append(factory.createInvoke(exceptions[i], "printStackTrace", Type.VOID, Type.NO_ARGS, (short)182));
            BranchInstruction goto_10x = InstructionFactory.createBranchInstruction((short)167, null);
            il.append(goto_10x);
            gotos[i] = goto_10x;
            bridgeMethod.addExceptionHandler(ih_0, ih_105, ih_109, new ObjectType(exceptions[i]));
        }
        if (dest.getReturnType() == Type.VOID) {
            ih_149 = il.append(InstructionFactory.createReturn(dest.getReturnType()));
        } else {
            ih_149 = il.append(InstructionConstants.ACONST_NULL);
            InstructionHandle ih_150 = il.append(InstructionFactory.createReturn(Type.OBJECT));
        }
        ifnull_62.setTarget(ih_42);
        for (int i = 0; i < gotos.length; ++i) {
            gotos[i].setTarget(ih_149);
        }
        bridgeMethod.isAbstract(false);
        bridgeMethod.setMaxStack();
        bridgeMethod.setMaxLocals();
        bridgeMethod.removeLocalVariables();
        Method m = bridgeMethod.getMethod();
        Code code = m.getCode();
        if (code != null) {
            NGUtil.debugPrint(false, code.toString(true));
        } else {
            NGUtil.debugPrint(false, "code null");
        }
        return bridgeMethod;
    }

    public boolean removeSnippetIfNameExists(LinkedList<MethodGen> snippets, MethodGen meth) {
        NGUtil.debugPrint(false, "SP.removeSnippetIfNameExists meth:" + meth.getName());
        ListIterator m = snippets.listIterator();
        while (m.hasNext()) {
            MethodGen next = (MethodGen)m.next();
            NGUtil.debugPrint(false, "   Checking against:" + next.getName());
            if (next.getName().equals(meth.getName())) {
                NGUtil.debugPrint(false, "    FOUND MATCH");
                snippets.remove(next);
                return true;
            }
            NGUtil.debugPrint(false, "    NO MATCH");
        }
        return false;
    }

    private String[][] mapConversion(GenericSignature.ClassSignature sig, GenericSignature.MethodSignature msig) {
        return GenericSignature.mapConversion(sig, msig);
    }

    private String[][] mapConversionParent(GenericSignature.ClassSignature sig) {
        return sig.mapConversionParent();
    }

    public void processMeth(ClassGen clazz, boolean addToQueue) {
        if (clazz == this.OBJECT_CLAZZ) {
            return;
        }
        if (!this.checkNextgen(clazz)) {
            return;
        }
        if (this.visited.containsKey(clazz)) {
            return;
        }
        this.visited.put(clazz, clazz);
        NGUtil.debugPrint(false, "processMeth:" + clazz.getClassName() + " extends " + NGUtil.toBaseClass(clazz.getSuperclassName()));
        ClassGen parent = this.loadClass(NGUtil.toBaseClass(clazz.getSuperclassName()));
        this.processMeth(parent, !this.visited.containsKey(parent));
        String[] ifs = clazz.getInterfaceNames();
        for (int i = 0; i < ifs.length; ++i) {
            ClassGen iface;
            this.processMeth(iface, !this.visited.containsKey(iface = this.loadClass(NGUtil.toBaseClass(ifs[i]))));
        }
        Method[] methods = clazz.getMethods();
        ConstantPoolGen cpg = clazz.getConstantPool();
        for (int i = 0; i < methods.length; ++i) {
            MethodGen meth;
            GenericSignature.MethodSignature msig;
            if ((methods[i].getAccessFlags() & 0x400) == 0 && methods[i].getCode() == null || (msig = this.getSignature(meth = new MethodGen(methods[i], clazz.getClassName(), cpg))) == GenericSignature.MethodSignature.NO_SIG) continue;
            String sig = msig.toString(true);
            NGUtil.debugPrint(false, "        sig:" + msig + " q:" + addToQueue);
            NGUtil.debugPrint(false, "]] Meth hash:" + clazz.getClassName() + "." + sig);
            this.hashSigToMethod.put(clazz.getClassName() + "." + sig, meth);
            if (!addToQueue) continue;
            this.propagateUpwards(clazz, meth);
        }
    }

    protected void propagateUpwards(ClassGen clazz, MethodGen meth) {
        int i;
        ClassGen parent;
        NGUtil.debugPrint(false, "SP.propagateUpwards:" + clazz.getClassName() + " " + meth);
        GenericSignature.MethodSignature sig = this.getSignature(meth);
        String msig = sig.toString(true);
        String[] ifs = clazz.getInterfaceNames();
        ClassGen[] ups = new ClassGen[1 + ifs.length];
        ups[0] = parent = this.loadClass(NGUtil.toBaseClass(clazz.getSuperclassName()));
        for (i = 0; i < ifs.length; ++i) {
            ClassGen iface;
            NGUtil.debugPrint(false, "ifs[" + i + "]" + ifs[i]);
            ups[1 + i] = iface = this.loadClass(NGUtil.toBaseClass(ifs[i]));
        }
        NGUtil.debugPrint(false, "propagateUpwards: hash:" + clazz.getClassName() + clazz.hashCode() + meth.hashCode());
        this.hashMethods.addIfNotExists(clazz, meth);
        for (i = 0; i < ups.length; ++i) {
            ClassGen up = ups[i];
            MethodGen m = null;
            if (up == this.OBJECT_CLAZZ || (m = this.hashSigToMethod.get(up.getClassName() + "." + msig)) == null) continue;
            NGUtil.debugPrint(false, "AddingToHash:" + up.getClassName() + "." + msig + " => " + clazz);
            this.hashSubImpl.addIfNotExists(up.getClassName() + "." + msig, clazz);
            this.propagateUpwards(up, m);
        }
    }

    protected LinkedList<MethodGen> collectMethodGens(String cname, ClassGen clazz, ConstantPoolGen cpg) {
        NGUtil.debugPrint(false, "collectMethodGens:" + cname);
        LinkedList<MethodGen> snippets = new LinkedList<MethodGen>();
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            MethodGen orig = new MethodGen(methods[i], cname, cpg);
            NGUtil.debugPrint(false, " >> found snippet:" + orig.getName() + " " + orig.getSignature());
            orig.removeLocalVariables();
            snippets.add(orig);
        }
        return snippets;
    }

    class AttributeVisitor
    extends EmptyVisitor {
        ConstantPoolGen psrc;
        ConstantPoolGen pdest;
        Attribute result = null;

        public AttributeVisitor(ConstantPoolGen p1, ConstantPoolGen p2) {
            this.psrc = p1;
            this.pdest = p2;
        }

        public void fixAttributes(MethodGen meth) {
            Attribute[] a = meth.getAttributes();
            meth.removeAttributes();
            for (int j = 0; j < a.length; ++j) {
                Attribute attr = this.copyAttribute(a[j]);
                meth.addAttribute(attr);
            }
        }

        public Attribute copyAttribute(Attribute att) {
            Attribute tmp = this.result;
            att.accept(this);
            Attribute ret = this.result;
            this.result = tmp;
            return ret;
        }

        public void visitCode(Code obj) {
        }

        public void visitSynthetic(Synthetic obj) {
            int idx = this.pdest.addUtf8("Synthetic");
            Synthetic sy = new Synthetic(idx, obj.getLength(), obj.getBytes(), this.pdest.getConstantPool());
            this.result = sy;
        }

        public void visitSignature(Signature obj) {
            Constant name = this.psrc.getConstant(obj.getNameIndex());
            Constant const1 = this.psrc.getConstant(obj.getSignatureIndex());
            int name_idx = this.pdest.addConstant(name, this.psrc);
            int sig_idx = this.pdest.addConstant(const1, this.psrc);
            Signature sg = new Signature(name_idx, obj.getLength(), sig_idx, this.pdest.getConstantPool());
            this.result = sg;
        }
    }

    class ReflectionChecker
    extends EmptyVisitor {
        boolean needsReflect;
        ConstantPoolGen cp;

        public ReflectionChecker(ConstantPoolGen cp) {
            this.cp = cp;
            this.needsReflect = false;
        }

        public boolean check(MethodGen m) {
            this.needsReflect = false;
            InstructionList il = m.getInstructionList();
            Instruction[] is = il.getInstructions();
            for (int i = 0; i < is.length; ++i) {
                NGUtil.debugPrint(false, "#" + is[i] + is[i].getClass());
                if (!(is[i] instanceof CPInstruction)) continue;
                Constant x = this.cp.getConstant(((CPInstruction)is[i]).getIndex());
                NGUtil.debugPrint(false, "IO:" + ((CPInstruction)is[i]).getIndex() + x + " " + x.getClass());
                x.accept(this);
            }
            return this.needsReflect;
        }

        public void visitConstantClass(ConstantClass obj) {
            String n = obj.getBytes(this.cp.getConstantPool());
            this.needsReflect = this.needsReflect || n.indexOf("{-1}") > -1;
            NGUtil.debugPrint(false, "  will reflect {-1}?  " + n + " " + n.indexOf("{-1}") + " " + this.needsReflect);
        }

        public void visitConstantNameAndType(ConstantNameAndType obj) {
            String n = obj.getName(this.cp.getConstantPool());
            this.needsReflect = this.needsReflect || n.indexOf("{-1}") > -1;
            NGUtil.debugPrint(false, "  will reflect {-1}?  " + n + " " + n.indexOf("{-1}") + " " + this.needsReflect);
        }

        public void visitConstantString(ConstantString obj) {
        }

        public void visitConstantUtf8(ConstantUtf8 obj) {
        }
    }
}

