/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.compiler.code;

import edu.rice.cs.nextgen2.compiler.code.BoundKind;
import edu.rice.cs.nextgen2.compiler.code.Scope;
import edu.rice.cs.nextgen2.compiler.code.Symbol;
import edu.rice.cs.nextgen2.compiler.util.List;
import edu.rice.cs.nextgen2.compiler.util.ListBuffer;
import edu.rice.cs.nextgen2.compiler.util.Log;
import edu.rice.cs.nextgen2.compiler.util.Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Type {
    public static final Type noType = new Type(18, null);
    public static boolean moreInfo = false;
    public int tag;
    public Symbol.TypeSymbol tsym;
    public Object constValue = null;
    public static final List<Type> emptyList = new List();

    public void accept(Visitor v) {
        v.visitType(this);
    }

    public Type(int tag, Symbol.TypeSymbol tsym) {
        this.tag = tag;
        this.tsym = tsym;
    }

    public Type map(Mapping f) {
        return this;
    }

    public static List<Type> map(List<Type> these, Mapping f) {
        if (these.nonEmpty()) {
            List<Type> tail1 = Type.map(these.tail, f);
            Type head1 = f.apply((Type)these.head);
            if (tail1 != these.tail || head1 != these.head) {
                return tail1.prepend(head1);
            }
        }
        return these;
    }

    public Type constType(Object constValue) {
        assert (this.tag <= 8);
        Type t = new Type(this.tag, this.tsym);
        t.constValue = constValue;
        return t;
    }

    public Type baseType() {
        if (this.constValue == null) {
            return this;
        }
        return this.tsym.type;
    }

    public static List<Type> baseTypes(List<Type> types) {
        if (types.nonEmpty()) {
            Type t = ((Type)types.head).baseType();
            List<Type> ts = Type.baseTypes(types.tail);
            if (t != types.head || ts != types.tail) {
                return new List<Type>(t, ts);
            }
        }
        return types;
    }

    public String toString() {
        String s;
        String string = s = this.tsym == null || this.tsym.name == null ? "<none>" : this.tsym.name.toString();
        if (moreInfo && this.tag == 14) {
            s = s + this.hashCode();
        }
        return s;
    }

    public static String toString(List<Type> list) {
        if (list.isEmpty()) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append(((Type)list.head).toString());
        List l = list.tail;
        while (l.nonEmpty()) {
            buf.append(",").append(((Type)l.head).toString());
            l = l.tail;
        }
        return buf.toString();
    }

    public String stringValue() {
        if (this.tag == 8) {
            return (Integer)this.constValue == 0 ? "false" : "true";
        }
        if (this.tag == 2) {
            return String.valueOf((char)((Integer)this.constValue).intValue());
        }
        return this.constValue.toString();
    }

    public boolean isFalse() {
        return this.tag == 8 && this.constValue != null && (Integer)this.constValue == 0;
    }

    public boolean isTrue() {
        return this.tag == 8 && this.constValue != null && (Integer)this.constValue != 0;
    }

    public String argtypes(boolean varargs) {
        List<Type> args = this.argtypes();
        if (!varargs) {
            return args.toString();
        }
        StringBuffer buf = new StringBuffer();
        while (args.tail.nonEmpty()) {
            buf.append(args.head);
            args = args.tail;
            buf.append(',');
        }
        if (((Type)args.head).tag == 11) {
            buf.append(((ArrayType)args.head).elemtype);
            buf.append("...");
        } else {
            buf.append(args.head);
        }
        return buf.toString();
    }

    public List<Type> typarams() {
        return emptyList;
    }

    public Type outer() {
        return null;
    }

    public List<Type> argtypes() {
        return emptyList;
    }

    public Type restype() {
        return null;
    }

    public List<Type> thrown() {
        return emptyList;
    }

    public Type bound() {
        return null;
    }

    public void setThrown(List<Type> t) {
        throw new AssertionError();
    }

    public List<Type> allparams() {
        return emptyList;
    }

    public boolean isErroneous() {
        return false;
    }

    public static boolean isErroneous(List<Type> ts) {
        List<Type> l = ts;
        while (l.nonEmpty()) {
            if (((Type)l.head).isErroneous()) {
                return true;
            }
            l = l.tail;
        }
        return false;
    }

    public boolean isParameterized() {
        return false;
    }

    public boolean isRaw() {
        return false;
    }

    public boolean isCompound() {
        return (this.tsym.flags() & 0x1000000L) != 0L;
    }

    public boolean isPrimitive() {
        return this.tag < 9;
    }

    public boolean contains(Type elem) {
        return elem == this;
    }

    public static boolean contains(List<Type> these, Type elem) {
        List<Type> l = these;
        while (l.tail != null) {
            if (((Type)l.head).contains(elem)) {
                return true;
            }
            l = l.tail;
        }
        return false;
    }

    public boolean containsSome(List<Type> elems) {
        List<Type> l = elems;
        while (l.nonEmpty()) {
            if (this.contains((Type)elems.head)) {
                return true;
            }
            l = l.tail;
        }
        return false;
    }

    public boolean isSuperBound() {
        return false;
    }

    public boolean isExtendsBound() {
        return false;
    }

    public boolean isUnbound() {
        return false;
    }

    public Type withTypeVar(Type t) {
        return this;
    }

    public static List<Type> removeBounds(List<Type> types) {
        ListBuffer<Type> result = new ListBuffer<Type>();
        while (types.nonEmpty()) {
            result.append(((Type)types.head).removeBounds());
            types = types.tail;
        }
        return result.toList();
    }

    public Type removeBounds() {
        return this;
    }

    public MethodType asMethodType() {
        throw new AssertionError();
    }

    public void complete() {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static abstract class Visitor {
        public void visitClassType(ClassType that) {
            this.visitType(that);
        }

        public void visitArgumentType(ArgumentType that) {
            this.visitType(that);
        }

        public void visitArrayType(ArrayType that) {
            this.visitType(that);
        }

        public void visitMethodType(MethodType that) {
            this.visitType(that);
        }

        public void visitPackageType(PackageType that) {
            this.visitType(that);
        }

        public void visitTypeVar(TypeVar that) {
            this.visitType(that);
        }

        public void visitCapturedType(CapturedType that) {
            this.visitTypeVar(that);
        }

        public void visitDelegatedType(DelegatedType that) {
            that.qtype.accept(this);
        }

        public void visitForAll(ForAll that) {
            this.visitDelegatedType(that);
        }

        public void visitUndetVar(UndetVar that) {
            this.visitDelegatedType(that);
        }

        public void visitErrorType(ErrorType that) {
            this.visitType(that);
        }

        public abstract void visitType(Type var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ErrorType
    extends ClassType {
        public ErrorType() {
            super(noType, emptyList, null);
            this.tag = 19;
        }

        public ErrorType(Symbol.ClassSymbol c) {
            this();
            this.tsym = c;
            c.type = this;
            c.kind = 31;
            c.members_field = new Scope.ErrorScope(c);
        }

        public ErrorType(Name name, Symbol.TypeSymbol container) {
            this(new Symbol.ClassSymbol(0x40000009L, name, null, container));
        }

        @Override
        public void accept(Visitor v) {
            v.visitErrorType(this);
        }

        @Override
        public Type constType(Object constValue) {
            return this;
        }

        @Override
        public Type outer() {
            return this;
        }

        @Override
        public Type restype() {
            return this;
        }

        public Type asSub(Symbol sym) {
            return this;
        }

        @Override
        public Type map(Mapping f) {
            return this;
        }

        public boolean isGenType(Type that) {
            return true;
        }

        @Override
        public boolean isErroneous() {
            return true;
        }

        @Override
        public List<Type> allparams() {
            return emptyList;
        }

        @Override
        public List<Type> typarams() {
            return emptyList;
        }
    }

    public static class UndetVar
    extends DelegatedType {
        public List<Type> lobounds = emptyList;
        public List<Type> hibounds = emptyList;
        public Type inst = null;

        public void accept(Visitor v) {
            v.visitUndetVar(this);
        }

        public UndetVar(Type origin) {
            super(21, origin);
        }

        public String toString() {
            if (this.inst != null) {
                return this.inst.toString();
            }
            return this.qtype + "?";
        }

        public Type baseType() {
            if (this.inst != null) {
                return this.inst.baseType();
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ForAll
    extends DelegatedType
    implements Cloneable {
        public List<Type> tvars;

        public ForAll(List<Type> tvars, Type qtype) {
            super(16, qtype);
            this.tvars = tvars;
        }

        @Override
        public void accept(Visitor v) {
            v.visitForAll(this);
        }

        @Override
        public String toString() {
            return "<" + this.tvars + ">" + this.qtype;
        }

        @Override
        public List<Type> typarams() {
            return this.tvars;
        }

        @Override
        public void setThrown(List<Type> t) {
            this.qtype.setThrown(t);
        }

        @Override
        public Object clone() {
            ForAll result = (ForAll)super.clone();
            result.qtype = (Type)result.qtype.clone();
            return result;
        }

        @Override
        public boolean isErroneous() {
            return this.qtype.isErroneous();
        }

        @Override
        public Type map(Mapping f) {
            return f.apply(this.qtype);
        }

        @Override
        public boolean contains(Type elem) {
            return this.qtype.contains(elem);
        }

        @Override
        public MethodType asMethodType() {
            return this.qtype.asMethodType();
        }

        @Override
        public void complete() {
            List<Type> l = this.tvars;
            while (l.nonEmpty()) {
                ((TypeVar)l.head).bound.complete();
                l = l.tail;
            }
            this.qtype.complete();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class DelegatedType
    extends Type {
        public Type qtype;

        public DelegatedType(int tag, Type qtype) {
            super(tag, qtype.tsym);
            this.qtype = qtype;
        }

        @Override
        public void accept(Visitor v) {
            v.visitDelegatedType(this);
        }

        @Override
        public String toString() {
            return this.qtype.toString();
        }

        @Override
        public List<Type> typarams() {
            return this.qtype.typarams();
        }

        @Override
        public Type outer() {
            return this.qtype.outer();
        }

        @Override
        public List<Type> argtypes() {
            return this.qtype.argtypes();
        }

        @Override
        public Type restype() {
            return this.qtype.restype();
        }

        @Override
        public List<Type> thrown() {
            return this.qtype.thrown();
        }

        @Override
        public List<Type> allparams() {
            return this.qtype.allparams();
        }

        @Override
        public Type bound() {
            return this.qtype.bound();
        }

        @Override
        public Object clone() {
            DelegatedType t = (DelegatedType)super.clone();
            t.qtype = (Type)this.qtype.clone();
            return t;
        }

        @Override
        public boolean isErroneous() {
            return this.qtype.isErroneous();
        }
    }

    public static class CapturedType
    extends TypeVar {
        public Type lower;

        public CapturedType(Name name, Symbol owner, Type upper, Type lower) {
            super(name, owner);
            this.bound = upper;
            this.lower = lower;
        }

        public void accept(Visitor v) {
            v.visitCapturedType(this);
        }
    }

    public static class TypeVar
    extends Type {
        public Type bound = null;
        int rank_field = -1;

        public TypeVar(Name name, Symbol owner) {
            super(14, null);
            this.tsym = new Symbol.TypeSymbol(0L, name, this, owner);
        }

        public TypeVar(Symbol.TypeSymbol tsym, Type bound) {
            super(14, tsym);
            this.bound = bound;
        }

        public void accept(Visitor v) {
            v.visitTypeVar(this);
        }

        public Type bound() {
            return this.bound;
        }
    }

    public static class PackageType
    extends Type {
        PackageType(Symbol.TypeSymbol tsym) {
            super(13, tsym);
        }

        public void accept(Visitor v) {
            v.visitPackageType(this);
        }

        public String toString() {
            return this.tsym.fullName().toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MethodType
    extends Type
    implements Cloneable {
        public List<Type> argtypes;
        public Type restype;
        public List<Type> thrown;

        public MethodType(List<Type> argtypes, Type restype, List<Type> thrown, Symbol.TypeSymbol methodClass) {
            super(12, methodClass);
            this.argtypes = argtypes;
            this.restype = restype;
            this.thrown = thrown;
        }

        @Override
        public void accept(Visitor v) {
            v.visitMethodType(this);
        }

        @Override
        public String toString() {
            return "(" + this.argtypes + ")" + this.restype;
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (!(that instanceof MethodType)) {
                return false;
            }
            MethodType mthat = (MethodType)that;
            List<Type> thisargs = this.argtypes;
            List<Type> thatargs = mthat.argtypes;
            while (thisargs.tail != null && thatargs.tail != null && ((Type)thisargs.head).equals(thatargs.head)) {
                thisargs = thisargs.tail;
                thatargs = thatargs.tail;
            }
            if (thisargs.tail != null || thatargs.tail != null) {
                return false;
            }
            return this.restype.equals(mthat.restype);
        }

        public int hashCode() {
            int h = 12;
            List<Type> thisargs = this.argtypes;
            while (thisargs.tail != null) {
                h = (h << 5) + ((Type)thisargs.head).hashCode();
                thisargs = thisargs.tail;
            }
            return (h << 5) + this.restype.hashCode();
        }

        @Override
        public List<Type> argtypes() {
            return this.argtypes;
        }

        @Override
        public Type restype() {
            return this.restype;
        }

        @Override
        public List<Type> thrown() {
            return this.thrown;
        }

        @Override
        public void setThrown(List<Type> t) {
            this.thrown = t;
        }

        @Override
        public boolean isErroneous() {
            return MethodType.isErroneous(this.argtypes) || this.restype != null && this.restype.isErroneous();
        }

        @Override
        public Type map(Mapping f) {
            List<Type> argtypes1 = MethodType.map(this.argtypes, f);
            Type restype1 = f.apply(this.restype);
            List<Type> thrown1 = MethodType.map(this.thrown, f);
            if (argtypes1 == this.argtypes && restype1 == this.restype && thrown1 == this.thrown) {
                return this;
            }
            return new MethodType(argtypes1, restype1, thrown1, this.tsym);
        }

        @Override
        public boolean contains(Type elem) {
            return elem == this || MethodType.contains(this.argtypes, elem) || this.restype.contains(elem);
        }

        @Override
        public MethodType asMethodType() {
            return this;
        }

        @Override
        public void complete() {
            List<Type> l = this.argtypes;
            while (l.nonEmpty()) {
                ((Type)l.head).complete();
                l = l.tail;
            }
            this.restype.complete();
            l = this.thrown;
            while (l.nonEmpty()) {
                ((Type)l.head).complete();
                l = l.tail;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ArrayType
    extends Type {
        public Type elemtype;

        public ArrayType(Type elemtype, Symbol.TypeSymbol arrayClass) {
            super(11, arrayClass);
            this.elemtype = elemtype;
        }

        @Override
        public void accept(Visitor v) {
            v.visitArrayType(this);
        }

        @Override
        public String toString() {
            return this.elemtype + "[]";
        }

        public boolean equals(Object that) {
            return this == that || that instanceof ArrayType && this.elemtype.equals(((ArrayType)that).elemtype);
        }

        public int hashCode() {
            return 352 + this.elemtype.hashCode();
        }

        @Override
        public List<Type> allparams() {
            return this.elemtype.allparams();
        }

        @Override
        public boolean isErroneous() {
            return this.elemtype.isErroneous();
        }

        @Override
        public boolean isParameterized() {
            return this.elemtype.isParameterized();
        }

        @Override
        public boolean isRaw() {
            return this.elemtype.isRaw();
        }

        @Override
        public Type map(Mapping f) {
            Type elemtype1 = f.apply(this.elemtype);
            if (elemtype1 == this.elemtype) {
                return this;
            }
            return new ArrayType(elemtype1, this.tsym);
        }

        @Override
        public boolean contains(Type elem) {
            return elem == this || this.elemtype.contains(elem);
        }

        @Override
        public void complete() {
            this.elemtype.complete();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassType
    extends Type {
        public Type outer_field;
        public List<Type> typarams_field;
        public List<Type> allparams_field;
        public Type supertype_field;
        public List<Type> interfaces_field;
        int rank_field = -1;

        public ClassType(Type outer, List<Type> typarams, Symbol.TypeSymbol tsym) {
            super(10, tsym);
            this.outer_field = outer;
            this.typarams_field = typarams;
            this.allparams_field = null;
            this.supertype_field = null;
            this.interfaces_field = null;
        }

        @Override
        public void accept(Visitor v) {
            v.visitClassType(this);
        }

        @Override
        public Type constType(Object constValue) {
            ClassType t = new ClassType(this.outer_field, this.typarams_field, this.tsym);
            t.constValue = constValue;
            return t;
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer();
            if (this.outer().tag == 10 && this.tsym.owner.kind == 2) {
                buf.append(this.outer().toString());
                buf.append(".");
                buf.append(this.className(this.tsym, false));
            } else {
                buf.append(this.className(this.tsym, true));
            }
            if (this.typarams().nonEmpty()) {
                buf.append('<');
                buf.append(this.typarams().toString());
                buf.append(">");
            }
            return buf.toString();
        }

        private String className(Symbol sym, boolean longform) {
            if (sym.name.len == 0 && (sym.flags() & 0x1000000L) != 0L) {
                StringBuffer s = new StringBuffer(this.supertype_field.toString());
                List<Type> is = this.interfaces_field;
                while (is.nonEmpty()) {
                    s.append("&");
                    s.append(((Type)is.head).toString());
                    is = is.tail;
                }
                return s.toString();
            }
            if (sym.name.len == 0) {
                ClassType norm = (ClassType)this.tsym.type;
                String s = norm.interfaces_field.nonEmpty() ? Log.getLocalizedString("anonymous.class", norm.interfaces_field.head) : Log.getLocalizedString("anonymous.class", norm.supertype_field);
                if (moreInfo) {
                    s = s + String.valueOf(sym.hashCode());
                }
                return s;
            }
            if (longform) {
                return sym.fullName().toString();
            }
            return sym.name.toString();
        }

        @Override
        public List<Type> typarams() {
            if (this.typarams_field == null) {
                this.complete();
                if (this.typarams_field == null) {
                    this.typarams_field = emptyList;
                }
            }
            return this.typarams_field;
        }

        @Override
        public Type outer() {
            return this.outer_field;
        }

        @Override
        public List<Type> allparams() {
            if (this.allparams_field == null) {
                this.allparams_field = this.typarams().prependList(this.outer().allparams());
            }
            return this.allparams_field;
        }

        @Override
        public boolean isErroneous() {
            return this.outer().isErroneous() || ClassType.isErroneous(this.typarams()) || this != this.tsym.type && this.tsym.type.isErroneous();
        }

        @Override
        public boolean isParameterized() {
            return this.allparams().tail != null;
        }

        @Override
        public boolean isRaw() {
            return this != this.tsym.type && this.tsym.type.allparams().nonEmpty() && this.allparams().isEmpty();
        }

        @Override
        public Type map(Mapping f) {
            Type outer = this.outer();
            Type outer1 = f.apply(outer);
            List<Type> typarams = this.typarams();
            List<Type> typarams1 = ClassType.map(typarams, f);
            if (outer1 == outer && typarams1 == typarams) {
                return this;
            }
            return new ClassType(outer1, typarams1, this.tsym);
        }

        @Override
        public boolean contains(Type elem) {
            return elem == this || this.isParameterized() && (this.outer().contains(elem) || ClassType.contains(this.typarams(), elem));
        }

        @Override
        public void complete() {
            if (this.tsym.completer != null) {
                this.tsym.complete();
            }
        }
    }

    public static class ArgumentType
    extends Type {
        public Type type;
        public BoundKind kind;
        public TypeVar bound;
        boolean isPrintingBound = false;

        public void accept(Visitor v) {
            v.visitArgumentType(this);
        }

        public ArgumentType(Type type, BoundKind kind, Symbol.TypeSymbol tsym) {
            super(15, tsym);
            assert (type != null);
            this.kind = kind;
            this.type = type;
        }

        public ArgumentType(ArgumentType that, TypeVar bound) {
            this(that.type, that.kind, that.tsym, bound);
        }

        public ArgumentType(Type type, BoundKind kind, Symbol.TypeSymbol tsym, TypeVar bound) {
            this(type, kind, tsym);
            this.bound = bound;
        }

        public boolean isSuperBound() {
            return this.kind == BoundKind.SUPER || this.kind == BoundKind.UNBOUND;
        }

        public boolean isExtendsBound() {
            return this.kind == BoundKind.EXTENDS || this.kind == BoundKind.UNBOUND;
        }

        public boolean isUnbound() {
            return this.kind == BoundKind.UNBOUND;
        }

        public Type withTypeVar(Type t) {
            if (this.bound == t) {
                return this;
            }
            this.bound = (TypeVar)t;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            StringBuffer s = new StringBuffer();
            s.append(this.kind.toString());
            if (this.kind != BoundKind.UNBOUND) {
                s.append(this.type);
            }
            if (moreInfo && this.bound != null && !this.isPrintingBound) {
                try {
                    this.isPrintingBound = true;
                    s.append("{:").append(this.bound.bound).append(":}");
                }
                finally {
                    this.isPrintingBound = false;
                }
            }
            return s.toString();
        }

        public Type map(Mapping f) {
            Type t = this.type;
            if (t != null) {
                t = f.apply(t);
            }
            if (t == this.type) {
                return this;
            }
            return new ArgumentType(t, this.kind, this.tsym, this.bound);
        }

        public Type removeBounds() {
            return this.isUnbound() ? this : this.type;
        }
    }

    public static abstract class Mapping {
        public abstract Type apply(Type var1);
    }
}

