/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.compiler.comp;

import edu.rice.cs.nextgen2.compiler.code.Scope;
import edu.rice.cs.nextgen2.compiler.code.Symbol;
import edu.rice.cs.nextgen2.compiler.code.Symtab;
import edu.rice.cs.nextgen2.compiler.code.Type;
import edu.rice.cs.nextgen2.compiler.code.Types;
import edu.rice.cs.nextgen2.compiler.comp.Annotate;
import edu.rice.cs.nextgen2.compiler.comp.Attr;
import edu.rice.cs.nextgen2.compiler.comp.AttrContext;
import edu.rice.cs.nextgen2.compiler.comp.Check;
import edu.rice.cs.nextgen2.compiler.comp.Env;
import edu.rice.cs.nextgen2.compiler.comp.MemberEnter;
import edu.rice.cs.nextgen2.compiler.comp.Resolve;
import edu.rice.cs.nextgen2.compiler.comp.Todo;
import edu.rice.cs.nextgen2.compiler.jvm.ClassReader;
import edu.rice.cs.nextgen2.compiler.tree.Tree;
import edu.rice.cs.nextgen2.compiler.tree.TreeInfo;
import edu.rice.cs.nextgen2.compiler.tree.TreeMaker;
import edu.rice.cs.nextgen2.compiler.util.Context;
import edu.rice.cs.nextgen2.compiler.util.List;
import edu.rice.cs.nextgen2.compiler.util.ListBuffer;
import edu.rice.cs.nextgen2.compiler.util.Log;
import edu.rice.cs.nextgen2.compiler.util.Name;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Enter
extends Tree.Visitor {
    protected static final Context.Key<Enter> enterKey = new Context.Key();
    Log log;
    Symtab syms;
    Resolve rs;
    Check chk;
    TreeMaker make;
    Attr attr;
    ClassReader reader;
    Name.Table names;
    Annotate annotate;
    MemberEnter memberEnter;
    Types types;
    private final Todo todo;
    Map<Symbol.TypeSymbol, Env<AttrContext>> typeEnvs = new HashMap<Symbol.TypeSymbol, Env<AttrContext>>();
    ListBuffer<Symbol.ClassSymbol> uncompleted;
    private Tree.ClassDef predefClassDef;
    protected Env<AttrContext> env;
    Type result;

    public static Enter instance(Context context) {
        Enter instance = context.get(enterKey);
        if (instance == null) {
            instance = new Enter(context);
        }
        return instance;
    }

    protected Enter(Context context) {
        context.put(enterKey, this);
        this.names = Name.Table.instance(context);
        this.log = Log.instance(context);
        this.reader = ClassReader.instance(context);
        this.make = TreeMaker.instance(context);
        this.syms = Symtab.instance(context);
        this.rs = Resolve.instance(context);
        this.chk = Check.instance(context);
        this.attr = Attr.instance(context);
        this.types = Types.instance(context);
        this.memberEnter = MemberEnter.instance(context);
        this.annotate = Annotate.instance(context);
        this.predefClassDef = new Tree.ClassDef(this.make.Modifiers(1L), this.syms.predefClass.name, null, null, null, null, this.syms.predefClass);
        this.todo = Todo.instance(context);
    }

    public Env<AttrContext> getEnv(Symbol.TypeSymbol sym) {
        return this.typeEnvs.get(sym);
    }

    public Env<AttrContext> classEnv(Tree.ClassDef tree, Env<AttrContext> env) {
        Env<AttrContext> localEnv = env.dup(tree, ((AttrContext)env.info).dup(new Scope(tree.sym)));
        localEnv.enclClass = tree;
        localEnv.outer = env;
        ((AttrContext)localEnv.info).isSelfCall = false;
        return localEnv;
    }

    Env<AttrContext> topLevelEnv(Tree.TopLevel tree) {
        Env<AttrContext> localEnv = new Env<AttrContext>(tree, new AttrContext());
        localEnv.toplevel = tree;
        localEnv.enclClass = this.predefClassDef;
        tree.namedImportScope = new Scope.ImportScope(tree.packge);
        tree.starImportScope = new Scope.ImportScope(tree.packge);
        ((AttrContext)localEnv.info).scope = tree.namedImportScope;
        return localEnv;
    }

    Scope enterScope(Env<AttrContext> env) {
        return env.tree.tag == 3 ? ((Tree.ClassDef)env.tree).sym.members_field : ((AttrContext)env.info).scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Type classEnter(Tree tree, Env<AttrContext> env) {
        Env<AttrContext> prevEnv = this.env;
        try {
            this.env = env;
            tree.accept(this);
            Type type = this.result;
            return type;
        }
        catch (Symbol.CompletionFailure ex) {
            Type type = this.chk.completionError(tree.pos, ex);
            return type;
        }
        finally {
            this.env = prevEnv;
        }
    }

    <T extends Tree> List<Type> classEnter(List<T> trees, Env<AttrContext> env) {
        ListBuffer<Type> ts = new ListBuffer<Type>();
        List<Object> l = trees;
        while (l.nonEmpty()) {
            ts.append(this.classEnter((Tree)l.head, env));
            l = l.tail;
        }
        return ts.toList();
    }

    @Override
    public void visitTopLevel(Tree.TopLevel tree) {
        Name prev = this.log.useSource(tree.sourcefile);
        boolean addEnv = false;
        boolean isPkgInfo = Enter.endsWith("" + tree.sourcefile, "package-info.java");
        if (tree.pid != null) {
            tree.packge = this.reader.enterPackage(TreeInfo.fullName(tree.pid));
            if (tree.packageAnnotations.nonEmpty()) {
                if (isPkgInfo) {
                    addEnv = true;
                } else {
                    this.log.error(((Tree.Annotation)tree.packageAnnotations.head).pos, "pkg.annotations.sb.in.package-info.java", new Object[0]);
                }
            }
        } else {
            tree.packge = this.syms.emptyPackage;
        }
        tree.packge.complete();
        Env<AttrContext> env = this.topLevelEnv(tree);
        if (isPkgInfo) {
            Env<AttrContext> env0 = this.typeEnvs.get(tree.packge);
            if (env0 == null) {
                this.typeEnvs.put(tree.packge, env);
            } else {
                Tree.TopLevel tree0 = env0.toplevel;
                if (tree.sourcefile != tree0.sourcefile) {
                    this.log.warning(tree.pid != null ? tree.pid.pos : 0, "pkg-info.already.seen", tree.packge);
                    if (addEnv || tree0.packageAnnotations.isEmpty() && tree.docComments != null && tree.docComments.get(tree) != null) {
                        this.typeEnvs.put(tree.packge, env);
                    }
                }
            }
        }
        List<Type> r = this.classEnter(tree.defs, env);
        if (addEnv) {
            this.todo.append(env);
        }
        this.log.useSource(prev);
        this.result = null;
    }

    @Override
    public void visitClassDef(Tree.ClassDef tree) {
        Symbol.ClassSymbol c;
        Symbol owner = ((AttrContext)this.env.info).scope.owner;
        Scope enclScope = this.enterScope(this.env);
        if (owner.kind == 1) {
            Symbol.PackageSymbol packge;
            Symbol q = packge = (Symbol.PackageSymbol)owner;
            while (q != null && q.kind == 1) {
                q.flags_field |= 0x800000L;
                q = q.owner;
            }
            c = this.reader.enterClass(tree.name, packge);
            packge.members().enterIfAbsent(c);
            if ((tree.mods.flags & 1L) != 0L && !Enter.classNameMatchesFileName(c, this.env)) {
                this.log.error(tree.pos, "class.public.should.be.in.file", tree.name);
            }
        } else {
            if (tree.name.len != 0 && !this.chk.checkUniqueClassName(tree.pos, tree.name, enclScope)) {
                this.result = null;
                return;
            }
            if (owner.kind == 2) {
                c = this.reader.enterClass(tree.name, (Symbol.TypeSymbol)owner);
                if ((owner.flags_field & 0x200L) != 0L) {
                    tree.mods.flags |= 9L;
                }
            } else {
                c = this.reader.defineClass(tree.name, owner);
                c.flatname = this.chk.localClassName(c);
                if (c.name.len != 0) {
                    this.chk.checkTransparentClass(tree.pos, c, ((AttrContext)this.env.info).scope);
                }
            }
        }
        tree.sym = c;
        tree.sym.is_nextgen = true;
        if (this.chk.compiled.get(c.flatname) != null) {
            this.duplicateClass(tree.pos, c);
            this.result = new Type.ErrorType(tree.name, (Symbol.TypeSymbol)owner);
            tree.sym = (Symbol.ClassSymbol)this.result.tsym;
            return;
        }
        this.chk.compiled.put(c.flatname, c);
        enclScope.enter(c);
        Env<AttrContext> localEnv = this.classEnv(tree, this.env);
        this.typeEnvs.put(c, localEnv);
        c.completer = this.memberEnter;
        c.flags_field = this.chk.checkFlags(tree.pos, tree.mods.flags, c, tree);
        c.sourcefile = this.env.toplevel.sourcefile;
        c.members_field = new Scope(c);
        Type.ClassType ct = (Type.ClassType)c.type;
        if (owner.kind != 1 && (c.flags_field & 8L) == 0L) {
            Symbol owner1 = owner;
            while ((owner1.kind & 0x14) != 0 && (owner1.flags_field & 8L) == 0L) {
                owner1 = owner1.owner;
            }
            if (owner1.kind == 2) {
                ct.outer_field = owner1.type;
            }
        }
        ct.typarams_field = this.classEnter(tree.typarams, localEnv);
        if (!c.isLocal() && this.uncompleted != null) {
            this.uncompleted.append(c);
        }
        this.classEnter(tree.defs, localEnv);
        this.result = c.type;
    }

    private static boolean classNameMatchesFileName(Symbol.ClassSymbol c, Env<AttrContext> env) {
        String fname = env.toplevel.sourcefile.toString();
        String cname = c.name + ".java";
        try {
            return Enter.endsWith(fname, cname) || Enter.endsWith(new File(fname).getCanonicalPath(), cname);
        }
        catch (IOException ex) {
            return false;
        }
    }

    protected static boolean endsWith(String pathname, String filename) {
        return pathname.endsWith(filename) && (pathname.length() == filename.length() || pathname.charAt(pathname.length() - filename.length() - 1) == File.separatorChar);
    }

    protected void duplicateClass(int pos, Symbol.ClassSymbol c) {
        this.log.error(pos, "duplicate.class", c.fullname);
    }

    @Override
    public void visitTypeParameter(Tree.TypeParameter tree) {
        Type.TypeVar a = tree.type != null ? (Type.TypeVar)tree.type : new Type.TypeVar(tree.name, ((AttrContext)this.env.info).scope.owner);
        tree.type = a;
        if (this.chk.checkUnique(tree.pos, a.tsym, ((AttrContext)this.env.info).scope)) {
            ((AttrContext)this.env.info).scope.enter(a.tsym);
        }
        this.result = a;
    }

    @Override
    public void visitTree(Tree tree) {
        this.result = null;
    }

    public void main(List<Tree> trees) {
        this.complete(trees, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(List<Tree> trees, Symbol.ClassSymbol c) {
        this.annotate.enterStart();
        ListBuffer<Symbol.ClassSymbol> prevUncompleted = this.uncompleted;
        if (this.memberEnter.completionEnabled) {
            this.uncompleted = new ListBuffer();
        }
        try {
            this.classEnter(trees, null);
            if (this.memberEnter.completionEnabled) {
                while (this.uncompleted.nonEmpty()) {
                    Symbol.ClassSymbol clazz = this.uncompleted.next();
                    if (c == null || c == clazz || prevUncompleted == null) {
                        clazz.complete();
                        continue;
                    }
                    prevUncompleted.append(clazz);
                }
                List<Tree> l = trees;
                while (l.nonEmpty()) {
                    Tree.TopLevel tree = (Tree.TopLevel)l.head;
                    if (tree.starImportScope.elems == null) {
                        Name prev = this.log.useSource(tree.sourcefile);
                        Env<AttrContext> env = this.typeEnvs.get(tree);
                        if (env == null) {
                            env = this.topLevelEnv(tree);
                        }
                        this.memberEnter.memberEnter(tree, env);
                        this.log.useSource(prev);
                    }
                    l = l.tail;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        finally {
            this.uncompleted = prevUncompleted;
            this.annotate.enterDone();
        }
    }
}

