/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.compiler.comp;

import edu.rice.cs.nextgen2.compiler.code.Attribute;
import edu.rice.cs.nextgen2.compiler.code.Scope;
import edu.rice.cs.nextgen2.compiler.code.Source;
import edu.rice.cs.nextgen2.compiler.code.Symbol;
import edu.rice.cs.nextgen2.compiler.code.Symtab;
import edu.rice.cs.nextgen2.compiler.code.Type;
import edu.rice.cs.nextgen2.compiler.code.Types;
import edu.rice.cs.nextgen2.compiler.comp.Attr;
import edu.rice.cs.nextgen2.compiler.comp.AttrContext;
import edu.rice.cs.nextgen2.compiler.comp.Check;
import edu.rice.cs.nextgen2.compiler.comp.ConstFold;
import edu.rice.cs.nextgen2.compiler.comp.Env;
import edu.rice.cs.nextgen2.compiler.comp.Resolve;
import edu.rice.cs.nextgen2.compiler.jvm.ClassReader;
import edu.rice.cs.nextgen2.compiler.jvm.ClassWriter;
import edu.rice.cs.nextgen2.compiler.jvm.Target;
import edu.rice.cs.nextgen2.compiler.tree.Tree;
import edu.rice.cs.nextgen2.compiler.tree.TreeInfo;
import edu.rice.cs.nextgen2.compiler.tree.TreeMaker;
import edu.rice.cs.nextgen2.compiler.tree.TreeScanner;
import edu.rice.cs.nextgen2.compiler.tree.TreeTranslator;
import edu.rice.cs.nextgen2.compiler.util.Context;
import edu.rice.cs.nextgen2.compiler.util.Convert;
import edu.rice.cs.nextgen2.compiler.util.List;
import edu.rice.cs.nextgen2.compiler.util.ListBuffer;
import edu.rice.cs.nextgen2.compiler.util.Log;
import edu.rice.cs.nextgen2.compiler.util.Name;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lower
extends TreeTranslator {
    protected static final Context.Key<Lower> lowerKey = new Context.Key();
    private Name.Table names;
    private Log log;
    private Symtab syms;
    private Resolve rs;
    private Check chk;
    private Attr attr;
    private TreeMaker make;
    private ClassWriter writer;
    private ClassReader reader;
    private ConstFold cfolder;
    private Target target;
    private Source source;
    private boolean allowEnums;
    private final Name dollarAssertionsDisabled;
    private final Name classDollar;
    private Types types;
    Symbol.ClassSymbol currentClass;
    ListBuffer<Tree> translated;
    Env<AttrContext> attrEnv;
    Map<Tree, Integer> endPositions;
    Map<Symbol.ClassSymbol, Tree.ClassDef> classdefs;
    Map<Symbol, Symbol> actualSymbols;
    Tree.MethodDef currentMethodDef;
    Symbol.MethodSymbol currentMethodSym;
    Tree.ClassDef outermostClassDef;
    Tree outermostMemberDef;
    ClassMap classMap = new ClassMap();
    Map<Symbol.ClassSymbol, List<Symbol.VarSymbol>> freevarCache;
    Map<Symbol.TypeSymbol, EnumMapping> enumSwitchMap = new LinkedHashMap<Symbol.TypeSymbol, EnumMapping>();
    private static final int DEREFcode = 0;
    private static final int ASSIGNcode = 2;
    private static final int PREINCcode = 4;
    private static final int PREDECcode = 6;
    private static final int POSTINCcode = 8;
    private static final int POSTDECcode = 10;
    private static final int FIRSTASGOPcode = 12;
    private static final int NCODES = Lower.accessCode(275) + 2;
    private Map<Symbol, Integer> accessNums;
    private Map<Symbol, Symbol.MethodSymbol[]> accessSyms;
    private Map<Symbol, Symbol.MethodSymbol> accessConstrs;
    private ListBuffer<Symbol> accessed;
    Scope proxies;
    List<Symbol.VarSymbol> outerThisStack;
    private Tree enclOp;

    public static Lower instance(Context context) {
        Lower instance = context.get(lowerKey);
        if (instance == null) {
            instance = new Lower(context);
        }
        return instance;
    }

    protected Lower(Context context) {
        context.put(lowerKey, this);
        this.names = Name.Table.instance(context);
        this.log = Log.instance(context);
        this.syms = Symtab.instance(context);
        this.rs = Resolve.instance(context);
        this.chk = Check.instance(context);
        this.attr = Attr.instance(context);
        this.make = TreeMaker.instance(context);
        this.writer = ClassWriter.instance(context);
        this.reader = ClassReader.instance(context);
        this.cfolder = ConstFold.instance(context);
        this.target = Target.instance(context);
        this.source = Source.instance(context);
        this.allowEnums = this.source.allowEnums();
        this.dollarAssertionsDisabled = this.names.fromString(this.target.syntheticNameChar() + "assertionsDisabled");
        this.classDollar = this.names.fromString("class" + this.target.syntheticNameChar());
        this.types = Types.instance(context);
    }

    Tree.ClassDef classDef(Symbol.ClassSymbol c) {
        Tree.ClassDef def = this.classdefs.get(c);
        if (def == null && this.outermostMemberDef != null) {
            this.classMap.scan(this.outermostMemberDef);
            def = this.classdefs.get(c);
        }
        if (def == null) {
            this.classMap.scan(this.outermostClassDef);
            def = this.classdefs.get(c);
        }
        return def;
    }

    List<Symbol.VarSymbol> freevars(Symbol.ClassSymbol c) {
        if ((c.owner.kind & 0x14) != 0) {
            List<Symbol.VarSymbol> fvs = this.freevarCache.get(c);
            if (fvs == null) {
                FreeVarCollector collector = new FreeVarCollector(c);
                collector.scan(this.classDef(c));
                fvs = collector.fvs;
                this.freevarCache.put(c, fvs);
            }
            return fvs;
        }
        return Symbol.VarSymbol.emptyList;
    }

    EnumMapping mapForEnum(int pos, Symbol.TypeSymbol enumClass) {
        EnumMapping map = this.enumSwitchMap.get(enumClass);
        if (map == null) {
            map = new EnumMapping(pos, enumClass);
            this.enumSwitchMap.put(enumClass, map);
        }
        return map;
    }

    Tree makeLit(Type type, Object value) {
        if (type.tag == 8) {
            return this.make.Ident((Integer)value == 0 ? this.syms.falseConst : this.syms.trueConst);
        }
        return this.make.Literal(type.tag, value).setType(type.constType(value));
    }

    Tree.NewClass makeNewClass(Type ctype, List<Tree> args) {
        Tree.NewClass tree = this.make.NewClass(null, null, this.make.QualIdent(ctype.tsym), args, null);
        tree.constructor = this.rs.resolveConstructor(this.make.pos, this.attrEnv, ctype, TreeInfo.types(args), null, false, false);
        tree.type = ctype;
        return tree;
    }

    Tree makeUnary(int optag, Tree arg) {
        Tree.Unary tree = this.make.Unary(optag, arg);
        tree.operator = this.rs.resolveUnaryOperator(this.make.pos, optag, this.attrEnv, arg.type);
        tree.type = tree.operator.type.restype();
        return tree;
    }

    Tree.Binary makeBinary(int optag, Tree lhs, Tree rhs) {
        Tree.Binary tree = this.make.Binary(optag, lhs, rhs);
        tree.operator = this.rs.resolveBinaryOperator(this.make.pos, optag, this.attrEnv, lhs.type, rhs.type);
        tree.type = tree.operator.type.restype();
        return tree;
    }

    Tree.Assignop makeAssignop(int optag, Tree lhs, Tree rhs) {
        Tree.Assignop tree = this.make.Assignop(optag, lhs, rhs);
        tree.operator = this.rs.resolveBinaryOperator(this.make.pos, tree.tag - 17, this.attrEnv, lhs.type, rhs.type);
        tree.type = lhs.type;
        return tree;
    }

    Tree makeString(Tree tree) {
        if (tree.type.tag >= 10) {
            return tree;
        }
        Symbol.MethodSymbol valueOfSym = this.lookupMethod(tree.pos, this.names.valueOf, this.syms.stringType, Type.emptyList.prepend(tree.type));
        return this.make.App(this.make.QualIdent(valueOfSym), List.make(tree));
    }

    Symbol.ClassSymbol makeEmptyClass(long flags, Symbol.ClassSymbol owner) {
        Symbol.ClassSymbol c = this.reader.defineClass(this.names.empty, owner);
        c.flatname = this.chk.localClassName(c);
        c.sourcefile = owner.sourcefile;
        c.completer = null;
        c.members_field = new Scope(c);
        c.flags_field = flags;
        Type.ClassType ctype = (Type.ClassType)c.type;
        ctype.supertype_field = this.syms.objectType;
        ctype.interfaces_field = Type.emptyList;
        Tree.ClassDef odef = this.classDef(owner);
        this.enterSynthetic(odef.pos, c, owner.members());
        this.chk.compiled.put(c.flatname, c);
        Tree.ClassDef cdef = this.make.ClassDef(this.make.Modifiers(flags), this.names.empty, Tree.TypeParameter.emptyList, null, Tree.emptyList, Tree.emptyList);
        cdef.sym = c;
        cdef.type = c.type;
        odef.defs = odef.defs.prepend(cdef);
        return c;
    }

    private void duplicateError(int pos, Symbol sym) {
        if (!sym.type.isErroneous()) {
            this.log.error(pos, "synthetic.name.conflict", sym, sym.location());
        }
    }

    private void enterSynthetic(int pos, Symbol sym, Scope s) {
        if (sym.name != this.names.error && sym.name != this.names.empty) {
            Scope.Entry e = s.lookup(sym.name);
            while (e.scope == s) {
                if (sym != e.sym && sym.kind == e.sym.kind && ((sym.kind & 0x14) == 0 || this.types.erasure(sym.type).equals(this.types.erasure(e.sym.type)))) {
                    this.duplicateError(pos, e.sym);
                    break;
                }
                e = e.next();
            }
        }
        s.enter(sym);
    }

    private Symbol lookupSynthetic(Name name, Scope s) {
        Symbol sym = s.lookup((Name)name).sym;
        return sym == null || (sym.flags() & 0x1000L) == 0L ? null : sym;
    }

    private Symbol.MethodSymbol lookupMethod(int pos, Name name, Type qual, List<Type> args) {
        return this.rs.resolveInternalMethod(pos, this.attrEnv, qual, name, args, null);
    }

    private Symbol.MethodSymbol lookupConstructor(int pos, Type qual, List<Type> args) {
        return this.rs.resolveInternalConstructor(pos, this.attrEnv, qual, args, null);
    }

    private Symbol.VarSymbol lookupField(int pos, Type qual, Name name) {
        return this.rs.resolveInternalField(pos, this.attrEnv, qual, name);
    }

    private static int accessCode(int bytecode) {
        if (96 <= bytecode && bytecode <= 131) {
            return (bytecode - 96) * 2 + 12;
        }
        if (bytecode == 256) {
            return 84;
        }
        if (270 <= bytecode && bytecode <= 275) {
            return (bytecode - 270 + 131 + 2 - 96) * 2 + 12;
        }
        return -1;
    }

    private static int accessCode(Tree tree, Tree enclOp) {
        if (enclOp == null) {
            return 0;
        }
        if (enclOp.tag == 30 && tree == TreeInfo.skipParens(((Tree.Assign)enclOp).lhs)) {
            return 2;
        }
        if (50 <= enclOp.tag && enclOp.tag <= 53 && tree == TreeInfo.skipParens(((Tree.Unary)enclOp).arg)) {
            return (enclOp.tag - 50) * 2 + 4;
        }
        if (74 <= enclOp.tag && enclOp.tag <= 90 && tree == TreeInfo.skipParens(((Tree.Assignop)enclOp).lhs)) {
            return Lower.accessCode(((Symbol.OperatorSymbol)((Tree.Assignop)enclOp).operator).opcode);
        }
        return 0;
    }

    private Symbol.OperatorSymbol binaryAccessOperator(int acode) {
        Scope.Entry e = this.syms.predefClass.members().elems;
        while (e != null) {
            if (e.sym instanceof Symbol.OperatorSymbol) {
                Symbol.OperatorSymbol op = (Symbol.OperatorSymbol)e.sym;
                if (Lower.accessCode(op.opcode) == acode) {
                    return op;
                }
            }
            e = e.sibling;
        }
        return null;
    }

    private static int treeTag(Symbol.OperatorSymbol operator) {
        switch (operator.opcode) {
            case 128: 
            case 129: {
                return 74;
            }
            case 130: 
            case 131: {
                return 75;
            }
            case 126: 
            case 127: {
                return 76;
            }
            case 120: 
            case 121: 
            case 270: 
            case 271: {
                return 83;
            }
            case 122: 
            case 123: 
            case 272: 
            case 273: {
                return 84;
            }
            case 124: 
            case 125: 
            case 274: 
            case 275: {
                return 85;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 256: {
                return 86;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                return 87;
            }
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                return 88;
            }
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                return 89;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                return 90;
            }
        }
        throw new AssertionError();
    }

    Name accessName(int anum, int acode) {
        return this.names.fromString("access" + this.target.syntheticNameChar() + anum + acode / 10 + acode % 10);
    }

    Symbol.MethodSymbol accessSymbol(Symbol sym, Tree tree, Tree enclOp, boolean protAccess, boolean refSuper) {
        Symbol.MethodSymbol[] accessors;
        Symbol.MethodSymbol accessor;
        List<Type> thrown;
        Type restype;
        List<Type> argtypes;
        int acode;
        Integer anum;
        Symbol.ClassSymbol accOwner = refSuper && protAccess ? (Symbol.ClassSymbol)((Tree.Select)tree).selected.type.tsym : this.accessClass(sym, protAccess, tree);
        Symbol vsym = sym;
        if (sym.owner != accOwner) {
            vsym = sym.clone(accOwner);
            this.actualSymbols.put(vsym, sym);
        }
        if ((anum = this.accessNums.get(vsym)) == null) {
            anum = this.accessed.length();
            this.accessNums.put(vsym, anum);
            this.accessSyms.put(vsym, new Symbol.MethodSymbol[NCODES]);
            this.accessed.append(vsym);
        }
        switch (vsym.kind) {
            case 4: {
                acode = Lower.accessCode(tree, enclOp);
                if (acode >= 12) {
                    Symbol.OperatorSymbol operator = this.binaryAccessOperator(acode);
                    argtypes = operator.opcode == 256 ? List.make(this.syms.objectType) : operator.type.argtypes().tail;
                } else {
                    argtypes = acode == 2 ? Type.emptyList.prepend(vsym.erasure(this.types)) : Type.emptyList;
                }
                restype = vsym.erasure(this.types);
                thrown = Type.emptyList;
                break;
            }
            case 16: {
                acode = 0;
                argtypes = vsym.erasure(this.types).argtypes();
                restype = vsym.erasure(this.types).restype();
                thrown = vsym.type.thrown();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (protAccess && refSuper) {
            ++acode;
        }
        if ((vsym.flags() & 8L) == 0L) {
            argtypes = argtypes.prepend(vsym.owner.erasure(this.types));
        }
        if ((accessor = (accessors = this.accessSyms.get(vsym))[acode]) == null) {
            accessor = new Symbol.MethodSymbol(4104L, this.accessName(anum, acode), new Type.MethodType(argtypes, restype, thrown, this.syms.methodClass), accOwner);
            this.enterSynthetic(tree.pos, accessor, accOwner.members());
            accessors[acode] = accessor;
        }
        return accessor;
    }

    Tree accessBase(int pos, Symbol sym) {
        return (sym.flags() & 8L) != 0L ? this.access(this.make.at(pos).QualIdent(sym.owner)) : this.makeOwnerThis(pos, sym, true);
    }

    boolean needsPrivateAccess(Symbol sym) {
        if ((sym.flags() & 2L) == 0L || sym.owner == this.currentClass) {
            return false;
        }
        if (sym.name == this.names.init && (sym.owner.owner.kind & 0x14) != 0) {
            sym.flags_field &= 0xFFFFFFFFFFFFFFFDL;
            return false;
        }
        return true;
    }

    boolean needsProtectedAccess(Symbol sym, Tree tree) {
        if ((sym.flags() & 4L) == 0L || sym.owner.owner == this.currentClass.owner || sym.packge() == this.currentClass.packge()) {
            return false;
        }
        if (!this.currentClass.isSubClass(sym.owner, this.types)) {
            return true;
        }
        if ((sym.flags() & 8L) != 0L || tree.tag != 34 || TreeInfo.name(((Tree.Select)tree).selected) == this.names._super) {
            return false;
        }
        return !((Tree.Select)tree).selected.type.tsym.isSubClass(this.currentClass, this.types);
    }

    Symbol.ClassSymbol accessClass(Symbol sym, boolean protAccess, Tree tree) {
        if (protAccess) {
            Symbol.TypeSymbol qualifier = null;
            Symbol.ClassSymbol c = this.currentClass;
            if (tree.tag == 34 && (sym.flags() & 8L) == 0L) {
                qualifier = ((Tree.Select)tree).selected.type.tsym;
                while (!qualifier.isSubClass(c, this.types)) {
                    c = c.owner.enclClass();
                }
                return c;
            }
            while (!c.isSubClass(sym.owner, this.types)) {
                c = c.owner.enclClass();
            }
            return c;
        }
        return sym.owner.enclClass();
    }

    Tree access(Symbol sym, Tree tree, Tree enclOp, boolean refSuper) {
        while (sym.kind == 4 && sym.owner.kind == 16 && sym.owner.enclClass() != this.currentClass) {
            Object cv = ((Symbol.VarSymbol)sym).constValue;
            if (cv != null) {
                this.make.at(tree.pos);
                return this.makeLit(sym.type, cv);
            }
            sym = this.proxies.lookup((Name)this.proxyName((Name)sym.name)).sym;
            assert (sym != null && (sym.flags_field & 0x10L) != 0L);
            tree = this.make.at(tree.pos).Ident(sym);
        }
        Tree base = tree.tag == 34 ? ((Tree.Select)tree).selected : null;
        switch (sym.kind) {
            case 2: {
                if (sym.owner.kind == 1) break;
                Name flatname = Convert.shortName(sym.flatName());
                while (base != null && TreeInfo.symbol(base) != null && TreeInfo.symbol((Tree)base).kind != 1) {
                    base = base.tag == 34 ? ((Tree.Select)base).selected : null;
                }
                if (tree.tag == 35) {
                    ((Tree.Ident)tree).name = flatname;
                    break;
                }
                if (base == null) {
                    tree = this.make.at(tree.pos).Ident(sym);
                    ((Tree.Ident)tree).name = flatname;
                    break;
                }
                ((Tree.Select)tree).selected = base;
                ((Tree.Select)tree).name = flatname;
                break;
            }
            case 4: 
            case 16: {
                Object cv;
                boolean baseReq;
                if (sym.owner.kind != 2) break;
                boolean protAccess = refSuper && !this.needsPrivateAccess(sym) || this.needsProtectedAccess(sym, tree);
                boolean accReq = protAccess || this.needsPrivateAccess(sym);
                boolean bl = baseReq = base == null && sym.owner != this.syms.predefClass && !sym.isMemberOf(this.currentClass, this.types);
                if (!accReq && !baseReq) break;
                this.make.at(tree.pos);
                if (sym.kind == 4 && (cv = ((Symbol.VarSymbol)sym).constValue) != null) {
                    return this.makeLit(sym.type, cv);
                }
                if (accReq) {
                    List<Tree> args = Tree.emptyList;
                    if ((sym.flags() & 8L) == 0L) {
                        if (base == null) {
                            base = this.makeOwnerThis(tree.pos, sym, true);
                        }
                        args = args.prepend(base);
                        base = null;
                    }
                    Symbol.MethodSymbol access = this.accessSymbol(sym, tree, enclOp, protAccess, refSuper);
                    Tree receiver = this.make.Select(base != null ? base : this.make.QualIdent(access.owner), access);
                    return this.make.App(receiver, args);
                }
                if (!baseReq) break;
                return this.make.at(tree.pos).Select(this.accessBase(tree.pos, sym), sym);
            }
        }
        return tree;
    }

    Tree access(Tree tree) {
        Symbol sym = TreeInfo.symbol(tree);
        return sym == null ? tree : this.access(sym, tree, null, false);
    }

    Symbol accessConstructor(int pos, Symbol constr) {
        if (this.needsPrivateAccess(constr)) {
            Symbol.ClassSymbol accOwner = constr.owner.enclClass();
            Symbol.MethodSymbol aconstr = this.accessConstrs.get(constr);
            if (aconstr == null) {
                List<Type> argtypes = constr.type.argtypes();
                if ((accOwner.flags_field & 0x4000L) != 0L) {
                    argtypes = argtypes.prepend(this.syms.intType).prepend(this.syms.stringType);
                }
                aconstr = new Symbol.MethodSymbol(4096L, this.names.init, new Type.MethodType(argtypes.append(this.accessConstructorTag().erasure(this.types)), constr.type.restype(), constr.type.thrown(), this.syms.methodClass), accOwner);
                this.enterSynthetic(pos, aconstr, accOwner.members());
                this.accessConstrs.put(constr, aconstr);
                this.accessed.append(constr);
            }
            return aconstr;
        }
        return constr;
    }

    Symbol.ClassSymbol accessConstructorTag() {
        Symbol.ClassSymbol topClass = this.currentClass.outermostClass();
        Name flatname = this.names.fromString("" + topClass.fullName() + this.target.syntheticNameChar() + "1");
        Symbol.ClassSymbol ctag = this.chk.compiled.get(flatname);
        if (ctag == null) {
            ctag = this.makeEmptyClass(4104L, topClass);
        }
        return ctag;
    }

    void makeAccessible(Symbol sym) {
        Tree.ClassDef cdef = this.classDef(sym.owner.enclClass());
        assert (cdef != null) : "class def not found: " + sym + " in " + sym.owner;
        if (sym.name == this.names.init) {
            cdef.defs = cdef.defs.prepend(this.accessConstructorDef(cdef.pos, sym, this.accessConstrs.get(sym)));
        } else {
            Symbol.MethodSymbol[] accessors = this.accessSyms.get(sym);
            for (int i = 0; i < NCODES; ++i) {
                if (accessors[i] == null) continue;
                cdef.defs = cdef.defs.prepend(this.accessDef(cdef.pos, sym, accessors[i], i));
            }
        }
    }

    Tree accessDef(int pos, Symbol vsym, Symbol.MethodSymbol accessor, int acode) {
        Tree stat;
        List<Tree> args;
        Tree ref;
        this.currentClass = vsym.owner.enclClass();
        this.make.at(pos);
        Tree.MethodDef md = this.make.MethodDef(accessor, null);
        Symbol sym = this.actualSymbols.get(vsym);
        if (sym == null) {
            sym = vsym;
        }
        if ((sym.flags() & 8L) != 0L) {
            ref = this.make.Ident(sym);
            args = this.make.Idents(md.params);
        } else {
            ref = this.make.Select(this.make.Ident((Tree.VarDef)md.params.head), sym);
            args = this.make.Idents(md.params.tail);
        }
        if (sym.kind == 4) {
            Tree expr;
            int acode1 = acode - (acode & 1);
            switch (acode1) {
                case 0: {
                    expr = ref;
                    break;
                }
                case 2: {
                    expr = this.make.Assign(ref, (Tree)args.head);
                    break;
                }
                case 4: 
                case 6: 
                case 8: 
                case 10: {
                    expr = this.makeUnary((acode1 - 4 >> 1) + 50, ref);
                    break;
                }
                default: {
                    expr = this.make.Assignop(Lower.treeTag(this.binaryAccessOperator(acode1)), ref, (Tree)args.head);
                    ((Tree.Assignop)expr).operator = this.binaryAccessOperator(acode1);
                }
            }
            stat = this.make.Return(expr.setType(sym.type));
        } else {
            stat = this.make.Call(this.make.App(ref, args));
        }
        md.body = this.make.Block(0L, List.make(stat));
        List<Tree> l = md.params;
        while (l.nonEmpty()) {
            ((Tree.VarDef)l.head).vartype = this.access(((Tree.VarDef)l.head).vartype);
            l = l.tail;
        }
        md.restype = this.access(md.restype);
        l = md.thrown;
        while (l.nonEmpty()) {
            l.head = this.access((Tree)l.head);
            l = l.tail;
        }
        return md;
    }

    Tree accessConstructorDef(int pos, Symbol constr, Symbol.MethodSymbol accessor) {
        this.make.at(pos);
        Tree.MethodDef md = this.make.MethodDef(accessor, accessor.externalType(this.types), null);
        Tree.Ident callee = this.make.Ident(this.names._this);
        callee.sym = constr;
        callee.type = constr.type;
        md.body = this.make.Block(0L, List.make(this.make.Call(this.make.App(callee, this.make.Idents(md.params.reverse().tail.reverse())))));
        return md;
    }

    Name proxyName(Name name) {
        return this.names.fromString("val" + this.target.syntheticNameChar() + name);
    }

    List<Tree.VarDef> freevarDefs(int pos, List<Symbol.VarSymbol> freevars, Symbol owner) {
        long flags = 4112L;
        if (owner.kind == 2 && this.target.usePrivateSyntheticFields()) {
            flags |= 2L;
        }
        List<Tree.VarDef> defs = Tree.VarDef.emptyList;
        List<Symbol.VarSymbol> l = freevars;
        while (l.nonEmpty()) {
            Symbol.VarSymbol v = (Symbol.VarSymbol)l.head;
            Symbol.VarSymbol proxy = new Symbol.VarSymbol(flags, this.proxyName(v.name), v.erasure(this.types), owner);
            this.proxies.enter(proxy);
            Tree.VarDef vd = this.make.at(pos).VarDef(proxy, null);
            vd.vartype = this.access(vd.vartype);
            defs = defs.prepend(vd);
            l = l.tail;
        }
        return defs;
    }

    Name outerThisName(Type type, Symbol owner) {
        Type t = type.outer();
        int nestingLevel = 0;
        while (t.tag == 10) {
            t = t.outer();
            ++nestingLevel;
        }
        Name result = this.names.fromString("this" + this.target.syntheticNameChar() + nestingLevel);
        while (owner.kind == 2 && ((Symbol.ClassSymbol)owner).members().lookup((Name)result).scope != null) {
            result = this.names.fromString(result.toString() + this.target.syntheticNameChar());
        }
        return result;
    }

    Tree.VarDef outerThisDef(int pos, Symbol owner) {
        long flags = 4112L;
        if (owner.kind == 2 && this.target.usePrivateSyntheticFields()) {
            flags |= 2L;
        }
        Type target = this.types.erasure(owner.enclClass().type.outer());
        Symbol.VarSymbol outerThis = new Symbol.VarSymbol(flags, this.outerThisName(target, owner), target, owner);
        this.outerThisStack = this.outerThisStack.prepend(outerThis);
        Tree.VarDef vd = this.make.at(pos).VarDef(outerThis, null);
        vd.vartype = this.access(vd.vartype);
        return vd;
    }

    List<Tree> loadFreevars(int pos, List<Symbol.VarSymbol> freevars) {
        List<Tree> args = Tree.emptyList;
        List<Symbol.VarSymbol> l = freevars;
        while (l.nonEmpty()) {
            args = args.prepend(this.loadFreevar(pos, (Symbol.VarSymbol)l.head));
            l = l.tail;
        }
        return args;
    }

    Tree loadFreevar(int pos, Symbol.VarSymbol v) {
        return this.access(v, this.make.at(pos).Ident(v), null, false);
    }

    Tree makeThis(int pos, Symbol.TypeSymbol c) {
        if (this.currentClass == c) {
            return this.make.at(pos).This(c.erasure(this.types));
        }
        return this.makeOuterThis(pos, c);
    }

    Tree makeOuterThis(int pos, Symbol.TypeSymbol c) {
        List<Symbol.VarSymbol> ots = this.outerThisStack;
        if (ots.isEmpty()) {
            this.log.error(pos, "no.encl.instance.of.type.in.scope", c);
            assert (false);
            return this.make.Ident(this.syms.nullConst);
        }
        Symbol.VarSymbol ot = (Symbol.VarSymbol)ots.head;
        Tree tree = this.access(this.make.at(pos).Ident(ot));
        Symbol.TypeSymbol otc = ot.type.tsym;
        while (otc != c) {
            do {
                if ((ots = ots.tail).isEmpty()) {
                    this.log.error(pos, "no.encl.instance.of.type.in.scope", c);
                    assert (false);
                    return tree;
                }
                ot = (Symbol.VarSymbol)ots.head;
            } while (ot.owner != otc);
            if (otc.owner.kind != 1 && !otc.hasOuterInstance()) {
                this.chk.earlyRefError(pos, c);
                assert (false);
                return this.make.Ident(this.syms.nullConst);
            }
            tree = this.access(this.make.at(pos).Select(tree, ot));
            otc = ot.type.tsym;
        }
        return tree;
    }

    Tree makeOwnerThis(int pos, Symbol sym, boolean preciseMatch) {
        Symbol c = sym.owner;
        if (preciseMatch ? sym.isMemberOf(this.currentClass, this.types) : this.currentClass.isSubClass(sym.owner, this.types)) {
            return this.make.at(pos).This(c.erasure(this.types));
        }
        List<Symbol.VarSymbol> ots = this.outerThisStack;
        if (ots.isEmpty()) {
            this.log.error(pos, "no.encl.instance.of.type.in.scope", c);
            assert (false);
            return this.make.Ident(this.syms.nullConst);
        }
        Symbol.VarSymbol ot = (Symbol.VarSymbol)ots.head;
        Tree tree = this.access(this.make.at(pos).Ident(ot));
        Symbol.TypeSymbol otc = ot.type.tsym;
        while (!(!preciseMatch ? otc.isSubClass(sym.owner, this.types) : sym.isMemberOf(otc, this.types))) {
            do {
                if ((ots = ots.tail).isEmpty()) {
                    this.log.error(pos, "no.encl.instance.of.type.in.scope", c);
                    assert (false);
                    return tree;
                }
                ot = (Symbol.VarSymbol)ots.head;
            } while (ot.owner != otc);
            tree = this.access(this.make.at(pos).Select(tree, ot));
            otc = ot.type.tsym;
        }
        return tree;
    }

    Tree initField(int pos, Name name) {
        Scope.Entry e = this.proxies.lookup(name);
        Symbol rhs = e.sym;
        assert (rhs.owner.kind == 16);
        Symbol lhs = e.next().sym;
        assert (rhs.owner.owner == lhs.owner);
        this.make.at(pos);
        return this.make.Exec(this.make.Assign(this.make.Select(this.make.This(lhs.owner.erasure(this.types)), lhs), this.make.Ident(rhs)).setType(lhs.erasure(this.types)));
    }

    Tree initOuterThis(int pos) {
        Symbol.VarSymbol rhs = (Symbol.VarSymbol)this.outerThisStack.head;
        assert (rhs.owner.kind == 16);
        Symbol.VarSymbol lhs = (Symbol.VarSymbol)this.outerThisStack.tail.head;
        assert (rhs.owner.owner == lhs.owner);
        this.make.at(pos);
        return this.make.Exec(this.make.Assign(this.make.Select(this.make.This(lhs.owner.erasure(this.types)), lhs), this.make.Ident(rhs)).setType(lhs.erasure(this.types)));
    }

    private Symbol.ClassSymbol outerCacheClass() {
        Symbol.ClassSymbol clazz = this.outermostClassDef.sym;
        if ((clazz.flags() & 0x200L) == 0L && !this.target.useInnerCacheClass()) {
            return clazz;
        }
        Scope s = clazz.members();
        Scope.Entry e = s.elems;
        while (e != null) {
            if (e.sym.kind == 2 && e.sym.name == this.names.empty && (e.sym.flags() & 0x200L) == 0L) {
                return (Symbol.ClassSymbol)e.sym;
            }
            e = e.sibling;
        }
        return this.makeEmptyClass(4104L, clazz);
    }

    private Symbol.MethodSymbol classDollarSym(int pos) {
        Symbol.ClassSymbol outerCacheClass = this.outerCacheClass();
        Symbol.MethodSymbol classDollarSym = (Symbol.MethodSymbol)this.lookupSynthetic(this.classDollar, outerCacheClass.members());
        if (classDollarSym == null) {
            classDollarSym = new Symbol.MethodSymbol(4104L, this.classDollar, new Type.MethodType(Type.emptyList.prepend(this.syms.stringType), this.types.erasure(this.syms.classType), Type.emptyList, this.syms.methodClass), outerCacheClass);
            this.enterSynthetic(pos, classDollarSym, outerCacheClass.members());
            Tree.MethodDef md = this.make.MethodDef(classDollarSym, null);
            try {
                md.body = this.classDollarSymBody(pos, md);
            }
            catch (Symbol.CompletionFailure ex) {
                md.body = this.make.Block(0L, Tree.emptyList);
                this.chk.completionError(pos, ex);
            }
            Tree.ClassDef outerCacheClassDef = this.classDef(outerCacheClass);
            outerCacheClassDef.defs = outerCacheClassDef.defs.prepend(md);
        }
        return classDollarSym;
    }

    Tree.Block classDollarSymBody(int pos, Tree.MethodDef md) {
        Tree.Throw rethrow;
        Tree.Block returnResult;
        Symbol.MethodSymbol classDollarSym = md.sym;
        Symbol.ClassSymbol outerCacheClass = (Symbol.ClassSymbol)classDollarSym.owner;
        if (this.target.classLiteralsNoInit()) {
            Symbol.VarSymbol clsym = new Symbol.VarSymbol(4104L, this.names.fromString("cl" + this.target.syntheticNameChar()), this.syms.classLoaderType, outerCacheClass);
            this.enterSynthetic(pos, clsym, outerCacheClass.members());
            Tree.VarDef cldef = this.make.VarDef(clsym, null);
            Tree.ClassDef outerCacheClassDef = this.classDef(outerCacheClass);
            outerCacheClassDef.defs = outerCacheClassDef.defs.prepend(cldef);
            Tree.NewArray newcache = this.make.NewArray(this.make.Type(outerCacheClass.type), Tree.emptyList.prepend(this.make.Literal(4, 0).setType(this.syms.intType)), null);
            newcache.type = new Type.ArrayType(this.types.erasure(outerCacheClass.type), (Symbol.TypeSymbol)this.syms.arrayClass);
            Symbol.MethodSymbol forNameSym = this.lookupMethod(this.make.pos, this.names.forName, this.types.erasure(this.syms.classType), Type.emptyList.prepend(this.syms.classLoaderType).prepend(this.syms.booleanType).prepend(this.syms.stringType));
            Tree clvalue = this.make.Conditional(this.makeBinary(60, this.make.Ident(clsym), this.make.Ident(this.syms.nullConst)), this.make.Assign(this.make.Ident(clsym), this.makeCall(this.makeCall(this.makeCall(newcache, this.names.getClass, Tree.emptyList), this.names.getComponentType, Tree.emptyList), this.names.getClassLoader, Tree.emptyList)).setType(this.syms.classLoaderType), this.make.Ident(clsym)).setType(this.syms.classLoaderType);
            List<Tree> args = Tree.emptyList.prepend(clvalue).prepend(this.make.Ident(this.syms.falseConst)).prepend(this.make.Ident(((Tree.VarDef)md.params.head).sym));
            returnResult = this.make.Block(0L, Tree.emptyList.prepend(this.make.Call(this.make.App(this.make.Ident(forNameSym), args))));
        } else {
            Symbol.MethodSymbol forNameSym = this.lookupMethod(this.make.pos, this.names.forName, this.types.erasure(this.syms.classType), Type.emptyList.prepend(this.syms.stringType));
            returnResult = this.make.Block(0L, Tree.emptyList.prepend(this.make.Call(this.make.App(this.make.QualIdent(forNameSym), List.make(this.make.Ident(((Tree.VarDef)md.params.head).sym))))));
        }
        Symbol.VarSymbol catchParam = new Symbol.VarSymbol(0L, this.make.paramName(1), this.syms.classNotFoundExceptionType, classDollarSym);
        if (this.target.hasInitCause()) {
            Tree throwExpr = this.makeCall(this.makeNewClass(this.syms.noClassDefFoundErrorType, Tree.emptyList), this.names.initCause, Tree.emptyList.prepend(this.make.Ident(catchParam)));
            rethrow = this.make.Throw(throwExpr);
        } else {
            Symbol.MethodSymbol getMessageSym = this.lookupMethod(this.make.pos, this.names.getMessage, this.syms.classNotFoundExceptionType, Type.emptyList);
            rethrow = this.make.Throw(this.makeNewClass(this.syms.noClassDefFoundErrorType, List.make(this.make.App(this.make.Select(this.make.Ident(catchParam), getMessageSym), Tree.emptyList))));
        }
        Tree.Block rethrowStmt = this.make.Block(0L, Tree.emptyList.prepend(rethrow));
        Tree.Catch catchBlock = this.make.Catch(this.make.VarDef(catchParam, null), rethrowStmt);
        Tree.Try tryCatch = this.make.Try(returnResult, Tree.Catch.emptyList.prepend(catchBlock), null);
        return this.make.Block(0L, Tree.emptyList.prepend(tryCatch));
    }

    private Tree makeCall(Tree left, Name name, List<Tree> args) {
        assert (left.type != null);
        List<Type> types = Type.emptyList;
        Symbol.MethodSymbol funcsym = this.lookupMethod(this.make.pos, name, left.type, TreeInfo.types(args));
        return this.make.App(this.make.Select(left, funcsym), args);
    }

    private Name cacheName(String sig) {
        StringBuffer buf = new StringBuffer();
        if (sig.startsWith("[")) {
            buf = buf.append("array");
            while (sig.startsWith("[")) {
                buf = buf.append(this.target.syntheticNameChar());
                sig = sig.substring(1);
            }
            if (sig.startsWith("L")) {
                sig = sig.substring(0, sig.length() - 1);
            }
        } else {
            buf = buf.append("class" + this.target.syntheticNameChar());
        }
        buf = buf.append(sig.replace('.', this.target.syntheticNameChar()));
        return this.names.fromString(buf.toString());
    }

    private Symbol.VarSymbol cacheSym(int pos, String sig) {
        Symbol.ClassSymbol outerCacheClass = this.outerCacheClass();
        Name cname = this.cacheName(sig);
        Symbol.VarSymbol cacheSym = (Symbol.VarSymbol)this.lookupSynthetic(cname, outerCacheClass.members());
        if (cacheSym == null) {
            cacheSym = new Symbol.VarSymbol(4104L, cname, this.types.erasure(this.syms.classType), outerCacheClass);
            this.enterSynthetic(pos, cacheSym, outerCacheClass.members());
            Tree.VarDef cacheDef = this.make.VarDef(cacheSym, null);
            Tree.ClassDef outerCacheClassDef = this.classDef(outerCacheClass);
            outerCacheClassDef.defs = outerCacheClassDef.defs.prepend(cacheDef);
        }
        return cacheSym;
    }

    private Tree classOf(Tree clazz) {
        return this.classOfType(clazz.type, clazz.pos);
    }

    private Tree classOfType(Type type, int pos) {
        switch (type.tag) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                Symbol.ClassSymbol c = this.types.boxedClass(type);
                Symbol typeSym = this.rs.access(this.rs.findIdentInType(this.attrEnv, c.type, this.names.TYPE, 4), pos, c.type, this.names.TYPE, true);
                if (typeSym.kind == 4) {
                    this.attr.evalInit((Symbol.VarSymbol)typeSym);
                }
                return this.make.QualIdent(typeSym);
            }
            case 10: 
            case 11: {
                if (this.target.hasClassLiterals()) {
                    Symbol.VarSymbol sym = new Symbol.VarSymbol(25L, this.names._class, this.syms.classType, type.tsym);
                    return this.make.at(pos).Select(this.make.Type(type), sym);
                }
                String sig = this.writer.xClassName(type).toString().replace('/', '.');
                Symbol.VarSymbol cs = this.cacheSym(pos, sig);
                return this.make.at(pos).Conditional(this.makeBinary(60, this.make.Ident(cs), this.make.Ident(this.syms.nullConst)), this.make.Assign(this.make.Ident(cs), this.make.App(this.make.Ident(this.classDollarSym(pos)), List.make(this.make.Literal(10, sig).setType(this.syms.stringType)))).setType(this.types.erasure(this.syms.classType)), this.make.Ident(cs)).setType(this.types.erasure(this.syms.classType));
            }
        }
        throw new AssertionError();
    }

    private Tree assertFlagTest(int pos) {
        Symbol.ClassSymbol outermostClass = this.outermostClassDef.sym;
        Symbol.ClassSymbol container = this.currentClass;
        Symbol.VarSymbol assertDisabledSym = (Symbol.VarSymbol)this.lookupSynthetic(this.dollarAssertionsDisabled, container.members());
        if (assertDisabledSym == null) {
            assertDisabledSym = new Symbol.VarSymbol(4120L, this.dollarAssertionsDisabled, this.syms.booleanType, container);
            this.enterSynthetic(pos, assertDisabledSym, container.members());
            Symbol.MethodSymbol desiredAssertionStatusSym = this.lookupMethod(pos, this.names.desiredAssertionStatus, this.types.erasure(this.syms.classType), Type.emptyList);
            Tree.ClassDef containerDef = this.classDef(container);
            this.make.at(containerDef.pos);
            Tree notStatus = this.makeUnary(48, this.make.App(this.make.Select(this.classOfType(this.types.erasure(outermostClass.type), containerDef.pos), desiredAssertionStatusSym), Tree.emptyList));
            Tree.VarDef assertDisabledDef = this.make.VarDef(assertDisabledSym, notStatus);
            containerDef.defs = containerDef.defs.prepend(assertDisabledDef);
        }
        this.make.at(pos);
        return this.makeUnary(48, this.make.Ident(assertDisabledSym));
    }

    Tree abstractRval(Tree rval, Type type, TreeBuilder builder) {
        rval = TreeInfo.skipParens(rval);
        switch (rval.tag) {
            case 36: {
                return builder.build(rval);
            }
            case 35: {
                Tree.Ident id = (Tree.Ident)rval;
                if ((id.sym.flags() & 0x10L) == 0L || id.sym.owner.kind != 16) break;
                return builder.build(rval);
            }
        }
        Symbol.VarSymbol var = new Symbol.VarSymbol(4112L, Name.fromString(this.names, this.target.syntheticNameChar() + "" + rval.hashCode()), type, this.currentMethodSym);
        Tree.VarDef def = this.make.VarDef(var, rval);
        Tree built = builder.build(this.make.Ident(var));
        Tree.LetExpr res = this.make.LetExpr(def, built);
        res.type = built.type;
        return res;
    }

    Tree abstractRval(Tree rval, TreeBuilder builder) {
        return this.abstractRval(rval, rval.type, builder);
    }

    Tree abstractLval(Tree lval, final TreeBuilder builder) {
        lval = TreeInfo.skipParens(lval);
        switch (lval.tag) {
            case 35: {
                return builder.build(lval);
            }
            case 34: {
                final Tree.Select s = (Tree.Select)lval;
                Tree selected = TreeInfo.skipParens(s.selected);
                Symbol lid = TreeInfo.symbol(s.selected);
                if (lid != null && lid.kind == 2) {
                    return builder.build(lval);
                }
                return this.abstractRval(s.selected, new TreeBuilder(){

                    public Tree build(Tree selected) {
                        return builder.build(Lower.this.make.Select(selected, s.sym));
                    }
                });
            }
            case 33: {
                final Tree.Indexed i = (Tree.Indexed)lval;
                return this.abstractRval(i.indexed, new TreeBuilder(){

                    public Tree build(final Tree indexed) {
                        return Lower.this.abstractRval(i.index, ((Lower)Lower.this).syms.intType, new TreeBuilder(){

                            public Tree build(Tree index) {
                                Tree.Indexed newLval = Lower.this.make.Indexed(indexed, index);
                                newLval.setType(i.type);
                                return builder.build(newLval);
                            }
                        });
                    }
                });
            }
        }
        throw new AssertionError(lval);
    }

    Tree makeComma(Tree expr1, final Tree expr2) {
        return this.abstractRval(expr1, new TreeBuilder(){

            public Tree build(Tree discarded) {
                return expr2;
            }
        });
    }

    @Override
    public Tree translate(Tree tree) {
        Integer endPos;
        if (tree == null) {
            return null;
        }
        this.make.at(tree.pos);
        tree.accept(this);
        if (this.endPositions != null && this.result != tree && (endPos = this.endPositions.remove(tree)) != null) {
            this.endPositions.put(this.result, endPos);
        }
        return this.result;
    }

    public Tree translate(Tree tree, Type type) {
        return tree == null ? null : this.boxIfNeeded(this.translate(tree), type);
    }

    public Tree translate(Tree tree, Tree enclOp) {
        Tree prevEnclOp = this.enclOp;
        this.enclOp = enclOp;
        Tree res = this.translate(tree);
        this.enclOp = prevEnclOp;
        return res;
    }

    public List<Tree> translate(List<Tree> trees, Tree enclOp) {
        Tree prevEnclOp = this.enclOp;
        this.enclOp = enclOp;
        List<Tree> res = this.translate(trees);
        this.enclOp = prevEnclOp;
        return res;
    }

    public List<Tree> translate(List<Tree> trees, Type type) {
        if (trees == null) {
            return null;
        }
        List<Tree> l = trees;
        while (l.nonEmpty()) {
            l.head = this.translate((Tree)l.head, type);
            l = l.tail;
        }
        return trees;
    }

    @Override
    public void visitTopLevel(Tree.TopLevel tree) {
        if (tree.packageAnnotations.nonEmpty()) {
            Name name = this.names.fromString("package-info");
            long flags = 4608L;
            Tree.ClassDef packageAnnotationsClass = this.make.ClassDef(this.make.Modifiers(flags, tree.packageAnnotations), name, Tree.TypeParameter.emptyList, null, Tree.emptyList, Tree.emptyList);
            Symbol.ClassSymbol c = this.reader.defineClass(name, tree.packge);
            c.flatname = this.names.fromString(tree.packge + "." + name);
            c.sourcefile = tree.sourcefile;
            c.completer = null;
            c.members_field = new Scope(c);
            c.flags_field = flags;
            c.attributes_field = tree.packge.attributes_field;
            tree.packge.attributes_field = Attribute.Compound.emptyList;
            Type.ClassType ctype = (Type.ClassType)c.type;
            ctype.supertype_field = this.syms.objectType;
            ctype.interfaces_field = Type.emptyList;
            packageAnnotationsClass.sym = c;
            this.translated.append(packageAnnotationsClass);
        }
    }

    @Override
    public void visitClassDef(Tree.ClassDef tree) {
        Symbol.ClassSymbol currentClassPrev = this.currentClass;
        Symbol.MethodSymbol currentMethodSymPrev = this.currentMethodSym;
        this.currentClass = tree.sym;
        this.currentMethodSym = null;
        this.classdefs.put(this.currentClass, tree);
        this.proxies = this.proxies.dup(this.currentClass);
        List<Symbol.VarSymbol> prevOuterThisStack = this.outerThisStack;
        if ((tree.mods.flags & 0x4000L) != 0L && (this.types.supertype((Type)this.currentClass.type).tsym.flags() & 0x4000L) == 0L) {
            this.visitEnumDef(tree);
        }
        Tree.VarDef otdef = null;
        if (this.currentClass.hasOuterInstance()) {
            otdef = this.outerThisDef(tree.pos, this.currentClass);
        }
        List<Tree.VarDef> fvdefs = this.freevarDefs(tree.pos, this.freevars(this.currentClass), this.currentClass);
        tree.extending = this.translate(tree.extending);
        tree.implementing = this.translate(tree.implementing);
        List<Tree> seen = Tree.emptyList;
        while (tree.defs != seen) {
            List<Tree> unseen;
            List<Tree> l = unseen = tree.defs;
            while (l.nonEmpty() && l != seen) {
                Tree outermostMemberDefPrev = this.outermostMemberDef;
                if (outermostMemberDefPrev == null) {
                    this.outermostMemberDef = (Tree)l.head;
                }
                l.head = this.translate((Tree)l.head);
                this.outermostMemberDef = outermostMemberDefPrev;
                l = l.tail;
            }
            seen = unseen;
        }
        if ((tree.mods.flags & 4L) != 0L) {
            tree.mods.flags |= 1L;
        }
        tree.mods.flags &= 0x6E11L;
        tree.name = Convert.shortName(this.currentClass.flatName());
        List<Tree.VarDef> l = fvdefs;
        while (l.nonEmpty()) {
            tree.defs = tree.defs.prepend((Tree)l.head);
            this.enterSynthetic(tree.pos, ((Tree.VarDef)l.head).sym, this.currentClass.members());
            l = l.tail;
        }
        if (this.currentClass.hasOuterInstance()) {
            tree.defs = tree.defs.prepend(otdef);
            this.enterSynthetic(tree.pos, otdef.sym, this.currentClass.members());
        }
        this.proxies = this.proxies.leave();
        this.outerThisStack = prevOuterThisStack;
        this.translated.append(tree);
        this.currentClass = currentClassPrev;
        this.currentMethodSym = currentMethodSymPrev;
        this.result = this.make.at(tree.pos).Block(0L, Tree.emptyList);
    }

    private void visitEnumDef(Tree.ClassDef tree) {
        this.make.at(tree.pos);
        if (tree.extending == null) {
            tree.extending = this.make.Type(this.types.supertype(tree.type));
        }
        int nextOrdinal = 0;
        ListBuffer<Tree> values = new ListBuffer<Tree>();
        ListBuffer<Tree> enumDefs = new ListBuffer<Tree>();
        ListBuffer otherDefs = new ListBuffer();
        List<Tree> defs = tree.defs;
        while (defs.nonEmpty()) {
            if (((Tree)defs.head).tag == 5 && (((Tree.VarDef)defs.head).mods.flags & 0x4000L) != 0L) {
                Tree.VarDef var = (Tree.VarDef)defs.head;
                this.visitEnumConstantDef(var, nextOrdinal++);
                values.append(this.make.QualIdent(var.sym));
                enumDefs.append(var);
            } else {
                otherDefs.append(defs.head);
            }
            defs = defs.tail;
        }
        Name valuesName = this.names.fromString(this.target.syntheticNameChar() + "VALUES");
        while (tree.sym.members().lookup((Name)valuesName).scope != null) {
            valuesName = this.names.fromString(valuesName + "" + this.target.syntheticNameChar());
        }
        Type.ArrayType arrayType = new Type.ArrayType(this.types.erasure(tree.type), (Symbol.TypeSymbol)this.syms.arrayClass);
        Symbol.VarSymbol valuesVar = new Symbol.VarSymbol(4122L, valuesName, arrayType, tree.type.tsym);
        Tree.NewArray newArray = this.make.NewArray(this.make.Type(this.types.erasure(tree.type)), Tree.emptyList, values.toList());
        newArray.type = arrayType;
        enumDefs.append(this.make.VarDef(valuesVar, newArray));
        tree.sym.members().enter(valuesVar);
        Symbol.MethodSymbol valuesSym = this.lookupMethod(tree.pos, this.names.values, tree.type, Type.emptyList);
        Tree.TypeCast valuesResult = this.make.TypeCast(valuesSym.type.restype(), this.make.App(this.make.Select(this.make.Ident(valuesVar), this.syms.arrayCloneMethod), Tree.emptyList));
        Tree.MethodDef valuesDef = this.make.MethodDef(valuesSym, this.make.Block(0L, Tree.emptyList.prepend(this.make.Return(valuesResult))));
        enumDefs.append(valuesDef);
        Symbol.MethodSymbol valueOfSym = this.lookupMethod(tree.pos, this.names.valueOf, tree.sym.type, Type.emptyList.prepend(this.syms.stringType));
        assert ((valueOfSym.flags() & 8L) != 0L);
        Symbol.VarSymbol nameArgSym = (Symbol.VarSymbol)valueOfSym.params.head;
        Tree.Ident nameVal = (Tree.Ident)this.make.Ident(nameArgSym);
        Symbol.VarSymbol eSym = new Symbol.VarSymbol(4112L, this.names.fromString(this.target.syntheticNameChar() + "E"), tree.type, valueOfSym);
        Tree.Return returnE = this.make.Return(this.make.Ident(eSym));
        Tree eName = this.makeCall(this.make.Ident(eSym), this.names._name, Tree.emptyList);
        Tree condition = this.makeCall(eName, this.names.fromString("equals"), Tree.emptyList.prepend(nameVal));
        Tree.If ifStmt = this.make.If(condition, returnE, null);
        Tree.ForeachLoop foreachLoop = this.make.ForeachLoop(this.make.VarDef(eSym, null), this.make.Ident(valuesVar), ifStmt);
        Tree.NewClass newclass = this.make.NewClass(null, null, this.make.Ident(this.syms.illegalArgumentExceptionType.tsym), Tree.emptyList.prepend(nameVal), null);
        newclass.type = this.syms.illegalArgumentExceptionType;
        newclass.constructor = this.lookupMethod(tree.pos, this.names.init, this.syms.illegalArgumentExceptionType, Type.emptyList.prepend(this.syms.stringType));
        Tree.Throw throwStatement = this.make.Throw(newclass);
        Tree.MethodDef valueOf = this.make.MethodDef(valueOfSym, this.make.Block(0L, Tree.emptyList.prepend(throwStatement).prepend(foreachLoop)));
        nameVal.sym = ((Tree.VarDef)valueOf.params.head).sym;
        enumDefs.append(valueOf);
        enumDefs.appendList(otherDefs.toList());
        tree.defs = enumDefs.toList();
        if (this.target.compilerBootstrap(tree.sym)) {
            this.addEnumCompatibleMembers(tree);
        }
    }

    private void visitEnumConstantDef(Tree.VarDef var, int ordinal) {
        Tree.NewClass varDef = (Tree.NewClass)var.init;
        varDef.args = varDef.args.prepend(this.makeLit(this.syms.intType, ordinal)).prepend(this.makeLit(this.syms.stringType, var.name.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitMethodDef(Tree.MethodDef tree) {
        if (tree.name == this.names.init && (this.currentClass.flags_field & 0x4000L) != 0L) {
            Tree.VarDef nameParam = this.make.at(tree.pos).Param(this.names.fromString(this.target.syntheticNameChar() + "enum" + this.target.syntheticNameChar() + "name"), this.syms.stringType, tree.sym);
            nameParam.mods.flags |= 0x1000L;
            nameParam.sym.flags_field |= 0x1000L;
            Tree.VarDef ordParam = this.make.Param(this.names.fromString(this.target.syntheticNameChar() + "enum" + this.target.syntheticNameChar() + "ordinal"), this.syms.intType, tree.sym);
            ordParam.mods.flags |= 0x1000L;
            ordParam.sym.flags_field |= 0x1000L;
            tree.params = tree.params.prepend(ordParam).prepend(nameParam);
            Symbol.MethodSymbol m = tree.sym;
            Type olderasure = m.erasure(this.types);
            m.erasure_field = new Type.MethodType(olderasure.argtypes().prepend(this.syms.intType).prepend(this.syms.stringType), olderasure.restype(), olderasure.thrown(), this.syms.methodClass);
            if (this.target.compilerBootstrap(m.owner)) {
                Symbol nameVarSym = this.lookupSynthetic(this.names.fromString("$name"), tree.sym.owner.members());
                Tree nameIdent = this.make.Ident(nameParam.sym);
                Tree id1 = this.make.Ident(nameVarSym);
                Tree.Assign newAssign = this.make.Assign(id1, nameIdent);
                newAssign.type = id1.type;
                Tree.Exec nameAssign = this.make.Exec(newAssign);
                nameAssign.type = id1.type;
                tree.body.stats = tree.body.stats.prepend(nameAssign);
                Symbol ordinalVarSym = this.lookupSynthetic(this.names.fromString("$ordinal"), tree.sym.owner.members());
                Tree ordIdent = this.make.Ident(ordParam.sym);
                id1 = this.make.Ident(ordinalVarSym);
                newAssign = this.make.Assign(id1, ordIdent);
                newAssign.type = id1.type;
                Tree.Exec ordinalAssign = this.make.Exec(newAssign);
                ordinalAssign.type = id1.type;
                tree.body.stats = tree.body.stats.prepend(ordinalAssign);
            }
        }
        Tree.MethodDef prevMethodDef = this.currentMethodDef;
        Symbol.MethodSymbol prevMethodSym = this.currentMethodSym;
        try {
            this.currentMethodDef = tree;
            this.currentMethodSym = tree.sym;
            this.visitMethodDefInternal(tree);
        }
        finally {
            this.currentMethodDef = prevMethodDef;
            this.currentMethodSym = prevMethodSym;
        }
    }

    private void visitMethodDefInternal(Tree.MethodDef tree) {
        if (tree.name == this.names.init && (this.currentClass.isInner() || (this.currentClass.owner.kind & 0x14) != 0)) {
            Symbol.MethodSymbol m = tree.sym;
            this.proxies = this.proxies.dup(m);
            List<Symbol.VarSymbol> prevOuterThisStack = this.outerThisStack;
            List<Symbol.VarSymbol> fvs = this.freevars(this.currentClass);
            Tree.VarDef otdef = null;
            if (this.currentClass.hasOuterInstance()) {
                otdef = this.outerThisDef(tree.pos, m);
            }
            List<Tree.VarDef> fvdefs = this.freevarDefs(tree.pos, fvs, m);
            tree.restype = this.translate(tree.restype);
            tree.params = this.translateVarDefs(tree.params);
            tree.thrown = this.translate(tree.thrown);
            if (tree.body == null) {
                this.result = tree;
                return;
            }
            tree.params = tree.params.appendList(fvdefs);
            if (this.currentClass.hasOuterInstance()) {
                tree.params = tree.params.prepend(otdef);
            }
            Tree selfCall = this.translate((Tree)tree.body.stats.head);
            List<Tree> added = Tree.emptyList;
            if (fvs.nonEmpty()) {
                List<Type> addedargtypes = List.make();
                List<Symbol.VarSymbol> l = fvs;
                while (l.nonEmpty()) {
                    if (TreeInfo.isInitialConstructor(tree)) {
                        added = added.prepend(this.initField(tree.body.pos, this.proxyName(((Symbol.VarSymbol)l.head).name)));
                    }
                    addedargtypes = addedargtypes.prepend(((Symbol.VarSymbol)l.head).erasure(this.types));
                    l = l.tail;
                }
                Type olderasure = m.erasure(this.types);
                m.erasure_field = new Type.MethodType(olderasure.argtypes().appendList(addedargtypes), olderasure.restype(), olderasure.thrown(), this.syms.methodClass);
            }
            if (this.currentClass.hasOuterInstance() && TreeInfo.isInitialConstructor(tree)) {
                added = added.prepend(this.initOuterThis(tree.body.pos));
            }
            this.proxies = this.proxies.leave();
            List<Tree> stats = this.translate(tree.body.stats.tail);
            tree.body.stats = this.target.initializeFieldsBeforeSuper() ? stats.prepend(selfCall).prependList(added) : stats.prependList(added).prepend(selfCall);
            this.outerThisStack = prevOuterThisStack;
        } else {
            super.visitMethodDef(tree);
        }
        this.result = tree;
    }

    @Override
    public void visitTypeCast(Tree.TypeCast tree) {
        tree.clazz = this.translate(tree.clazz);
        tree.expr = tree.type.isPrimitive() != tree.expr.type.isPrimitive() ? this.translate(tree.expr, tree.type) : this.translate(tree.expr);
        this.result = tree;
    }

    @Override
    public void visitNewClass(Tree.NewClass tree) {
        Symbol constructor;
        Symbol.ClassSymbol c = (Symbol.ClassSymbol)tree.constructor.owner;
        boolean isEnum = (tree.constructor.owner.flags() & 0x4000L) != 0L;
        List<Type> argTypes = tree.constructor.type.argtypes();
        if (isEnum) {
            argTypes = argTypes.prepend(this.syms.intType).prepend(this.syms.stringType);
        }
        tree.args = this.boxArgs(argTypes, tree.args, tree.varargsElement);
        tree.varargsElement = null;
        if ((c.owner.kind & 0x14) != 0) {
            tree.args = tree.args.appendList(this.loadFreevars(tree.pos, this.freevars(c)));
        }
        if ((constructor = this.accessConstructor(tree.pos, tree.constructor)) != tree.constructor) {
            tree.args = tree.args.append(this.make.Ident(this.syms.nullConst));
            tree.constructor = constructor;
        }
        if (c.hasOuterInstance()) {
            Tree thisArg;
            if (tree.encl != null) {
                thisArg = this.attr.makeNullCheck(this.translate(tree.encl));
                thisArg.type = tree.encl.type;
            } else {
                thisArg = (c.owner.kind & 0x14) != 0 ? this.makeThis(tree.pos, c.type.outer().tsym) : this.makeOwnerThis(tree.pos, c, false);
            }
            tree.args = tree.args.prepend(thisArg);
        }
        tree.encl = null;
        if (tree.def != null) {
            this.translate(tree.def);
            tree.clazz = this.access(this.make.at(tree.clazz.pos).Ident(tree.def.sym));
            tree.def = null;
        } else {
            tree.clazz = this.access(c, tree.clazz, this.enclOp, false);
        }
        this.result = tree;
    }

    @Override
    public void visitConditional(Tree.Conditional tree) {
        Tree cond = tree.cond = this.translate(tree.cond, this.syms.booleanType);
        if (cond.type.isTrue()) {
            this.result = this.convert(this.translate(tree.truepart, tree.type), tree.type);
        } else if (cond.type.isFalse()) {
            this.result = this.convert(this.translate(tree.falsepart, tree.type), tree.type);
        } else {
            tree.truepart = this.translate(tree.truepart, tree.type);
            tree.falsepart = this.translate(tree.falsepart, tree.type);
            this.result = tree;
        }
    }

    private Tree convert(Tree tree, Type pt) {
        if (tree.type == pt) {
            return tree;
        }
        Tree.TypeCast result = this.make.at(tree.pos).TypeCast(this.make.Type(pt), tree);
        result.type = tree.type.constValue != null ? this.cfolder.coerce(tree.type, pt) : pt;
        return result;
    }

    @Override
    public void visitIf(Tree.If tree) {
        Tree cond = tree.cond = this.translate(tree.cond, this.syms.booleanType);
        if (cond.type.isTrue()) {
            this.result = this.translate(tree.thenpart);
        } else if (cond.type.isFalse()) {
            this.result = tree.elsepart != null ? this.translate(tree.elsepart) : this.make.Skip();
        } else {
            tree.thenpart = this.translate(tree.thenpart);
            tree.elsepart = this.translate(tree.elsepart);
            this.result = tree;
        }
    }

    @Override
    public void visitAssert(Tree.Assert tree) {
        int detailPos = tree.detail == null ? tree.pos : tree.detail.pos;
        tree.cond = this.translate(tree.cond, this.syms.booleanType);
        if (!tree.cond.type.isTrue()) {
            List<Tree> exnArgs;
            Tree cond = this.assertFlagTest(tree.pos);
            List<Tree> list = exnArgs = tree.detail == null ? Tree.emptyList : List.make(this.translate(tree.detail));
            if (!tree.cond.type.isFalse()) {
                cond = this.makeBinary(56, cond, this.makeUnary(48, tree.cond));
            }
            this.result = this.make.If(cond, this.make.at(detailPos).Throw(this.makeNewClass(this.syms.assertionErrorType, exnArgs)), null);
        } else {
            this.result = this.make.Skip();
        }
    }

    @Override
    public void visitApply(Tree.Apply tree) {
        Symbol meth = TreeInfo.symbol(tree.meth);
        List<Type> argtypes = meth.type.argtypes();
        if (this.allowEnums && meth.name == this.names.init && meth.owner == this.syms.enumSym) {
            argtypes = argtypes.tail.tail;
        }
        tree.args = this.boxArgs(argtypes, tree.args, tree.varargsElement);
        tree.varargsElement = null;
        Name methName = TreeInfo.name(tree.meth);
        if (meth.name == this.names.init) {
            Symbol constructor = this.accessConstructor(tree.pos, meth);
            if (constructor != meth) {
                tree.args = tree.args.append(this.make.Ident(this.syms.nullConst));
                TreeInfo.setSymbol(tree.meth, constructor);
            }
            Symbol.ClassSymbol c = constructor.owner.type.tag == 10 ? (Symbol.ClassSymbol)constructor.owner : (Symbol.ClassSymbol)this.types.erasure((Type)constructor.owner.type).tsym;
            if ((c.owner.kind & 0x14) != 0) {
                tree.args = tree.args.appendList(this.loadFreevars(tree.pos, this.freevars(c)));
            }
            if ((c.flags_field & 0x4000L) != 0L || c.fullName() == this.names.java_lang_Enum) {
                List<Tree.VarDef> params = this.currentMethodDef.params;
                if (this.currentMethodSym.owner.hasOuterInstance()) {
                    params = params.tail;
                }
                tree.args = tree.args.prepend(this.make.at(tree.pos).Ident(((Tree.VarDef)params.tail.head).sym)).prepend(this.make.Ident(((Tree.VarDef)params.head).sym));
            }
            if (c.hasOuterInstance()) {
                Tree thisArg;
                if (tree.meth.tag == 34) {
                    thisArg = this.attr.makeNullCheck(this.translate(((Tree.Select)tree.meth).selected));
                    tree.meth = this.make.Ident(constructor);
                    ((Tree.Ident)tree.meth).name = methName;
                } else {
                    thisArg = (c.owner.kind & 0x14) != 0 || methName == this.names._this ? this.makeThis(tree.meth.pos, c.type.outer().tsym) : this.makeOwnerThis(tree.meth.pos, c, false);
                }
                tree.args = tree.args.prepend(thisArg);
            }
        } else {
            tree.meth = this.translate(tree.meth);
            if (tree.meth.tag == 26) {
                Tree.Apply app = (Tree.Apply)tree.meth;
                app.args = tree.args.prependList(app.args);
                this.result = app;
                return;
            }
        }
        this.result = tree;
    }

    List<Tree> boxArgs(List<Type> parameters, List<Tree> _args, Type varargsElement) {
        List<Tree> args = _args;
        if (parameters.isEmpty()) {
            return args;
        }
        boolean anyChanges = false;
        ListBuffer<Tree> result = new ListBuffer<Tree>();
        while (parameters.tail.nonEmpty()) {
            Tree arg = this.translate((Tree)args.head, (Type)parameters.head);
            anyChanges |= arg != args.head;
            result.append(arg);
            args = args.tail;
            parameters = parameters.tail;
        }
        Type parameter = (Type)parameters.head;
        if (varargsElement != null) {
            anyChanges = true;
            ListBuffer<Tree> elems = new ListBuffer<Tree>();
            while (args.nonEmpty()) {
                Tree arg = this.translate((Tree)args.head, varargsElement);
                elems.append(arg);
                args = args.tail;
            }
            Tree.NewArray boxedArgs = this.make.NewArray(this.make.Type(varargsElement), Tree.emptyList, elems.toList());
            boxedArgs.type = new Type.ArrayType(varargsElement, (Symbol.TypeSymbol)this.syms.arrayClass);
            result.append(boxedArgs);
        } else {
            if (args.length() != 1) {
                throw new AssertionError(args);
            }
            Tree arg = this.translate((Tree)args.head, parameter);
            boolean bl = arg != args.head;
            result.append(arg);
            if (!(anyChanges |= bl)) {
                return _args;
            }
        }
        return result.toList();
    }

    Tree boxIfNeeded(Tree tree, Type type) {
        boolean havePrimitive = tree.type.isPrimitive();
        if (havePrimitive == type.isPrimitive()) {
            return tree;
        }
        if (havePrimitive) {
            Type unboxedTarget = this.types.unboxedType(type);
            if (unboxedTarget.tag != 18) {
                if (!this.types.isSubType(tree.type, unboxedTarget)) {
                    tree.type = unboxedTarget;
                }
                return this.boxPrimitive(tree, type);
            }
            tree = this.boxPrimitive(tree);
        } else {
            tree = this.unbox(tree, type);
        }
        return tree;
    }

    Tree boxPrimitive(Tree tree) {
        return this.boxPrimitive(tree, this.types.boxedClass((Type)tree.type).type);
    }

    Tree boxPrimitive(Tree tree, Type box) {
        this.make.at(tree.pos);
        if (this.target.boxWithConstructors()) {
            Symbol.MethodSymbol ctor = this.lookupConstructor(tree.pos, box, Type.emptyList.prepend(tree.type));
            return this.make.Create(ctor, List.make(tree));
        }
        Symbol.MethodSymbol valueOfSym = this.lookupMethod(tree.pos, this.names.valueOf, box, Type.emptyList.prepend(tree.type));
        return this.make.App(this.make.QualIdent(valueOfSym), List.make(tree));
    }

    Tree unbox(Tree tree, Type primitive) {
        Type unboxedType = this.types.unboxedType(tree.type);
        this.make.at(tree.pos);
        Symbol.MethodSymbol valueSym = this.lookupMethod(tree.pos, unboxedType.tsym.name.append(this.names.Value), tree.type, Type.emptyList);
        return this.make.App(this.make.Select(tree, valueSym), Tree.emptyList);
    }

    @Override
    public void visitParens(Tree.Parens tree) {
        Tree expr = this.translate(tree.expr);
        this.result = expr == tree.expr ? tree : expr;
    }

    @Override
    public void visitIndexed(Tree.Indexed tree) {
        tree.indexed = this.translate(tree.indexed);
        tree.index = this.translate(tree.index, this.syms.intType);
        this.result = tree;
    }

    @Override
    public void visitAssign(Tree.Assign tree) {
        tree.lhs = this.translate(tree.lhs, (Tree)tree);
        tree.rhs = this.translate(tree.rhs, tree.lhs.type);
        if (tree.lhs.tag == 26) {
            Tree.Apply app = (Tree.Apply)tree.lhs;
            app.args = List.make(tree.rhs).prependList(app.args);
            this.result = app;
        } else {
            this.result = tree;
        }
    }

    @Override
    public void visitAssignop(final Tree.Assignop tree) {
        if (!tree.lhs.type.isPrimitive() && tree.operator.type.restype().isPrimitive()) {
            Tree newTree = this.abstractLval(tree.lhs, new TreeBuilder(){

                public Tree build(Tree lhs) {
                    int newTag = tree.tag - 17;
                    Symbol newOperator = Lower.this.rs.resolveBinaryOperator(tree.pos, newTag, Lower.this.attrEnv, tree.lhs.type, tree.rhs.type);
                    Tree.Binary opResult = Lower.this.make.Binary(newTag, lhs, tree.rhs);
                    opResult.operator = newOperator;
                    opResult.type = newOperator.type.restype();
                    Tree.TypeCast newRhs = Lower.this.make.TypeCast(Lower.this.types.unboxedType(lhs.type), (Tree)opResult);
                    return Lower.this.make.Assign(lhs, newRhs).setType(tree.type);
                }
            });
            this.result = this.translate(newTree);
            return;
        }
        tree.lhs = this.translate(tree.lhs, (Tree)tree);
        tree.rhs = this.translate(tree.rhs, (Type)tree.operator.type.argtypes().tail.head);
        if (tree.lhs.tag == 26) {
            Tree.Apply app = (Tree.Apply)tree.lhs;
            Tree rhs = ((Symbol.OperatorSymbol)tree.operator).opcode == 256 ? this.makeString(tree.rhs) : tree.rhs;
            app.args = List.make(rhs).prependList(app.args);
            this.result = app;
        } else {
            this.result = tree;
        }
    }

    Tree lowerBoxedPostop(final Tree.Unary tree) {
        return this.abstractLval(tree.arg, new TreeBuilder(){

            public Tree build(final Tree tmp1) {
                return Lower.this.abstractRval(tmp1, new TreeBuilder(){

                    public Tree build(Tree tmp2) {
                        int opcode = tree.tag == 52 ? 86 : 87;
                        Tree.Assignop update = Lower.this.makeAssignop(opcode, tmp1, Lower.this.make.Literal(1));
                        return Lower.this.makeComma(update, tmp2);
                    }
                });
            }
        });
    }

    @Override
    public void visitUnary(Tree.Unary tree) {
        boolean isUpdateOperator;
        boolean bl = isUpdateOperator = 50 <= tree.tag && tree.tag <= 53;
        if (isUpdateOperator && !tree.arg.type.isPrimitive()) {
            switch (tree.tag) {
                case 50: 
                case 51: {
                    int opcode = tree.tag == 50 ? 86 : 87;
                    Tree.Assignop newTree = this.makeAssignop(opcode, tree.arg, this.make.Literal(1));
                    this.result = this.translate((Tree)newTree, tree.type);
                    return;
                }
                case 52: 
                case 53: {
                    this.result = this.translate(this.lowerBoxedPostop(tree), tree.type);
                    return;
                }
            }
            throw new AssertionError(tree);
        }
        tree.arg = this.boxIfNeeded(this.translate(tree.arg, (Tree)tree), tree.type);
        if (tree.tag == 48 && tree.arg.type.constValue != null) {
            tree.type = this.cfolder.fold1(257, tree.arg.type);
        }
        this.result = isUpdateOperator && tree.arg.tag == 26 ? tree.arg : tree;
    }

    @Override
    public void visitBinary(Tree.Binary tree) {
        List<Type> formals = tree.operator.type.argtypes();
        Tree lhs = tree.lhs = this.translate(tree.lhs, (Type)formals.head);
        switch (tree.tag) {
            case 55: {
                if (lhs.type.isTrue()) {
                    this.result = lhs;
                    return;
                }
                if (!lhs.type.isFalse()) break;
                this.result = this.translate(tree.rhs, (Type)formals.tail.head);
                return;
            }
            case 56: {
                if (lhs.type.isFalse()) {
                    this.result = lhs;
                    return;
                }
                if (!lhs.type.isTrue()) break;
                this.result = this.translate(tree.rhs, (Type)formals.tail.head);
                return;
            }
        }
        tree.rhs = this.translate(tree.rhs, (Type)formals.tail.head);
        this.result = tree;
    }

    @Override
    public void visitIdent(Tree.Ident tree) {
        this.result = this.access(tree.sym, tree, this.enclOp, false);
    }

    @Override
    public void visitForeachLoop(Tree.ForeachLoop tree) {
        if (this.types.elemtype(tree.expr.type) == null) {
            this.visitIterableForeachLoop(tree);
        } else {
            this.visitArrayForeachLoop(tree);
        }
    }

    private void visitArrayForeachLoop(Tree.ForeachLoop tree) {
        this.make.at(tree.expr.pos);
        Symbol.VarSymbol arraycache = new Symbol.VarSymbol(0L, this.names.fromString("arr" + this.target.syntheticNameChar()), tree.expr.type, this.currentMethodSym);
        Tree.VarDef arraycachedef = this.make.VarDef(arraycache, tree.expr);
        Symbol.VarSymbol lencache = new Symbol.VarSymbol(0L, this.names.fromString("len" + this.target.syntheticNameChar()), this.syms.intType, this.currentMethodSym);
        Tree.VarDef lencachedef = this.make.VarDef(lencache, this.make.Select(this.make.Ident(arraycache), this.syms.lengthVar));
        Symbol.VarSymbol index = new Symbol.VarSymbol(0L, this.names.fromString("i" + this.target.syntheticNameChar()), this.syms.intType, this.currentMethodSym);
        Tree.VarDef indexdef = this.make.VarDef(index, this.make.Literal(4, 0));
        indexdef.init.type = indexdef.type = this.syms.intType.constType(0);
        List<Tree> loopinit = List.make().prepend(indexdef).prepend(lencachedef).prepend(arraycachedef);
        Tree.Binary cond = this.makeBinary(62, this.make.Ident(index), this.make.Ident(lencache));
        Tree.Exec step = this.make.Exec(this.makeUnary(50, this.make.Ident(index)));
        Type elemtype = this.types.elemtype(tree.expr.type);
        Tree.VarDef loopvarinit = this.make.VarDef(tree.var.sym, this.make.Indexed(this.make.Ident(arraycache), this.make.Ident(index)).setType(elemtype));
        Tree.Block body = this.make.Block(0L, List.make().prepend(tree.body).prepend(loopvarinit));
        this.result = this.translate(this.make.ForLoop(loopinit, cond, List.make().prepend(step), body));
        this.patchTargets(body, tree, this.result);
    }

    private void patchTargets(Tree body, final Tree src, final Tree dest) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Patcher
        extends TreeScanner {
            Patcher() {
            }

            @Override
            public void visitBreak(Tree.Break tree) {
                if (tree.target == src) {
                    tree.target = dest;
                }
            }

            @Override
            public void visitContinue(Tree.Continue tree) {
                if (tree.target == src) {
                    tree.target = dest;
                }
            }

            @Override
            public void visitClassDef(Tree.ClassDef tree) {
            }
        }
        new Patcher().scan(body);
    }

    private void visitIterableForeachLoop(Tree.ForeachLoop tree) {
        this.make.at(tree.expr.pos);
        Type iteratorTarget = this.syms.objectType;
        Type iterableType = this.types.asSuper(this.types.upperBound(tree.expr.type), this.syms.iterableType.tsym);
        if (iterableType.typarams().nonEmpty()) {
            iteratorTarget = this.types.erasure((Type)iterableType.typarams().head);
        }
        Type eType = tree.expr.type;
        tree.expr.type = this.types.erasure(eType);
        if (eType.tag == 14 && eType.bound().isCompound()) {
            tree.expr = this.make.TypeCast(this.types.erasure(iterableType), tree.expr);
        }
        Symbol.MethodSymbol iterator = this.lookupMethod(tree.expr.pos, this.names.iterator, this.types.erasure(this.syms.iterableType), Type.emptyList);
        Symbol.VarSymbol itvar = new Symbol.VarSymbol(0L, this.names.fromString("i" + this.target.syntheticNameChar()), this.types.erasure(iterator.type.restype()), this.currentMethodSym);
        Tree.VarDef itvardef = this.make.VarDef(itvar, this.make.App(this.make.Select(tree.expr, iterator), Tree.emptyList));
        List<Tree> loopinit = Tree.emptyList.prepend(itvardef);
        Symbol.MethodSymbol hasNext = this.lookupMethod(tree.expr.pos, this.names.hasNext, itvar.type, Type.emptyList);
        Tree cond = this.make.App(this.make.Select(this.make.Ident(itvar), hasNext), Tree.emptyList);
        Symbol.MethodSymbol next = this.lookupMethod(tree.expr.pos, this.names.next, itvar.type, Type.emptyList);
        Tree vardefinit = this.make.App(this.make.Select(this.make.Ident(itvar), next), Tree.emptyList);
        if (iteratorTarget != this.syms.objectType) {
            vardefinit = this.make.TypeCast(iteratorTarget, vardefinit);
        }
        Tree.VarDef indexDef = this.make.VarDef(tree.var.sym, vardefinit);
        Tree.Block body = this.make.Block(0L, Tree.emptyList.prepend(tree.body).prepend(indexDef));
        this.result = this.translate(this.make.ForLoop(loopinit, cond, Tree.emptyList, body));
        this.patchTargets(body, tree, this.result);
    }

    @Override
    public void visitVarDef(Tree.VarDef tree) {
        Symbol.MethodSymbol oldMethodSym = this.currentMethodSym;
        tree.mods = (Tree.Modifiers)this.translate(tree.mods);
        tree.vartype = this.translate(tree.vartype);
        if (this.currentMethodSym == null) {
            this.currentMethodSym = new Symbol.MethodSymbol(tree.mods.flags & 8L | 0x100000L, this.names.empty, null, this.currentClass);
        }
        if (tree.init != null) {
            tree.init = this.translate(tree.init, tree.type);
        }
        this.result = tree;
        this.currentMethodSym = oldMethodSym;
    }

    @Override
    public void visitBlock(Tree.Block tree) {
        Symbol.MethodSymbol oldMethodSym = this.currentMethodSym;
        if (this.currentMethodSym == null) {
            this.currentMethodSym = new Symbol.MethodSymbol(tree.flags | 0x100000L, this.names.empty, null, this.currentClass);
        }
        super.visitBlock(tree);
        this.currentMethodSym = oldMethodSym;
    }

    @Override
    public void visitDoLoop(Tree.DoLoop tree) {
        tree.body = this.translate(tree.body);
        tree.cond = this.translate(tree.cond, this.syms.booleanType);
        this.result = tree;
    }

    @Override
    public void visitWhileLoop(Tree.WhileLoop tree) {
        tree.cond = this.translate(tree.cond, this.syms.booleanType);
        tree.body = this.translate(tree.body);
        this.result = tree;
    }

    @Override
    public void visitForLoop(Tree.ForLoop tree) {
        tree.init = this.translate(tree.init);
        if (tree.cond != null) {
            tree.cond = this.translate(tree.cond, this.syms.booleanType);
        }
        tree.step = this.translate(tree.step);
        tree.body = this.translate(tree.body);
        this.result = tree;
    }

    @Override
    public void visitReturn(Tree.Return tree) {
        if (tree.expr != null) {
            tree.expr = this.translate(tree.expr, this.types.erasure(this.currentMethodDef.restype.type));
        }
        this.result = tree;
    }

    @Override
    public void visitSwitch(Tree.Switch tree) {
        Type selsuper = this.types.supertype(tree.selector.type);
        boolean enumSwitch = selsuper != null && (tree.selector.type.tsym.flags() & 0x4000L) != 0L;
        Type target = enumSwitch ? tree.selector.type : this.syms.intType;
        tree.selector = this.translate(tree.selector, target);
        tree.cases = this.translateCases(tree.cases);
        if (enumSwitch) {
            this.result = this.visitEnumSwitch(tree);
            this.patchTargets(this.result, tree, this.result);
        } else {
            this.result = tree;
        }
    }

    public Tree visitEnumSwitch(Tree.Switch tree) {
        Symbol.TypeSymbol enumSym = tree.selector.type.tsym;
        EnumMapping map = this.mapForEnum(tree.pos, enumSym);
        this.make.at(tree.pos);
        Symbol.MethodSymbol ordinalMethod = this.lookupMethod(tree.pos, this.names.ordinal, tree.selector.type, Type.emptyList);
        Tree.Indexed selector = this.make.Indexed(map.mapVar, this.make.App(this.make.Select(tree.selector, ordinalMethod), Tree.emptyList));
        ListBuffer<Tree.Case> cases = new ListBuffer<Tree.Case>();
        for (Tree.Case c : tree.cases) {
            if (c.pat != null) {
                Symbol.VarSymbol label = (Symbol.VarSymbol)TreeInfo.symbol(c.pat);
                Tree pat = map.forConstant(label);
                cases.append(this.make.Case(pat, c.stats));
                continue;
            }
            cases.append(c);
        }
        return this.make.Switch(selector, cases.toList());
    }

    @Override
    public void visitNewArray(Tree.NewArray tree) {
        tree.elemtype = this.translate(tree.elemtype);
        List<Tree> t = tree.dims;
        while (t.tail != null) {
            if (t.head != null) {
                t.head = this.translate((Tree)t.head, this.syms.intType);
            }
            t = t.tail;
        }
        tree.elems = this.translate(tree.elems, this.types.elemtype(tree.type));
        this.result = tree;
    }

    @Override
    public void visitSelect(Tree.Select tree) {
        boolean qualifiedSuperAccess = tree.selected.tag == 34 && TreeInfo.name(tree.selected) == this.names._super;
        tree.selected = this.translate(tree.selected);
        this.result = tree.name == this.names._class ? this.classOf(tree.selected) : (tree.name == this.names._this || tree.name == this.names._super ? this.makeThis(tree.pos, tree.selected.type.tsym) : this.access(tree.sym, tree, this.enclOp, qualifiedSuperAccess));
    }

    @Override
    public void visitLetExpr(Tree.LetExpr tree) {
        tree.defs = this.translateVarDefs(tree.defs);
        tree.expr = this.translate(tree.expr, tree.type);
        this.result = tree;
    }

    @Override
    public void visitAnnotation(Tree.Annotation tree) {
        this.result = tree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Tree> translateTopLevelClass(Env<AttrContext> env, Tree cdef, TreeMaker make) {
        ListBuffer<Tree> translated = null;
        try {
            this.attrEnv = env;
            this.make = make;
            this.endPositions = env.toplevel.endPositions;
            this.currentClass = null;
            this.currentMethodDef = null;
            this.outermostClassDef = cdef.tag == 3 ? (Tree.ClassDef)cdef : null;
            this.outermostMemberDef = null;
            this.translated = new ListBuffer();
            this.classdefs = new HashMap<Symbol.ClassSymbol, Tree.ClassDef>();
            this.actualSymbols = new HashMap<Symbol, Symbol>();
            this.freevarCache = new HashMap<Symbol.ClassSymbol, List<Symbol.VarSymbol>>();
            this.proxies = new Scope(this.syms.noSymbol);
            this.outerThisStack = Symbol.VarSymbol.emptyList;
            this.accessNums = new HashMap<Symbol, Integer>();
            this.accessSyms = new HashMap<Symbol, Symbol.MethodSymbol[]>();
            this.accessConstrs = new HashMap<Symbol, Symbol.MethodSymbol>();
            this.accessed = new ListBuffer();
            this.translate(cdef, (Tree)null);
            List<Symbol> l = this.accessed.toList();
            while (l.nonEmpty()) {
                this.makeAccessible((Symbol)l.head);
                l = l.tail;
            }
            for (EnumMapping map : this.enumSwitchMap.values()) {
                map.translate();
            }
            translated = this.translated;
            Object var8_7 = null;
            this.attrEnv = null;
            this.make = null;
            this.endPositions = null;
            this.currentClass = null;
            this.currentMethodDef = null;
            this.outermostClassDef = null;
            this.outermostMemberDef = null;
            this.translated = null;
            this.classdefs = null;
            this.actualSymbols = null;
            this.freevarCache = null;
            this.proxies = null;
            this.outerThisStack = null;
            this.accessNums = null;
            this.accessSyms = null;
            this.accessConstrs = null;
            this.accessed = null;
            this.enumSwitchMap.clear();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.attrEnv = null;
            this.make = null;
            this.endPositions = null;
            this.currentClass = null;
            this.currentMethodDef = null;
            this.outermostClassDef = null;
            this.outermostMemberDef = null;
            this.translated = null;
            this.classdefs = null;
            this.actualSymbols = null;
            this.freevarCache = null;
            this.proxies = null;
            this.outerThisStack = null;
            this.accessNums = null;
            this.accessSyms = null;
            this.accessConstrs = null;
            this.accessed = null;
            this.enumSwitchMap.clear();
            throw throwable;
        }
        return translated.toList();
    }

    private void addEnumCompatibleMembers(Tree.ClassDef cdef) {
        this.make.at(0);
        Symbol.VarSymbol ordinalFieldSym = this.addEnumOrdinalField(cdef);
        Symbol.VarSymbol nameFieldSym = this.addEnumNameField(cdef);
        Symbol.MethodSymbol ordinalMethodSym = this.addEnumFieldOrdinalMethod(cdef, ordinalFieldSym);
        Symbol.MethodSymbol nameMethodSym = this.addEnumFieldNameMethod(cdef, nameFieldSym);
        this.addEnumToString(cdef, nameFieldSym);
        this.addEnumCompareTo(cdef, ordinalFieldSym);
    }

    private Symbol.VarSymbol addEnumOrdinalField(Tree.ClassDef cdef) {
        Symbol.VarSymbol ordinal = new Symbol.VarSymbol(4114L, this.names.fromString("$ordinal"), this.syms.intType, cdef.sym);
        cdef.sym.members().enter(ordinal);
        cdef.defs = cdef.defs.prepend(this.make.VarDef(ordinal, null));
        return ordinal;
    }

    private Symbol.VarSymbol addEnumNameField(Tree.ClassDef cdef) {
        Symbol.VarSymbol name = new Symbol.VarSymbol(4114L, this.names.fromString("$name"), this.syms.stringType, cdef.sym);
        cdef.sym.members().enter(name);
        cdef.defs = cdef.defs.prepend(this.make.VarDef(name, null));
        return name;
    }

    private Symbol.MethodSymbol addEnumFieldOrdinalMethod(Tree.ClassDef cdef, Symbol.VarSymbol ordinalSymbol) {
        Symbol.MethodSymbol ordinalSym = this.lookupMethod(cdef.pos, this.names.ordinal, cdef.type, Type.emptyList);
        assert (ordinalSym != null);
        assert (ordinalSym instanceof Symbol.MethodSymbol);
        Tree.Return ret = this.make.Return(this.make.Ident(ordinalSymbol));
        List<Tree> statements = Tree.emptyList.prepend(ret);
        cdef.defs = cdef.defs.append(this.make.MethodDef(ordinalSym, this.make.Block(0L, statements)));
        return ordinalSym;
    }

    private Symbol.MethodSymbol addEnumFieldNameMethod(Tree.ClassDef cdef, Symbol.VarSymbol nameSymbol) {
        Symbol.MethodSymbol nameSym = this.lookupMethod(cdef.pos, this.names._name, cdef.type, Type.emptyList);
        assert (nameSym != null);
        assert (nameSym instanceof Symbol.MethodSymbol);
        Tree.Return ret = this.make.Return(this.make.Ident(nameSymbol));
        List<Tree> statements = Tree.emptyList.prepend(ret);
        cdef.defs = cdef.defs.append(this.make.MethodDef(nameSym, this.make.Block(0L, statements)));
        return nameSym;
    }

    private Symbol.MethodSymbol addEnumToString(Tree.ClassDef cdef, Symbol.VarSymbol nameSymbol) {
        Symbol.MethodSymbol toStringSym = this.lookupMethod(cdef.pos, this.names.toString, cdef.type, Type.emptyList);
        Tree toStringDecl = null;
        if (toStringSym != null) {
            toStringDecl = TreeInfo.declarationFor(toStringSym, cdef);
        }
        if (toStringDecl != null) {
            return toStringSym;
        }
        Tree.Return ret = this.make.Return(this.make.Ident(nameSymbol));
        List<Tree> statements = Tree.emptyList.prepend(ret);
        Tree resTypeTree = this.make.Type(this.syms.stringType);
        Type.MethodType toStringType = new Type.MethodType(Type.emptyList, this.syms.stringType, Type.emptyList, cdef.sym);
        toStringSym = new Symbol.MethodSymbol(1L, this.names.toString, toStringType, cdef.type.tsym);
        toStringDecl = this.make.MethodDef(toStringSym, this.make.Block(0L, statements));
        cdef.defs = cdef.defs.prepend(toStringDecl);
        cdef.sym.members().enter(toStringSym);
        return toStringSym;
    }

    private Symbol.MethodSymbol addEnumCompareTo(Tree.ClassDef cdef, Symbol.VarSymbol ordinalSymbol) {
        Symbol.MethodSymbol compareToSym = this.lookupMethod(cdef.pos, this.names.compareTo, cdef.type, Type.emptyList.prepend(cdef.sym.type));
        assert (compareToSym != null);
        assert (compareToSym instanceof Symbol.MethodSymbol);
        Tree.MethodDef compareToDecl = (Tree.MethodDef)TreeInfo.declarationFor(compareToSym, cdef);
        ListBuffer<Tree> blockStatements = new ListBuffer<Tree>();
        Tree.Modifiers mod1 = this.make.Modifiers(0L);
        Name oName = Name.fromString(this.names, "o");
        Tree.VarDef par1 = this.make.Param(oName, cdef.type, compareToSym);
        Tree.Ident paramId1 = this.make.Ident(this.names.java_lang_Object);
        paramId1.type = cdef.type;
        paramId1.sym = par1.sym;
        compareToSym.params = Symbol.VarSymbol.emptyList.prepend(par1.sym);
        Tree par1UsageId = this.make.Ident(par1.sym);
        Tree castTargetIdent = this.make.Ident(cdef.sym);
        Tree.TypeCast cast = this.make.TypeCast(castTargetIdent, par1UsageId);
        cast.setType(castTargetIdent.type);
        Name otherName = Name.fromString(this.names, "other");
        Symbol.VarSymbol otherVarSym = new Symbol.VarSymbol(mod1.flags, otherName, cdef.type, compareToSym);
        Tree.VarDef otherVar = this.make.VarDef(otherVarSym, cast);
        blockStatements.append(otherVar);
        Tree id1 = this.make.Ident(ordinalSymbol);
        Tree fLocUsageId = this.make.Ident(otherVarSym);
        Tree sel = this.make.Select(fLocUsageId, ordinalSymbol);
        Tree.Binary bin = this.makeBinary(70, id1, sel);
        Tree.Return ret = this.make.Return(bin);
        blockStatements.append(ret);
        Tree.MethodDef compareToMethod = this.make.MethodDef(compareToSym, this.make.Block(0L, blockStatements.toList()));
        compareToMethod.params = Tree.VarDef.emptyList.prepend(par1);
        cdef.defs = cdef.defs.append(compareToMethod);
        return compareToSym;
    }

    static interface TreeBuilder {
        public Tree build(Tree var1);
    }

    class EnumMapping {
        int pos = 0;
        int next = 1;
        final Symbol.TypeSymbol forEnum;
        final Symbol.VarSymbol mapVar;
        final Map<Symbol.VarSymbol, Integer> values;

        EnumMapping(int pos, Symbol.TypeSymbol forEnum) {
            this.forEnum = forEnum;
            this.values = new LinkedHashMap<Symbol.VarSymbol, Integer>();
            this.pos = pos;
            Name varName = Lower.this.names.fromString(Lower.this.target.syntheticNameChar() + "SwitchMap" + Lower.this.target.syntheticNameChar() + Lower.this.writer.xClassName(forEnum.type).toString().replace('/', '.').replace('.', Lower.this.target.syntheticNameChar()));
            Symbol.ClassSymbol outerCacheClass = Lower.this.outerCacheClass();
            this.mapVar = new Symbol.VarSymbol(4120L, varName, new Type.ArrayType(((Lower)Lower.this).syms.intType, (Symbol.TypeSymbol)((Lower)Lower.this).syms.arrayClass), outerCacheClass);
            Lower.this.enterSynthetic(pos, this.mapVar, outerCacheClass.members());
        }

        Tree forConstant(Symbol.VarSymbol v) {
            Integer result = this.values.get(v);
            if (result == null) {
                result = this.next++;
                this.values.put(v, result);
            }
            return Lower.this.make.Literal(result);
        }

        void translate() {
            Lower.this.make.at(this.pos);
            Tree.ClassDef owner = Lower.this.classDef((Symbol.ClassSymbol)this.mapVar.owner);
            Symbol.MethodSymbol valuesMethod = Lower.this.lookupMethod(this.pos, ((Lower)Lower.this).names.values, this.forEnum.type, Type.emptyList);
            Tree size = Lower.this.make.Select(Lower.this.make.App(Lower.this.make.QualIdent(valuesMethod), Tree.emptyList), ((Lower)Lower.this).syms.lengthVar);
            Tree mapVarInit = Lower.this.make.NewArray(Lower.this.make.Type(((Lower)Lower.this).syms.intType), Tree.emptyList.prepend(size), null).setType(new Type.ArrayType(((Lower)Lower.this).syms.intType, (Symbol.TypeSymbol)((Lower)Lower.this).syms.arrayClass));
            ListBuffer<Tree.Try> stmts = new ListBuffer<Tree.Try>();
            Symbol.MethodSymbol ordinalMethod = Lower.this.lookupMethod(this.pos, ((Lower)Lower.this).names.ordinal, this.forEnum.type, Type.emptyList);
            List<Tree.Catch> catcher = Tree.Catch.emptyList.prepend(Lower.this.make.Catch(Lower.this.make.VarDef(new Symbol.VarSymbol(0x200000000L, ((Lower)Lower.this).names.ex, ((Lower)Lower.this).syms.noSuchFieldErrorType, ((Lower)Lower.this).syms.noSymbol), null), Lower.this.make.Block(0L, Tree.emptyList)));
            for (Map.Entry<Symbol.VarSymbol, Integer> e : this.values.entrySet()) {
                Symbol.VarSymbol enumerator = e.getKey();
                Integer mappedValue = e.getValue();
                Tree assign = Lower.this.make.Assign(Lower.this.make.Indexed(this.mapVar, Lower.this.make.App(Lower.this.make.Select(Lower.this.make.QualIdent(enumerator), ordinalMethod), Tree.emptyList)), Lower.this.make.Literal(mappedValue)).setType(((Lower)Lower.this).syms.intType);
                assign = Lower.this.make.Exec(assign);
                Tree.Try _try = Lower.this.make.Try(Lower.this.make.Block(0L, Tree.emptyList.prepend(assign)), catcher, null);
                stmts.append(_try);
            }
            owner.defs = owner.defs.prepend(Lower.this.make.Block(8L, stmts.toList())).prepend(Lower.this.make.VarDef(this.mapVar, mapVarInit));
        }
    }

    class FreeVarCollector
    extends TreeScanner {
        Symbol owner;
        Symbol.ClassSymbol clazz;
        List<Symbol.VarSymbol> fvs;

        FreeVarCollector(Symbol.ClassSymbol clazz) {
            this.clazz = clazz;
            this.owner = clazz.owner;
            this.fvs = Symbol.VarSymbol.emptyList;
        }

        private void addFreeVar(Symbol.VarSymbol v) {
            List<Symbol.VarSymbol> l = this.fvs;
            while (l.nonEmpty()) {
                if (l.head == v) {
                    return;
                }
                l = l.tail;
            }
            this.fvs = this.fvs.prepend(v);
        }

        private void addFreeVars(Symbol.ClassSymbol c) {
            List<Symbol.VarSymbol> fvs = Lower.this.freevarCache.get(c);
            if (fvs != null) {
                List<Symbol.VarSymbol> l = fvs;
                while (l.nonEmpty()) {
                    this.addFreeVar((Symbol.VarSymbol)l.head);
                    l = l.tail;
                }
            }
        }

        public void visitIdent(Tree.Ident tree) {
            Lower.this.result = tree;
            this.visitSymbol(tree.sym);
        }

        private void visitSymbol(Symbol _sym) {
            Symbol sym = _sym;
            if (sym.kind == 4) {
                while (sym != null && sym.owner != this.owner) {
                    sym = Lower.this.proxies.lookup((Name)Lower.this.proxyName((Name)sym.name)).sym;
                }
                if (sym != null && sym.owner == this.owner) {
                    Symbol.VarSymbol v = (Symbol.VarSymbol)sym;
                    if (v.constValue == null) {
                        this.addFreeVar(v);
                    }
                } else if (Lower.this.outerThisStack.head != null && Lower.this.outerThisStack.head != _sym) {
                    this.visitSymbol((Symbol)Lower.this.outerThisStack.head);
                }
            }
        }

        public void visitNewClass(Tree.NewClass tree) {
            Symbol.ClassSymbol c = (Symbol.ClassSymbol)tree.constructor.owner;
            this.addFreeVars(c);
            if (tree.encl == null && c.hasOuterInstance() && Lower.this.outerThisStack.head != null) {
                this.visitSymbol((Symbol)Lower.this.outerThisStack.head);
            }
            super.visitNewClass(tree);
        }

        public void visitSelect(Tree.Select tree) {
            if ((tree.name == ((Lower)Lower.this).names._this || tree.name == ((Lower)Lower.this).names._super) && tree.selected.type.tsym != this.clazz && Lower.this.outerThisStack.head != null) {
                this.visitSymbol((Symbol)Lower.this.outerThisStack.head);
            }
            super.visitSelect(tree);
        }

        public void visitApply(Tree.Apply tree) {
            if (TreeInfo.name(tree.meth) == ((Lower)Lower.this).names._super) {
                this.addFreeVars((Symbol.ClassSymbol)TreeInfo.symbol((Tree)tree.meth).owner);
                Symbol constructor = TreeInfo.symbol(tree.meth);
                Symbol.ClassSymbol c = (Symbol.ClassSymbol)constructor.owner;
                if (c.hasOuterInstance() && tree.meth.tag != 34 && Lower.this.outerThisStack.head != null) {
                    this.visitSymbol((Symbol)Lower.this.outerThisStack.head);
                }
            }
            super.visitApply(tree);
        }
    }

    class ClassMap
    extends TreeScanner {
        ClassMap() {
        }

        public void visitClassDef(Tree.ClassDef tree) {
            Lower.this.classdefs.put(tree.sym, tree);
            super.visitClassDef(tree);
        }
    }
}

