/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.compiler.flatten;

import edu.rice.cs.nextgen2.compiler.code.Scope;
import edu.rice.cs.nextgen2.compiler.code.Symbol;
import edu.rice.cs.nextgen2.compiler.code.Symtab;
import edu.rice.cs.nextgen2.compiler.code.Type;
import edu.rice.cs.nextgen2.compiler.code.Types;
import edu.rice.cs.nextgen2.compiler.flatten.ClassVisitorEnv;
import edu.rice.cs.nextgen2.compiler.flatten.ListHash;
import edu.rice.cs.nextgen2.compiler.flatten.MethodEnvSnippetClosure;
import edu.rice.cs.nextgen2.compiler.flatten.MethodVisitorEnv;
import edu.rice.cs.nextgen2.compiler.flatten.SnippetClosure;
import edu.rice.cs.nextgen2.compiler.flatten.TreeChecker;
import edu.rice.cs.nextgen2.compiler.flatten.TreeSnippeter;
import edu.rice.cs.nextgen2.compiler.flatten.TypeFlattener;
import edu.rice.cs.nextgen2.compiler.flatten.Util;
import edu.rice.cs.nextgen2.compiler.flatten.VisitorEnv;
import edu.rice.cs.nextgen2.compiler.tree.Tree;
import edu.rice.cs.nextgen2.compiler.tree.TreeInfo;
import edu.rice.cs.nextgen2.compiler.tree.TreeMaker;
import edu.rice.cs.nextgen2.compiler.tree.TreeTranslator;
import edu.rice.cs.nextgen2.compiler.util.Context;
import edu.rice.cs.nextgen2.compiler.util.List;
import edu.rice.cs.nextgen2.compiler.util.ListBuffer;
import edu.rice.cs.nextgen2.compiler.util.Log;
import edu.rice.cs.nextgen2.compiler.util.Name;
import edu.rice.cs.nextgen2.compiler.util.Warner;
import edu.rice.cs.nextgen2.util.NGUtil;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Flat
extends TreeTranslator {
    protected static final Context.Key<Flat> flatKey = new Context.Key();
    private Context context;
    private Name.Table names;
    private Log log;
    private Symtab syms;
    final TreeMaker make;
    public TypeFlattener tyflat;
    final Types types;
    static final boolean PROCESS_METHS = true;
    TreeChecker treeChecker;
    ListBuffer<Tree.MethodDef> parametricMethods = new ListBuffer();
    ListHash<Symbol.MethodSymbol, SnippetClosure> methodSnippets = new ListHash();
    public HashMap<Tree.Apply, MethodEnvSnippetClosure> applyMves = new HashMap();
    HashMap<Symbol.ClassSymbol, Tree.ClassDef> classTemplates = new HashMap();
    private VisitorEnv env;
    public final MixinFixer mixer = new MixinFixer();

    public static Flat instance(Context context) {
        Flat instance = context.get(flatKey);
        if (instance == null) {
            instance = new Flat(context);
        }
        return instance;
    }

    private Flat(Context context) {
        this.context = context;
        context.put(flatKey, this);
        this.names = Name.Table.instance(context);
        this.log = Log.instance(context);
        this.syms = Symtab.instance(context);
        this.make = TreeMaker.instance(context);
        this.tyflat = TypeFlattener.instance(context);
        this.types = Types.instance(context);
        TreeSnippeter.init(context);
        this.treeChecker = new TreeChecker(this.types, this.log, this.syms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tree translate(Tree tree, VisitorEnv env) {
        VisitorEnv prevEnv = this.env;
        try {
            this.env = env;
            if (tree == null) {
                this.result = null;
            } else {
                tree.accept(this);
            }
        }
        finally {
            this.env = prevEnv;
        }
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Tree> translate(List<Tree> trees, VisitorEnv env) {
        List<Tree> res;
        VisitorEnv prevEnv = this.env;
        try {
            this.env = env;
            res = this.translate(trees);
        }
        finally {
            this.env = prevEnv;
        }
        return res;
    }

    @Override
    public void visitClassDef(Tree.ClassDef tree) {
        Type newSuperType;
        Tree.MethodDef snippet;
        SnippetClosure sc;
        List<SnippetClosure> l;
        List<Name> typaramNames;
        VisitorEnv env2;
        boolean isInterface;
        Type.ClassType classType = (Type.ClassType)tree.type;
        Type superType = this.types.supertype(classType);
        NGUtil.debugPrint(false, "F.ClassDef: " + tree.name + "<" + tree.typarams + ">" + " extends " + superType + " <" + superType.typarams() + ">");
        long new_flags = tree.mods.flags & 0xFFFFFFFFFFFFFFFDL & 0xFFFFFFFFFFFFFFFBL | 1L;
        if ((new_flags & 4L) != 0L) assert (false);
        tree.mods.flags = new_flags;
        tree.sym.flags_field = new_flags;
        boolean bl = isInterface = (tree.sym.flags_field & 0x200L) != 0L;
        if (tree.typarams == null || tree.typarams.isEmpty()) {
            env2 = this.env.newClassVisitorEnv(tree.sym, this.syms.errSymbol);
            tree.defs = env2.defs.appendList(this.translate(tree.defs, env2)).toList();
            this.result = tree;
        } else if (!isInterface && tree.typarams.nonEmpty() && superType.tag != 14) {
            typaramNames = Util.typeNames(tree.type.typarams());
            NGUtil.debugPrint(false, "ClassDef=2: typarams:" + typaramNames);
            Type.ClassType interfaceType = this.tyflat.genPCInterface(tree.type, typaramNames);
            Type.ClassType templateType = (Type.ClassType)this.tyflat.flatten((Type)((Type.ClassType)tree.type), typaramNames);
            templateType.interfaces_field = List.make(interfaceType);
            templateType.outer_field = ((Type.ClassType)tree.type).outer_field;
            Symbol.ClassSymbol templateSymbol = (Symbol.ClassSymbol)templateType.tsym;
            Symbol.ClassSymbol interfaceSymbol = (Symbol.ClassSymbol)interfaceType.tsym;
            templateSymbol.sourcefile = tree.sym.sourcefile;
            interfaceSymbol.sourcefile = tree.sym.sourcefile;
            Util.initScopeSymbols(templateSymbol, false);
            Util.initScopeSymbols(interfaceSymbol, false);
            List<Tree> templateInterfaces = this.typeToIdent(templateType.interfaces_field);
            List<Tree> interfaceInterfaces = this.typeToIdent(interfaceType.interfaces_field);
            env2 = this.env.newClassVisitorEnv(tree.sym, templateSymbol);
            tree.defs = this.translate(tree.defs, env2);
            List<Tree> flatDefs = tree.defs;
            List<SnippetClosure> snipClosures = env2.getSnipClosures().toList();
            ListBuffer<Object> snippets = new ListBuffer();
            List<SnippetClosure> l2 = snipClosures;
            while (l2.nonEmpty()) {
                SnippetClosure sc2 = (SnippetClosure)l2.head;
                Tree.MethodDef snippet2 = sc2.genSnippet(templateSymbol, 4112);
                snippets.append(snippet2);
                l2 = l2.tail;
            }
            snippets = env2.constructors.appendList(snippets.toList());
            List<Object> templateDefs = snippets.toList();
            snippets = new ListBuffer();
            List<SnippetClosure> l3 = snipClosures;
            while (l3.nonEmpty()) {
                SnippetClosure sc3 = (SnippetClosure)l3.head;
                Tree.MethodDef snippet3 = sc3.genSnippet(tree.sym, 5120);
                snippets.append(snippet3);
                l3 = l3.tail;
            }
            snippets.appendList(flatDefs);
            List<Tree> classDefs = snippets.toList().appendList(env2.defs.toList());
            Tree.Ident superIdent = this.typeToIdent(tree.type);
            this.make.at(tree.pos);
            Tree.ClassDef templateClass = this.make.ClassDef(this.make.Modifiers(tree.mods.flags), templateSymbol.name, Tree.TypeParameter.emptyList, superIdent, templateInterfaces, templateDefs);
            templateClass.sym = templateSymbol;
            templateClass.type = templateType;
            this.classTemplates.put(tree.sym, templateClass);
            Tree.ClassDef interfaceClass = this.make.ClassDef(this.make.Modifiers(tree.mods.flags & 0xFFFFFFFFFFFFFFEFL & 0xFFFFFFFFFFFFFBFFL | 0x200L), interfaceSymbol.name, Tree.TypeParameter.emptyList, null, interfaceInterfaces, Tree.emptyList);
            interfaceClass.sym = interfaceSymbol;
            interfaceSymbol.flags_field = interfaceClass.mods.flags;
            interfaceClass.type = interfaceType;
            templateClass.accept(this.treeChecker);
            interfaceClass.accept(this.treeChecker);
            this.env.defs.append(templateClass);
            this.env.defs.append(interfaceClass);
            tree.sym.flags_field = tree.mods.flags = tree.mods.flags & 0xFFFFFFFFFFFFFFEFL | 0x400L;
            tree.defs = classDefs;
            this.result = tree;
        } else if (isInterface && tree.typarams.nonEmpty() && superType.tag != 14) {
            typaramNames = Util.typeNames(tree.type.typarams());
            NGUtil.debugPrint(false, "ClassDef=2: typarams:" + typaramNames);
            Type.ClassType templateType = this.tyflat.genPCInterface(tree.type, typaramNames, false);
            templateType.interfaces_field = templateType.interfaces_field.append(classType);
            templateType.outer_field = ((Type.ClassType)tree.type).outer_field;
            Symbol.ClassSymbol templateSymbol = (Symbol.ClassSymbol)templateType.tsym;
            templateSymbol.sourcefile = tree.sym.sourcefile;
            Util.initScopeSymbols(templateSymbol, false);
            List<Tree> templateInterfaces = this.typeToIdent(templateType.interfaces_field);
            env2 = this.env.newClassVisitorEnv(tree.sym, templateSymbol);
            tree.defs = this.translate(tree.defs, env2);
            List<Tree> flatDefs = tree.defs;
            List<SnippetClosure> snipClosures = env2.getSnipClosures().toList();
            ListBuffer<Object> snippets = new ListBuffer();
            List<SnippetClosure> l4 = snipClosures;
            while (l4.nonEmpty()) {
                SnippetClosure sc4 = (SnippetClosure)l4.head;
                Tree.MethodDef snippet4 = sc4.genSnippet(templateSymbol, 4112);
                snippets.append(snippet4);
                l4 = l4.tail;
            }
            snippets = env2.constructors.appendList(snippets.toList());
            List<Object> templateDefs = snippets.toList();
            snippets = new ListBuffer();
            l = snipClosures;
            while (l.nonEmpty()) {
                sc = (SnippetClosure)l.head;
                snippet = sc.genSnippet(tree.sym, 5120);
                snippets.append(snippet);
                l = l.tail;
            }
            snippets.appendList(flatDefs);
            List<Tree> classDefs = snippets.toList().appendList(env2.defs.toList());
            Tree.Ident superIdent = this.typeToIdent(tree.type);
            this.make.at(tree.pos);
            Tree.ClassDef templateClass = this.make.ClassDef(tree.mods, templateSymbol.name, Tree.TypeParameter.emptyList, superIdent, templateInterfaces, templateDefs);
            templateClass.sym = templateSymbol;
            templateClass.type = templateType;
            this.classTemplates.put(tree.sym, templateClass);
            templateClass.accept(this.treeChecker);
            this.env.defs.append(templateClass);
            tree.sym.flags_field = tree.mods.flags = tree.mods.flags & 0xFFFFFFFFFFFFFFEFL | 0x400L;
            tree.defs = classDefs;
            this.result = tree;
        } else {
            env2 = this.env.newClassVisitorEnv(tree.sym, this.syms.errSymbol);
            typaramNames = Util.typeNames(tree.type.typarams());
            newSuperType = this.tyflat.flatten(classType.supertype_field, typaramNames);
            ((Symbol.ClassSymbol)newSuperType.tsym).members_field = ((Symbol.ClassSymbol)superType.bound().tsym).members_field;
            tree.extending = this.typeToIdent(newSuperType);
            NGUtil.debugPrint(false, "mixin type:" + tree.name + " " + tree.type + " => " + this.tyflat.flatten(tree.type));
            List<Type> newIfaces = this.tyflat.flatten(classType.interfaces_field, typaramNames);
            List<Type> l1 = classType.interfaces_field;
            List<Type> l2 = newIfaces;
            while (l1.nonEmpty()) {
                ((Symbol.ClassSymbol)((Type)l2.head).tsym).members_field = ((Symbol.ClassSymbol)((Type)l1.head).tsym).members_field;
                l1 = l1.tail;
                l2 = l2.tail;
            }
            tree.implementing = this.typeToIdent(newIfaces);
            Type.ClassType oldType = (Type.ClassType)tree.type;
            Symbol.ClassSymbol oldSym = tree.sym;
            Type.ClassType newType = (Type.ClassType)this.tyflat.flatten(tree.type);
            Symbol.ClassSymbol newSym = (Symbol.ClassSymbol)newType.tsym;
            newType.supertype_field = newSuperType;
            newType.interfaces_field = newIfaces;
            newSym.members_field = oldSym.members_field;
            newSym.sourcefile = oldSym.sourcefile;
            tree.type = newType;
            tree.sym = newSym;
            tree.name = newSym.name;
            NGUtil.debugPrint(false, " type.tsym:" + oldType.tsym + " tree.sym :" + tree.sym);
            tree.typarams = Tree.TypeParameter.emptyList;
            Symbol.ClassSymbol interfaceSym = new Symbol.ClassSymbol(oldSym.flags(), oldSym.name, null, oldSym.owner);
            Type.ClassType interfaceType = new Type.ClassType(oldType.outer_field, oldType.typarams_field, interfaceSym);
            interfaceType.supertype_field = oldType.supertype_field;
            interfaceType.interfaces_field = oldType.interfaces_field;
            interfaceSym.type = interfaceType;
            Util.initScopeSymbols(interfaceSym, false);
            Symbol.ClassSymbol interfaceSymbol = (Symbol.ClassSymbol)interfaceType.tsym;
            interfaceSymbol.sourcefile = tree.sym.sourcefile;
            List<Tree> interfaceInterfaces = this.typeToIdent(interfaceType.interfaces_field);
            List<Tree> interfaceDefs = this.treeClone(tree.defs, interfaceSymbol, false);
            tree = this.mixer.translate(tree, oldSym, newSym);
            NGUtil.debugPrint(false, "mixin: st:" + newSuperType + " ext:" + tree.extending);
            NGUtil.debugPrint(false, "mixin: st:" + tree);
            tree.defs = this.translate(tree.defs, env2);
            List<Tree> flatDefs = tree.defs;
            tree.defs = tree.defs.appendList(this.mixer.newMethods.toList());
            List<Tree> t = this.mixer.newMethods.toList();
            while (t.nonEmpty()) {
                newSym.members().enter(((Tree.MethodDef)t.head).sym);
                t = t.tail;
            }
            this.make.at(tree.pos);
            Tree.ClassDef interfaceClass = this.make.ClassDef(this.make.Modifiers(tree.mods.flags & 0xFFFFFFFFFFFFFFEFL & 0xFFFFFFFFFFFFFBFFL), interfaceSymbol.name, Tree.TypeParameter.emptyList, null, interfaceInterfaces, Tree.emptyList);
            interfaceClass.sym = interfaceSymbol;
            interfaceSymbol.flags_field = interfaceClass.mods.flags;
            interfaceClass.type = interfaceType;
            this.env.defs.append(interfaceClass);
            this.result = tree;
        }
        NGUtil.debugPrint(false, "methHash1:" + env2 + " " + env2.hashCode());
        for (Symbol.ClassSymbol methIface : env2.methEnvHash.keySet()) {
            NGUtil.debugPrint(false, "creating env:" + methIface);
            MethodVisitorEnv mve = env2.methEnvHash.get(methIface);
            Symbol.MethodSymbol methodSymbol = mve.msym;
            Tree.ClassDef polyInterface = this.genStaticEnvInterface(methodSymbol);
            Tree.ClassDef envTemplate = this.genEnvTemplate(methodSymbol, polyInterface.sym);
            NGUtil.debugPrint(false, "Flat.meth: iface:" + polyInterface.sym + "\n           templ:" + envTemplate.sym);
            List<SnippetClosure> snipClosures = mve.getSnipClosures().toList();
            ListBuffer<Tree.MethodDef> snippets = new ListBuffer<Tree.MethodDef>();
            l = snipClosures;
            while (l.nonEmpty()) {
                sc = (SnippetClosure)l.head;
                snippet = sc.genSnippet(envTemplate.sym, 4097);
                snippets.append(snippet);
                l = l.tail;
            }
            envTemplate.defs = snippets.toList();
            Tree.MethodDef constructor = this.generateDefaultConstructor(envTemplate);
            this.addSingleton(envTemplate, constructor);
            polyInterface.accept(this.treeChecker);
            envTemplate.accept(this.treeChecker);
            this.env.defs.append(polyInterface);
            this.env.defs.append(envTemplate);
            NGUtil.debugPrint(false, "envdefs:" + this.env.defs.toList());
        }
        if (superType.isParameterized() && Util.isGround(superType) && ((Symbol.ClassSymbol)superType.tsym).is_nextgen) {
            newSuperType = this.tyflat.flatten(classType.supertype_field, Util.EMPTY_NAMES);
            ((Symbol.ClassSymbol)newSuperType.tsym).members_field = ((Symbol.ClassSymbol)superType.tsym).members_field;
            classType.supertype_field = newSuperType;
        }
        if (classType.interfaces_field != null) {
            ListBuffer<Type> newIfaces = new ListBuffer<Type>();
            List<Type> ifaces = classType.interfaces_field;
            while (ifaces.nonEmpty()) {
                Type newIface;
                Type iface = (Type)ifaces.head;
                if (iface.isParameterized() && Util.isGround(iface) && ((Symbol.ClassSymbol)iface.tsym).is_nextgen) {
                    newIface = this.tyflat.flatten(iface, Util.EMPTY_NAMES);
                    ((Symbol.ClassSymbol)newIface.tsym).members_field = ((Symbol.ClassSymbol)iface.tsym).members_field;
                } else {
                    newIface = iface;
                }
                newIfaces.append(newIface);
                ifaces = ifaces.tail;
            }
            classType.interfaces_field = newIfaces.toList();
        }
    }

    protected List<Tree> treeClone(List<Tree> defs, Symbol.ClassSymbol isym, boolean copyBody) {
        ListBuffer<Tree.MethodDef> newDefs = new ListBuffer<Tree.MethodDef>();
        List<Tree> l = defs;
        while (l.nonEmpty()) {
            Tree f = (Tree)l.head;
            if (f.tag == 4) {
                Tree.MethodDef m = (Tree.MethodDef)f;
                if (m.name != this.names.init && m.name != this.names.clinit) {
                    Tree.Block body = m.body;
                    if (!copyBody) {
                        body = null;
                    }
                    Symbol.MethodSymbol newSym = m.sym.clone(isym);
                    Tree.MethodDef newdef = new Tree.MethodDef(this.make.Modifiers(m.mods.flags), m.name, m.restype, m.typarams, m.params, m.thrown, body, m.defaultValue, newSym);
                    newDefs.append(newdef);
                    isym.members().enter(newSym);
                }
            }
            l = l.tail;
        }
        return newDefs.toList();
    }

    @Override
    public void visitMethodDef(Tree.MethodDef tree) {
        NGUtil.debugPrint(false, "Flat.MethDef: " + tree.name + "<" + tree.typarams + ">");
        Symbol.MethodSymbol methodSymbol = tree.sym;
        Type methodType = tree.sym.type;
        int hcode = methodType.hashCode();
        Symbol.ClassSymbol owner = (Symbol.ClassSymbol)methodSymbol.owner;
        Type ownerType = owner.type;
        Type superType = this.types.supertype(ownerType);
        VisitorEnv newEnv = this.env;
        Symbol.ClassSymbol envInterfaceSym = null;
        if (methodType.tag == 16) {
            envInterfaceSym = this.tyflat.genPMInterface(methodSymbol, methodType.typarams());
            NGUtil.debugPrint(false, "F.visitEnv: param:" + envInterfaceSym);
            Name polyInterfaceName = this.names.fromString("polyEnvLocal");
            Tree.Ident polyInterfaceTypeIdent = (Tree.Ident)this.make.Ident(envInterfaceSym);
            int pflags = 16;
            Symbol.VarSymbol polyInterfaceVarSymbol = new Symbol.VarSymbol(pflags, polyInterfaceName, envInterfaceSym.type, methodSymbol);
            Tree.VarDef polyInterfaceDef = new Tree.VarDef(this.make.Modifiers(pflags), polyInterfaceName, polyInterfaceTypeIdent, null, polyInterfaceVarSymbol);
            polyInterfaceDef.type = envInterfaceSym.type;
            List<Tree.VarDef> newParams = tree.params.prepend(polyInterfaceDef);
            tree.params = newParams;
            List<Type> argtypes = methodType.argtypes();
            argtypes = argtypes.prepend(this.types.erasure(envInterfaceSym.type));
            ((Type.MethodType)((Type.ForAll)methodType).qtype).argtypes = argtypes;
            methodSymbol.erasure_field = null;
            NGUtil.debugPrint(false, "methHash2:" + this.env + " " + this.env.hashCode());
            newEnv = this.env.genMethodVisitorEnv(owner, methodSymbol, this.env, polyInterfaceDef);
        }
        tree.body = (Tree.Block)this.translate(tree.body, newEnv);
        if (methodSymbol.name == this.names.init && ownerType.isParameterized()) {
            NGUtil.debugPrint(false, "type:" + tree.type + " args:" + ((Type.MethodType)tree.type).argtypes + " thrown:" + ((Type.MethodType)tree.type).thrown + " res:" + tree.restype);
            Type.MethodType initType = new Type.MethodType(((Type.MethodType)tree.type).argtypes, ((Type.MethodType)tree.type).restype, ((Type.MethodType)tree.type).thrown, (Symbol.ClassSymbol)tree.sym.owner);
            Symbol.MethodSymbol newInitSym = tree.sym.clone(this.env.templateSymbol);
            newInitSym.flags_field &= 0xFFFFFFFFFFFFFFFDL;
            this.env.templateSymbol.members().enter(newInitSym);
            Tree.Ident superIdent = new Tree.Ident(this.names._super, methodSymbol);
            superIdent.type = this.syms.voidType;
            superIdent.pos = tree.pos;
            ListBuffer<Tree.Ident> args = new ListBuffer<Tree.Ident>();
            ListBuffer<Tree.VarDef> newVarDefs = new ListBuffer<Tree.VarDef>();
            List<Tree.VarDef> l = tree.params;
            while (l.nonEmpty()) {
                Tree.VarDef def = (Tree.VarDef)l.head;
                Symbol.VarSymbol newVarSymbol = def.sym.clone(newInitSym);
                Tree.VarDef newDef = new Tree.VarDef(def.mods, def.name, def.vartype, null, newVarSymbol);
                newDef.pos = def.pos;
                newDef.type = def.type;
                Tree.Ident ident = (Tree.Ident)this.make.Ident(newVarSymbol);
                newVarDefs.append(newDef);
                args.append(ident);
                l = l.tail;
            }
            Tree.Apply superCall = this.make.Apply(Tree.emptyList, superIdent, args.toList());
            superCall.type = this.syms.voidType;
            Tree.Block initBody = this.make.Block(0L, List.make(superCall));
            Tree.MethodDef templateConstructor = new Tree.MethodDef(this.make.Modifiers(tree.mods.flags), tree.name, tree.restype, tree.typarams, newVarDefs.toList(), tree.thrown, initBody, null, newInitSym);
            templateConstructor.pos = tree.pos;
            templateConstructor.type = tree.type;
            this.env.constructors.append(templateConstructor);
            if ((tree.mods.flags & 2L) != 0L) {
                tree.mods.flags &= 0xFFFFFFFFFFFFFFFDL;
                methodSymbol.flags_field &= 0xFFFFFFFFFFFFFFFDL;
            }
        } else if (ownerType.isParameterized() && methodType.tag != 16 && (methodSymbol.flags() & 0x400L) == 0L) {
            Tree.MethodDef mdef = this.generateBridge(tree, owner, this.env.templateSymbol, methodSymbol.name, true);
            this.env.constructors.append(mdef);
            this.env.templateSymbol.members().enter(mdef.sym);
        }
        if (methodSymbol.name == this.names.init && superType.isParameterized() && Util.isGround(superType) && !Util.cantTranslate(superType)) {
            List<Tree> stats = tree.body.stats;
            Tree.Apply superCall = (Tree.Apply)((Tree.Exec)stats.head).expr;
            if (superCall.meth.tag == 35) {
                Tree.Ident superIdent = (Tree.Ident)superCall.meth;
                this.make.at(tree.pos);
                Symbol.MethodSymbol newSuperSym = ((Symbol.MethodSymbol)superIdent.sym).clone(this.tyflat.flatten((Type)superType).tsym);
                Tree.Ident newSuperIdent = (Tree.Ident)new Tree.Ident(this.names._super, newSuperSym).setType(this.syms.voidType).setPos(superIdent.pos);
                superCall.meth = newSuperIdent;
            }
        }
        int hcode2 = tree.sym.type.hashCode();
        assert (hcode == hcode2);
        this.result = tree;
    }

    public Tree.MethodDef generateBridge(Tree.MethodDef tree, Symbol owner, Symbol newOwner, Name methodName, boolean useSuper) {
        Tree.Ident superIdent;
        Symbol.MethodSymbol methodSymbol = tree.sym;
        Type.MethodType mtype = (Type.MethodType)tree.type;
        Type.MethodType initType = new Type.MethodType(mtype.argtypes, mtype.restype, mtype.thrown, (Symbol.ClassSymbol)tree.sym.owner);
        Symbol.MethodSymbol newInitSym = tree.sym.clone(newOwner);
        newInitSym.name = methodName;
        newInitSym.flags_field &= 0xFFFFFFFFFFFFFFFDL;
        if (useSuper) {
            superIdent = new Tree.Ident(this.names._super, methodSymbol.owner);
            superIdent.type = owner.type;
        } else {
            superIdent = new Tree.Ident(this.names._this, methodSymbol.owner);
            superIdent.type = newOwner.type;
        }
        superIdent.pos = tree.pos;
        Tree.Select superSelect = new Tree.Select(superIdent, methodSymbol.name, methodSymbol);
        superSelect.type = mtype;
        ListBuffer<Tree.Ident> args = new ListBuffer<Tree.Ident>();
        ListBuffer<Tree.VarDef> newVarDefs = new ListBuffer<Tree.VarDef>();
        List<Tree.VarDef> l = tree.params;
        while (l.nonEmpty()) {
            Tree.VarDef def = (Tree.VarDef)l.head;
            Symbol.VarSymbol newVarSymbol = def.sym.clone(newInitSym);
            Tree.VarDef newDef = new Tree.VarDef(def.mods, def.name, def.vartype, null, newVarSymbol);
            newDef.pos = def.pos;
            newDef.type = def.type;
            Tree.Ident ident = (Tree.Ident)this.make.Ident(newVarSymbol);
            newVarDefs.append(newDef);
            args.append(ident);
            l = l.tail;
        }
        Tree.Apply superCall = this.make.Apply(null, superSelect, args.toList());
        superCall.type = ((Type.MethodType)tree.type).restype;
        Tree.Block initBody = this.make.Block(0L, List.make(this.make.Call(superCall)));
        Tree.MethodDef templateConstructor = new Tree.MethodDef(this.make.Modifiers(tree.mods.flags), methodName, tree.restype, tree.typarams, newVarDefs.toList(), tree.thrown, initBody, null, newInitSym);
        templateConstructor.pos = tree.pos;
        templateConstructor.type = tree.type;
        if ((tree.mods.flags & 2L) != 0L) {
            tree.mods.flags &= 0xFFFFFFFFFFFFFFFDL;
            methodSymbol.flags_field &= 0xFFFFFFFFFFFFFFFDL;
        }
        return templateConstructor;
    }

    @Override
    public void visitVarDef(Tree.VarDef tree) {
        tree.vartype = this.translate(tree.vartype, this.env);
        tree.init = this.translate(tree.init, this.env);
        this.result = tree;
    }

    @Override
    public void visitExec(Tree.Exec tree) {
        Type t = tree.expr.type;
        int hcode = tree.expr.type.hashCode();
        tree.expr = this.translate(tree.expr);
        if (tree.expr.type.hashCode() != hcode) {
            NGUtil.debugPrint(true, " Hashcode mismatch: before " + t + " " + t.hashCode() + tree.expr.type + " " + tree.expr.type.hashCode());
        }
        this.result = tree;
    }

    @Override
    public void visitApply(Tree.Apply tree) {
        Symbol.ClassSymbol methodOwner;
        NGUtil.debugPrint(false, "Flat.visitApply:" + tree + " " + this.env.getClass());
        tree.meth = this.translate(tree.meth);
        tree.args = this.translate(tree.args);
        Symbol.MethodSymbol methodSym = (Symbol.MethodSymbol)TreeInfo.symbol(tree.meth);
        NGUtil.debugPrint(false, "F.visitApply: msym:" + methodSym + " owner:" + (methodSym == null ? "null" : methodSym.owner));
        Type methodType = methodSym.type;
        if (methodSym.owner.type.tag == 10) {
            methodOwner = (Symbol.ClassSymbol)methodSym.owner;
        } else {
            methodOwner = (Symbol.ClassSymbol)this.tyflat.flatten((Type)methodSym.owner.type).tsym;
            NGUtil.debugPrint(false, "F.visitApply: old: " + methodSym.owner + " new: " + methodOwner);
            methodSym.owner = methodOwner;
        }
        if (methodType.tag == 16 && methodOwner.is_nextgen) {
            Tree mve;
            NGUtil.debugPrint(false, "tree.typeargs:" + tree.typeargs + " mtype: " + methodType + " mtype.tvars() " + ((Type.ForAll)methodType).tvars);
            if (tree.typeargs == null || tree.typeargs.isEmpty()) {
                this.log.rawError(tree.pos, "Type vars not specified for polymorphic call " + tree);
                this.result = tree;
                return;
            }
            List<Type> typargs = TreeInfo.types(tree.typeargs);
            boolean isClassSnippet = this.env instanceof ClassVisitorEnv;
            Symbol.MethodSymbol currentMeth = null;
            if (!isClassSnippet) {
                currentMeth = ((MethodVisitorEnv)this.env).msym;
            }
            List<Name> availTyparams = null;
            if (currentMeth != null) {
                availTyparams = Util.typeNames(currentMeth.type.typarams());
            }
            List<Name> reqTyparams = Util.typeNamesTree(tree.typeargs);
            if (!isClassSnippet && this.tyflat.genPMInterfaceString(currentMeth, currentMeth.type.typarams()).equals(this.tyflat.genPMInterfaceString(methodSym, TreeInfo.types(tree.typeargs))) && availTyparams.equals(reqTyparams)) {
                NGUtil.debugPrint(false, "EOF: found " + tree);
                Tree.VarDef polyEnv = ((MethodVisitorEnv)this.env).polyEnv;
                Name nextName = polyEnv.name;
                Type nextType = (Type)((Type.MethodType)((Type.ForAll)methodType).qtype).argtypes.head;
                Symbol.VarSymbol nextVarSymbol = polyEnv.sym;
                Tree.Ident recIdent = (Tree.Ident)this.make.Ident(nextVarSymbol);
                recIdent.name = nextName;
                mve = recIdent;
            } else {
                Symbol.ClassSymbol pmEnv = this.tyflat.getEnv(tree.meth, TreeInfo.types(tree.typeargs));
                if (Util.isGround(TreeInfo.types(tree.typeargs))) {
                    Tree.Ident singletonTypeIdent = (Tree.Ident)this.make.Ident(pmEnv);
                    Name singletonName = this.names.fromString("ONLY");
                    Symbol.VarSymbol singletonVarSym = new Symbol.VarSymbol(24L, singletonName, pmEnv.type, pmEnv);
                    Tree.Select singletonSelect = new Tree.Select(singletonTypeIdent, singletonName, singletonVarSym);
                    singletonSelect.type = pmEnv.type;
                    mve = singletonSelect;
                } else {
                    Tree app;
                    NGUtil.debugPrint(false, "env:" + this.env.getClass());
                    mve = app = this.env.constructApplySnippet(tree);
                    Symbol meth = TreeInfo.symbol(tree.meth);
                    Type mt = this.types.erasure(meth.type);
                    NGUtil.debugPrint(false, " -- check: " + mt.restype());
                }
            }
            ListBuffer<Tree> args = new ListBuffer<Tree>();
            args.append(mve);
            List<Tree> l = tree.args;
            while (l.nonEmpty()) {
                args.append((Tree)l.head);
                l = l.tail;
            }
            tree.args = args.toList();
        }
        NGUtil.debugPrint(false, "<<<Flat.visitApply:" + tree);
        this.result = tree;
    }

    @Override
    public void visitNewClass(Tree.NewClass tree) {
        NGUtil.debugPrint(false, ">Flat.newClass:" + tree + " flat?" + Util.isGround(tree.type));
        tree.encl = this.translate(tree.encl, this.env);
        tree.clazz = this.translate(tree.clazz, this.env);
        tree.args = this.translate(tree.args, this.env);
        tree.def = (Tree.ClassDef)this.translate(tree.def, this.env);
        if (!tree.type.isParameterized() || Util.cantTranslate(tree.type)) {
            this.result = tree;
        } else if (Util.isGround(tree.type)) {
            this.result = this.tyflat.toSnippets.translate(tree);
            this.result.accept(this.treeChecker);
        } else {
            this.result = this.genSnippet(tree, tree.args, tree.constructor.type.argtypes(), tree.clazz, tree.type);
        }
        Symbol constr = tree.constructor;
        Symbol.ClassSymbol accOwner = constr.owner.enclClass();
        assert (accOwner.members() != null) : "accOwner.members is null ";
        NGUtil.debugPrint(false, "<Flat.newClass:" + this.result + " type:" + this.result.type);
    }

    @Override
    public void visitNewArray(Tree.NewArray tree) {
        tree.elemtype = this.translate(tree.elemtype);
        tree.dims = this.translate(tree.dims);
        tree.elems = this.translate(tree.elems);
        NGUtil.debugPrint(false, ">F.visitNewArray:" + tree.type + tree.type.getClass() + Util.isGround(tree.type));
        if ((!tree.type.isParameterized() || Util.cantTranslate(tree.type)) && Util.isGround(tree.type)) {
            this.result = tree;
        } else if (Util.isGround(tree.type)) {
            this.result = this.tyflat.toSnippets.translate(tree);
        } else {
            List<Type> argtypes;
            List<Tree> args;
            if (tree.elems == null) {
                args = tree.dims;
                argtypes = List.make(tree.dims.length(), this.syms.intType);
            } else {
                args = tree.elems;
                argtypes = List.make(tree.elems.length(), tree.elemtype.type);
            }
            this.result = this.genSnippet(tree, args, argtypes, tree.elemtype, this.types.erasure(tree.type));
        }
        NGUtil.debugPrint(false, "<F.visitNewArray:" + this.result);
    }

    @Override
    public void visitAssign(Tree.Assign tree) {
        super.visitAssign(tree);
    }

    @Override
    public void visitAssignop(Tree.Assignop tree) {
        super.visitAssignop(tree);
    }

    @Override
    public void visitTypeCast(Tree.TypeCast tree) {
        tree.expr = this.translate(tree.expr);
        Type castType = tree.clazz.type;
        Type exprType = tree.expr.type;
        if (!castType.isParameterized() && Util.isGround(castType) || exprType.tag != 14 && this.types.isCastable(exprType, castType, Warner.noWarnings) && !castType.isParameterized() && Util.isGround(castType)) {
            this.result = tree;
        } else {
            List<Type> x = castType.typarams();
            boolean hasClass = false;
            boolean hasWild = false;
            List<Type> params = castType.typarams();
            while (params.nonEmpty()) {
                if (((Type)params.head).tag == 10) {
                    hasClass = true;
                } else {
                    hasWild = true;
                }
                params = params.tail;
            }
            if (hasClass && hasWild) {
                this.log.rawWarning(tree.pos, "Cannot mix wildcards and classes in parametric casts: " + tree);
            }
            this.result = hasWild ? tree : (Util.isGround(castType) ? this.tyflat.toSnippets.translate(tree) : this.genSnippet(tree, List.make(tree.expr), List.make(this.syms.objectType), tree.clazz, this.types.erasure(castType)));
        }
        NGUtil.debugPrint(false, "Flat.visitTypeCast:" + tree + " => " + this.result);
    }

    @Override
    public void visitTypeTest(Tree.TypeTest tree) {
        tree.expr = this.translate(tree.expr, this.env);
        NGUtil.debugPrint(false, "Flat.visitTypeTest:" + tree);
        Type testType = tree.clazz.type;
        Type exprType = tree.expr.type;
        NGUtil.debugPrint(false, "param?:" + testType.isParameterized() + " ground?:" + Util.isGround(testType) + " typevar?:" + (testType.tag == 14) + " typearg?:" + (testType.tag == 15) + " tag:" + testType.tag);
        if (this.types.isCastable(exprType, testType, Warner.noWarnings) && testType.tag != 14 && !testType.isParameterized()) {
            NGUtil.debugPrint(false, "1 " + exprType + " instance of " + testType + testType.tag);
            this.result = tree;
        } else {
            NGUtil.debugPrint(false, "2 " + exprType + " instance of " + testType + testType.tag);
            if (Util.isGround(testType)) {
                tree = (Tree.TypeTest)this.tyflat.toSnippets.translate(tree);
                NGUtil.debugPrint(false, "3  >  " + tree);
                this.result = tree;
            } else {
                this.result = this.genSnippet(tree, List.make(tree.expr), List.make(this.syms.objectType), Util.BOOL_IDENT, Util.BOOLEAN_TYPE);
            }
        }
    }

    public Tree genSnippet(Tree tree, List<Tree> args, List<Type> argtypes, Tree res, Type restype) {
        return this.env.constructSnippet(tree, args, argtypes, res, restype);
    }

    @Override
    public void visitIdent(Tree.Ident tree) {
        NGUtil.debugPrint(false, "Flat.visitIdent:" + tree + " type:" + tree.type + " sym:" + tree.sym + "[" + tree.sym.kind + "]" + "sym.owner:" + tree.sym.owner + " owner.encl:" + tree.sym.owner.enclClass());
        this.result = tree;
    }

    @Override
    public void visitSelect(Tree.Select tree) {
        super.visitSelect(tree);
        NGUtil.debugPrint(false, "F.visitSelect:" + tree + " sel:" + tree.selected.type);
        if (tree.selected.type.tag != 13 && tree.selected.type.tag != 11) {
            Type flatType;
            Symbol sym = TreeInfo.symbol(tree.selected);
            Type flatType2 = flatType = this.tyflat.flatten(tree.selected.type);
            boolean isMixin = tree.selected.type.tag == 10 && ((Type.ClassType)tree.selected.type.tsym.type).supertype_field != null && ((Type.ClassType)tree.selected.type.tsym.type).supertype_field.tag == 14;
            boolean isGround = Util.isGround(tree.selected.type);
            if (isMixin) {
                if (tree.selected.tag == 29) {
                    Tree.Parens p = (Tree.Parens)tree.selected;
                    tree.selected = p.expr;
                    flatType = this.tyflat.flatten(tree.selected.type);
                }
                sym.type = flatType;
                if (!isGround) {
                    tree.selected.type = flatType;
                } else {
                    tree.selected.type = flatType;
                    String newName = "$M" + Util.dotToDOT(flatType2) + tree.name.toString();
                    tree.name = this.names.fromString(newName);
                    Symbol nsym = tree.sym.clone(tree.sym.owner);
                    nsym.name = tree.name;
                    tree.sym = nsym;
                }
            }
        } else {
            Symbol sym = TreeInfo.symbol(tree.selected);
            if (sym != null && sym.kind == 2) {
                this.result = this.genSnippet(tree, Tree.emptyList, Type.emptyList, tree.selected, tree.type);
            }
        }
    }

    @Override
    public void visitTypeArray(Tree.TypeArray tree) {
        this.result = tree;
    }

    @Override
    public void visitTypeApply(Tree.TypeApply tree) {
        Type apType = tree.type;
        NGUtil.debugPrint(false, "Flat.TypeApply:" + tree.type + " ground?:" + Util.isGround(apType) + " " + this.tyflat.flatten(tree.type));
        Type flatType = this.tyflat.flatten(tree.type);
        NGUtil.debugPrint(false, "<Flat.TypeApply:" + tree.type + " => " + flatType);
        this.make.at(tree.pos);
        this.result = this.make.Type(flatType);
        NGUtil.debugPrint(false, "<Flat.TypeApply: res:" + this.result + " " + this.result.type + " " + this.result.type.tsym);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tree translateTopLevelClass(Tree cdef, VisitorEnv env) {
        try {
            Tree tree = this.translate(cdef, env);
            return tree;
        }
        finally {
            env = null;
        }
    }

    public Tree.Ident typeToIdent(Type type) {
        return (Tree.Ident)this.make.Ident(type.tsym);
    }

    public List<Tree> typeToIdent(List<Type> types) {
        List<Tree> typeIdents = Tree.emptyList;
        List<Type> l = types;
        while (l.nonEmpty()) {
            typeIdents = typeIdents.append(this.typeToIdent((Type)l.head));
            l = l.tail;
        }
        return typeIdents;
    }

    public Tree.ClassDef genStaticEnvInterface(Symbol.MethodSymbol methSym) {
        Type.ForAll type = (Type.ForAll)methSym.type;
        Symbol.ClassSymbol newInterfaceSymbol = this.tyflat.genPMInterface(methSym, type.tvars);
        Type.ClassType newInterfaceType = (Type.ClassType)newInterfaceSymbol.type;
        Symbol.ClassSymbol classSym = (Symbol.ClassSymbol)methSym.owner;
        NGUtil.debugPrint(false, ">SP.genEnvInterface: msym:" + classSym + "." + methSym + " ifaces:" + ((Type.ClassType)classSym.type).interfaces_field);
        Type stype = this.types.supertype(classSym.type);
        List<Tree> interfaceInterfaces = Tree.emptyList;
        Tree.ClassDef interfaceClass = this.make.ClassDef(this.make.Modifiers(newInterfaceSymbol.flags_field), newInterfaceSymbol.name, Tree.TypeParameter.emptyList, this.make.Type(newInterfaceType.supertype_field), interfaceInterfaces, Tree.emptyList);
        interfaceClass.sym = newInterfaceSymbol;
        interfaceClass.type = newInterfaceType;
        return interfaceClass;
    }

    public Tree.ClassDef genEnvTemplate(Symbol.MethodSymbol methSym, Symbol.ClassSymbol envInterfaceSym) {
        Symbol.ClassSymbol envTemplateSym = this.tyflat.genPMTemplate(methSym);
        Tree.ClassDef templateClass = this.make.ClassDef(this.make.Modifiers(envTemplateSym.flags()), envTemplateSym.name, Tree.TypeParameter.emptyList, this.make.Type(this.syms.objectType), List.make(this.make.Type(envInterfaceSym.type)), Tree.emptyList);
        templateClass.sym = envTemplateSym;
        templateClass.type = envTemplateSym.type;
        return templateClass;
    }

    protected Tree.MethodDef generateDefaultConstructor(Tree.ClassDef templateClass) {
        Symbol.ClassSymbol envTemplateSym = templateClass.sym;
        int superFlags = 1;
        Type.MethodType newSuperType = new Type.MethodType(Type.emptyList, this.syms.voidType, Type.emptyList, this.syms.methodClass);
        Symbol.MethodSymbol newSuperSymbol = new Symbol.MethodSymbol(superFlags, this.names.init, newSuperType, this.syms.objectType.tsym);
        Tree.Ident superIdent = new Tree.Ident(this.names._super, newSuperSymbol);
        superIdent.type = this.syms.voidType;
        Tree.Apply superCall = this.make.Apply(Tree.emptyList, superIdent, Tree.emptyList);
        superCall.type = newSuperType;
        NGUtil.debugPrint(false, " sym:" + newSuperSymbol + newSuperSymbol.hashCode());
        NGUtil.debugPrint(false, " type: " + newSuperType + newSuperType.hashCode() + newSuperType.getClass());
        Tree.Block initBody = this.make.Block(0L, List.make(superCall));
        int constructFlags = 2;
        Type.MethodType newConstructorType = new Type.MethodType(Type.emptyList, this.syms.voidType, Type.emptyList, this.syms.methodClass);
        Symbol.MethodSymbol newConstructorSymbol = new Symbol.MethodSymbol(constructFlags, this.names.init, newConstructorType, envTemplateSym);
        Tree.MethodDef templateConstructor = new Tree.MethodDef(this.make.Modifiers(4098L), this.names.init, this.make.Type(this.syms.voidType), Tree.TypeParameter.emptyList, Tree.VarDef.emptyList, Tree.emptyList, initBody, null, newConstructorSymbol);
        templateClass.defs = templateClass.defs.append(templateConstructor);
        envTemplateSym.members_field.enter(newConstructorSymbol);
        templateConstructor.type = this.syms.voidType;
        return templateConstructor;
    }

    protected Tree.MethodDef generateExtraFunc(Tree.ClassDef templateClass) {
        Symbol.ClassSymbol envTemplateSym = templateClass.sym;
        int constructFlags = 2;
        Type.MethodType newConstructorType = new Type.MethodType(List.make(this.syms.objectType), this.syms.voidType, Type.emptyList, this.syms.methodClass);
        Symbol.MethodSymbol newConstructorSymbol = new Symbol.MethodSymbol(constructFlags, this.names.init, newConstructorType, envTemplateSym);
        Tree.Ident ident_p = this.make.Ident(this.names._this);
        Symbol.VarSymbol this_s = new Symbol.VarSymbol(16L, this.names._this, templateClass.sym.type, newConstructorSymbol);
        ident_p.sym = this_s;
        ident_p.type = templateClass.sym.type;
        Name getClass_n = this.names.fromString("getClass");
        Type.MethodType getClass_t = new Type.MethodType(Type.emptyList, this.syms.classType, Type.emptyList, this.syms.methodClass);
        Symbol.MethodSymbol getClass_s = new Symbol.MethodSymbol(1L, getClass_n, getClass_t, this.syms.objectType.tsym);
        Tree.Select this_getClass = new Tree.Select(ident_p, getClass_n, getClass_s);
        this_getClass.type = getClass_t;
        Tree.Apply getClass_a = new Tree.Apply(null, this_getClass, Tree.emptyList);
        getClass_a.type = getClass_t.restype;
        Name toString_n = this.names.toString;
        Type.MethodType toString_t = new Type.MethodType(Type.emptyList, this.syms.objectType, Type.emptyList, this.syms.methodClass);
        Symbol.MethodSymbol toString_s = new Symbol.MethodSymbol(1L, toString_n, toString_t, this.syms.objectType.tsym);
        Tree.Select getClass_toString = new Tree.Select(getClass_a, toString_n, toString_s);
        getClass_toString.type = toString_t;
        Tree.Apply toString_a = new Tree.Apply(null, getClass_toString, Tree.emptyList);
        toString_a.type = toString_t.restype;
        Tree.Exec exec = new Tree.Exec(getClass_toString);
        Tree.Block initBody = this.make.Block(0L, List.make(exec));
        Symbol.VarSymbol vs = new Symbol.VarSymbol(16L, this.names.fromString("hi"), this.syms.objectType, newConstructorSymbol);
        Tree.VarDef vd = new Tree.VarDef(this.make.Modifiers(16L), this.names.fromString("hi"), this.make.Type(this.syms.objectType), null, vs);
        vd.type = this.syms.objectType;
        List<Tree.VarDef> params = List.make(vd);
        Tree.MethodDef templateConstructor = new Tree.MethodDef(this.make.Modifiers(4098L), this.names.init, this.make.Type(this.syms.voidType), Tree.TypeParameter.emptyList, params, Tree.emptyList, initBody, null, newConstructorSymbol);
        templateClass.defs = templateClass.defs.append(templateConstructor);
        envTemplateSym.members_field.enter(newConstructorSymbol);
        templateConstructor.type = this.syms.voidType;
        return templateConstructor;
    }

    protected void addSingleton(Tree.ClassDef templateClass, Tree.MethodDef constructor) {
        Symbol.ClassSymbol envTemplateSym = templateClass.sym;
        Symbol.MethodSymbol newConstructorSymbol = constructor.sym;
        Type singletonType = envTemplateSym.type;
        int sflags = 25;
        Name singletonName = this.names.fromString("ONLY");
        Symbol.VarSymbol singletonVarSymbol = new Symbol.VarSymbol(sflags, singletonName, singletonType, envTemplateSym);
        Tree.Ident singletonTypeIdent = new Tree.Ident(envTemplateSym.name, singletonType.tsym);
        singletonTypeIdent.type = singletonType;
        Tree.NewClass initExpr = new Tree.NewClass(null, Tree.emptyList, singletonTypeIdent, Tree.emptyList, null);
        initExpr.constructor = newConstructorSymbol;
        initExpr.type = singletonType;
        Tree.VarDef singleton = new Tree.VarDef(this.make.Modifiers(sflags), singletonName, singletonTypeIdent, initExpr, singletonVarSymbol);
        singleton.type = singletonType;
        templateClass.defs = templateClass.defs.append(singleton);
        envTemplateSym.members_field.enter(singletonVarSymbol);
    }

    public final class MixinFixer
    extends TreeTranslator {
        HashMap<Symbol, Symbol> translation = new HashMap();
        ListBuffer<Tree> newMethods = new ListBuffer();

        private MixinFixer() {
        }

        public Tree.ClassDef translate(Tree.ClassDef t, Symbol o, Symbol n) {
            this.translation.clear();
            this.translation.put(o, n);
            this.newMethods = new ListBuffer();
            return (Tree.ClassDef)super.translate(t);
        }

        public void visitClassDef(Tree.ClassDef tree) {
            Type.ClassType classType = (Type.ClassType)tree.type;
            Type superType = Flat.this.types.supertype(classType);
            Type newType = Flat.this.tyflat.flatten(classType);
            String prefix = "$M" + Util.dotToDOT(newType);
            List<Tree> d = tree.defs;
            while (d.nonEmpty()) {
                if (((Tree)d.head).tag == 4) {
                    Tree.MethodDef meth = (Tree.MethodDef)d.head;
                    Name origName = meth.name;
                    Name hygieneName = Flat.this.names.fromString(prefix + meth.name.toString());
                    Symbol.MethodSymbol methodSymbol = meth.sym;
                    if (methodSymbol.name != ((Flat)Flat.this).names.init && (methodSymbol.flags_field & 8L) == 0L) {
                        Symbol.MethodSymbol p = this.checkParentInterfaceDefines(tree.sym, classType, methodSymbol);
                        Symbol.MethodSymbol nsym = methodSymbol.clone(tree.sym);
                        nsym.name = hygieneName;
                        meth.sym = nsym;
                        meth.name = nsym.name;
                        if (p != null) {
                            NGUtil.debugPrint(false, "Generate Bridge!! :" + p.owner + " => " + classType.tsym + " meth:" + p.name);
                            Tree.MethodDef mdef = Flat.this.generateBridge(meth, p.owner, classType.tsym, origName, false);
                            this.newMethods.append(mdef);
                        }
                        this.translation.put(methodSymbol, nsym);
                        methodSymbol.owner.members().enter(nsym);
                        methodSymbol.owner.members().remove(methodSymbol);
                    }
                }
                d = d.tail;
            }
            super.visitClassDef(tree);
        }

        public Symbol.MethodSymbol checkParentInterfaceDefines(Symbol.ClassSymbol origin, Type ctype, Symbol.MethodSymbol msym) {
            List<Type> ifaces;
            List<Type> i = ifaces = Flat.this.types.interfaces(ctype);
            while (i.nonEmpty()) {
                Type itype = (Type)i.head;
                Symbol.TypeSymbol c = itype.tsym;
                Scope.Entry e = c.members().lookup(msym.name);
                while (e.scope != null) {
                    if (msym.overrides(e.sym, origin, Flat.this.types, false)) {
                        return msym;
                    }
                    e = e.next();
                }
                Symbol.MethodSymbol m = this.checkParentInterfaceDefines(origin, itype, msym);
                if (m != null) {
                    return m;
                }
                i = i.tail;
            }
            return null;
        }

        public void visitIdent(Tree.Ident tree) {
            super.visitIdent(tree);
            NGUtil.debugPrint(false, "MF.ident: " + tree + " sym:" + tree.sym + " owner:" + tree.sym.owner);
            Symbol repl = this.translation.get(tree.sym);
            if (repl != null) {
                tree.sym = repl;
            }
            if ((repl = this.translation.get(tree.sym.owner)) != null) {
                tree.sym.owner = repl;
            }
            if ((repl = this.translation.get(tree.sym.owner.enclClass())) != null) {
                tree.sym.owner.owner = repl;
            }
            this.result = tree;
        }
    }
}

