/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.compiler.flatten;

import edu.rice.cs.nextgen2.compiler.code.Scope;
import edu.rice.cs.nextgen2.compiler.code.Symbol;
import edu.rice.cs.nextgen2.compiler.code.Symtab;
import edu.rice.cs.nextgen2.compiler.code.Type;
import edu.rice.cs.nextgen2.compiler.code.Types;
import edu.rice.cs.nextgen2.compiler.tree.Tree;
import edu.rice.cs.nextgen2.compiler.tree.TreeInfo;
import edu.rice.cs.nextgen2.compiler.tree.TreeTranslator;
import edu.rice.cs.nextgen2.compiler.util.List;
import edu.rice.cs.nextgen2.compiler.util.Log;

public class TreeChecker
extends TreeTranslator {
    final Types types;
    final Log log;
    private Symtab syms;

    public TreeChecker(Types t, Log l, Symtab s) {
        this.types = t;
        this.log = l;
        this.syms = s;
    }

    public void visitClassDef(Tree.ClassDef tree) {
        super.visitClassDef(tree);
        Type.ClassType classType = (Type.ClassType)tree.type;
        Type superType = this.types.supertype(classType);
        if ((classType.tsym.flags() & 0x200L) != 0L) assert (superType == this.syms.objectType) : "Interface " + classType + " sypertype is not obj";
        this.result = tree;
    }

    public void visitNewClass(Tree.NewClass tree) {
        super.visitNewClass(tree);
        assert (tree.constructor != null) : "Constructor symbol for " + tree + " is null";
        Symbol.ClassSymbol c = (Symbol.ClassSymbol)tree.constructor.owner;
        assert (c != null) : " Constructor owner is null for " + tree;
        this.result = tree;
    }

    public void visitApply(Tree.Apply tree) {
        super.visitApply(tree);
        Symbol meth = TreeInfo.symbol(tree.meth);
        Type mt = this.types.erasure(meth.type);
        List<Type> argtypes = mt.argtypes();
        assert (tree.args.length() == argtypes.length()) : "tree " + tree + "tree args:" + tree.args.length() + " <> " + argtypes.length() + " meth:" + meth + " => " + mt + mt.getClass();
        meth.erasure_field = null;
        this.result = tree;
    }

    public void checkSym(String msg, Symbol m) {
        System.out.println("TC.checksym" + msg + " 0x" + Long.toHexString(m.flags()));
    }

    public void visitMethodDef(Tree.MethodDef tree) {
        super.visitMethodDef(tree);
        Type x = this.types.erasure(tree.type);
        this.result = tree;
        Scope.Entry e = tree.sym.owner.members().lookup(tree.name);
        while (e.sym != null) {
            if (e.sym != tree.sym && this.types.isSameType(this.types.erasure(e.sym.type), x)) {
                this.log.error(tree.pos, "name.clash.same.erasure", tree.sym, e.sym);
                assert (false);
                return;
            }
            e = e.next();
        }
    }
}

