/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.compiler.flatten;

import edu.rice.cs.nextgen2.compiler.code.Symbol;
import edu.rice.cs.nextgen2.compiler.code.Symtab;
import edu.rice.cs.nextgen2.compiler.code.Type;
import edu.rice.cs.nextgen2.compiler.code.Types;
import edu.rice.cs.nextgen2.compiler.flatten.Util;
import edu.rice.cs.nextgen2.compiler.tree.Tree;
import edu.rice.cs.nextgen2.compiler.tree.TreeInfo;
import edu.rice.cs.nextgen2.compiler.util.Context;
import edu.rice.cs.nextgen2.compiler.util.List;
import edu.rice.cs.nextgen2.util.NGUtil;

public class TreeSnippeter {
    static Symtab syms;
    protected static TreeSnippeter instance;
    static Types types;

    private TreeSnippeter() {
    }

    public static void init(Context c) {
        syms = Symtab.instance(c);
        instance = new TreeSnippeter();
        types = Types.instance(c);
    }

    public static TreeSnippeter instance() {
        if (instance == null) {
            throw new RuntimeException("TreeSnippeter not inited");
        }
        return instance;
    }

    public static boolean isSnippetable(Tree tree) {
        return tree.tag == 32 || tree.tag == 27 || tree.tag == 28 || tree.tag == 31 || tree.tag == 26 || tree.tag == 34;
    }

    protected Snippeter find(Tree tree) {
        switch (tree.tag) {
            case 32: {
                return new TypeTestSnippeter(tree);
            }
            case 27: {
                return new NewClassSnippeter(tree);
            }
            case 28: {
                return new NewArraySnippeter(tree);
            }
            case 31: {
                return new TypeCastSnippeter(tree);
            }
            case 26: {
                return new ApplySnippeter(tree);
            }
            case 34: {
                return new SelectSnippeter(tree);
            }
        }
        assert (false) : "No Snippet translation defined for " + tree;
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SelectSnippeter
    implements Snippeter {
        Tree.Select tree;

        public SelectSnippeter(Tree t) {
            this.tree = (Tree.Select)t;
        }

        @Override
        public Type getTypeArg() {
            return this.tree.selected.type;
        }

        @Override
        public void setTypeArg(Type t) {
            this.tree.selected = new Tree.Ident(t.tsym.name, t.tsym).setPos(this.tree.selected.pos).setType(t);
        }

        @Override
        public List<Tree> getArgs() {
            return Tree.emptyList;
        }

        @Override
        public void setArgs(List<Tree> a) {
        }

        @Override
        public Tree copy() {
            return null;
        }

        @Override
        public String snippetString() {
            return "$select$" + Util.toMethodString(this.getTypeArg()) + this.tree.name;
        }

        @Override
        public String snippetHash() {
            return this.snippetString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ApplySnippeter
    implements Snippeter {
        Tree.Apply tree;

        public ApplySnippeter(Tree t) {
            this.tree = (Tree.Apply)t;
        }

        @Override
        public Type getTypeArg() {
            throw new RuntimeException("unimpl");
        }

        @Override
        public void setTypeArg(Type t) {
            throw new RuntimeException("unimpl");
        }

        @Override
        public List<Tree> getArgs() {
            throw new RuntimeException("unimpl");
        }

        @Override
        public void setArgs(List<Tree> a) {
            throw new RuntimeException("unimpl");
        }

        @Override
        public Tree copy() {
            throw new RuntimeException("unimpl");
        }

        @Override
        public String snippetString() {
            throw new RuntimeException("unimpl");
        }

        @Override
        public String snippetHash() {
            List<Type> params = types.erasure(TreeInfo.types(this.tree.typeargs));
            String ret = "$apply$$$l" + NGUtil.dotToDOT(params.toString("$$C")) + "$$r";
            return ret;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TypeCastSnippeter
    implements Snippeter {
        Tree.TypeCast tree;

        public TypeCastSnippeter(Tree t) {
            this.tree = (Tree.TypeCast)t;
        }

        @Override
        public Type getTypeArg() {
            return this.tree.clazz.type;
        }

        @Override
        public void setTypeArg(Type t) {
            this.tree.clazz = new Tree.Ident(t.tsym.name, t.tsym).setPos(this.tree.clazz.pos).setType(t);
        }

        @Override
        public List<Tree> getArgs() {
            return List.make(this.tree.expr);
        }

        @Override
        public void setArgs(List<Tree> a) {
            this.tree.expr = (Tree)a.head;
        }

        @Override
        public Tree copy() {
            return new Tree.TypeCast(this.tree.clazz, this.tree.expr).setPos(this.tree.pos).setType(this.tree.type);
        }

        @Override
        public String snippetString() {
            return "$castTo$" + Util.toMethodString(this.getTypeArg());
        }

        @Override
        public String snippetHash() {
            return this.snippetString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NewArraySnippeter
    implements Snippeter {
        Tree.NewArray tree;

        public NewArraySnippeter(Tree t) {
            this.tree = (Tree.NewArray)t;
        }

        @Override
        public Type getTypeArg() {
            return this.tree.elemtype.type;
        }

        @Override
        public void setTypeArg(Type t) {
            this.tree.elemtype = new Tree.Ident(t.tsym.name, t.tsym).setPos(this.tree.pos).setType(t);
            this.tree.type = new Type.ArrayType(t, (Symbol.TypeSymbol)TreeSnippeter.syms.arrayClass);
        }

        @Override
        public List<Tree> getArgs() {
            if (this.tree.dims == null) {
                throw new InternalError("dims is null in " + this.tree);
            }
            if (this.tree.dims == Tree.emptyList) {
                return this.tree.elems;
            }
            return this.tree.dims;
        }

        @Override
        public void setArgs(List<Tree> a) {
            if (this.tree.dims == null) {
                throw new InternalError("dims is null in " + this.tree);
            }
            if (this.tree.dims.isEmpty()) {
                this.tree.elems = a;
            } else if (this.tree.elems == null || this.tree.elems.isEmpty()) {
                this.tree.dims = a;
            } else {
                throw new IllegalArgumentException("New Array " + this.tree + " dims = " + this.tree.dims + " and elems = " + this.tree.elems + " in setArgs");
            }
        }

        @Override
        public Tree copy() {
            return new Tree.NewArray(this.tree.elemtype, this.tree.dims, this.tree.elems).setPos(this.tree.pos).setType(this.tree.type);
        }

        @Override
        public String snippetString() {
            NGUtil.debugPrint(false, "snippetString:" + this.tree + " dim:" + this.tree.dims + " elem:" + this.tree.elems);
            int dims = 0;
            int elems = 0;
            if (this.tree.dims != null) {
                dims = this.tree.dims.length();
            }
            if (this.tree.elems != null) {
                elems = this.tree.elems.length();
            }
            return "$newArray$" + Util.toMethodString(this.getTypeArg()) + "$" + dims + "$" + elems;
        }

        @Override
        public String snippetHash() {
            return this.snippetString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class NewClassSnippeter
    implements Snippeter {
        Tree.NewClass tree;

        public NewClassSnippeter(Tree t) {
            this.tree = (Tree.NewClass)t;
        }

        @Override
        public Type getTypeArg() {
            return this.tree.type;
        }

        @Override
        public void setTypeArg(Type t) {
            this.tree.type = t;
            this.tree.clazz = new Tree.Ident(t.tsym.name, t.tsym).setPos(this.tree.clazz.pos).setType(t);
        }

        @Override
        public List<Tree> getArgs() {
            return this.tree.args;
        }

        @Override
        public void setArgs(List<Tree> a) {
            this.tree.args = a;
        }

        @Override
        public Tree copy() {
            Tree.NewClass ret = new Tree.NewClass(this.tree.encl, this.tree.typeargs, this.tree.clazz, this.tree.args, this.tree.def);
            ret.constructor = this.tree.constructor;
            ret.pos = this.tree.pos;
            ret.type = this.tree.type;
            return ret;
        }

        @Override
        public String snippetString() {
            return "$new$" + Util.toMethodString(this.getTypeArg());
        }

        @Override
        public String snippetHash() {
            List<Type> params = types.erasure(this.tree.constructor.type.argtypes());
            return "$new$" + Util.toMethodString(this.getTypeArg()) + "$$l" + NGUtil.dotToDOT(params.toString("$$C")) + "$$r";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TypeTestSnippeter
    implements Snippeter {
        Tree.TypeTest tree;

        public TypeTestSnippeter(Tree t) {
            this.tree = (Tree.TypeTest)t;
        }

        @Override
        public Type getTypeArg() {
            return this.tree.clazz.type;
        }

        @Override
        public void setTypeArg(Type t) {
            this.tree.clazz = new Tree.Ident(t.tsym.name, t.tsym).setPos(this.tree.clazz.pos).setType(t);
        }

        @Override
        public List<Tree> getArgs() {
            return List.make(this.tree.expr);
        }

        @Override
        public void setArgs(List<Tree> a) {
            this.tree.expr = (Tree)a.head;
        }

        @Override
        public Tree copy() {
            return new Tree.TypeTest(this.tree.expr, this.tree.clazz).setPos(this.tree.pos).setType(this.tree.type);
        }

        @Override
        public String snippetString() {
            return "$instanceOf$" + Util.toMethodString(this.getTypeArg());
        }

        @Override
        public String snippetHash() {
            return this.snippetString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Snippeter {
        public Type getTypeArg();

        public void setTypeArg(Type var1);

        public List<Tree> getArgs();

        public void setArgs(List<Tree> var1);

        public Tree copy();

        public String snippetString();

        public String snippetHash();
    }
}

