/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.compiler.flatten;

import edu.rice.cs.nextgen2.compiler.code.Scope;
import edu.rice.cs.nextgen2.compiler.code.Symbol;
import edu.rice.cs.nextgen2.compiler.code.Symtab;
import edu.rice.cs.nextgen2.compiler.code.Type;
import edu.rice.cs.nextgen2.compiler.code.Types;
import edu.rice.cs.nextgen2.compiler.flatten.ParamCollector;
import edu.rice.cs.nextgen2.compiler.flatten.Util;
import edu.rice.cs.nextgen2.compiler.tree.Tree;
import edu.rice.cs.nextgen2.compiler.tree.TreeInfo;
import edu.rice.cs.nextgen2.compiler.tree.TreeMaker;
import edu.rice.cs.nextgen2.compiler.tree.TreeTranslator;
import edu.rice.cs.nextgen2.compiler.util.Context;
import edu.rice.cs.nextgen2.compiler.util.List;
import edu.rice.cs.nextgen2.compiler.util.ListBuffer;
import edu.rice.cs.nextgen2.compiler.util.Log;
import edu.rice.cs.nextgen2.compiler.util.Name;
import edu.rice.cs.nextgen2.util.NGUtil;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeFlattener
extends Type.Visitor {
    int index_offset = 0;
    List<Name> typaramNames;
    Type result = null;
    private TreeMaker make;
    private Symtab syms;
    private Name.Table names;
    Symbol.PackageSymbol EMPTY_PACKAGE_SYMBOL;
    static TypeFlattener instance;
    final Types types;
    final Log log;
    HashMap<String, Symbol.ClassSymbol> classMap = new HashMap();
    public final TreeFlattener toSnippets = new TreeFlattener();
    HashMap<String, Symbol.ClassSymbol> check = new HashMap();

    protected TypeFlattener(Context context) {
        this.make = TreeMaker.instance(context);
        this.syms = Symtab.instance(context);
        this.names = Name.Table.instance(context);
        this.types = Types.instance(context);
        this.log = Log.instance(context);
        this.EMPTY_PACKAGE_SYMBOL = new Symbol.PackageSymbol(this.names.emptyPackage, null);
    }

    public static TypeFlattener instance(Context c) {
        if (instance == null) {
            instance = new TypeFlattener(c);
        }
        return instance;
    }

    public String mangledName(Type that) {
        Symbol.TypeSymbol x = that.tsym;
        String res = x.owner != null && x.owner.kind == 2 ? this.mangledName(x.owner.type) + "$" + Util.dotToDOT(x.name) : NGUtil.dotToDOT(((Symbol)x).toString());
        return NGUtil.dotToDOT(res);
    }

    public String formFlatNameList(List<Type> params) {
        String res = "";
        List<Type> l = params;
        while (l.nonEmpty()) {
            res = l.head instanceof Type.CapturedType ? res + this.mangledName(((Type.CapturedType)l.head).bound) : res + this.mangledName((Type)l.head);
            if (l.tail.nonEmpty()) {
                res = res + "$$C";
            }
            l = l.tail;
        }
        return res;
    }

    public Name formFlatName(Symbol.TypeSymbol tsym, List<Type> params) {
        String res = tsym.name + "$$L" + this.formFlatNameList(params) + "$$R";
        return this.names.fromString(res);
    }

    public List<Type> flatten(List<Type> these, List<Name> boundNames) {
        return this.flatten(these, boundNames, 0);
    }

    public List<Type> flatten(List<Type> these, List<Name> boundNames, int offset) {
        if (these == null) {
            return Type.emptyList;
        }
        if (!these.nonEmpty()) {
            return these;
        }
        List<Type> flat = Type.emptyList;
        List<Type> l = these;
        while (l.nonEmpty()) {
            flat = flat.append(this.flatten((Type)l.head, boundNames, offset));
            l = l.tail;
        }
        assert (these.length() == flat.length());
        NGUtil.debugPrint(false, "TF.flattenList:" + these + " > " + flat);
        return flat;
    }

    public Type flatten(Type t) {
        return this.flatten(t, Util.typeNames(ParamCollector.ONLY.typarams(t)), 0);
    }

    public Type flatten(Type t, int offset) {
        return this.flatten(t, Util.typeNames(t.typarams()), offset);
    }

    public Type flatten(Type t, List<Name> typaramNames) {
        return this.flatten(t, typaramNames, 0);
    }

    public Type flatten(Type t, List<Name> typaramNames, int offset) {
        if (Util.cantTranslate(t)) {
            return t;
        }
        int old_offset = this.index_offset;
        this.index_offset = offset;
        this.typaramNames = typaramNames;
        t.accept(this);
        this.index_offset = old_offset;
        NGUtil.debugPrint(false, "TF.flatten:" + t.tsym + t.tsym.hashCode() + " <" + typaramNames + ">" + t.getClass() + " offset:" + offset + "=> " + this.result.tsym + this.result.tsym.hashCode());
        return this.result;
    }

    public Type genBaseType(Type type, List<Name> typaramNames) {
        return this.flattenTypeVar(type, typaramNames, "{", "}B");
    }

    public Type flattenTypeVar(Type that, List<Name> typarmNames, String pre, String suf) {
        NGUtil.debugPrint(false, "TF.flattenTypeVar:" + that + that.getClass() + " params:" + typarmNames);
        int i = this.typaramNames.index(that.tsym.name) + this.index_offset;
        if (i < 0) {
            throw new RuntimeException("Unbound typevar t:" + that + " " + that.getClass() + " vars:" + this.typaramNames);
        }
        Symbol.ClassSymbol sym = new Symbol.ClassSymbol(that.tsym.flags(), this.names.fromString(pre + i + suf), null, this.EMPTY_PACKAGE_SYMBOL);
        Type.ClassType type = new Type.ClassType(Type.noType, Type.emptyList, sym);
        sym.type = type;
        sym.is_nextgen = true;
        type.interfaces_field = Type.emptyList;
        NGUtil.debugPrint(false, "flattenTypeVar: " + that + " ::" + that.tsym.owner.type + " " + that.tsym.owner.type.getClass());
        Type parent = that;
        if (parent.tag == 10) {
            type.supertype_field = ((Type.ClassType)that).supertype_field;
        } else {
            Type parentErasure = this.types.erasure(parent);
            if ((parentErasure.tsym.flags() & 0x200L) != 0L || (type.tsym.flags() & 0x200L) != 0L) {
                type.interfaces_field = List.make(parentErasure);
            } else {
                type.supertype_field = parentErasure;
            }
            NGUtil.debugPrint(false, "TF.flattenTypeVar:  CHECK:" + parent + " " + parent.getClass() + " => " + type.supertype_field);
        }
        NGUtil.debugPrint(false, "flattenTypeVar:" + that + " > " + type);
        return type;
    }

    @Override
    public void visitClassType(Type.ClassType that) {
        List<Type> typarams = that.typarams_field;
        if (typarams.isEmpty()) {
            this.result = that;
            return;
        }
        List<Type> params = this.flatten(typarams, this.typaramNames);
        NGUtil.debugPrint(false, ">TF.visitClassType:" + that + " extends " + that.supertype_field);
        Name flatName = this.formFlatName(that.tsym, params);
        Symbol.ClassSymbol flatTsym = null;
        String hashCode = "" + that.tsym + that.tsym.hashCode() + params;
        if (this.classMap.containsKey(hashCode)) {
            flatTsym = this.classMap.get(hashCode);
            this.result = flatTsym.type;
        } else {
            flatTsym = new Symbol.ClassSymbol(that.tsym.flags(), flatName, null, that.tsym.owner);
            Type.ClassType flatType = new Type.ClassType(that.outer(), Type.emptyList, flatTsym);
            flatTsym.type = flatType;
            flatTsym.is_nextgen = true;
            flatType.interfaces_field = that.interfaces_field;
            flatType.supertype_field = ((Type.ClassType)that.tsym.type).supertype_field.tag == 14 ? that.supertype_field : that;
            if (flatType.interfaces_field == null) {
                flatType.interfaces_field = new List();
            }
            if ((that.tsym.flags() & 0x200L) != 0L) {
                flatType.interfaces_field = flatType.interfaces_field.append(that);
            }
            this.classMap.put(hashCode, flatTsym);
            this.result = flatType;
        }
        NGUtil.debugPrint(false, "<TF.visitClassType:" + this.result + flatTsym + flatTsym.hashCode());
    }

    @Override
    public void visitArgumentType(Type.ArgumentType that) {
        NGUtil.debugPrint(false, "TF.flattenArgumentType " + that);
        this.result = Util.isGround(that) ? that.type : this.flatten(that.type, this.typaramNames);
    }

    @Override
    public void visitArrayType(Type.ArrayType that) {
        if (Util.isGround(that.elemtype)) {
            this.result = that;
        } else {
            Type elemType = this.flatten(that.elemtype, this.typaramNames);
            this.result = new Type.ArrayType(elemType, that.tsym);
        }
    }

    @Override
    public void visitMethodType(Type.MethodType that) {
        this.visitType(that);
    }

    @Override
    public void visitPackageType(Type.PackageType that) {
        this.visitType(that);
    }

    @Override
    public void visitTypeVar(Type.TypeVar that) {
        this.result = this.flattenTypeVar(that, this.typaramNames, "{", "}");
    }

    @Override
    public void visitForAll(Type.ForAll that) {
        this.visitType(that);
    }

    @Override
    public void visitErrorType(Type.ErrorType that) {
        this.visitType(that);
    }

    @Override
    public void visitType(Type that) {
        this.result = that;
    }

    public Type.ClassType genPCInterface(Type t, List<Name> boundNames) {
        return this.genPCInterface(t, boundNames, true);
    }

    public Type.ClassType genPCInterface(Type t, List<Name> boundNames, boolean addDollar) {
        NGUtil.debugPrint(false, ">TF.genPCInterface:" + t + "<" + boundNames + ">" + t.getClass());
        Name flatName = this.flatten((Type)t, boundNames).tsym.name;
        boolean isInterface = (t.tsym.flags_field & 0x200L) != 0L;
        String app = "";
        if (!isInterface) {
            app = "$";
        }
        Name interfaceName = this.names.fromString(flatName.toString() + app);
        Symbol owner = t.tag == 14 ? this.EMPTY_PACKAGE_SYMBOL : t.tsym.owner;
        Symbol.ClassSymbol flatTsym = new Symbol.ClassSymbol(t.tsym.flags() & 0xFFFFFFFFFFFFFFEFL | 0x200L, interfaceName, null, owner);
        Util.initScopeSymbols(flatTsym, false);
        NGUtil.debugPrint(false, " TF.genPCInterface:" + flatTsym + " " + flatTsym.members());
        Type.ClassType flatType = new Type.ClassType(Type.noType, Type.emptyList, flatTsym);
        if (t.tag == 10) {
            Type.ClassType t1 = (Type.ClassType)t;
            ListBuffer<Type.ClassType> if0 = new ListBuffer<Type.ClassType>();
            if (t1.interfaces_field != null) {
                List<Type> l = t1.interfaces_field;
                while (l.nonEmpty()) {
                    if (((Symbol.ClassSymbol)((Type)l.head).tsym).is_nextgen) {
                        if0.append(this.genPCInterface((Type.ClassType)l.head, boundNames));
                    }
                    l = l.tail;
                }
            }
            List<Type.ClassType> ifaces = if0.toList();
            if (t1.supertype_field != null && t1.supertype_field.isParameterized()) {
                ifaces = ifaces.append(this.genPCInterface((Type.ClassType)t1.supertype_field, boundNames));
            }
            flatType.interfaces_field = ifaces;
        } else {
            flatType.interfaces_field = Type.emptyList;
        }
        flatType.supertype_field = this.syms.objectType;
        flatTsym.type = flatType;
        NGUtil.debugPrint(false, "<TF.genPCInterface: " + flatType + " ifaces:" + flatType.interfaces_field);
        return flatType;
    }

    public Type.ClassType genMixinInterface(Type t, List<Name> boundNames) {
        NGUtil.debugPrint(false, ">TF.genMixinInterface:" + t + "<" + boundNames + ">" + t.getClass());
        Name flatName = this.flatten((Type)t, boundNames).tsym.name;
        boolean isInterface = (t.tsym.flags_field & 0x200L) != 0L;
        String app = "";
        if (!isInterface) {
            app = "$";
        }
        Name interfaceName = this.names.fromString(flatName.toString() + app);
        Symbol owner = t.tag == 14 ? this.EMPTY_PACKAGE_SYMBOL : t.tsym.owner;
        Symbol.ClassSymbol flatTsym = new Symbol.ClassSymbol(t.tsym.flags() & 0xFFFFFFFFFFFFFFEFL | 0x200L, interfaceName, null, owner);
        Util.initScopeSymbols(flatTsym, false);
        NGUtil.debugPrint(false, " TF.genPCInterface:" + flatTsym + " " + flatTsym.members());
        Type.ClassType flatType = new Type.ClassType(Type.noType, Type.emptyList, flatTsym);
        flatType.interfaces_field = Type.emptyList;
        flatType.supertype_field = this.syms.objectType;
        flatTsym.type = flatType;
        NGUtil.debugPrint(false, "<TF.genMixinInterface: " + flatType + " ifaces:" + flatType.interfaces_field);
        return flatType;
    }

    public String genPMInterfaceString(Symbol.MethodSymbol sym, List<Type> typarams) {
        return this.genPMInterfaceString((Symbol.ClassSymbol)this.getMethEnvBaseClass((Symbol.MethodSymbol)sym).tsym, sym, typarams);
    }

    protected String genPMInterfaceString(Symbol.ClassSymbol csym, Symbol.MethodSymbol sym, List<Type> typarams) {
        List<Type> params = this.types.erasure(typarams);
        String f = (sym.flags() & 8L) != 0L ? "S" : "D";
        String ret = csym.name + "$$l" + this.formFlatNameList(params) + "$$r" + f + "$$E";
        NGUtil.debugPrint(false, "<TF.genPolyInterface:" + sym + " <" + typarams + ">" + " => " + ret);
        return ret;
    }

    public Name genPMInterfaceName(Symbol.ClassSymbol csym, Symbol.MethodSymbol sym, List<Type> typarams) {
        return this.names.fromString(this.genPMInterfaceString(csym, sym, typarams));
    }

    public Name genSPMTemplateName(Symbol.ClassSymbol csym, Symbol.MethodSymbol sym, List<Type> typarams, List<Type> typargs) {
        NGUtil.debugPrint(false, "genSPMTemplateName:" + sym + sym.owner + sym.owner.type.typarams());
        String fullname = sym.fullName().toString();
        Name fn = this.names.fromString(this.genPMInterfaceString(csym, sym, typarams) + "$$L" + this.formFlatNameList(typargs) + "$$R");
        NGUtil.debugPrint(false, "<TF.genSPMTemplateName:" + sym + " <" + typarams + "> " + " args:<" + typargs + ">" + " => " + fn);
        return fn;
    }

    public Name genDPMTemplateName(Symbol.MethodSymbol sym, Type.ClassType cprefix, List<Type> typarams, List<Type> typargs) {
        String class_prefix;
        List<Name> ctypnames = Util.typeNames(cprefix.typarams());
        List<Type> ctyparams = this.flatten(cprefix.typarams(), ctypnames);
        NGUtil.debugPrint(false, "genDPMTemplateName:" + cprefix + "." + sym + " params:" + typarams + " args:" + typargs);
        List<Type> params = this.types.erasure(sym.type.typarams());
        String f = (sym.flags() & 8L) != 0L ? "S" : "D";
        if (cprefix.tsym.name.len > 0) {
            class_prefix = cprefix.tsym.name.toString();
        } else {
            String x = ((Symbol.ClassSymbol)cprefix.tsym).flatname.toString();
            class_prefix = x.substring(x.lastIndexOf("$") + 1);
        }
        String ret = class_prefix + "$$L" + NGUtil.dotToDOT(ctyparams.toString("$$C")) + "$$R" + "$$l" + NGUtil.dotToDOT(this.types.erasure(params).toString("$$C")) + "$$r" + f + "$$E";
        String fullname = sym.fullName().toString();
        Name fn = this.names.fromString(ret + "$$L" + this.formFlatNameList(typargs) + "$$R");
        NGUtil.debugPrint(false, "CHECK>> TF.genDPMTemplateName:" + cprefix + "." + sym + " <" + typarams + "> " + " args:<" + typargs + ">" + " => " + fn);
        return fn;
    }

    public Type.ClassType getMethEnvBaseClass(Symbol.MethodSymbol msym) {
        return this.getMethEnvBaseClass(msym, null);
    }

    public Type.ClassType getMethEnvBaseClass(Symbol.MethodSymbol msym, Type.ClassType c) {
        Type.ForAll mtype = (Type.ForAll)msym.type;
        Symbol.ClassSymbol origin = (Symbol.ClassSymbol)msym.owner;
        Type.ClassType ctype = (Type.ClassType)origin.type;
        NGUtil.debugPrint(false, ">getMethEnvBaseClass: origin: " + origin + " otype:" + ctype + " c: " + c + " .. " + this.types.supertype(ctype));
        Type supertype = this.types.supertype(ctype);
        NGUtil.debugPrint(false, ">getMethEnvBaseClass: origin: " + origin + " otype:" + ctype + " c: " + c);
        NGUtil.debugPrint(false, "TF.getMethEnvBase: " + msym + " " + ctype + " extends " + supertype);
        Type.ClassType def = this.findDefinition(msym, (Type.ClassType)ctype.tsym.type);
        NGUtil.debugPrint(false, "[]findDefinition:" + origin + "." + msym + " => " + def);
        if (def != null) {
            ctype = def;
        }
        NGUtil.debugPrint(false, "<TF.getMethEnvBase: " + ctype);
        return ctype;
    }

    public Type.ClassType checkParentDefines(Symbol.MethodSymbol msym) {
        Symbol.ClassSymbol origin = (Symbol.ClassSymbol)msym.owner;
        Type.ClassType highest = null;
        Type.ClassType ctype = (Type.ClassType)origin.type;
        Type.ClassType superctype = (Type.ClassType)this.types.supertype(ctype);
        while (!this.types.isSameType(superctype, this.syms.objectType)) {
            Symbol.MethodSymbol m = this.symbolExists(msym, (Symbol.ClassSymbol)superctype.tsym);
            NGUtil.debugPrint(false, " Implementation:" + origin + "." + msym + " => " + m);
            if (m == null) break;
            NGUtil.debugPrint(false, "..checkParentDefines: " + ctype + "(" + ctype.tsym.type + ")" + " extends " + superctype + " ==> " + m.owner + "." + m);
            List<Type> classtvars = ParamCollector.ONLY.typarams(ctype.tsym.type);
            List<Type> superInstVars = superctype.typarams();
            List<Name> undef = Util.subtract(Util.typeNames(classtvars), Util.typeNames(superInstVars));
            NGUtil.debugPrint(false, "  var set:" + classtvars + " - " + superInstVars + " ok? " + (undef.length() == 0));
            if (undef.length() > 0) break;
            highest = superctype;
            ctype = superctype;
            superctype = (Type.ClassType)this.types.supertype(ctype.tsym.type);
        }
        return highest;
    }

    public Symbol.MethodSymbol symbolExists(Symbol.MethodSymbol msym, Symbol.ClassSymbol o) {
        NGUtil.debugPrint(false, ">symbolExists:" + msym + " in " + o);
        Type t = o.type;
        while (t.tag == 10) {
            Symbol.TypeSymbol c = t.tsym;
            NGUtil.debugPrint(false, " checking:" + c + " " + c.members());
            Scope.Entry e = c.members().lookup(msym.name);
            while (e.scope != null) {
                if (e.sym.kind == 16) {
                    Symbol.MethodSymbol m = (Symbol.MethodSymbol)e.sym;
                    NGUtil.debugPrint(false, "symbolExists:" + m + " <> " + msym + " override: " + msym.overrides(m, o, this.types, false));
                    if (msym.overrides(m, o, this.types, false) && (m.flags() & 0x1000L) == 0L) {
                        return m;
                    }
                }
                e = e.next();
            }
            t = this.types.supertype(t);
        }
        return null;
    }

    public Type.ClassType checkInterfaceCall(Symbol.MethodSymbol msym, Symbol.ClassSymbol origin) {
        Type.ClassType ctype = (Type.ClassType)origin.type;
        NGUtil.debugPrint(false, ">TF.checkInterfaceCall:" + msym + " c:" + origin + " if:" + this.types.interfaces(ctype));
        Type.ClassType impl = this.implemented(msym, origin);
        Type supertype = this.types.supertype(ctype);
        if (impl == null && supertype.tag == 10) {
            Type.ClassType superctype = (Type.ClassType)this.types.supertype(ctype);
            Symbol.ClassSymbol supercsym = (Symbol.ClassSymbol)superctype.tsym;
            impl = this.checkInterfaceCall(msym, supercsym);
        }
        NGUtil.debugPrint(false, "<TF.checkInterfaceCall:" + msym + " c:" + origin + " => " + impl);
        return impl;
    }

    private Type.ClassType findDefinition(Symbol.MethodSymbol msym, Type.ClassType ctype) {
        Type.ClassType found = null;
        List<Type> supers = this.types.interfaces(ctype);
        NGUtil.debugPrint(false, ">TF.find: " + ctype + " " + supers + " " + ((ctype.tsym.flags() & 0x200L) == 0L));
        if ((ctype.tsym.flags() & 0x200L) == 0L && ctype != this.syms.objectType && this.types.supertype((Type)ctype).tag != 18) {
            supers = supers.prepend(this.types.supertype(ctype));
        }
        NGUtil.debugPrint(false, ">>> " + supers + " " + ((ctype.tsym.flags() & 0x200L) == 0L));
        List<Type> is = supers;
        while (found == null && is.nonEmpty()) {
            Type.ClassType h = (Type.ClassType)is.head;
            Symbol.TypeSymbol i = h.tsym;
            NGUtil.debugPrint(false, ">>> " + is.head + " ng:" + ((Symbol.ClassSymbol)i).is_nextgen + " " + ((Type)is.head).getClass());
            if (((Symbol.ClassSymbol)i).is_nextgen) {
                Type.ClassType found2;
                NGUtil.debugPrint(false, ">TF.find: loop: " + ctype + "." + msym + " in " + i);
                Symbol.MethodSymbol m = this.symbolExists(msym, (Symbol.ClassSymbol)i);
                NGUtil.debugPrint(false, "]]]]" + m + " <> " + i.members().lookup((Name)msym.name).sym);
                if (m != null) {
                    NGUtil.debugPrint(false, "comparing to:" + m + " " + msym.overrides(m, (Symbol.TypeSymbol)msym.owner, this.types, true) + " " + msym.type.restype() + " <> " + this.types.memberType(msym.owner.type, m).restype() + " => " + this.types.isSameType(msym.type.restype(), this.types.memberType(msym.owner.type, m).restype()) + " op2: " + this.types.returnTypeSubstitutable(m.type, msym.type) + " " + this.types.returnTypeSubstitutable(msym.type, m.type) + " " + this.types.returnTypeSubstitutable(this.types.erasure(m.type), this.types.erasure(msym.type)));
                    if (msym.overrides(m, (Symbol.TypeSymbol)msym.owner, this.types, true) && this.types.returnTypeSubstitutable(msym.type, m.type)) {
                        NGUtil.debugPrint(false, "..checkParentDefines: " + ctype + "(" + ctype.tsym.type + ")" + " implements " + h + " ==> " + m.owner + "." + m);
                        List<Type> classtvars = ParamCollector.ONLY.typarams(ctype.tsym.type);
                        List<Type> superInstVars = h.typarams();
                        NGUtil.debugPrint(false, "  var set:" + classtvars + " - " + superInstVars);
                        List<Name> undef = Util.subtract(Util.typeNames(classtvars), Util.typeNames(superInstVars));
                        NGUtil.debugPrint(false, "  var set:" + classtvars + " - " + superInstVars + " ok? " + (undef.length() == 0));
                        if (undef.length() > 0) break;
                        found = h;
                    }
                }
                if ((found2 = this.findDefinition(msym, h)) != null) {
                    found = found2;
                }
            }
            is = is.tail;
        }
        NGUtil.debugPrint(false, "<TF.findDefinition: " + ctype + "." + msym + " >>" + found);
        return found;
    }

    private Type.ClassType implemented(Symbol.MethodSymbol msym, Symbol.TypeSymbol c) {
        Type.ClassType found = null;
        Type.ClassType ctype = (Type.ClassType)c.type;
        List<Type> is = this.types.interfaces(c.type);
        while (found == null && is.nonEmpty()) {
            Type.ClassType h = (Type.ClassType)is.head;
            Symbol.TypeSymbol i = h.tsym;
            NGUtil.debugPrint(false, ">TF.implemented: " + c + "." + msym + " => " + i);
            Scope.Entry e = i.members().lookup(msym.name);
            while (found == null && e.scope != null) {
                NGUtil.debugPrint(false, "comparing to:" + e.sym + " " + msym.overrides(e.sym, (Symbol.TypeSymbol)msym.owner, this.types, true) + " " + msym.type.restype() + " <> " + this.types.memberType(msym.owner.type, e.sym).restype() + " => " + this.types.isSameType(msym.type.restype(), this.types.memberType(msym.owner.type, e.sym).restype()) + " op2: " + this.types.returnTypeSubstitutable(e.sym.type, msym.type));
                if (msym.overrides(e.sym, (Symbol.TypeSymbol)msym.owner, this.types, true) && this.types.returnTypeSubstitutable(e.sym.type, msym.type)) {
                    NGUtil.debugPrint(false, "..checkParentDefines: " + ctype + "(" + ctype.tsym.type + ")" + " implements " + h + " ==> " + e.sym.owner + "." + e.sym);
                    List<Type> classtvars = ParamCollector.ONLY.typarams(ctype);
                    List<Type> superInstVars = h.typarams();
                    NGUtil.debugPrint(false, "  var set:" + classtvars + " - " + superInstVars);
                    List<Name> undef = Util.subtract(Util.typeNames(classtvars), Util.typeNames(superInstVars));
                    NGUtil.debugPrint(false, "  var set:" + classtvars + " - " + superInstVars + " ok? " + (undef.length() == 0));
                    if (undef.length() > 0) break;
                    found = h;
                }
                e = e.next();
            }
            if (found == null) {
                found = this.implemented(msym, i);
            }
            is = is.tail;
        }
        NGUtil.debugPrint(false, "<TF.implemented: " + c + "." + msym + " >>" + found);
        return found;
    }

    public Symbol.ClassSymbol genPMInterface(Symbol.MethodSymbol msym, List<Type> typarams) {
        NGUtil.debugPrint(false, " owner:" + msym.owner + msym.owner.getClass() + " " + msym.owner.owner + " " + msym.owner.owner.getClass());
        Symbol owner = msym.owner.owner;
        while (owner.kind != 2 && owner.kind != 1) {
            owner = owner.owner;
        }
        Symbol.ClassSymbol csym = (Symbol.ClassSymbol)this.getMethEnvBaseClass((Symbol.MethodSymbol)msym).tsym;
        Name iname = this.genPMInterfaceName(csym, msym, typarams);
        int flags = 521;
        if (this.check.containsKey("" + owner + "." + iname)) {
            return this.check.get("" + owner + "." + iname);
        }
        Type.ClassType itype = new Type.ClassType(Type.noType, typarams, null);
        itype.supertype_field = this.syms.objectType;
        itype.interfaces_field = Type.emptyList;
        Symbol.ClassSymbol isym = new Symbol.ClassSymbol(flags, iname, itype, csym.owner);
        isym.sourcefile = ((Symbol.ClassSymbol)msym.owner).sourcefile;
        Util.initScopeSymbols(isym, false);
        itype.tsym = isym;
        this.check.put(owner + "." + iname, isym);
        NGUtil.debugPrint(false, "<<genPMInterface:" + msym.owner + "." + msym + "<" + typarams + "> =>" + isym);
        return isym;
    }

    public Symbol.ClassSymbol genPMTemplate(Symbol.MethodSymbol methSym) {
        Type.ForAll type = (Type.ForAll)methSym.type;
        List<Type> typarams = type.tvars;
        List<Name> typnames = Util.typeNames(typarams);
        if ((methSym.flags() & 8L) != 0L) {
            List<Type> typargs = this.flatten(typarams, typnames);
            return this.genSPMInstance(methSym, typargs);
        }
        Type.ClassType ownerType = (Type.ClassType)methSym.owner.type;
        int offset = ((Type.ClassType)methSym.owner.type).typarams().length();
        List<Type> typargs = this.flatten(typarams, typnames, offset);
        NGUtil.debugPrint(false, "SP.genPolyTemplate:" + methSym.owner.type.typarams() + " off:" + offset + " owner:" + ownerType);
        return this.genDPMClassSymbol(methSym, ownerType, typarams, typargs);
    }

    protected Symbol.ClassSymbol getEnv(Tree meth, List<Type> typeargs) {
        Symbol.MethodSymbol msym = (Symbol.MethodSymbol)TreeInfo.symbol(meth);
        if ((msym.flags() & 8L) != 0L) {
            Symbol.ClassSymbol ret = this.genSPMInstance(msym, typeargs);
            return ret;
        }
        Type.ClassType currType = null;
        boolean doh = false;
        if (meth.tag == 34) {
            Tree.Select m = (Tree.Select)meth;
            Type.ClassType ctype = (Type.ClassType)m.selected.type;
            currType = this.getMethEnvBaseClass(msym, ctype);
            currType = (Type.ClassType)this.types.asSuper(ctype, currType.tsym);
            Type.ClassType curr = (Type.ClassType)this.types.erasure(currType);
            Type.ClassType ct = (Type.ClassType)this.types.erasure(ctype);
            NGUtil.debugPrint(false, "F.getEnv: recvr: " + ctype + " => " + ct + " static meth:" + currType + " => " + curr);
        } else if (meth.tag == 35) {
            Type.ClassType ctype = (Type.ClassType)((Tree.Ident)meth).sym.owner.type;
            currType = this.getMethEnvBaseClass(msym, ctype);
        } else {
            this.log.rawError(meth.pos, "Unable to determine recv type" + meth.getClass());
        }
        List<Type> typarams = this.types.erasure(msym.type.typarams());
        NGUtil.debugPrint(false, "getEnv.check: base: " + currType + " params:" + typarams + " typargs: " + typeargs);
        Symbol.ClassSymbol ret = this.genDPMClassSymbol(msym, currType, typarams, typeargs);
        if (doh) {
            System.err.println("dohing: " + ret);
        }
        return ret;
    }

    public Symbol.ClassSymbol genSPMInstance(Symbol.MethodSymbol msym, List<Type> typargs) {
        Type.ForAll type = (Type.ForAll)msym.type;
        List<Type> typarams = type.tvars;
        Symbol.ClassSymbol csym = (Symbol.ClassSymbol)this.getMethEnvBaseClass((Symbol.MethodSymbol)msym).tsym;
        Name flatName = this.genSPMTemplateName(csym, msym, typarams, typargs);
        return this.genPMInstance(msym, flatName);
    }

    public Symbol.ClassSymbol genDPMClassSymbol(Symbol.MethodSymbol methSym, Type.ClassType cprefix, List<Type> typarams, List<Type> typargs) {
        Name flatName = this.genDPMTemplateName(methSym, cprefix, typarams, typargs);
        assert (cprefix != this.syms.objectType);
        NGUtil.debugPrint(false, "TF.gennDPMClassSymbol: " + cprefix + "." + methSym + " => " + flatName);
        return this.genPMInstance(methSym, flatName);
    }

    protected Symbol.ClassSymbol genPMInstance(Symbol.MethodSymbol methSym, Name flatName) {
        Type.ForAll type = (Type.ForAll)methSym.type;
        List<Type> typarams = type.tvars;
        if (this.check.containsKey("" + methSym + "." + flatName)) {
            return this.check.get("" + methSym + "." + flatName);
        }
        NGUtil.debugPrint(false, "TF.genPolyInstance: " + methSym + "params:" + typarams + " => " + flatName);
        Symbol.ClassSymbol interfaceSymbol = this.genPMInterface(methSym, typarams);
        long flags = interfaceSymbol.flags();
        Type.ClassType envTemplateType = new Type.ClassType(Type.noType, Type.emptyList, null);
        Symbol owner = methSym.owner.owner;
        while (owner.kind != 2 && owner.kind != 1) {
            owner = owner.owner;
        }
        Symbol.ClassSymbol envTemplateSymbol = new Symbol.ClassSymbol(flags, flatName, envTemplateType, owner);
        envTemplateType.tsym = envTemplateSymbol;
        NGUtil.debugPrint(false, "genPMInstance: tempType" + envTemplateType + " " + this.types.erasure(envTemplateType));
        envTemplateSymbol.sourcefile = interfaceSymbol.sourcefile;
        envTemplateSymbol.flags_field &= 0xFFFFFFFFFFFFFDFFL;
        Util.initScopeSymbols(envTemplateSymbol, false);
        envTemplateType.interfaces_field = List.make(interfaceSymbol.type);
        envTemplateType.supertype_field = this.syms.objectType;
        NGUtil.debugPrint(false, "<<TF.genPolyInstance:" + envTemplateSymbol);
        this.check.put("" + methSym + "." + flatName, envTemplateSymbol);
        return envTemplateSymbol;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class TreeFlattener
    extends TreeTranslator {
        private List<Name> typaramNames;

        private TreeFlattener() {
        }

        public Tree translate(Tree tree, List<Name> typaramNames) {
            NGUtil.debugPrint(false, "TF.TreeF.translate:" + tree + " <" + typaramNames + ">");
            if (tree == null) {
                return null;
            }
            this.typaramNames = typaramNames;
            tree.accept(this);
            Tree result = this.result;
            this.result = null;
            return result;
        }

        @Override
        public void visitNewClass(Tree.NewClass tree) {
            Symbol constructor = tree.constructor;
            TypeFlattener.this.make.at(tree.pos);
            NGUtil.debugPrint(false, "Flatten:" + tree + " <" + this.typaramNames + ">");
            Type flatType = TypeFlattener.this.flatten(tree.type, this.typaramNames);
            Symbol.TypeSymbol flatTypeSymbol = flatType.tsym;
            Tree.Ident flatTypeIdent = (Tree.Ident)TypeFlattener.this.make.Ident(TypeFlattener.this.flatten((Type)tree.clazz.type, this.typaramNames).tsym);
            Symbol newConstructor = tree.constructor;
            if (tree.def == null) {
                newConstructor = constructor.clone(flatType.tsym);
            }
            Tree.NewClass res = new Tree.NewClass(tree.encl, Tree.emptyList, flatTypeIdent, tree.args, tree.def);
            res.constructor = newConstructor;
            res.type = flatType;
            res.pos = tree.pos;
            this.result = res;
        }

        @Override
        public void visitTypeCast(Tree.TypeCast tree) {
            Tree.TypeCast outer;
            Type castType = tree.clazz.type;
            Type.ClassType flatCastType = TypeFlattener.this.genPCInterface(castType, this.typaramNames);
            TypeFlattener.this.make.at(tree.pos);
            Tree.Ident flatIdent = (Tree.Ident)TypeFlattener.this.make.Ident(flatCastType.tsym);
            flatIdent.type = flatCastType;
            Tree.TypeCast inner = TypeFlattener.this.make.TypeCast(flatIdent, tree.expr);
            inner.type = flatCastType;
            NGUtil.debugPrint(false, "VE.TypeCast: clazz:" + castType + " " + castType.getClass());
            NGUtil.debugPrint(false, "VE.TypeCast: old:" + tree.clazz + " => " + flatCastType + " new:" + inner.clazz);
            NGUtil.debugPrint(false, " tree.type:" + tree.type);
            if (((Type.ClassType)tree.expr.type.tsym.type).supertype_field.tag == 14) {
                this.result = tree.expr;
                return;
            }
            if (castType.tag == 14) {
                Type baseType = TypeFlattener.this.genBaseType(castType, this.typaramNames);
                Symbol.TypeSymbol baseSymbol = baseType.tsym;
                baseSymbol.erasure_field = baseType;
                Tree.Ident baseIdent = (Tree.Ident)TypeFlattener.this.make.Ident(baseSymbol);
                baseIdent.type = baseType;
                outer = TypeFlattener.this.make.TypeCast(baseIdent, (Tree)inner);
                outer.type = baseType;
            } else if (castType.tag == 11) {
                Type flatType = TypeFlattener.this.flatten(castType, this.typaramNames);
                outer = TypeFlattener.this.make.TypeCast(flatType, tree.expr);
                outer.type = flatType;
            } else {
                outer = TypeFlattener.this.make.TypeCast(tree.type, (Tree)inner);
                outer.type = flatCastType;
            }
            this.result = outer;
        }

        @Override
        public void visitTypeTest(Tree.TypeTest tree) {
            Type typeTest = tree.clazz.type;
            Type.ClassType newTypeTest = TypeFlattener.this.genPCInterface(typeTest, this.typaramNames);
            NGUtil.debugPrint(false, "VE.TypeTest:" + tree + typeTest + " => " + newTypeTest);
            TypeFlattener.this.make.at(tree.pos);
            Tree.Ident flatIdent = (Tree.Ident)TypeFlattener.this.make.Ident(newTypeTest.tsym);
            Tree.TypeTest res = new Tree.TypeTest(tree.expr, flatIdent);
            res.type = tree.type;
            res.pos = tree.pos;
            this.result = res;
        }

        @Override
        public void visitNewArray(Tree.NewArray tree) {
            Type flatAtype;
            Type etype = tree.elemtype.type;
            Type flatEtype = TypeFlattener.this.flatten(etype, this.typaramNames);
            TypeFlattener.this.make.at(tree.pos);
            Tree.Ident flatIdent = (Tree.Ident)TypeFlattener.this.make.Ident(flatEtype.tsym);
            flatIdent.type = flatEtype;
            Tree.NewArray res = new Tree.NewArray(flatIdent, tree.dims, tree.elems);
            res.type = flatAtype = TypeFlattener.this.flatten(tree.type, this.typaramNames);
            res.pos = tree.pos;
            this.result = res;
            NGUtil.debugPrint(false, "TF.visitNewArray:" + tree + " => " + res);
        }

        @Override
        public void visitSelect(Tree.Select tree) {
            super.visitSelect(tree);
            if (tree.selected.type.tag == 14) {
                Type flattype = TypeFlattener.this.flatten(tree.selected.type, this.typaramNames);
                TypeFlattener.this.make.at(tree.pos);
                Tree.Ident flatIdent = (Tree.Ident)TypeFlattener.this.make.Ident(flattype.tsym);
                flatIdent.type = flattype;
                Tree.Select res = new Tree.Select(flatIdent, tree.name, tree.sym);
                res.type = tree.type;
                res.pos = tree.pos;
                this.result = res;
            }
        }
    }
}

