/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.compiler.flatten;

import edu.rice.cs.nextgen2.compiler.code.Scope;
import edu.rice.cs.nextgen2.compiler.code.Symbol;
import edu.rice.cs.nextgen2.compiler.code.Type;
import edu.rice.cs.nextgen2.compiler.tree.Tree;
import edu.rice.cs.nextgen2.compiler.util.List;
import edu.rice.cs.nextgen2.compiler.util.ListBuffer;
import edu.rice.cs.nextgen2.compiler.util.Name;
import edu.rice.cs.nextgen2.util.NGUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static final List<Name> EMPTY_NAMES = new List();
    public static final Tree.TypeIdent BOOL_IDENT = new Tree.TypeIdent(8);
    public static final Type BOOLEAN_TYPE = new Type(8, null);

    public static void debugPrintTrees(String msg, List<Tree> stats) {
        List<Tree> l = stats;
        while (l.nonEmpty()) {
            System.out.println(msg + " " + ((Tree)l.head).tag + " : " + l.head);
            l = l.tail;
        }
    }

    public static void initScopeSymbols(Symbol.ClassSymbol sym) {
        Util.initScopeSymbols(sym, true);
    }

    public static void initScopeSymbols(Symbol.ClassSymbol sym, boolean add) {
        Symbol.TypeSymbol owner = sym.owner.kind == 16 ? (Symbol.TypeSymbol)sym.owner.owner : (Symbol.TypeSymbol)sym.owner;
        sym.members_field = new Scope(sym);
        sym.members_field.next = owner.members();
        if (add && owner.members() != null) {
            owner.members().enter(sym);
        }
    }

    public static boolean cantTranslate(Type t) {
        return t.tsym.fullName().toString().indexOf("java.lang") > -1 || t.tsym.fullName().toString().indexOf("java.util") > -1;
    }

    public static boolean isGround(Type t) {
        if (t instanceof Type.CapturedType) {
            t = ((Type.CapturedType)t).bound;
        }
        switch (t.tag) {
            case 14: {
                return false;
            }
            case 15: {
                Type inner = ((Type.ArgumentType)t).type;
                return Util.isGround(inner);
            }
            case 11: {
                return Util.isGround(((Type.ArrayType)t).elemtype);
            }
        }
        return Util.isGround(t.typarams());
    }

    public static boolean isGround(List<Type> these) {
        return these.isEmpty() || Util.isGround((Type)these.head) && Util.isGround(these.tail);
    }

    public static List<Type> collectTyparms(Symbol.ClassSymbol csym, Symbol.MethodSymbol msym) {
        List<Type> retTyparams;
        List<Type> typarams2 = Type.emptyList;
        if (msym.type.tag == 16) {
            typarams2 = ((Type.ForAll)msym.type).typarams();
        }
        if ((msym.flags() & 8L) == 0L) {
            List<Type> typarams = csym.type.typarams();
            retTyparams = typarams.appendList(typarams2);
        } else {
            retTyparams = typarams2;
        }
        return retTyparams;
    }

    public static List<Name> typeNames(List<Type> typarams) {
        ListBuffer<Name> typeNames = new ListBuffer<Name>();
        List<Type> l = typarams;
        while (l.nonEmpty()) {
            if (l.head instanceof Type.ArgumentType) {
                Type top = ((Type.ArgumentType)l.head).type;
                typeNames.append(top.tsym.name);
            } else {
                typeNames.append(((Type)l.head).tsym.name);
            }
            l = l.tail;
        }
        return typeNames.toList();
    }

    public static List<Name> typeNamesTree(List<Tree> typarams) {
        if (typarams == null) {
            return EMPTY_NAMES;
        }
        ListBuffer<Name> typeNames = new ListBuffer<Name>();
        List<Tree> l = typarams;
        while (l.nonEmpty()) {
            if (((Tree)l.head).type instanceof Type.ArgumentType) {
                Type top = ((Type.ArgumentType)((Tree)l.head).type).type;
                typeNames.append(top.tsym.name);
            } else {
                typeNames.append(((Tree)l.head).type.tsym.name);
            }
            l = l.tail;
        }
        return typeNames.toList();
    }

    public static String dotToDOT(Name n) {
        return NGUtil.dotToDOT(n.toString());
    }

    public static String dotToDOT(Type n) {
        return NGUtil.dotToDOT(n.toString());
    }

    public static String toMethodString(Type t) {
        return NGUtil.elimBrack(NGUtil.dotToDOT(t.toString()));
    }

    public static String snippetEnvEncode(Symbol.MethodSymbol msym, Symbol.ClassSymbol c) {
        return "[]";
    }

    public static String snippetEnvEncode(Symbol.MethodSymbol msym) {
        if (msym == null) {
            return "nullMethod";
        }
        if (msym.type.tag != 16) {
            return msym.owner.fullName() + "$" + msym.name.toString();
        }
        Type.ForAll f = (Type.ForAll)msym.type;
        String ret = msym.owner.fullName() + "$" + f.typarams().length() + ((msym.flags() & 8L) == 0L);
        return ret;
    }

    public static <T> List<T> subtract(List<T> a, List<T> b) {
        ListBuffer ret = new ListBuffer();
        List<Object> l = a;
        while (l.nonEmpty()) {
            if (!b.contains(l.head)) {
                ret.append(l.head);
            }
            l = l.tail;
        }
        return ret.toList();
    }

    public static <T> List<T> remove(List<T> a, T b) {
        ListBuffer ret = new ListBuffer();
        List<Object> l = a;
        while (l.nonEmpty()) {
            if (!b.equals(l.head)) {
                ret.append(l.head);
            }
            l = l.tail;
        }
        return ret.toList();
    }

    public static <T> T elementAt(List<T> a, int index) {
        int i = index;
        List<Object> l = a;
        while (l.nonEmpty()) {
            if (i == 0) {
                return (T)l.head;
            }
            --i;
            l = l.tail;
        }
        throw new RuntimeException("Util.elementAt called with too high index:" + a + " i=" + index);
    }
}

