/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.compiler.flatten;

import edu.rice.cs.nextgen2.compiler.code.Symbol;
import edu.rice.cs.nextgen2.compiler.code.Symtab;
import edu.rice.cs.nextgen2.compiler.code.Type;
import edu.rice.cs.nextgen2.compiler.code.Types;
import edu.rice.cs.nextgen2.compiler.comp.Resolve;
import edu.rice.cs.nextgen2.compiler.flatten.ClassVisitorEnv;
import edu.rice.cs.nextgen2.compiler.flatten.Flat;
import edu.rice.cs.nextgen2.compiler.flatten.MethodEnvSnippetClosure;
import edu.rice.cs.nextgen2.compiler.flatten.MethodVisitorEnv;
import edu.rice.cs.nextgen2.compiler.flatten.SnippetClosure;
import edu.rice.cs.nextgen2.compiler.flatten.TreeSnippeter;
import edu.rice.cs.nextgen2.compiler.flatten.TypeFlattener;
import edu.rice.cs.nextgen2.compiler.flatten.Util;
import edu.rice.cs.nextgen2.compiler.tree.Tree;
import edu.rice.cs.nextgen2.compiler.tree.TreeInfo;
import edu.rice.cs.nextgen2.compiler.tree.TreeMaker;
import edu.rice.cs.nextgen2.compiler.util.Context;
import edu.rice.cs.nextgen2.compiler.util.List;
import edu.rice.cs.nextgen2.compiler.util.ListBuffer;
import edu.rice.cs.nextgen2.compiler.util.Log;
import edu.rice.cs.nextgen2.compiler.util.Name;
import edu.rice.cs.nextgen2.util.NGUtil;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VisitorEnv {
    VisitorEnv outerEnv;
    HashMap<String, Symbol.MethodSymbol> cache = new HashMap();
    List<Name> typaramNames;
    Symbol owner;
    Symbol.ClassSymbol templateSymbol;
    Flat flat;
    TypeFlattener flatten;
    ListBuffer<SnippetClosure> snippetClosures;
    public ListBuffer<Tree> defs;
    ListBuffer<Tree> constructors;
    protected TreeMaker make;
    public final Symtab syms;
    protected Name.Table names;
    public Context context;
    public Resolve rs;
    protected Log log;
    final Types types;
    HashMap<Symbol.ClassSymbol, MethodVisitorEnv> methEnvHash;
    protected static HashMap<String, VisitorEnv> hashMve = new HashMap();

    public VisitorEnv(Context c, VisitorEnv oe, Symbol o, Symbol.ClassSymbol template, List<Name> n) {
        this.context = c;
        this.outerEnv = oe;
        this.owner = o;
        this.templateSymbol = template;
        this.typaramNames = n;
        this.flat = Flat.instance(c);
        this.make = TreeMaker.instance(c);
        this.syms = Symtab.instance(c);
        this.names = Name.Table.instance(c);
        this.flatten = TypeFlattener.instance(c);
        this.rs = Resolve.instance(c);
        this.types = Types.instance(c);
        this.log = Log.instance(c);
        if (template == null) {
            this.templateSymbol = this.syms.errSymbol;
        }
        this.defs = new ListBuffer();
        this.snippetClosures = new ListBuffer();
        this.constructors = new ListBuffer();
        this.methEnvHash = new HashMap();
    }

    public static String snippetString(Tree tree) {
        return TreeSnippeter.instance().find(tree).snippetString();
    }

    public static String snippetHash(Tree tree) {
        return TreeSnippeter.instance().find(tree).snippetHash();
    }

    public Symbol.MethodSymbol getSnippet(Tree tree) {
        return this.cache.get(VisitorEnv.snippetHash(tree));
    }

    public void putSnippet(Tree tree, Symbol.MethodSymbol sym) {
        this.cache.put(VisitorEnv.snippetHash(tree), sym);
    }

    public abstract Tree constructSnippet(Tree var1, List<Tree> var2, List<Type> var3, Tree var4, Type var5);

    public Symbol.MethodSymbol constructSnippetSymbol(Tree tree, List<Tree> args, List<Type> argtypes, Tree returnIdent, Type returnType, boolean requiresReflection) {
        Symbol.MethodSymbol cached = this.getSnippet(tree);
        if (cached != null) {
            return cached;
        }
        Name snippetName = this.names.fromString(NGUtil.dotToDOT(this.types.erasure(this.owner.type).toString()) + VisitorEnv.snippetString(tree));
        NGUtil.debugPrint(false, "VE.css:" + this.types.erasure(this.owner.type) + " :" + this.types.erasure(this.owner.type).getClass() + " :" + this.types.erasure((Type)this.owner.type).tsym.name + " :" + VisitorEnv.snippetHash(tree) + " name: " + snippetName);
        ListBuffer<Tree.VarDef> newVarDefs = new ListBuffer<Tree.VarDef>();
        ListBuffer<Tree.Ident> snippetParams = new ListBuffer<Tree.Ident>();
        Type.MethodType snippetType = new Type.MethodType(argtypes, returnType, Type.emptyList, null);
        Symbol.MethodSymbol abstractSnippetSymbol = new Symbol.MethodSymbol(5120L, snippetName, snippetType, this.owner);
        this.make.at(tree.pos);
        int i = 0;
        List<Type> l = argtypes;
        while (l.nonEmpty()) {
            Type nextType = (Type)l.head;
            Name nextName = this.names.fromString("$x" + i);
            Symbol.VarSymbol nextVarSymbol = new Symbol.VarSymbol(16L, nextName, nextType, this.owner);
            Tree.VarDef v = this.make.Param(nextName, nextType, abstractSnippetSymbol);
            TreeInfo.setSymbol(v.vartype, nextVarSymbol);
            Tree.Ident nextIdent = (Tree.Ident)this.make.Ident(nextVarSymbol);
            snippetParams.append(nextIdent);
            newVarDefs.append(v);
            l = l.tail;
            ++i;
        }
        List<Tree.VarDef> varDefs = newVarDefs.toList();
        TreeSnippeter.Snippeter snip = TreeSnippeter.instance().find(tree);
        snip.setArgs(snippetParams.toList());
        Tree.MethodDef abstractSnippet = this.make.MethodDef(this.make.Modifiers(1028L), snippetName, returnIdent, Tree.TypeParameter.emptyList, varDefs, Tree.emptyList, null, null);
        abstractSnippet.type = snippetType;
        abstractSnippet.sym = abstractSnippetSymbol;
        abstractSnippet.type = snippetType;
        SnippetClosure stored = new SnippetClosure(tree, abstractSnippetSymbol, returnType, this.typaramNames, this, this.make, requiresReflection);
        this.snippetClosures.append(stored);
        this.putSnippet(tree, abstractSnippetSymbol);
        return abstractSnippetSymbol;
    }

    public Symbol.MethodSymbol constructApplySnippetSymbol(Tree.Apply tree) {
        Symbol.MethodSymbol envMethodSym;
        Symbol.MethodSymbol cached = this.getSnippet(tree);
        if (cached != null) {
            return cached;
        }
        Symbol.MethodSymbol methodSym = (Symbol.MethodSymbol)TreeInfo.symbol(tree.meth);
        Type methodType = methodSym.type;
        Name methodName = null;
        NGUtil.debugPrint(false, ">VE.constructApply:" + tree);
        Type.ClassType newMveBase = this.flat.tyflat.getMethEnvBaseClass(methodSym);
        List<Type> typeargs = TreeInfo.types(tree.typeargs);
        Symbol.ClassSymbol fullSym = this.flat.tyflat.getEnv(tree.meth, typeargs);
        NGUtil.debugPrint(false, "VE.constructApply: sym:" + fullSym + " typeargs:" + typeargs);
        if ((methodSym.flags() & 8L) != 0L) {
            methodName = this.flat.tyflat.genSPMInstance((Symbol.MethodSymbol)methodSym, typeargs).name;
        } else if (tree.meth.tag == 34 || tree.meth.tag == 35) {
            Type.ClassType type = null;
            Type.ClassType otype = null;
            if (tree.meth.tag == 34) {
                Tree.Select m = (Tree.Select)tree.meth;
                type = (Type.ClassType)this.flat.tyflat.flatten(m.selected.type);
                otype = (Type.ClassType)m.selected.type;
            } else {
                Tree.Ident i = (Tree.Ident)tree.meth;
                otype = (Type.ClassType)i.sym.owner.type;
                type = (Type.ClassType)this.flat.tyflat.flatten(otype);
            }
            methodName = this.flat.tyflat.genDPMTemplateName(methodSym, (Type.ClassType)this.types.erasure(newMveBase), typeargs, typeargs);
            int offset = otype.typarams().length();
            List<Name> typnames = Util.typeNames(otype.typarams()).appendList(Util.typeNames(typeargs));
            List<Type> typargs = this.flat.tyflat.flatten(typeargs, typnames);
            NGUtil.debugPrint(false, "VE.constructApply: c.typarams:" + otype.typarams() + " " + " typnames:" + typeargs + "(" + typnames + ")" + " typargs:" + typargs);
            fullSym = this.flat.tyflat.genDPMClassSymbol(methodSym, otype, typeargs, typargs);
            methodName = this.names.fromString(fullSym.name.toString().replaceAll("[{}]", ""));
        } else assert (false) : "FIX: SP.visitApply: " + tree.meth + " " + tree.meth.getClass();
        NGUtil.debugPrint(false, "VE.apply:methodName:" + methodName);
        NGUtil.debugPrint(false, "VE.apply:fullSym:" + fullSym);
        Type.ClassType returnType = (Type.ClassType)((Type.ClassType)fullSym.type).interfaces_field.head;
        NGUtil.debugPrint(false, " -- envInterfaceType::" + returnType);
        Type.MethodType envMethodType = new Type.MethodType(Type.emptyList, returnType, Type.emptyList, this.syms.methodClass);
        NGUtil.debugPrint(false, " -- mtype:" + envMethodType + " res:" + envMethodType.restype);
        Symbol.MethodSymbol abstractSnippetSymbol = envMethodSym = new Symbol.MethodSymbol(1L, methodName, envMethodType, this.owner);
        MethodEnvSnippetClosure stored = new MethodEnvSnippetClosure(tree, abstractSnippetSymbol, (Type)returnType, fullSym, this.typaramNames, this, this.make);
        this.snippetClosures.append(stored);
        this.putSnippet(tree, abstractSnippetSymbol);
        return abstractSnippetSymbol;
    }

    public abstract Tree constructApplySnippet(Tree.Apply var1);

    public ListBuffer<SnippetClosure> getSnipClosures() {
        return this.snippetClosures;
    }

    public void setTypeNames(List<Name> input) {
        this.typaramNames = input;
    }

    public static VisitorEnv newClassVisitorEnv(Context c, Symbol.ClassSymbol owner) {
        return new ClassVisitorEnv(c, null, owner, null, Util.EMPTY_NAMES);
    }

    public VisitorEnv newClassVisitorEnv(Symbol.ClassSymbol owner, Symbol.ClassSymbol template) {
        List<Type> typarams = owner.type.typarams();
        List<Name> typaramNames = Util.typeNames(typarams);
        return new ClassVisitorEnv(this.context, this, owner, template, typaramNames);
    }

    public VisitorEnv genMethodVisitorEnv(Symbol.ClassSymbol csym, Symbol.MethodSymbol msym, VisitorEnv outerEnv, Tree.VarDef polyEnv) {
        assert (msym.type.tag == 16) : "NG2: MethodEnv for non Poly" + msym;
        VisitorEnv ret = null;
        List<Name> typaramNames = Util.typeNames(Util.collectTyparms(csym, msym));
        if (ret != null) {
            ret.setTypeNames(typaramNames);
            return ret;
        }
        HashMap<Symbol.ClassSymbol, MethodVisitorEnv> hash = outerEnv.methEnvHash;
        Symbol.ClassSymbol key = (Symbol.ClassSymbol)polyEnv.type.tsym;
        if (!hash.containsKey(key)) {
            ret = new MethodVisitorEnv(this.context, csym, msym, typaramNames, outerEnv, polyEnv);
            hash.put(key, (MethodVisitorEnv)ret);
        } else {
            ret = hash.get(key);
            NGUtil.debugPrint(false, "msym:" + ((MethodVisitorEnv)ret).msym + " " + ((MethodVisitorEnv)ret).msym.hashCode() + " <> " + msym + " " + msym.hashCode());
            NGUtil.debugPrint(false, "typnames:" + ((MethodVisitorEnv)ret).typaramNames + " <> " + typaramNames);
            NGUtil.debugPrint(false, "penv:" + ((MethodVisitorEnv)ret).polyEnv + " " + ((MethodVisitorEnv)ret).polyEnv.hashCode() + " <> " + polyEnv + " " + polyEnv.hashCode());
            ((MethodVisitorEnv)ret).msym = msym;
            ((MethodVisitorEnv)ret).typaramNames = typaramNames;
            ((MethodVisitorEnv)ret).polyEnv = polyEnv;
        }
        return ret;
    }

    public MethodEnvSnippetClosure genApplySnippet(Tree.Apply tree) {
        return new MethodEnvSnippetClosure(tree, this.typaramNames, this, this.make);
    }
}

