/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.compiler.tree;

import edu.rice.cs.nextgen2.compiler.code.Flags;
import edu.rice.cs.nextgen2.compiler.code.Symbol;
import edu.rice.cs.nextgen2.compiler.code.Type;
import edu.rice.cs.nextgen2.compiler.tree.Tree;
import edu.rice.cs.nextgen2.compiler.tree.TreeScanner;
import edu.rice.cs.nextgen2.compiler.util.Context;
import edu.rice.cs.nextgen2.compiler.util.List;
import edu.rice.cs.nextgen2.compiler.util.ListBuffer;
import edu.rice.cs.nextgen2.compiler.util.Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeInfo {
    protected static final Context.Key<TreeInfo> treeInfoKey = new Context.Key();
    private Name[] opname = new Name[28];
    public static final int notExpression = -1;
    public static final int noPrec = 0;
    public static final int assignPrec = 1;
    public static final int assignopPrec = 2;
    public static final int condPrec = 3;
    public static final int orPrec = 4;
    public static final int andPrec = 5;
    public static final int bitorPrec = 6;
    public static final int bitxorPrec = 7;
    public static final int bitandPrec = 8;
    public static final int eqPrec = 9;
    public static final int ordPrec = 10;
    public static final int shiftPrec = 11;
    public static final int addPrec = 12;
    public static final int mulPrec = 13;
    public static final int prefixPrec = 14;
    public static final int postfixPrec = 15;
    public static final int precCount = 16;

    public static TreeInfo instance(Context context) {
        TreeInfo instance = context.get(treeInfoKey);
        if (instance == null) {
            instance = new TreeInfo(context);
        }
        return instance;
    }

    private TreeInfo(Context context) {
        context.put(treeInfoKey, this);
        Name.Table names = Name.Table.instance(context);
        this.opname[0] = names.fromString("+");
        this.opname[1] = names.hyphen;
        this.opname[2] = names.fromString("!");
        this.opname[3] = names.fromString("~");
        this.opname[4] = names.fromString("++");
        this.opname[5] = names.fromString("--");
        this.opname[6] = names.fromString("++");
        this.opname[7] = names.fromString("--");
        this.opname[8] = names.fromString("<*nullchk*>");
        this.opname[9] = names.fromString("||");
        this.opname[10] = names.fromString("&&");
        this.opname[14] = names.fromString("==");
        this.opname[15] = names.fromString("!=");
        this.opname[16] = names.fromString("<");
        this.opname[17] = names.fromString(">");
        this.opname[18] = names.fromString("<=");
        this.opname[19] = names.fromString(">=");
        this.opname[11] = names.fromString("|");
        this.opname[12] = names.fromString("^");
        this.opname[13] = names.fromString("&");
        this.opname[20] = names.fromString("<<");
        this.opname[21] = names.fromString(">>");
        this.opname[22] = names.fromString(">>>");
        this.opname[23] = names.fromString("+");
        this.opname[24] = names.hyphen;
        this.opname[25] = names.asterisk;
        this.opname[26] = names.slash;
        this.opname[27] = names.fromString("%");
    }

    public Name operatorName(int tag) {
        return this.opname[tag - 46];
    }

    public static boolean isConstructor(Tree tree) {
        if (tree.tag == 4) {
            Name name = ((Tree.MethodDef)tree).name;
            return name == name.table.init;
        }
        return false;
    }

    public static boolean hasConstructors(List<Tree> trees) {
        List<Tree> l = trees;
        while (l.nonEmpty()) {
            if (TreeInfo.isConstructor((Tree)l.head)) {
                return true;
            }
            l = l.tail;
        }
        return false;
    }

    public static boolean isSyntheticInit(Tree stat) {
        if (stat.tag == 20) {
            Tree.Exec exec = (Tree.Exec)stat;
            if (exec.expr.tag == 30) {
                Tree.Assign assign = (Tree.Assign)exec.expr;
                if (assign.lhs.tag == 34) {
                    Name selected;
                    Tree.Select select = (Tree.Select)assign.lhs;
                    if (select.sym != null && (select.sym.flags() & 0x1000L) != 0L && (selected = TreeInfo.name(select.selected)) != null && selected == selected.table._this) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static Name calledMethodName(Tree tree) {
        if (tree.tag == 20) {
            Tree.Exec exec = (Tree.Exec)tree;
            if (exec.expr.tag == 26) {
                Name mname = TreeInfo.name(((Tree.Apply)exec.expr).meth);
                return mname;
            }
        }
        return null;
    }

    public static boolean isSelfCall(Tree tree) {
        Name name = TreeInfo.calledMethodName(tree);
        if (name != null) {
            Name.Table names = name.table;
            return name == names._this || name == names._super;
        }
        return false;
    }

    public static boolean isSuperCall(Tree tree) {
        Name name = TreeInfo.calledMethodName(tree);
        if (name != null) {
            Name.Table names = name.table;
            return name == names._super;
        }
        return false;
    }

    public static boolean isInitialConstructor(Tree tree) {
        Tree.Apply app = TreeInfo.firstConstructorCall(tree);
        if (app == null) {
            return false;
        }
        Name meth = TreeInfo.name(app.meth);
        return meth == null || meth != meth.table._this;
    }

    public static Tree.Apply firstConstructorCall(Tree tree) {
        if (tree.tag != 4) {
            return null;
        }
        Tree.MethodDef md = (Tree.MethodDef)tree;
        Name.Table names = md.name.table;
        if (md.name != names.init) {
            return null;
        }
        if (md.body == null) {
            return null;
        }
        List<Tree> stats = md.body.stats;
        while (stats.nonEmpty() && TreeInfo.isSyntheticInit((Tree)stats.head)) {
            stats = stats.tail;
        }
        if (stats.isEmpty()) {
            return null;
        }
        if (((Tree)stats.head).tag != 20) {
            return null;
        }
        Tree.Exec exec = (Tree.Exec)stats.head;
        if (exec.expr.tag != 26) {
            return null;
        }
        return (Tree.Apply)exec.expr;
    }

    public static int firstStatPos(Tree tree) {
        if (tree.tag == 7 && ((Tree.Block)tree).stats.nonEmpty()) {
            return ((Tree)((Tree.Block)tree).stats.head).pos;
        }
        return tree.pos;
    }

    public static int endPos(Tree tree) {
        if (tree.tag == 7 && ((Tree.Block)tree).endpos != 0) {
            return ((Tree.Block)tree).endpos;
        }
        if (tree.tag == 15) {
            return TreeInfo.endPos(((Tree.Synchronized)tree).body);
        }
        if (tree.tag == 16) {
            Tree.Try t = (Tree.Try)tree;
            return TreeInfo.endPos(t.finalizer != null ? t.finalizer : t.catchers.last().body);
        }
        return tree.pos;
    }

    public static int finalizerPos(Tree tree) {
        if (tree.tag == 16) {
            Tree.Try t = (Tree.Try)tree;
            assert (t.finalizer != null);
            return TreeInfo.firstStatPos(t.finalizer);
        }
        if (tree.tag == 15) {
            return TreeInfo.endPos(((Tree.Synchronized)tree).body);
        }
        throw new AssertionError();
    }

    public static int positionFor(Symbol sym, Tree tree) {
        Tree decl;
        return ((decl = TreeInfo.declarationFor((Symbol)sym, (Tree)tree)) != null ? decl : tree).pos;
    }

    public static Tree declarationFor(Symbol sym, Tree tree) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class DeclScanner
        extends TreeScanner {
            Tree result = null;
            final /* synthetic */ Symbol val$sym;

            DeclScanner(Symbol symbol) {
                this.val$sym = symbol;
            }

            @Override
            public void scan(Tree tree) {
                if (tree != null && this.result == null) {
                    tree.accept(this);
                }
            }

            @Override
            public void visitTopLevel(Tree.TopLevel that) {
                if (that.packge == this.val$sym) {
                    this.result = that;
                } else {
                    super.visitTopLevel(that);
                }
            }

            @Override
            public void visitClassDef(Tree.ClassDef that) {
                if (that.sym == this.val$sym) {
                    this.result = that;
                } else {
                    super.visitClassDef(that);
                }
            }

            @Override
            public void visitMethodDef(Tree.MethodDef that) {
                if (that.sym == this.val$sym) {
                    this.result = that;
                } else {
                    super.visitMethodDef(that);
                }
            }

            @Override
            public void visitVarDef(Tree.VarDef that) {
                if (that.sym == this.val$sym) {
                    this.result = that;
                } else {
                    super.visitVarDef(that);
                }
            }
        }
        DeclScanner s = new DeclScanner(sym);
        tree.accept(s);
        return s.result;
    }

    public static Tree referencedStatement(Tree.Labelled tree) {
        Tree t = tree;
        do {
            t = t.body;
        } while (t.tag == 12);
        switch (t.tag) {
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                return t;
            }
        }
        return tree;
    }

    public static Tree skipParens(Tree tree) {
        while (tree.tag == 29) {
            tree = ((Tree.Parens)tree).expr;
        }
        return tree;
    }

    public static List<Type> types(List<Tree> trees) {
        ListBuffer<Type> ts = new ListBuffer<Type>();
        List<Tree> l = trees;
        while (l.nonEmpty()) {
            ts.append(((Tree)l.head).type);
            l = l.tail;
        }
        return ts.toList();
    }

    public static Name name(Tree tree) {
        switch (tree.tag) {
            case 35: {
                return ((Tree.Ident)tree).name;
            }
            case 34: {
                return ((Tree.Select)tree).name;
            }
            case 39: {
                return TreeInfo.name(((Tree.TypeApply)tree).clazz);
            }
        }
        return null;
    }

    public static Name fullName(Tree tree) {
        tree = TreeInfo.skipParens(tree);
        switch (tree.tag) {
            case 35: {
                return ((Tree.Ident)tree).name;
            }
            case 34: {
                Name sname = TreeInfo.fullName(((Tree.Select)tree).selected);
                return sname == null ? null : sname.append('.', TreeInfo.name(tree));
            }
        }
        return null;
    }

    public static Symbol symbol(Tree tree) {
        tree = TreeInfo.skipParens(tree);
        switch (tree.tag) {
            case 35: {
                return ((Tree.Ident)tree).sym;
            }
            case 34: {
                return ((Tree.Select)tree).sym;
            }
            case 39: {
                return TreeInfo.symbol(((Tree.TypeApply)tree).clazz);
            }
        }
        return null;
    }

    public static boolean nonstaticSelect(Tree tree) {
        tree = TreeInfo.skipParens(tree);
        if (tree.tag != 34) {
            return false;
        }
        Tree.Select s = (Tree.Select)tree;
        Symbol e = TreeInfo.symbol(s.selected);
        return e == null || e.kind != 1 && e.kind != 2;
    }

    public static void setSymbol(Tree tree, Symbol sym) {
        tree = TreeInfo.skipParens(tree);
        switch (tree.tag) {
            case 35: {
                ((Tree.Ident)tree).sym = sym;
                break;
            }
            case 34: {
                ((Tree.Select)tree).sym = sym;
                break;
            }
        }
    }

    public static long flags(Tree tree) {
        switch (tree.tag) {
            case 5: {
                return ((Tree.VarDef)tree).mods.flags;
            }
            case 4: {
                return ((Tree.MethodDef)tree).mods.flags;
            }
            case 3: {
                return ((Tree.ClassDef)tree).mods.flags;
            }
            case 7: {
                return ((Tree.Block)tree).flags;
            }
        }
        return 0L;
    }

    public static long firstFlag(long flags) {
        int flag = 1;
        while ((flag & 0xFFF) != 0 && ((long)flag & flags) == 0L) {
            flag <<= 1;
        }
        return flag;
    }

    public static String flagNames(long flags) {
        return Flags.toString(flags & 0xFFFL).trim();
    }

    public static int opPrec(int op) {
        switch (op) {
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                return 14;
            }
            case 52: 
            case 53: 
            case 54: {
                return 15;
            }
            case 30: {
                return 1;
            }
            case 74: 
            case 75: 
            case 76: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                return 2;
            }
            case 55: {
                return 4;
            }
            case 56: {
                return 5;
            }
            case 60: 
            case 61: {
                return 9;
            }
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                return 10;
            }
            case 57: {
                return 6;
            }
            case 58: {
                return 7;
            }
            case 59: {
                return 8;
            }
            case 66: 
            case 67: 
            case 68: {
                return 11;
            }
            case 69: 
            case 70: {
                return 12;
            }
            case 71: 
            case 72: 
            case 73: {
                return 13;
            }
            case 32: {
                return 10;
            }
        }
        throw new AssertionError();
    }
}

