/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.compiler.util;

import edu.rice.cs.nextgen2.compiler.util.Context;
import edu.rice.cs.nextgen2.compiler.util.LayoutCharacters;
import edu.rice.cs.nextgen2.compiler.util.Name;
import edu.rice.cs.nextgen2.compiler.util.Options;
import edu.rice.cs.nextgen2.compiler.util.Pair;
import edu.rice.cs.nextgen2.compiler.util.Position;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;

public class Log
implements LayoutCharacters {
    protected static final Context.Key<Log> logKey = new Context.Key();
    public static final Context.Key<PrintWriter> outKey = new Context.Key();
    public final PrintWriter errWriter;
    public final PrintWriter warnWriter;
    public final PrintWriter noticeWriter;
    private final int MaxErrors;
    private final int MaxWarnings;
    public boolean promptOnError;
    public boolean emitWarnings;
    public boolean dumpOnError;
    private Name sourcename;
    public int nerrors = 0;
    public int nwarnings = 0;
    private Set<Pair<Name, Integer>> recorded = new HashSet<Pair<Name, Integer>>();
    private byte[] buf = null;
    private int bp;
    private int lastLine;
    private static final String compilerRB = "edu.rice.cs.nextgen2.compiler.resources.compiler";
    private static ResourceBundle messageRB;

    protected Log(Context context, PrintWriter errWriter, PrintWriter warnWriter, PrintWriter noticeWriter) {
        context.put(logKey, this);
        this.errWriter = errWriter;
        this.warnWriter = warnWriter;
        this.noticeWriter = noticeWriter;
        Options options = Options.instance(context);
        this.dumpOnError = options.get("-doe") != null;
        this.promptOnError = options.get("-prompt") != null;
        this.emitWarnings = options.get("-nowarn") == null;
        this.sourcename = Name.Table.instance((Context)context).__input;
        this.MaxErrors = this.getIntOption(options, "-Xmaxerrs", 100);
        this.MaxWarnings = this.getIntOption(options, "-Xmaxwarns", 100);
    }

    private int getIntOption(Options options, String optionName, int defaultValue) {
        String s = (String)options.get(optionName);
        try {
            if (s != null) {
                return Integer.parseInt(s);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return defaultValue;
    }

    static final PrintWriter defaultWriter(Context context) {
        PrintWriter result = context.get(outKey);
        if (result == null) {
            result = new PrintWriter(System.err);
            context.put(outKey, result);
        }
        return result;
    }

    protected Log(Context context) {
        this(context, Log.defaultWriter(context));
    }

    protected Log(Context context, PrintWriter defaultWriter) {
        this(context, defaultWriter, defaultWriter, defaultWriter);
    }

    public static Log instance(Context context) {
        Log instance = context.get(logKey);
        if (instance == null) {
            instance = new Log(context);
        }
        return instance;
    }

    public Name useSource(Name name) {
        Name prev = this.sourcename;
        this.sourcename = name;
        if (prev != this.sourcename) {
            this.buf = null;
        }
        return prev;
    }

    public Name currentSource() {
        return this.sourcename;
    }

    public void flush() {
        this.errWriter.flush();
        this.warnWriter.flush();
        this.noticeWriter.flush();
    }

    public void prompt() {
        if (this.promptOnError) {
            System.err.println(Log.getLocalizedString("resume.abort", new Object[0]));
            try {
                while (true) {
                    switch (System.in.read()) {
                        case 65: 
                        case 97: {
                            System.exit(-1);
                            return;
                        }
                        case 82: 
                        case 114: {
                            return;
                        }
                        case 88: 
                        case 120: {
                            throw new AssertionError((Object)"user abort");
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printErrLine(int line, int col, PrintWriter writer) {
        try {
            int lineEnd;
            if (this.buf == null) {
                FileInputStream in = new FileInputStream(this.sourcename.toString());
                this.buf = new byte[in.available()];
                in.read(this.buf);
                in.close();
                this.bp = 0;
                this.lastLine = 1;
            } else if (this.lastLine > line) {
                this.bp = 0;
                this.lastLine = 1;
            }
            block9: while (this.bp < this.buf.length && this.lastLine < line) {
                switch (this.buf[this.bp]) {
                    case 13: {
                        ++this.bp;
                        if (this.bp < this.buf.length && this.buf[this.bp] == 10) {
                            ++this.bp;
                        }
                        ++this.lastLine;
                        continue block9;
                    }
                    case 10: {
                        ++this.bp;
                        ++this.lastLine;
                        continue block9;
                    }
                }
                ++this.bp;
            }
            for (lineEnd = this.bp; lineEnd < this.buf.length && this.buf[lineEnd] != 13 && this.buf[lineEnd] != 10; ++lineEnd) {
            }
            Log.printLines(writer, new String(this.buf, this.bp, lineEnd - this.bp));
            if (col == 0) {
                col = 1;
            }
            byte[] ptr = new byte[col];
            for (int i = 0; i < col - 1; ++i) {
                ptr[i] = 32;
            }
            ptr[col - 1] = 94;
            Log.printLines(writer, new String(ptr, 0, col));
        }
        catch (IOException e) {
            Log.printLines(this.errWriter, Log.getLocalizedString("source.unavailable", new Object[0]));
        }
        finally {
            this.errWriter.flush();
        }
    }

    public static void printLines(PrintWriter writer, String msg) {
        int nl;
        while ((nl = msg.indexOf(10)) != -1) {
            writer.println(msg.substring(0, nl));
            msg = msg.substring(nl + 1);
        }
        if (msg.length() != 0) {
            writer.println(msg);
        }
    }

    private void printDiagnostic(int pos, String msg, PrintWriter writer) {
        if (pos == 0) {
            Log.printLines(writer, msg);
        } else {
            int line = Position.line(pos);
            int col = Position.column(pos);
            Log.printLines(writer, this.sourcename + ":" + line + ": " + msg);
            this.printErrLine(line, col, writer);
        }
        if (this.dumpOnError) {
            new RuntimeException().printStackTrace(writer);
        }
        writer.flush();
    }

    public void error(int pos, String key, Object ... args) {
        Pair<Name, Integer> coords;
        if (this.nerrors < this.MaxErrors && !this.recorded.contains(coords = new Pair<Name, Integer>(this.sourcename, pos))) {
            this.recorded.add(coords);
            this.printDiagnostic(pos, (pos == 0 ? Log.getText("compiler.err.error", new Object[0]) : "") + Log.getText("compiler.err." + key, args), this.errWriter);
            this.prompt();
            ++this.nerrors;
        }
    }

    public void warning(int pos, String key, Object ... args) {
        if (this.nwarnings < this.MaxWarnings && this.emitWarnings) {
            this.printDiagnostic(pos, Log.getText("compiler.warn.warning", new Object[0]) + Log.getText("compiler.warn." + key, args), this.warnWriter);
            this.prompt();
            ++this.nwarnings;
        }
    }

    public void note(String key, Object ... args) {
        if (this.emitWarnings) {
            this.noticeWriter.print(Log.getText("compiler.note.note", new Object[0]));
            String msg = Log.getText("compiler.note." + key, args);
            Log.printLines(this.noticeWriter, msg);
            this.noticeWriter.flush();
        }
    }

    public static String getLocalizedString(String key, Object ... args) {
        return Log.getText("compiler.misc." + key, args);
    }

    private static void initResource() {
        try {
            messageRB = ResourceBundle.getBundle(compilerRB);
        }
        catch (MissingResourceException e) {
            throw new Error("Fatal: Resource for compiler is missing");
        }
    }

    public static String getText(String key, Object ... _args) {
        String[] args = new String[_args.length];
        for (int i = 0; i < _args.length; ++i) {
            args[i] = "" + _args[i];
        }
        if (messageRB == null) {
            Log.initResource();
        }
        try {
            return MessageFormat.format(messageRB.getString(key), args);
        }
        catch (MissingResourceException e) {
            String msg = "compiler message file broken: key=" + key + " arguments={0}, {1}, {2}, {3}, {4}, {5}, {6}, {7}";
            return MessageFormat.format(msg, args);
        }
    }

    private void printRawError(int pos, String msg) {
        if (pos == 0) {
            Log.printLines(this.errWriter, "error: " + msg);
        } else {
            int line = Position.line(pos);
            int col = Position.column(pos);
            Log.printLines(this.errWriter, this.sourcename + ":" + line + ": " + msg);
            this.printErrLine(line, col, this.errWriter);
        }
        this.errWriter.flush();
    }

    public void rawError(int pos, String msg) {
        Pair<Name, Integer> coords;
        if (this.nerrors < this.MaxErrors && !this.recorded.contains(coords = new Pair<Name, Integer>(this.sourcename, pos))) {
            this.recorded.add(coords);
            this.printRawError(pos, msg);
            this.prompt();
            ++this.nerrors;
        }
        this.errWriter.flush();
    }

    public void rawWarning(int pos, String msg) {
        if (this.nwarnings < this.MaxWarnings && this.emitWarnings) {
            this.printRawError(pos, "warning: " + msg);
        }
        this.prompt();
        ++this.nwarnings;
        this.errWriter.flush();
    }
}

