/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.code;

import edu.rice.cs.nextgen.compiler.code.ClassFile;
import edu.rice.cs.nextgen.compiler.code.Code;
import edu.rice.cs.nextgen.compiler.code.ConstantPool;
import edu.rice.cs.nextgen.compiler.code.Flags;
import edu.rice.cs.nextgen.compiler.code.Kinds;
import edu.rice.cs.nextgen.compiler.code.Scope;
import edu.rice.cs.nextgen.compiler.code.Symbol;
import edu.rice.cs.nextgen.compiler.code.Type;
import edu.rice.cs.nextgen.compiler.code.TypeTags;
import edu.rice.cs.nextgen.compiler.main.CompilerOptions;
import edu.rice.cs.nextgen.compiler.util.Asserter;
import edu.rice.cs.nextgen.compiler.util.ByteBuffer;
import edu.rice.cs.nextgen.compiler.util.Converter;
import edu.rice.cs.nextgen.compiler.util.List;
import edu.rice.cs.nextgen.compiler.util.ListBox;
import edu.rice.cs.nextgen.compiler.util.Name;
import edu.rice.cs.nextgen.compiler.util.Names;
import edu.rice.cs.nextgen.compiler.util.Set;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassWriter
extends ClassFile
implements Flags,
Kinds,
TypeTags {
    public final File outputDirectory;
    private final CompilerOptions compilerOptions;
    public final short majorVersion;
    public final short minorVersion;
    private static final int DATA_BUF_SIZE = 65536;
    private static final int POOL_BUF_SIZE = 131072;
    private ByteBuffer objectOutputBuffer = new ByteBuffer(65536);
    private ByteBuffer constantPoolOutputBuffer = new ByteBuffer(131072);
    private ConstantPool constantPool;
    private Set<Symbol.ClassSymbol> innerClasses;
    private ListBox<Symbol.ClassSymbol> innerClassesQueue;

    public ClassWriter(CompilerOptions options) {
        this.compilerOptions = options;
        this.majorVersion = ClassWriter.classMajorVersion(options.getTargetVersion());
        this.minorVersion = ClassWriter.classMinorVersion(options.getTargetVersion());
        this.outputDirectory = options.getOutputDirectory();
    }

    void putChar(ByteBuffer buff, int op, int x) {
        buff.elements[op] = (byte)(x >> 8 & 0xFF);
        buff.elements[op + 1] = (byte)(x & 0xFF);
    }

    void putInt(ByteBuffer buf, int adr, int x) {
        buf.elements[adr] = (byte)(x >> 24 & 0xFF);
        buf.elements[adr + 1] = (byte)(x >> 16 & 0xFF);
        buf.elements[adr + 2] = (byte)(x >> 8 & 0xFF);
        buf.elements[adr + 3] = (byte)(x & 0xFF);
    }

    void assembleSignature(ByteBuffer byteBuffer, Type type) {
        switch (type.tag) {
            case 1: {
                byteBuffer.appendByte(66);
                break;
            }
            case 3: {
                byteBuffer.appendByte(83);
                break;
            }
            case 2: {
                byteBuffer.appendByte(67);
                break;
            }
            case 4: {
                byteBuffer.appendByte(73);
                break;
            }
            case 5: {
                byteBuffer.appendByte(74);
                break;
            }
            case 6: {
                byteBuffer.appendByte(70);
                break;
            }
            case 7: {
                byteBuffer.appendByte(68);
                break;
            }
            case 8: {
                byteBuffer.appendByte(90);
                break;
            }
            case 9: {
                byteBuffer.appendByte(86);
                break;
            }
            case 10: {
                this.assembleClassSignature(type, byteBuffer);
                break;
            }
            case 11: {
                Type.ArrayType arrayType = (Type.ArrayType)type;
                byteBuffer.appendByte(91);
                this.assembleSignature(byteBuffer, arrayType.elementType);
                break;
            }
            case 12: {
                Type.MethodType methodType = (Type.MethodType)type;
                byteBuffer.appendByte(40);
                this.assembleSignature(byteBuffer, methodType.paramTypes);
                byteBuffer.appendByte(41);
                this.assembleSignature(byteBuffer, methodType.returnType);
                break;
            }
            case 14: {
                byteBuffer.appendByte(84);
                byteBuffer.appendName(type.typeSymbol.name);
                byteBuffer.appendByte(59);
                break;
            }
            case 15: {
                Type.ForAll forAllType = (Type.ForAll)type;
                this.assembleParamsSignature(byteBuffer, forAllType.typeParams);
                this.assembleSignature(byteBuffer, forAllType.quantifiedType);
                break;
            }
            default: {
                throw new InternalError(new StringBuffer().append("typeSig").append(type.tag).toString());
            }
        }
    }

    private void assembleClassSignature(Type type, ByteBuffer byteBuffer) {
        Type.ClassType classType = (Type.ClassType)type;
        Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)classType.typeSymbol;
        this.enterInner(classSymbol);
        if (classType.enclosingType().allParams().nonEmpty()) {
            this.assembleSignature(byteBuffer, classType.enclosingType());
            byteBuffer.appendByte(46);
        }
        byteBuffer.appendByte(76);
        byteBuffer.appendBytes(ClassWriter.externalize(classSymbol.flatname));
        if (classType.getTypeParams().nonEmpty()) {
            byteBuffer.appendByte(60);
            this.assembleSignature(byteBuffer, classType.getTypeParams());
            byteBuffer.appendByte(62);
        }
        byteBuffer.appendByte(59);
    }

    void assembleSignature(ByteBuffer byteBuffer, List<Type> types) {
        List<Type> ts = types;
        while (ts.nonEmpty()) {
            this.assembleSignature(byteBuffer, ts.getFirst());
            ts = ts.getRest();
        }
    }

    void assembleParamsSignature(ByteBuffer buf, List<Type> typarams) {
        buf.appendByte(60);
        List<Type> ts = typarams;
        while (ts.nonEmpty()) {
            Type.TypeVar tvar = (Type.TypeVar)ts.getFirst();
            buf.appendName(tvar.typeSymbol.name);
            buf.appendByte(58);
            this.assembleSignature(buf, tvar.bound);
            ts = ts.getRest();
        }
        buf.appendByte(62);
    }

    Name typeSignature(Type type) {
        ByteBuffer buf = new ByteBuffer();
        this.assembleSignature(buf, type);
        return buf.toName();
    }

    public Name getExternalClassName(Type t) {
        if (t.tag == 10) {
            return Name.fromUtf(ClassWriter.externalize(t.typeSymbol.flatName()));
        }
        if (t.tag == 11) {
            return this.typeSignature(t.erasure());
        }
        throw new InternalError("xClassName");
    }

    void writePool(ConstantPool pool) {
        int poolCountIdx = this.constantPoolOutputBuffer.length;
        this.constantPoolOutputBuffer.appendChar(0);
        for (int i = 1; i < pool.nextConstantPosition; ++i) {
            Object value = pool.constantPool[i];
            Asserter._assert(value != null);
            if (value instanceof Name) {
                this.constantPoolOutputBuffer.appendByte(1);
                byte[] bs = ((Name)value).toUtf();
                this.constantPoolOutputBuffer.appendChar(bs.length);
                this.constantPoolOutputBuffer.appendBytes(bs, 0, bs.length);
                continue;
            }
            if (value instanceof Symbol.ClassSymbol) {
                Symbol.ClassSymbol c = (Symbol.ClassSymbol)value;
                if (c.owner.kind == 2) {
                    pool.put(c.owner);
                }
                this.constantPoolOutputBuffer.appendByte(7);
                this.constantPoolOutputBuffer.appendChar(pool.put(Name.fromUtf(ClassWriter.externalize(c.flatname))));
                this.enterInner(c);
                continue;
            }
            if (value instanceof Symbol.MethodSymbol) {
                Symbol.MethodSymbol m = (Symbol.MethodSymbol)value;
                this.constantPoolOutputBuffer.appendByte((m.owner.flags() & 0x200) != 0 ? 11 : 10);
                this.constantPoolOutputBuffer.appendChar(pool.put(m.owner));
                this.constantPoolOutputBuffer.appendChar(pool.put(this.nameType(m)));
                continue;
            }
            if (value instanceof Symbol.VarSymbol) {
                Symbol.VarSymbol v = (Symbol.VarSymbol)value;
                this.constantPoolOutputBuffer.appendByte(9);
                this.constantPoolOutputBuffer.appendChar(pool.put(v.owner));
                this.constantPoolOutputBuffer.appendChar(pool.put(this.nameType(v)));
                continue;
            }
            if (value instanceof ClassFile.NameAndType) {
                ClassFile.NameAndType nt = (ClassFile.NameAndType)value;
                this.constantPoolOutputBuffer.appendByte(12);
                this.constantPoolOutputBuffer.appendChar(pool.put(nt.first));
                this.constantPoolOutputBuffer.appendChar(pool.put(this.typeSignature((Type)nt.second)));
                continue;
            }
            if (value instanceof Integer) {
                this.constantPoolOutputBuffer.appendByte(3);
                this.constantPoolOutputBuffer.appendInt((Integer)value);
                continue;
            }
            if (value instanceof Long) {
                this.constantPoolOutputBuffer.appendByte(5);
                this.constantPoolOutputBuffer.appendLong((Long)value);
                ++i;
                continue;
            }
            if (value instanceof Float) {
                this.constantPoolOutputBuffer.appendByte(4);
                this.constantPoolOutputBuffer.appendFloat(((Float)value).floatValue());
                continue;
            }
            if (value instanceof Double) {
                this.constantPoolOutputBuffer.appendByte(6);
                this.constantPoolOutputBuffer.appendDouble((Double)value);
                ++i;
                continue;
            }
            if (value instanceof String) {
                this.constantPoolOutputBuffer.appendByte(8);
                this.constantPoolOutputBuffer.appendChar(pool.put(Name.fromString((String)value)));
                continue;
            }
            if (value instanceof Type) {
                this.constantPoolOutputBuffer.appendByte(7);
                this.constantPoolOutputBuffer.appendChar(pool.put(this.getExternalClassName((Type)value)));
                continue;
            }
            throw new InternalError(new StringBuffer().append("writePool ").append(value).toString());
        }
        this.putChar(this.constantPoolOutputBuffer, poolCountIdx, pool.nextConstantPosition);
    }

    Name fieldName(Symbol sym) {
        if (this.compilerOptions.scramble() && (sym.flags() & 2) != 0 || this.compilerOptions.scrambleAll() && (sym.flags() & 5) == 0) {
            return Name.fromString(new StringBuffer().append("_$").append(sym.name.index).toString());
        }
        return sym.name;
    }

    ClassFile.NameAndType nameType(Symbol sym) {
        return new ClassFile.NameAndType(this.fieldName(sym), sym.externalType());
    }

    int writeAttribute(Name attrName) {
        this.objectOutputBuffer.appendChar(this.constantPool.put(attrName));
        this.objectOutputBuffer.appendInt(0);
        return this.objectOutputBuffer.length;
    }

    void endAttr(int index) {
        this.putInt(this.objectOutputBuffer, index - 4, this.objectOutputBuffer.length - index);
    }

    int beginAttrs() {
        this.objectOutputBuffer.appendChar(0);
        return this.objectOutputBuffer.length;
    }

    void endAttrs(int index, int count) {
        this.putChar(this.objectOutputBuffer, index - 2, count);
    }

    void enterInner(Symbol.ClassSymbol c) {
        if (!(c.owner.kind == 1 || c.templateClass() || this.innerClasses != null && this.innerClasses.contains(c))) {
            if (c.owner.kind == 2) {
                this.enterInner((Symbol.ClassSymbol)c.owner);
            }
            this.constantPool.put(c);
            this.constantPool.put(c.name);
            if (this.innerClasses == null) {
                this.innerClasses = Set.make();
                this.innerClassesQueue = new ListBox();
                this.constantPool.put(Names.InnerClasses);
            }
            this.innerClasses.put(c);
            this.innerClassesQueue.insertEnd(c);
        }
    }

    void writeField(Symbol.VarSymbol v) {
        int alenIdx;
        this.objectOutputBuffer.appendChar(v.flags());
        this.objectOutputBuffer.appendChar(this.constantPool.put(this.fieldName(v)));
        this.objectOutputBuffer.appendChar(this.constantPool.put(this.typeSignature(v.erasure())));
        int acountIdx = this.beginAttrs();
        int acount = 0;
        if (v.constantValue != null) {
            alenIdx = this.writeAttribute(Names.ConstantValue);
            this.objectOutputBuffer.appendChar(this.constantPool.put(v.constantValue));
            this.endAttr(alenIdx);
            ++acount;
        }
        if ((v.flags() & 0x20000) != 0) {
            alenIdx = this.writeAttribute(Names.Deprecated);
            this.endAttr(alenIdx);
            ++acount;
        }
        if ((v.flags() & 0x10000) != 0) {
            alenIdx = this.writeAttribute(Names.Synthetic);
            this.endAttr(alenIdx);
            ++acount;
        }
        if (v.type != v.erasure()) {
            alenIdx = this.writeAttribute(Names.Signature);
            this.objectOutputBuffer.appendChar(this.constantPool.put(this.typeSignature(v.type)));
            this.endAttr(alenIdx);
            ++acount;
        }
        this.endAttrs(acountIdx, acount);
    }

    void writeMethod(Symbol.MethodSymbol m) {
        int alenIdx;
        List<Symbol.ClassSymbol> thrown;
        int nthrown;
        this.objectOutputBuffer.appendChar(m.flags());
        this.objectOutputBuffer.appendChar(this.constantPool.put(this.fieldName(m)));
        this.objectOutputBuffer.appendChar(this.constantPool.put(this.typeSignature(m.externalType())));
        int acountIdx = this.beginAttrs();
        int acount = 0;
        if (m.byteCodes != null) {
            int alenIdx2 = this.writeAttribute(Names.Code);
            this.writeCode(m.byteCodes);
            this.endAttr(alenIdx2);
            ++acount;
        }
        if ((nthrown = (thrown = m.type.thrown()).length()) != 0) {
            alenIdx = this.writeAttribute(Names.Exceptions);
            this.objectOutputBuffer.appendChar(nthrown);
            List<Symbol.ClassSymbol> l = thrown;
            while (l.nonEmpty()) {
                this.objectOutputBuffer.appendChar(this.constantPool.put(l.getFirst()));
                l = l.getRest();
            }
            this.endAttr(alenIdx);
            ++acount;
        }
        if ((m.flags() & 0x20000) != 0) {
            alenIdx = this.writeAttribute(Names.Deprecated);
            this.endAttr(alenIdx);
            ++acount;
        }
        if ((m.flags() & 0x10000) != 0) {
            alenIdx = this.writeAttribute(Names.Synthetic);
            this.endAttr(alenIdx);
            ++acount;
        }
        if (m.type != m.erasure()) {
            alenIdx = this.writeAttribute(Names.Signature);
            this.objectOutputBuffer.appendChar(this.constantPool.put(this.typeSignature(m.type)));
            this.endAttr(alenIdx);
            ++acount;
        }
        this.endAttrs(acountIdx, acount);
    }

    void writeCode(Code code) {
        int i;
        int alenIdx;
        this.objectOutputBuffer.appendChar(code.maxStackSize);
        this.objectOutputBuffer.appendChar(code.maxLocals);
        this.objectOutputBuffer.appendInt(code.byteCodeIndex);
        this.objectOutputBuffer.appendBytes(code.byteCodeArray, 0, code.byteCodeIndex);
        this.objectOutputBuffer.appendChar(code.catchInfo.length());
        List<char[]> l = code.catchInfo.toList();
        while (l.nonEmpty()) {
            for (int i2 = 0; i2 < l.getFirst().length; ++i2) {
                this.objectOutputBuffer.appendChar(l.getFirst()[i2]);
            }
            l = l.getRest();
        }
        int acountIdx = this.beginAttrs();
        int acount = 0;
        if (code.lineInfo.nonEmpty()) {
            alenIdx = this.writeAttribute(Names.LineNumberTable);
            this.objectOutputBuffer.appendChar(code.lineInfo.length());
            List<char[]> l2 = code.lineInfo.reverse();
            while (l2.nonEmpty()) {
                for (i = 0; i < l2.getFirst().length; ++i) {
                    this.objectOutputBuffer.appendChar(l2.getFirst()[i]);
                }
                l2 = l2.getRest();
            }
            this.endAttr(alenIdx);
            ++acount;
        }
        if (code.varCount > 0) {
            alenIdx = this.writeAttribute(Names.LocalVariableTable);
            int nvars = code.varCount;
            this.objectOutputBuffer.appendChar(nvars);
            i = 0;
            while (nvars > 0) {
                if (code.localVar[i] != null) {
                    this.objectOutputBuffer.appendChar(code.localVarStartPc[i]);
                    this.objectOutputBuffer.appendChar(code.localVarLength[i]);
                    this.objectOutputBuffer.appendChar(this.constantPool.put(code.localVar[i].name));
                    this.objectOutputBuffer.appendChar(this.constantPool.put(this.typeSignature(code.localVar[i].erasure())));
                    this.objectOutputBuffer.appendChar(code.localVarRegister[i]);
                    --nvars;
                }
                ++i;
            }
            this.endAttr(alenIdx);
            ++acount;
        }
        this.endAttrs(acountIdx, acount);
    }

    void writeFields(Scope.Entry e) {
        if (e != null) {
            this.writeFields(e.sibling);
            if (e.symbol.kind == 4) {
                this.writeField((Symbol.VarSymbol)e.symbol);
            }
        }
    }

    void writeMethods(Scope.Entry e) {
        if (e != null) {
            this.writeMethods(e.sibling);
            if (e.symbol.kind == 16) {
                this.writeMethod((Symbol.MethodSymbol)e.symbol);
            }
        }
    }

    public void writeClassFile(OutputStream outputStream, Symbol.ClassSymbol classSymbol) throws IOException {
        this.objectOutputBuffer.reset();
        this.constantPoolOutputBuffer.reset();
        this.constantPool = classSymbol.constantPool;
        this.innerClasses = null;
        this.innerClassesQueue = null;
        Type supertype = classSymbol.type.getSuperType();
        List<Type> interfaces = classSymbol.type.getInterfaces();
        List<Type> typeParams = classSymbol.type.getTypeParams();
        int flags = classSymbol.flags();
        if ((flags & 4) != 0) {
            flags |= 1;
        }
        this.objectOutputBuffer.appendChar(flags & 0xE11 | 0x20);
        this.objectOutputBuffer.appendChar(this.constantPool.put(classSymbol));
        this.objectOutputBuffer.appendChar(supertype.tag == 10 ? this.constantPool.put(supertype.typeSymbol) : 0);
        this.objectOutputBuffer.appendChar(interfaces.length());
        List<Type> l = interfaces;
        while (l.nonEmpty()) {
            this.objectOutputBuffer.appendChar(this.constantPool.put(l.getFirst().typeSymbol));
            l = l.getRest();
        }
        int fieldsCount = 0;
        int methodsCount = 0;
        Scope.Entry e = classSymbol.members().entries;
        while (e != null) {
            switch (e.symbol.kind) {
                case 4: {
                    ++fieldsCount;
                    break;
                }
                case 16: {
                    ++methodsCount;
                    break;
                }
                case 2: {
                    this.enterInner((Symbol.ClassSymbol)e.symbol);
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
            e = e.sibling;
        }
        this.objectOutputBuffer.appendChar(fieldsCount);
        this.writeFields(classSymbol.members().entries);
        this.objectOutputBuffer.appendChar(methodsCount);
        this.writeMethods(classSymbol.members().entries);
        int acountIdx = this.beginAttrs();
        int acount = 0;
        boolean sigReq = typeParams.length() != 0 || supertype.getTypeParams().length() != 0;
        List<Type> l2 = interfaces;
        while (!sigReq && l2.nonEmpty()) {
            sigReq = l2.getFirst().getTypeParams().length() != 0;
            l2 = l2.getRest();
        }
        if (sigReq) {
            int alenIdx = this.writeAttribute(Names.Signature);
            ByteBuffer buf = new ByteBuffer();
            if (typeParams.length() != 0) {
                this.assembleParamsSignature(buf, typeParams);
            }
            this.assembleSignature(buf, supertype);
            List<Type> l3 = interfaces;
            while (l3.nonEmpty()) {
                this.assembleSignature(buf, l3.getFirst());
                l3 = l3.getRest();
            }
            this.objectOutputBuffer.appendChar(this.constantPool.put(buf.toName()));
            this.endAttr(alenIdx);
            ++acount;
        }
        if (classSymbol.sourcefile != null) {
            int alenIdx = this.writeAttribute(Names.SourceFile);
            this.objectOutputBuffer.appendChar(classSymbol.constantPool.put(classSymbol.sourcefile));
            this.endAttr(alenIdx);
            ++acount;
        }
        if ((classSymbol.flags() & 0x10000) != 0) {
            int alenIdx = this.writeAttribute(Names.Synthetic);
            this.endAttr(alenIdx);
            ++acount;
        }
        if ((classSymbol.flags() & 0x20000) != 0) {
            int alenIdx = this.writeAttribute(Names.Deprecated);
            this.endAttr(alenIdx);
            ++acount;
        }
        this.constantPoolOutputBuffer.appendInt(-889275714);
        this.constantPoolOutputBuffer.appendChar(this.minorVersion);
        this.constantPoolOutputBuffer.appendChar(this.majorVersion);
        this.writePool(classSymbol.constantPool);
        if (classSymbol.constantPool.nextConstantPosition > 65535) {
            throw new IOException("too many constants");
        }
        if (this.innerClasses != null) {
            int alenIdx = this.writeAttribute(Names.InnerClasses);
            this.objectOutputBuffer.appendChar(this.innerClassesQueue.length());
            List<Symbol.ClassSymbol> l4 = this.innerClassesQueue.toList();
            while (l4.nonEmpty()) {
                Symbol.ClassSymbol inner = l4.getFirst();
                this.objectOutputBuffer.appendChar(this.constantPool.get(inner));
                this.objectOutputBuffer.appendChar(inner.owner.kind == 2 ? this.constantPool.get(inner.owner) : 0);
                this.objectOutputBuffer.appendChar(inner.name.length != 0 ? this.constantPool.get(inner.name) : 0);
                this.objectOutputBuffer.appendChar(inner.flags());
                l4 = l4.getRest();
            }
            this.endAttr(alenIdx);
            ++acount;
        }
        this.endAttrs(acountIdx, acount);
        this.constantPoolOutputBuffer.appendBytes(this.objectOutputBuffer.elements, 0, this.objectOutputBuffer.length);
        outputStream.write(this.constantPoolOutputBuffer.elements, 0, this.constantPoolOutputBuffer.length);
        classSymbol.constantPool = null;
    }

    public File outputFile(Symbol.ClassSymbol c, String extension) throws IOException {
        if (this.outputDirectory == null) {
            String filename = new StringBuffer().append(Converter.shortName(c.flatname)).append(extension).toString();
            if (c.sourcefile == null) {
                return new File(filename);
            }
            String sourcedir = new File(c.sourcefile.toString()).getParent();
            if (sourcedir == null) {
                return new File(filename);
            }
            return new File(sourcedir, filename);
        }
        return this.outputFile(this.outputDirectory, c.flatname.toString(), extension);
    }

    File outputFile(File outdir, String name, String extension) throws IOException {
        int start = 0;
        int end = name.indexOf(46);
        while (end >= start) {
            if (!(outdir = new File(outdir, name.substring(start, end))).exists()) {
                outdir.mkdir();
            }
            start = end + 1;
            end = name.indexOf(46, start);
        }
        return new File(outdir, new StringBuffer().append(name.substring(start)).append(extension).toString());
    }
}

