/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.code;

import edu.rice.cs.nextgen.compiler.code.ClassReader;
import edu.rice.cs.nextgen.compiler.code.Code;
import edu.rice.cs.nextgen.compiler.code.ConstantPool;
import edu.rice.cs.nextgen.compiler.code.Symbol;
import edu.rice.cs.nextgen.compiler.main.CompilerOptions;
import edu.rice.cs.nextgen.compiler.util.Name;
import edu.rice.cs.nextgen.compiler.util.Names;

public class CompleteClassReader
extends ClassReader {
    public CompleteClassReader(CompilerOptions options) {
        super(options);
    }

    void indexPool() {
        super.indexPool();
        for (int i = 1; i < this.constantPool.length; ++i) {
            this.readPool(i);
        }
    }

    void readClass(Symbol.ClassSymbol c) {
        c.constantPool = new ConstantPool(this.constantPool.length, this.constantPool);
        super.readClass(c);
    }

    void readAttr(Symbol sym, Name attrName, int attrLen) {
        if (attrName == Names.Code) {
            ((Symbol.MethodSymbol)sym).byteCodes = this.readCode(sym);
        } else {
            super.readAttr(sym, attrName, attrLen);
        }
    }

    private Code readCode(Symbol owner) {
        Code code = new Code(false, true);
        code.maxStackSize = this.nextChar();
        code.maxLocals = this.nextChar();
        code.byteCodeIndex = this.nextInt();
        code.byteCodeArray = new byte[code.byteCodeIndex];
        System.arraycopy(this.classFileBytes, this.classFilePosition, code.byteCodeArray, 0, code.byteCodeIndex);
        this.classFilePosition += code.byteCodeIndex;
        int ncatches = this.nextChar();
        for (int i = 0; i < ncatches; ++i) {
            code.addCatch(this.nextChar(), this.nextChar(), this.nextChar(), this.nextChar());
        }
        int ac = this.nextChar();
        for (int i = 0; i < ac; ++i) {
            Name attrName = this.readName(this.nextChar());
            int attrLen = this.nextInt();
            if (attrName == Names.LineNumberTable) {
                int nlines = this.nextChar();
                for (int j = 0; j < nlines; ++j) {
                    code.addLineNumber(this.nextChar(), this.nextChar());
                }
                continue;
            }
            if (attrName == Names.LocalVariableTable) {
                code.varCount = this.nextChar();
                code.localVarStartPc = new char[code.varCount];
                code.localVarLength = new char[code.varCount];
                code.localVarRegister = new char[code.varCount];
                code.localVar = new Symbol.VarSymbol[code.varCount];
                for (int j = 0; j < code.varCount; ++j) {
                    code.localVarStartPc[j] = this.nextChar();
                    code.localVarLength[j] = this.nextChar();
                    code.localVar[j] = new Symbol.VarSymbol(0, this.readName(this.nextChar()), this.readType(this.nextChar()), owner);
                    code.localVarRegister[j] = this.nextChar();
                    code.localVar[j].address = code.localVarRegister[j];
                }
                continue;
            }
            this.unrecogized(attrName);
            this.classFilePosition += attrLen;
        }
        return code;
    }
}

