/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.code;

import edu.rice.cs.nextgen.compiler.code.Code;
import edu.rice.cs.nextgen.compiler.code.ConstantPool;
import edu.rice.cs.nextgen.compiler.code.Flags;
import edu.rice.cs.nextgen.compiler.code.Kinds;
import edu.rice.cs.nextgen.compiler.code.Scope;
import edu.rice.cs.nextgen.compiler.code.Type;
import edu.rice.cs.nextgen.compiler.code.TypeTags;
import edu.rice.cs.nextgen.compiler.flatten.SnippetClosure;
import edu.rice.cs.nextgen.compiler.instrument.PrintableObject;
import edu.rice.cs.nextgen.compiler.tree.Tree;
import edu.rice.cs.nextgen.compiler.util.Empty;
import edu.rice.cs.nextgen.compiler.util.FileEntry;
import edu.rice.cs.nextgen.compiler.util.Filter;
import edu.rice.cs.nextgen.compiler.util.List;
import edu.rice.cs.nextgen.compiler.util.Name;
import edu.rice.cs.nextgen.compiler.util.Names;

public abstract class Symbol
extends PrintableObject
implements Flags,
Kinds,
TypeTags {
    public static PackageSymbol EMPTY_PACKAGE_SYMBOL;
    public static TypeSymbol NO_SYMBOL;
    public static ClassSymbol ERROR_SYMBOL;
    public int kind;
    public int flags_field;
    public Name name;
    public Type type;
    public Symbol owner;
    public Completer completer;
    public Type erasure_field;
    public static int count;

    public int flags() {
        return this.flags_field;
    }

    public void setFlags(int f) {
        this.flags_field = f;
    }

    public Symbol(int kind, int flags, Name name, Type type, Symbol owner) {
        this.kind = kind;
        this.flags_field = flags;
        this.name = name;
        this.type = type;
        this.owner = owner;
        this.completer = null;
        this.erasure_field = null;
    }

    public boolean equals(Object o) {
        return o != null && this.getClass() == o.getClass() && this.kind == ((Symbol)o).kind && this.name == ((Symbol)o).name && this.owner == ((Symbol)o).owner;
    }

    static void init() {
        EMPTY_PACKAGE_SYMBOL = new PackageSymbol(Names.empty, null);
        NO_SYMBOL = new TypeSymbol(0, Names.empty, Type.NO_TYPE, EMPTY_PACKAGE_SYMBOL);
        Symbol.NO_SYMBOL.kind = 0;
        ERROR_SYMBOL = new ClassSymbol(9, Names.any, Type.ERROR_TYPE, EMPTY_PACKAGE_SYMBOL);
        Symbol.ERROR_SYMBOL.kind = 31;
        Symbol.ERROR_SYMBOL.members_field = Scope.ERROR;
        Scope.ERROR.owningSymbol = ERROR_SYMBOL;
        Type.init();
    }

    public static void reset() {
        Symbol.EMPTY_PACKAGE_SYMBOL.members_field = null;
    }

    public String toString() {
        return this.name.toString();
    }

    public void print() {
        this.print(Filter.NO_FILTER);
    }

    public Filter print(Filter f) {
        Symbol.leftBracket();
        Symbol.print("Symbol ");
        Symbol.print(this.name.toString());
        Symbol.rightBracket();
        return f;
    }

    public String location() {
        return this.owner.name == null || this.owner.name.length == 0 ? "" : " in " + this.owner;
    }

    public Type erasure() {
        if (this.erasure_field == null) {
            this.erasure_field = this.type.erasure();
        }
        return this.erasure_field;
    }

    public Type externalType() {
        Type t = this.erasure();
        if (this.name == Names.init && this.owner.isNested()) {
            Type this0type = this.owner.type.enclosingType().erasure();
            return new Type.MethodType(t.argTypes().cons(this0type), t.returnType(), t.thrown());
        }
        return t;
    }

    public boolean isLocal() {
        return (this.owner.kind & 0x1C) != 0 || this.owner.kind == 2 && this.owner.isLocal();
    }

    public boolean isConstructor() {
        return this.name == Names.init;
    }

    public boolean isStatic() {
        return (this.flags_field & 8) != 0;
    }

    public boolean isAbstract() {
        return (this.flags_field & 0x400) != 0;
    }

    public Name fullName() {
        return this.name;
    }

    public Name flatName() {
        return this.fullName();
    }

    public boolean isInterface() {
        return (this.flags_field & 0x200) != 0;
    }

    public boolean isFinal() {
        return (this.flags_field & 0x10) != 0;
    }

    public boolean isNested() {
        return this.type.enclosingType().tag == 10 && (this.flags() & 0x200) == 0;
    }

    public ClassSymbol enclClass() {
        Symbol c = this;
        while (c != null && (c.kind & 2) == 0) {
            c = c.owner;
        }
        return (ClassSymbol)c;
    }

    public ClassSymbol outermostClass() {
        Symbol sym = this;
        Symbol prev = null;
        while (sym.kind != 1) {
            prev = sym;
            sym = sym.owner;
        }
        return (ClassSymbol)prev;
    }

    public boolean subclass(Symbol base) {
        throw new InternalError("subclass " + this);
    }

    public Symbol complete() throws CompletionFailure {
        if (this.completer != null) {
            Completer c = this.completer;
            this.completer = null;
            c.complete(this);
        }
        return this;
    }

    static {
        Symbol.init();
        count = 0;
    }

    public static class CompletionFailure
    extends RuntimeException {
        public Symbol sym;
        public String errmsg;

        public CompletionFailure(Symbol sym, String errmsg) {
            this.sym = sym;
            this.errmsg = errmsg;
        }

        public String getMessage() {
            return this.errmsg;
        }
    }

    public static interface Completer {
        public void complete(Symbol var1) throws CompletionFailure;
    }

    public static class OperatorSymbol
    extends MethodSymbol {
        public int opcode;

        public OperatorSymbol(Name name, Type type, int opcode, Symbol owner) {
            super(9, name, type, owner);
            this.opcode = opcode;
        }

        public Filter print(Filter f) {
            OperatorSymbol.leftBracket();
            OperatorSymbol.print("OperatorSymbol ");
            OperatorSymbol.include(this.name);
            OperatorSymbol.rightBracket();
            return f;
        }
    }

    public static class MethodSymbol
    extends Symbol {
        public Code byteCodes = null;
        private boolean isSnippet = false;
        private ClassSymbol templateClass = null;
        public static final List<MethodSymbol> EMPTY_LIST = new Empty<MethodSymbol>();

        public MethodSymbol(int flags, Name name, Type type, Symbol owner) {
            super(16, flags, name, type, owner);
        }

        public static MethodSymbol makeSnippetSymbol(int flags, Name name, Type type, Symbol owner) {
            MethodSymbol snipSym = new MethodSymbol(flags, name, type, owner);
            snipSym.isSnippet = true;
            return snipSym;
        }

        public void setTemplateClass(ClassSymbol tc) {
            this.templateClass = tc;
        }

        public ClassSymbol getTemplateClass() {
            return this.templateClass;
        }

        public boolean isSnippet() {
            return this.isSnippet;
        }

        public String toString() {
            if ((this.flags() & 0x80000) != 0) {
                return "body of " + this.owner;
            }
            String s = this.name == Names.init ? "constructor " + this.owner.name : "method " + this.name;
            return s + "(" + this.type.argTypes().toString() + ")";
        }

        public Filter print(Filter f) {
            MethodSymbol.leftBracket();
            MethodSymbol.print("MethodSymbol ");
            MethodSymbol.include(this.name);
            if (this.byteCodes != null) {
                MethodSymbol.newline();
                MethodSymbol.include(this.byteCodes);
            }
            MethodSymbol.rightBracket();
            return f;
        }

        public String location() {
            Symbol impl;
            if ((this.flags_field & 0x100000) != 0 && (impl = this.implemented((TypeSymbol)this.owner)) != null) {
                return impl.location();
            }
            return super.location();
        }

        private Symbol implemented(TypeSymbol c) {
            Symbol impl = null;
            List<Type> is = c.type.getInterfaces();
            while (impl == null && is.nonEmpty()) {
                TypeSymbol i = is.getFirst().typeSymbol;
                Scope.Entry e = i.members().lookup(this.name);
                while (impl == null && e.scope != null) {
                    if (this.overrides(e.symbol, (TypeSymbol)this.owner) && this.type.returnType().isSameType(this.owner.type.memberType(e.symbol).returnType())) {
                        impl = e.symbol;
                    }
                    if (impl == null) {
                        impl = this.implemented(i);
                    }
                    e = e.next();
                }
                is = is.getRest();
            }
            return impl;
        }

        public boolean overrides(Symbol other, TypeSymbol origin) {
            return !this.isConstructor() && other.kind == 16 && (other.flags() & 2) == 0 && origin.type.memberType(this).sameArgs(origin.type.memberType(other));
        }

        public MethodSymbol implementation(TypeSymbol origin) {
            Type t = origin.type;
            while (t.tag == 10) {
                TypeSymbol c = t.typeSymbol;
                Scope.Entry e = c.members().lookup(this.name);
                while (e.scope != null) {
                    if (this.overrides(e.symbol, origin)) {
                        return (MethodSymbol)e.symbol;
                    }
                    e = e.next();
                }
                t = t.getSuperType();
            }
            return null;
        }
    }

    public static class VarSymbol
    extends Symbol {
        public int position = 0;
        public int address = -1;
        public Object constantValue;
        public static final List<VarSymbol> EMPTY_LIST = new Empty<VarSymbol>();

        public VarSymbol(int flags, Name name, Type type, Symbol owner) {
            super(4, flags, name, type, owner);
        }

        public String toString() {
            return "variable " + this.name;
        }

        public Filter print(Filter f) {
            VarSymbol.leftBracket();
            VarSymbol.print("VarSymbol ");
            VarSymbol.print(this.name.toString());
            VarSymbol.rightBracket();
            return f;
        }
    }

    public static class ClassInstantiationSymbol
    extends ClassSymbol {
        private Type baseType;

        public ClassInstantiationSymbol(int flags, Name name, Type type, Symbol owner, Type base) {
            super(flags, name, type, owner);
            this.baseType = base;
        }

        public Filter print(Filter f) {
            Filter result = f;
            ClassInstantiationSymbol.leftBracket();
            ClassInstantiationSymbol.print("ClassInstantiationSymbol");
            ClassInstantiationSymbol.space();
            ClassInstantiationSymbol.include(this.name);
            ClassInstantiationSymbol.include(" fullname: ", this.fullname, false);
            ClassInstantiationSymbol.include(" flatname: ", this.flatname, false);
            ClassInstantiationSymbol.newline();
            ClassInstantiationSymbol.print("members (cyclic references have been filtered):");
            ClassInstantiationSymbol.newline();
            if (this.members_field != null) {
                result = this.members_field.print(new Filter(){
                    final /* synthetic */ Filter val$f;
                    final /* synthetic */ ClassInstantiationSymbol this$0;
                    {
                        this.this$0 = this$0;
                        this.val$f = val$f;
                    }

                    public boolean ignore(Object o) {
                        return this.val$f.ignore(o) || o == this.this$0;
                    }
                });
            }
            ClassInstantiationSymbol.rightBracket();
            return result;
        }

        public String toString() {
            return ((this.flags_field & 0x200) != 0 ? "interface " : "class ") + "instantiation " + this.className();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassSymbol
    extends TypeSymbol {
        public static final List<ClassSymbol> EMPTY_LIST = new Empty<ClassSymbol>();
        public Scope members_field = null;
        public Name fullname;
        public Name flatname;
        public Name sourcefile;
        public FileEntry classfile;
        public ConstantPool constantPool;
        private int rank_field = -1;
        private List<SnippetClosure> newSnipClosures = SnippetClosure.EMPTY_LIST;
        private List<SnippetClosure> snipClosures = null;
        private Tree.ClassDef templateClass = null;

        public ClassSymbol(int flags, Name name, Type type, Symbol owner) {
            super(flags, name, type, owner);
            this.fullname = ClassSymbol.formFullName(name, owner);
            this.flatname = ClassSymbol.formFlatName(name, owner);
            this.sourcefile = null;
            this.classfile = null;
            this.constantPool = null;
        }

        public ClassSymbol(int flags, Name name, Symbol owner) {
            this(flags, name, new Type.ClassType(Type.NO_TYPE, Type.EMPTY_LIST, null), owner);
            if (this.type != null) {
                this.type.typeSymbol = this;
            }
        }

        public boolean isInner() {
            return this.owner.kind == 12 || this.owner.kind == 16 || this.owner.kind == 2 && !this.isStatic();
        }

        public void setNewSnipClosures(List<SnippetClosure> slist) {
            this.newSnipClosures = slist;
        }

        public List<SnippetClosure> getSnipClosures() {
            if (this.snipClosures == null) {
                Type supertype = this.type.getSuperType();
                if (supertype.isParameterized()) {
                    ClassSymbol superSymbol = (ClassSymbol)supertype.typeSymbol;
                    List<SnippetClosure> superSnipClosures = superSymbol.getSnipClosures();
                    List<Type> superParams = supertype.allParams();
                    List<Type> snipParams = supertype.typeSymbol.type.allParams();
                    List<SnippetClosure> tail = superSnipClosures;
                    while (!tail.isEmpty()) {
                        SnippetClosure next = tail.getFirst();
                        Tree.Snippetable expr = next.expression;
                        Type exprTypeArg = expr.getTypeArg();
                        Type newExprTypeArg = exprTypeArg.substitute(snipParams, superParams);
                        if (newExprTypeArg != exprTypeArg) {
                            Tree.Snippetable newExpr = expr.copy();
                            newExpr.setTypeArg(newExprTypeArg);
                            SnippetClosure newNext = tail.getFirst().copy();
                            newNext.setExpr(newExpr);
                            tail = tail.updateFirst(newNext);
                        }
                        tail = tail.getRest();
                    }
                    this.snipClosures = this.newSnipClosures.append(superSnipClosures);
                } else {
                    this.snipClosures = this.newSnipClosures;
                }
            }
            return this.snipClosures;
        }

        public void setTemplateClass(Tree.ClassDef tree) {
            this.templateClass = tree;
        }

        public Tree.ClassDef getTemplateClass() {
            return this.templateClass;
        }

        public boolean isSnippetComplete() {
            return this.snipClosures != null;
        }

        @Override
        public String toString() {
            return new StringBuffer().append((this.flags_field & 0x200) != 0 ? "interface " : "class ").append(this.className()).toString();
        }

        @Override
        public Filter print(Filter f) {
            Filter result = f;
            ClassSymbol.leftBracket();
            ClassSymbol.print("ClassSymbol");
            ClassSymbol.space();
            ClassSymbol.include(" fullname: ", this.fullname, false);
            ClassSymbol.space();
            ClassSymbol.include(" flatname: ", this.flatname, false);
            ClassSymbol.space();
            ClassSymbol.include("flags: ", this.flags_field, false);
            ClassSymbol.newline();
            ClassSymbol.print("members (cyclic references have been filtered):");
            ClassSymbol.newline();
            if (this.members_field != null) {
                result = this.members_field.print(new Filter(){
                    final /* synthetic */ Filter val$f;
                    final /* synthetic */ ClassSymbol this$0;
                    {
                        this.this$0 = this$0;
                        this.val$f = val$f;
                    }

                    public boolean ignore(Object o) {
                        return this.val$f.ignore(o) || o == this.this$0;
                    }
                });
            }
            ClassSymbol.rightBracket();
            return result;
        }

        @Override
        public int flags() {
            if (this.completer != null) {
                this.complete();
            }
            return this.flags_field;
        }

        @Override
        public Scope members() {
            if (this.completer != null) {
                this.complete();
            }
            return this.members_field;
        }

        @Override
        public Type erasure() {
            if (this.erasure_field == null) {
                this.erasure_field = this.type.isParameterized() ? new Type.ClassType(this.type.enclosingType().erasure(), Type.EMPTY_LIST, this) : this.type;
            }
            return this.erasure_field;
        }

        public String className() {
            if (this.name.length == 0) {
                return new StringBuffer().append("<anonymous ").append(this.flatname).append(">").toString();
            }
            return this.fullname.toString();
        }

        @Override
        public Name fullName() {
            return this.fullname;
        }

        @Override
        public Name flatName() {
            return this.flatname;
        }

        public boolean templateClass() {
            return this.name.toString().indexOf("{") != -1;
        }

        @Override
        public boolean subclass(Symbol base) {
            if (this == base) {
                return true;
            }
            if ((base.flags() & 0x200) != 0) {
                List<Type> is = this.type.getInterfaces();
                while (is.nonEmpty()) {
                    if (is.getFirst().typeSymbol.subclass(base)) {
                        return true;
                    }
                    is = is.getRest();
                }
                return false;
            }
            Type t = this.type.getSuperType();
            while (t.tag == 10 && t.typeSymbol != base) {
                t = t.getSuperType();
            }
            return t.tag == 10;
        }

        @Override
        public int rank() {
            if (this.rank_field < 0) {
                if (this.fullName() == Names.java_lang_Object) {
                    this.rank_field = 0;
                } else {
                    int r = this.type.getSuperType().typeSymbol.rank();
                    List<Type> l = this.type.getInterfaces();
                    while (l.nonEmpty()) {
                        if (l.getFirst().typeSymbol.rank() > r) {
                            r = l.getFirst().typeSymbol.rank();
                        }
                        l = l.getRest();
                    }
                    this.rank_field = r + 1;
                }
            }
            return this.rank_field;
        }

        @Override
        public boolean precedes(TypeSymbol that) {
            return that.rank() < this.rank() || that.rank() == this.rank() && this.less(that.fullName(), this.fullname);
        }

        private boolean less(Name n1, Name n2) {
            int j;
            int i = n1.index + n1.length - 1;
            for (j = n2.index + n2.length - 1; i != n1.index && j != n2.index && Name.names[i] == Name.names[j]; --i, --j) {
            }
            if (j == n2.index) {
                return false;
            }
            if (i == n1.index) {
                return true;
            }
            return Name.names[i] < Name.names[j];
        }
    }

    public static class PackageSymbol
    extends TypeSymbol {
        public Scope members_field;
        public Name fullname;

        public PackageSymbol(Name name, Type type, Symbol owner) {
            super(0, name, type, owner);
            this.kind = 1;
            this.members_field = null;
            this.fullname = PackageSymbol.formFullName(name, owner);
        }

        public PackageSymbol(Name name, Symbol owner) {
            this(name, null, owner);
            this.type = new Type.PackageType(this);
        }

        public String toString() {
            return "package " + this.fullname;
        }

        public Filter print(Filter f) {
            PackageSymbol.leftBracket();
            PackageSymbol.print("PackageSymbol ");
            PackageSymbol.print(this.fullname.toString());
            PackageSymbol.rightBracket();
            return f;
        }

        public Name fullName() {
            return this.fullname;
        }

        public Scope members() {
            if (this.completer != null) {
                this.complete();
            }
            return this.members_field;
        }

        public int flags() {
            if (this.completer != null) {
                this.complete();
            }
            return this.flags_field;
        }

        public boolean exists() {
            if (this.members() == null) {
                throw new InternalError();
            }
            return (this.flags() & 0x800000) != 0 || this.members().entries != null;
        }
    }

    public static class TypeSymbol
    extends Symbol {
        public TypeSymbol(int flags, Name name, Type type, Symbol owner) {
            super(2, flags, name, type, owner);
        }

        public String toString() {
            return "type variable " + this.name;
        }

        public Filter print(Filter f) {
            TypeSymbol.leftBracket();
            TypeSymbol.print("TypeSymbol ");
            TypeSymbol.print(this.name.toString());
            TypeSymbol.rightBracket();
            return f;
        }

        public Scope members() {
            return null;
        }

        public static Name formFullName(Name name, Symbol owner) {
            if (owner == null || (owner.kind & 0x1C) != 0) {
                return name;
            }
            Name prefix = owner.fullName();
            if (prefix == null || prefix.length == 0) {
                return name;
            }
            return prefix.append(Names.period).append(name);
        }

        public static Name formFlatName(Name name, Symbol owner) {
            if (owner == null || (owner.kind & 0x1C) != 0) {
                return name;
            }
            Name sep = owner.kind == 2 ? Names.dollar : Names.period;
            Name prefix = owner.flatName();
            if (prefix == null || prefix.length == 0) {
                return name;
            }
            return prefix.append(sep).append(name);
        }

        public int rank() {
            throw new InternalError();
        }

        public boolean precedes(TypeSymbol that) {
            throw new InternalError();
        }

        public boolean exists() {
            return true;
        }
    }
}

